/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge;

import atari.board.BUS;
import atari.cartridge.CartridgeFormat;
import atari.controls.ConsoleControls;
import atari.controls.ConsoleControlsInput;
import general.av.video.VideoStandard;
import general.board.BUS16Bits;
import general.board.ClockDriven;
import java.io.Serializable;
import java.util.Map;

public abstract class Cartridge
implements BUS16Bits,
ClockDriven,
Cloneable,
Serializable,
ConsoleControlsInput {
    protected transient BUS bus;
    protected byte[] bytes;
    private final String contentName;
    private final CartridgeFormat format;
    protected int maskedAddress;
    private VideoStandard suggestedVideoStandard = null;
    private static final int ADDRESS_MASK = 4095;
    public static final long serialVersionUID = 1L;

    protected Cartridge(byte[] content, String contentName, CartridgeFormat format) {
        this.bytes = content;
        this.contentName = contentName;
        this.format = format;
    }

    public byte[] content() {
        return this.bytes;
    }

    public String contentName() {
        return this.contentName;
    }

    public CartridgeFormat format() {
        return this.format;
    }

    public void connectBus(BUS bus) {
        this.bus = bus;
    }

    @Override
    public void clockPulse() {
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        return this.bytes[this.maskedAddress];
    }

    @Override
    public void writeByte(int address, byte b) {
        this.maskAddress(address);
    }

    public void monitorByteRead(int address, byte data) {
    }

    public void monitorByteWritten(int address, byte data) {
    }

    public boolean needsClock() {
        return false;
    }

    public boolean needsBusMonitoring() {
        return false;
    }

    protected void maskAddress(int address) {
        this.maskedAddress = address & 0xFFF;
    }

    public VideoStandard suggestedVideoStandard() {
        return this.suggestedVideoStandard;
    }

    public void suggestedVideoStandard(VideoStandard videoStandard) {
        this.suggestedVideoStandard = videoStandard;
    }

    public Cartridge clone() {
        try {
            return (Cartridge)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, boolean state) {
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, int position) {
    }

    @Override
    public void controlsStateReport(Map<ConsoleControls.Control, Boolean> report) {
    }
}

