/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge.formats;

import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeFormat;
import atari.cartridge.CartridgeFormatOption;
import atari.cartridge.formats.CartridgeBanked;
import atari.cartridge.formats.CartridgeFormatOptionHinted;

public final class Cartridge8K_E0
extends CartridgeBanked {
    private int slice0AddressOffset = 0;
    private int slice1AddressOffset = 0;
    private int slice2AddressOffset = 0;
    private static final int SIZE = 8192;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("E0", "8K Parker Bros."){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge create(byte[] content, String contentName) {
            return new Cartridge8K_E0(content, contentName, null);
        }

        @Override
        public CartridgeFormatOption getOption(byte[] content, String contentName) {
            if (content.length != 8192) {
                return null;
            }
            return new CartridgeFormatOptionHinted(102, this, contentName);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge8K_E0(byte[] content, String contentName) {
        super(content, contentName, FORMAT);
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        if (this.maskedAddress < 1024) {
            return this.bytes[this.slice0AddressOffset + this.maskedAddress];
        }
        if (this.maskedAddress < 2048) {
            return this.bytes[this.slice1AddressOffset + this.maskedAddress - 1024];
        }
        if (this.maskedAddress < 3072) {
            return this.bytes[this.slice2AddressOffset + this.maskedAddress - 2048];
        }
        return this.bytes[4096 + this.maskedAddress];
    }

    @Override
    protected void performBankSwitchOnMaskedAddress() {
        if (this.maskedAddress < 4064 || this.maskedAddress > 4087) {
            return;
        }
        if (this.maskedAddress <= 4071) {
            this.slice0AddressOffset = (this.maskedAddress - 4064) * 1024;
        } else if (this.maskedAddress <= 4079) {
            this.slice1AddressOffset = (this.maskedAddress - 4072) * 1024;
        } else if (this.maskedAddress <= 4087) {
            this.slice2AddressOffset = (this.maskedAddress - 4080) * 1024;
        }
    }

    /* synthetic */ Cartridge8K_E0(byte[] byArray, String string, Cartridge8K_E0 cartridge8K_E0) {
        this(byArray, string);
    }
}

