/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge.formats;

import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeFormat;
import atari.cartridge.CartridgeFormatOption;
import atari.cartridge.formats.Cartridge10K_DPC;
import atari.cartridge.formats.Cartridge12K_FA;
import atari.cartridge.formats.Cartridge16K_E7;
import atari.cartridge.formats.Cartridge16K_F6;
import atari.cartridge.formats.Cartridge24K_28K_FA2;
import atari.cartridge.formats.Cartridge2K_CV;
import atari.cartridge.formats.Cartridge32K_F4;
import atari.cartridge.formats.Cartridge4K;
import atari.cartridge.formats.Cartridge64K_F0;
import atari.cartridge.formats.Cartridge64K_X07;
import atari.cartridge.formats.Cartridge8K_0840;
import atari.cartridge.formats.Cartridge8K_512K_3E;
import atari.cartridge.formats.Cartridge8K_512K_3F;
import atari.cartridge.formats.Cartridge8K_512K_SB;
import atari.cartridge.formats.Cartridge8K_64K_EF;
import atari.cartridge.formats.Cartridge8K_E0;
import atari.cartridge.formats.Cartridge8K_F8;
import atari.cartridge.formats.Cartridge8K_FE;
import atari.cartridge.formats.Cartridge8K_UA;
import atari.cartridge.formats.CartridgePitfall2EnhancedDPCAudio;
import atari.cartridge.formats.NameHint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CartridgeDatabase {
    private static List<CartridgeFormat> allFormats = Arrays.asList(Cartridge4K.FORMAT, Cartridge2K_CV.FORMAT, Cartridge8K_F8.FORMAT, Cartridge12K_FA.FORMAT, Cartridge16K_F6.FORMAT, Cartridge24K_28K_FA2.FORMAT, Cartridge32K_F4.FORMAT, Cartridge64K_F0.FORMAT, Cartridge64K_X07.FORMAT, Cartridge8K_E0.FORMAT, Cartridge8K_FE.FORMAT, Cartridge16K_E7.FORMAT, Cartridge8K_512K_3E.FORMAT, Cartridge8K_512K_3F.FORMAT, Cartridge8K_64K_EF.FORMAT, Cartridge8K_512K_SB.FORMAT, Cartridge8K_UA.FORMAT, Cartridge8K_0840.FORMAT, Cartridge10K_DPC.FORMAT, CartridgePitfall2EnhancedDPCAudio.FORMAT);
    private static NameHint[] nameHints = new NameHint[]{new NameHint(Cartridge8K_E0.FORMAT, new String[]{".*MONTEZUMA.*", "MONTZREV.*", ".*GYRUS.*", ".*TOOTH.*PROTECTORS.*", "TOOTHPRO.*", ".*DEATH.*STAR.*BATTLE.*", "DETHSTAR.*", ".*JAMES.*BOND.*", "JAMEBOND.*", ".*SUPER.*COBRA.*", "SPRCOBRA.*", ".*TUTANKHAM.*", "TUTANK.*", ".*POPEYE.*", ".*SW.*ARCADE.*GAME.*", "SWARCADE.*", ".*Q.*BERT.*QUBES.*", "QBRTQUBE.*", ".*FROGGER.*2.*", "FROGGER2.*", ".*DO.*CASTLE.*", "DOCASTLE.*"}), new NameHint(Cartridge8K_FE.FORMAT, new String[]{".*ROBOT?.*TANK.*", "ROBOTANK.*", ".*DECATHLON.*", "DECATHLN.*"}), new NameHint(Cartridge16K_E7.FORMAT, new String[]{".*BUMP.*JUMP.*", "BNJ.*", ".*BURGER.?TIME.*", "BURGTIME.*", ".*POWER.*HE.?MAN.*", "HE_MAN.*"}), new NameHint(Cartridge8K_512K_3F.FORMAT, new String[]{".*POLARIS.*", ".*RIVER.*PATROL.*", "RIVERP.*", ".*SPRINGER.*", ".*MINER.*2049.*", "MNR2049R.*", ".*MINER.*2049.*VOLUME.*", "MINRVOL2.*", ".*ESPIAL.*", ".*ANDREW.*DAVIE.*"}), new NameHint(Cartridge8K_512K_3E.FORMAT, new String[]{".*BOULDER.*DASH.*", "BLDRDASH.*"}), new NameHint(CartridgePitfall2EnhancedDPCAudio.FORMAT, new String[]{".*PITFALL.*(2|II).*"})};
    private static final String HINTS_PREFIX_REGEX = "(|.*?(\\W|_|%20))";
    private static final String HINTS_SUFFIX_REGEX = "(|(\\W|_|%20).*)";
    private static final int NAME_HINT_BOOST = 50;
    private static final int FORMAT_HINT_BOOST = 100;

    public static ArrayList<CartridgeFormatOption> getFormatOptions(Cartridge cartridge) {
        return CartridgeDatabase.getFormatOptions(cartridge.content(), cartridge.contentName());
    }

    public static ArrayList<CartridgeFormatOption> getFormatOptionsUnhinted(Cartridge cartridge) {
        return CartridgeDatabase.getFormatOptions(cartridge.content(), "");
    }

    public static ArrayList<CartridgeFormatOption> getFormatOptions(byte[] content, String contentName) {
        ArrayList<CartridgeFormatOption> options = new ArrayList<CartridgeFormatOption>();
        for (CartridgeFormat format : allFormats) {
            CartridgeFormatOption option = format.getOption(content, contentName.toUpperCase());
            if (option == null) continue;
            options.add(option);
        }
        int prev = -1;
        for (CartridgeFormatOption op : options) {
            if (op.priority == prev) {
                throw new IllegalStateException("More than one CartridgeFormatOption with priority: " + prev);
            }
            prev = op.priority;
        }
        Collections.sort(options);
        return options;
    }

    static int priorityBoosted(int priority, CartridgeFormat format, String contentName) {
        if (CartridgeDatabase.formatHinted(format, contentName)) {
            return priority - 100;
        }
        if (CartridgeDatabase.nameHinted(format, contentName)) {
            return priority - 50;
        }
        return priority;
    }

    private static boolean formatHinted(CartridgeFormat format, String contentName) {
        return contentName.matches(HINTS_PREFIX_REGEX + format.id + HINTS_SUFFIX_REGEX);
    }

    private static boolean nameHinted(CartridgeFormat format, String contentName) {
        NameHint[] nameHintArray = nameHints;
        int n = nameHints.length;
        int n2 = 0;
        while (n2 < n) {
            NameHint hint = nameHintArray[n2];
            if (hint.format == format && hint.matches(contentName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

