/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;

public final class BIT
extends Instruction {
    private final int type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public BIT(M6502 cpu, int type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 20) {
            this.ea = this.cpu.fetchZeroPageAddress();
            return 3;
        }
        if (this.type == 10) {
            this.ea = this.cpu.fetchAbsoluteAddress();
            return 4;
        }
        throw new IllegalStateException("BIT Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        byte val = this.cpu.bus.readByte(this.ea);
        this.cpu.ZERO = (val & this.cpu.A) == 0;
        this.cpu.OVERFLOW = (val & 0x40) != 0;
        this.cpu.NEGATIVE = (val & 0x80) != 0;
    }
}

