/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;

public final class Bxx
extends Instruction {
    private final int bit;
    private final boolean cond;
    private int newPC;
    private boolean branch;
    public static final long serialVersionUID = 1L;

    public Bxx(M6502 cpu, int bit, boolean cond) {
        super(cpu);
        this.bit = bit;
        this.cond = cond;
    }

    @Override
    public int fetch() {
        this.newPC = this.cpu.fetchRelativeAddress();
        if (this.bit == 1) {
            this.branch = this.cpu.ZERO == this.cond;
        } else if (this.bit == 7) {
            this.branch = this.cpu.NEGATIVE == this.cond;
        } else if (this.bit == 0) {
            this.branch = this.cpu.CARRY == this.cond;
        } else if (this.bit == 6) {
            this.branch = this.cpu.OVERFLOW == this.cond;
        } else {
            throw new IllegalStateException("Bxx Invalid StatusBit: " + this.bit);
        }
        return this.branch ? (this.cpu.pageCrossed ? 4 : 3) : 2;
    }

    @Override
    public void execute() {
        if (this.branch) {
            this.cpu.PC = this.newPC;
        }
    }
}

