/*
 * Decompiled with CFR 0.152.
 */
package main;

import atari.network.RemoteReceiver;
import java.io.IOException;
import javax.swing.JOptionPane;
import parameters.Parameters;
import pc.room.Room;
import utils.Terminator;

public final class MultiplayerClient {
    public static void main(String[] args) throws IOException, InterruptedException {
        Parameters.init(args);
        Room clientRoom = Room.buildClientRoom();
        clientRoom.powerOn();
        boolean success = MultiplayerClient.askUserForConnection(clientRoom.clientCurrentConsole().remoteReceiver(), Parameters.mainArg);
        if (!success) {
            Terminator.terminate();
        }
    }

    private static boolean askUserForConnection(RemoteReceiver remoteReceiver, String defaultServer) {
        String server = defaultServer;
        while (true) {
            if (server != null && !server.isEmpty()) {
                try {
                    remoteReceiver.connect(server);
                    return true;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Unnable to connect to: " + server + "\n" + ex, "Atari Player 2 Client", 0);
                }
            }
            do {
                if ((server = (String)JOptionPane.showInputDialog(null, "Atari Player 1 Server address[:port]:", "Atari Player 2 Client", -1, null, null, server)) != null) continue;
                return false;
            } while ((server = server.trim()).isEmpty());
        }
    }
}

