/*
 * Decompiled with CFR 0.152.
 */
package parameters;

import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import utils.Terminator;

public final class Parameters {
    public static final String VERSION = "version 3.00";
    public static String mainArg;
    public static double TIA_FORCED_CLOCK;
    public static boolean TIA_SYNC_WITH_AUDIO_MONITOR;
    public static boolean TIA_SYNC_WITH_VIDEO_MONITOR;
    public static int TIA_AUDIO_SAMPLE_RATE;
    public static float TIA_AUDIO_MAX_AMPLITUDE;
    public static double VIDEO_NTSC_FPS;
    public static double VIDEO_PAL_FPS;
    public static int RAM_FRY_ZERO_BITS;
    public static int RAM_FRY_ONE_BITS;
    public static float RAM_FRY_VARIANCE;
    public static double SCREEN_DEFAULT_FPS;
    public static int SCREEN_DEFAULT_ORIGIN_X;
    public static double SCREEN_DEFAULT_ORIGIN_Y_PCT;
    public static int SCREEN_DEFAULT_WIDTH;
    public static double SCREEN_DEFAULT_HEIGHT_PCT;
    public static float SCREEN_DEFAULT_SCALE_X;
    public static float SCREEN_DEFAULT_SCALE_Y;
    public static float SCREEN_DEFAULT_SCALE_ASPECT_X;
    public static int SCREEN_BORDER_SIZE;
    public static int SCREEN_OSD_FRAMES;
    public static int SCREEN_VSYNC_TOLERANCE;
    public static boolean SCREEN_QUALITY_RENDERING;
    public static int SCREEN_CRT_MODE;
    public static float SCREEN_CRT_RETENTION_ALPHA;
    public static float SCREEN_SCANLINES_STRENGTH;
    public static int SCREEN_MULTI_BUFFERING;
    public static boolean SCREEN_PAGE_FLIPPING;
    public static int SCREEN_BUFFER_VSYNC;
    public static float SCREEN_FRAME_ACCELERATION;
    public static float SCREEN_INTERM_FRAME_ACCELERATION;
    public static float SCREEN_SCANLINES_ACCELERATION;
    public static boolean SCREEN_CARTRIDGE_CHANGE;
    public static boolean SCREEN_CONSOLE_PANEL;
    public static boolean SCREEN_FIXED_SIZE;
    public static boolean SCREEN_FULLSCREEN;
    public static double SPEAKER_DEFAULT_FPS;
    public static int SPEAKER_INPUT_BUFFER_SIZE;
    public static int SPEAKER_OUTPUT_BUFFER_SIZE;
    public static int SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME;
    public static int SPEAKER_NO_DATA_SLEEP_TIME;
    public static int SPEAKER_ADDED_THREAD_PRIORITY;
    public static int CONSOLE_FAST_SPEED_FACTOR;
    public static boolean BUS_DATA_RETENTION;
    public static int SERVER_SERVICE_PORT;
    public static int SERVER_MAX_UPDATES_PENDING;
    public static int CLIENT_MAX_UPDATES_PENDING;
    public static boolean MULTIPLAYER_UI;
    public static String OFFICIAL_WEBSITE;
    private static Properties props;
    private static Preferences userPreferences;
    private static boolean userPreferencesAsked;
    public static final int DEFAULT_KEY_P0_LEFT = 37;
    public static final int DEFAULT_KEY_P0_UP = 38;
    public static final int DEFAULT_KEY_P0_RIGHT = 39;
    public static final int DEFAULT_KEY_P0_DOWN = 40;
    public static final int DEFAULT_KEY_P0_BUTTON = 32;
    public static final int DEFAULT_KEY_P0_BUTTON2 = 127;
    public static final int DEFAULT_KEY_P1_LEFT = 70;
    public static final int DEFAULT_KEY_P1_UP = 84;
    public static final int DEFAULT_KEY_P1_RIGHT = 72;
    public static final int DEFAULT_KEY_P1_DOWN = 71;
    public static final int DEFAULT_KEY_P1_BUTTON = 65;
    public static final int DEFAULT_KEY_P1_BUTTON2 = 46;
    public static int KEY_P0_LEFT;
    public static int KEY_P0_UP;
    public static int KEY_P0_RIGHT;
    public static int KEY_P0_DOWN;
    public static int KEY_P0_BUTTON;
    public static int KEY_P0_BUTTON2;
    public static int KEY_P1_LEFT;
    public static int KEY_P1_UP;
    public static int KEY_P1_RIGHT;
    public static int KEY_P1_DOWN;
    public static int KEY_P1_BUTTON;
    public static int KEY_P1_BUTTON2;
    public static String LAST_ROM_FILE_CHOSEN;
    public static String LAST_ROM_URL_CHOSEN;

    static {
        Parameters.setLookAndFeel();
        mainArg = null;
        TIA_FORCED_CLOCK = 0.0;
        TIA_SYNC_WITH_AUDIO_MONITOR = false;
        TIA_SYNC_WITH_VIDEO_MONITOR = false;
        TIA_AUDIO_SAMPLE_RATE = 31430;
        TIA_AUDIO_MAX_AMPLITUDE = 0.5f;
        VIDEO_NTSC_FPS = 60.0;
        VIDEO_PAL_FPS = 50.384615;
        RAM_FRY_ZERO_BITS = 100;
        RAM_FRY_ONE_BITS = 25;
        RAM_FRY_VARIANCE = 0.3f;
        SCREEN_DEFAULT_FPS = -1.0;
        SCREEN_DEFAULT_ORIGIN_X = 10;
        SCREEN_DEFAULT_ORIGIN_Y_PCT = 12.0;
        SCREEN_DEFAULT_WIDTH = 160;
        SCREEN_DEFAULT_HEIGHT_PCT = 81.5;
        SCREEN_DEFAULT_SCALE_X = 4.0f;
        SCREEN_DEFAULT_SCALE_Y = 2.0f;
        SCREEN_DEFAULT_SCALE_ASPECT_X = 2.0f;
        SCREEN_BORDER_SIZE = 3;
        SCREEN_OSD_FRAMES = 160;
        SCREEN_VSYNC_TOLERANCE = 10;
        SCREEN_QUALITY_RENDERING = false;
        SCREEN_CRT_MODE = 0;
        SCREEN_CRT_RETENTION_ALPHA = 0.75f;
        SCREEN_SCANLINES_STRENGTH = 0.5f;
        SCREEN_MULTI_BUFFERING = 2;
        SCREEN_PAGE_FLIPPING = true;
        SCREEN_BUFFER_VSYNC = -1;
        SCREEN_FRAME_ACCELERATION = 0.0f;
        SCREEN_INTERM_FRAME_ACCELERATION = -1.0f;
        SCREEN_SCANLINES_ACCELERATION = -1.0f;
        SCREEN_CARTRIDGE_CHANGE = true;
        SCREEN_CONSOLE_PANEL = true;
        SCREEN_FIXED_SIZE = false;
        SCREEN_FULLSCREEN = false;
        SPEAKER_DEFAULT_FPS = -1.0;
        SPEAKER_INPUT_BUFFER_SIZE = 1536;
        SPEAKER_OUTPUT_BUFFER_SIZE = 768;
        SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME = 5;
        SPEAKER_NO_DATA_SLEEP_TIME = 20;
        SPEAKER_ADDED_THREAD_PRIORITY = 0;
        CONSOLE_FAST_SPEED_FACTOR = 8;
        BUS_DATA_RETENTION = true;
        SERVER_SERVICE_PORT = 9998;
        SERVER_MAX_UPDATES_PENDING = 20;
        CLIENT_MAX_UPDATES_PENDING = 20;
        MULTIPLAYER_UI = true;
        OFFICIAL_WEBSITE = "http://javatari.org";
        props = new Properties();
        userPreferencesAsked = false;
        KEY_P0_LEFT = 37;
        KEY_P0_UP = 38;
        KEY_P0_RIGHT = 39;
        KEY_P0_DOWN = 40;
        KEY_P0_BUTTON = 32;
        KEY_P0_BUTTON2 = 127;
        KEY_P1_LEFT = 70;
        KEY_P1_UP = 84;
        KEY_P1_RIGHT = 72;
        KEY_P1_DOWN = 71;
        KEY_P1_BUTTON = 65;
        KEY_P1_BUTTON2 = 46;
        LAST_ROM_FILE_CHOSEN = "";
        LAST_ROM_URL_CHOSEN = "";
    }

    public static void init(String[] args) {
        System.out.println(String.valueOf(System.getProperty("java.vm.name")) + " ver: " + System.getProperty("java.version"));
        Parameters.parseMainArg(args);
        Parameters.loadPropertiesFile();
        Parameters.parseOptions(args);
        Parameters.processProperties();
        Parameters.loadPreferences();
    }

    private static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void parseMainArg(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (!arg.startsWith("-")) {
                mainArg = arg;
                return;
            }
            ++n2;
        }
    }

    private static void parseOptions(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("-")) {
                String opt = arg.substring(1);
                Pattern p = Pattern.compile("=");
                String[] params = p.split(opt);
                if (params == null || params.length != 2 || params[0].isEmpty() || params[1].isEmpty()) {
                    System.out.println("Invalid option format: " + arg);
                    Terminator.terminate();
                }
                props.put(params[0].toUpperCase(), params[1]);
            }
            ++n2;
        }
    }

    private static void loadPropertiesFile() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("parameters/javatari.properties");
        try {
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (Exception ex) {
            System.out.println("parameters/javatari.properties not found, using defaults");
        }
        try {
            props.putAll((Map<?, ?>)System.getProperties());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private static void loadPreferences() {
        Preferences prefs = Parameters.getUserPreferences();
        if (prefs == null) {
            return;
        }
        try {
            String val = prefs.get("keyP0Left", null);
            if (val != null) {
                KEY_P0_LEFT = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP0Up", null)) != null) {
                KEY_P0_UP = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP0Right", null)) != null) {
                KEY_P0_RIGHT = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP0Down", null)) != null) {
                KEY_P0_DOWN = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP0Button", null)) != null) {
                KEY_P0_BUTTON = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP0Button2", null)) != null) {
                KEY_P0_BUTTON2 = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Left", null)) != null) {
                KEY_P1_LEFT = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Up", null)) != null) {
                KEY_P1_UP = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Right", null)) != null) {
                KEY_P1_RIGHT = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Down", null)) != null) {
                KEY_P1_DOWN = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Button", null)) != null) {
                KEY_P1_BUTTON = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Button2", null)) != null) {
                KEY_P1_BUTTON2 = Integer.parseInt(val);
            }
            if ((val = prefs.get("lastROMFileChosen", null)) != null) {
                LAST_ROM_FILE_CHOSEN = val;
            }
            if ((val = prefs.get("lastROMURLChosen", null)) != null) {
                LAST_ROM_URL_CHOSEN = val;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void savePreferences() {
        Preferences prefs = Parameters.getUserPreferences();
        if (prefs == null) {
            return;
        }
        try {
            prefs.put("keyP0Left", String.valueOf(KEY_P0_LEFT));
            prefs.put("keyP0Up", String.valueOf(KEY_P0_UP));
            prefs.put("keyP0Right", String.valueOf(KEY_P0_RIGHT));
            prefs.put("keyP0Down", String.valueOf(KEY_P0_DOWN));
            prefs.put("keyP0Button", String.valueOf(KEY_P0_BUTTON));
            prefs.put("keyP0Button2", String.valueOf(KEY_P0_BUTTON2));
            prefs.put("keyP1Left", String.valueOf(KEY_P1_LEFT));
            prefs.put("keyP1Up", String.valueOf(KEY_P1_UP));
            prefs.put("keyP1Right", String.valueOf(KEY_P1_RIGHT));
            prefs.put("keyP1Down", String.valueOf(KEY_P1_DOWN));
            prefs.put("keyP1Button", String.valueOf(KEY_P1_BUTTON));
            prefs.put("keyP1Button2", String.valueOf(KEY_P1_BUTTON2));
            prefs.put("lastROMFileChosen", LAST_ROM_FILE_CHOSEN);
            prefs.put("lastROMURLChosen", LAST_ROM_URL_CHOSEN);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Preferences getUserPreferences() {
        if (!userPreferencesAsked) {
            try {
                userPreferencesAsked = true;
                userPreferences = Preferences.userRoot().node("javatari");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return userPreferences;
    }

    private static void processProperties() {
        try {
            String val = props.getProperty("TIA_FORCED_CLOCK");
            if (val != null) {
                TIA_FORCED_CLOCK = Double.valueOf(val);
            }
            if ((val = props.getProperty("TIA_SYNC_WITH_AUDIO_MONITOR")) != null) {
                TIA_SYNC_WITH_AUDIO_MONITOR = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("TIA_SYNC_WITH_VIDEO_MONITOR")) != null) {
                TIA_SYNC_WITH_VIDEO_MONITOR = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("VIDEO_NTSC_FPS")) != null) {
                VIDEO_NTSC_FPS = Double.valueOf(val);
            }
            if ((val = props.getProperty("VIDEO_PAL_FPS")) != null) {
                VIDEO_PAL_FPS = Double.valueOf(val);
            }
            if ((val = props.getProperty("TIA_AUDIO_SAMPLE_RATE")) != null) {
                TIA_AUDIO_SAMPLE_RATE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("TIA_AUDIO_MAX_AMPLITUDE")) != null) {
                TIA_AUDIO_MAX_AMPLITUDE = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("RAM_FRY_ZERO_BITS")) != null) {
                RAM_FRY_ZERO_BITS = Integer.valueOf(val);
            }
            if ((val = props.getProperty("RAM_FRY_ONE_BITS")) != null) {
                RAM_FRY_ONE_BITS = Integer.valueOf(val);
            }
            if ((val = props.getProperty("RAM_FRY_VARIANCE")) != null) {
                RAM_FRY_VARIANCE = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_FPS")) != null) {
                SCREEN_DEFAULT_FPS = Double.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_ORIGIN_X")) != null) {
                SCREEN_DEFAULT_ORIGIN_X = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_ORIGIN_Y_PCT")) != null) {
                SCREEN_DEFAULT_ORIGIN_Y_PCT = Double.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_WIDTH")) != null) {
                SCREEN_DEFAULT_WIDTH = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_HEIGHT_PCT")) != null) {
                SCREEN_DEFAULT_HEIGHT_PCT = Double.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_SCALE_X")) != null) {
                SCREEN_DEFAULT_SCALE_X = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_SCALE_Y")) != null) {
                SCREEN_DEFAULT_SCALE_Y = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_SCALE_ASPECT_X")) != null) {
                SCREEN_DEFAULT_SCALE_ASPECT_X = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_BORDER_SIZE")) != null) {
                SCREEN_BORDER_SIZE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_OSD_FRAMES")) != null) {
                SCREEN_OSD_FRAMES = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_VSYNC_TOLERANCE")) != null) {
                SCREEN_VSYNC_TOLERANCE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_QUALITY_RENDERING")) != null) {
                SCREEN_QUALITY_RENDERING = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_CRT_MODE")) != null) {
                SCREEN_CRT_MODE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_CRT_RETENTION_ALPHA")) != null) {
                SCREEN_CRT_RETENTION_ALPHA = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_SCANLINES_STRENGTH")) != null) {
                SCREEN_SCANLINES_STRENGTH = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_MULTI_BUFFERING")) != null) {
                SCREEN_MULTI_BUFFERING = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_PAGE_FLIPPING")) != null) {
                SCREEN_PAGE_FLIPPING = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_BUFFER_VSYNC")) != null) {
                SCREEN_BUFFER_VSYNC = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_FRAME_ACCELERATION")) != null) {
                SCREEN_FRAME_ACCELERATION = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_INTERM_FRAME_ACCELERATION")) != null) {
                SCREEN_INTERM_FRAME_ACCELERATION = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_SCANLINES_ACCELERATION")) != null) {
                SCREEN_SCANLINES_ACCELERATION = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_CARTRIDGE_CHANGE")) != null) {
                SCREEN_CARTRIDGE_CHANGE = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_CONSOLE_PANEL")) != null) {
                SCREEN_CONSOLE_PANEL = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_FIXED_SIZE")) != null) {
                SCREEN_FIXED_SIZE = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_FULLSCREEN")) != null) {
                SCREEN_FULLSCREEN = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_DEFAULT_FPS")) != null) {
                SPEAKER_DEFAULT_FPS = Double.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_INPUT_BUFFER_SIZE")) != null) {
                SPEAKER_INPUT_BUFFER_SIZE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_OUTPUT_BUFFER_SIZE")) != null) {
                SPEAKER_OUTPUT_BUFFER_SIZE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME")) != null) {
                SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_NO_DATA_SLEEP_TIME")) != null) {
                SPEAKER_NO_DATA_SLEEP_TIME = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_ADDED_THREAD_PRIORITY")) != null) {
                SPEAKER_ADDED_THREAD_PRIORITY = Integer.valueOf(val);
            }
            if ((val = props.getProperty("CONSOLE_FAST_SPEED_FACTOR")) != null) {
                CONSOLE_FAST_SPEED_FACTOR = Integer.valueOf(val);
            }
            if ((val = props.getProperty("BUS_DATA_RETENTION")) != null) {
                BUS_DATA_RETENTION = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SERVER_SERVICE_PORT")) != null) {
                SERVER_SERVICE_PORT = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SERVER_MAX_UPDATES_PENDING")) != null) {
                SERVER_MAX_UPDATES_PENDING = Integer.valueOf(val);
            }
            if ((val = props.getProperty("CLIENT_MAX_UPDATES_PENDING")) != null) {
                CLIENT_MAX_UPDATES_PENDING = Integer.valueOf(val);
            }
            if ((val = props.getProperty("MULTIPLAYER_UI")) != null) {
                MULTIPLAYER_UI = Boolean.valueOf(val);
            }
        }
        catch (Exception ex) {
            System.out.println("Error processing properties:\n" + ex);
            Terminator.terminate();
        }
    }
}

