/*
 * Decompiled with CFR 0.152.
 */
package pc.cartridge;

import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeFormatOption;
import atari.cartridge.formats.CartridgeDatabase;
import java.util.ArrayList;
import pc.cartridge.UnsupportedROMFormatException;

public final class CartridgeCreator {
    public static Cartridge create(byte[] content, String contentName) throws UnsupportedROMFormatException {
        Cartridge cart = CartridgeCreator.findBestFormatAndCreate(content, contentName);
        return cart;
    }

    private static Cartridge findBestFormatAndCreate(byte[] content, String contentName) throws UnsupportedROMFormatException {
        ArrayList<CartridgeFormatOption> options = CartridgeDatabase.getFormatOptions(content, contentName);
        if (options.isEmpty()) {
            throw new UnsupportedROMFormatException("Size: " + content.length);
        }
        CartridgeFormatOption bestOption = options.get(0);
        System.out.println(bestOption);
        return bestOption.format.create(content, contentName);
    }
}

