/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import atari.controls.ConsoleControlsSocket;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pc.screen.ConsolePanel;
import pc.screen.DesktopScreenWindow;
import pc.screen.Monitor;
import utils.GraphicsDeviceHelper;
import utils.slickframe.HotspotManager;
import utils.slickframe.MousePressAndMotionListener;
import utils.slickframe.SlickFrame;

public final class DesktopConsolePanel
extends SlickFrame {
    private final DesktopScreenWindow masterWindow;
    private final ConsolePanel consolePanel;
    private boolean retracted = false;
    private boolean docked = true;
    private boolean userClosed = true;
    private Point dockedLocation;
    private Thread sizeAdjustThread;
    private HotspotManager hotspots;
    private BufferedImage retractButtonImage;
    private BufferedImage expandButtonImage;
    private BufferedImage closeButtonImage;
    public static final int WIDTH = 465;
    public static final int EXPANDED_HEIGHT = 137;
    public static final int RETRACTED_HEIGHT = 10;
    public static final long serialVersionUID = 1L;

    public DesktopConsolePanel(DesktopScreenWindow masterWindow, Monitor monitor) {
        super(false);
        this.masterWindow = masterWindow;
        this.addHotspots(this.detachMouseListener());
        this.consolePanel = new ConsolePanel(monitor, this.hotspots.detachMouseListener());
        this.buildGUI();
    }

    public void connect(ConsoleControlsSocket controlsSocket) {
        this.consolePanel.connect(controlsSocket);
    }

    @Override
    public void setVisible(boolean state) {
        if (!this.isVisible()) {
            this.setFocusable(false);
            this.setFocusableWindowState(false);
        }
        DesktopConsolePanel.super.setVisible(state);
        if (state) {
            this.userClosed = false;
            this.setState(0);
            this.setSize(this.desiredSize());
            this.toFront();
            this.masterWindow.toFront();
            this.masterWindow.requestFocus();
        }
    }

    public void toggle() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.toggleRetract();
    }

    private void buildGUI() {
        this.loadImages();
        this.setLayout(new BorderLayout());
        this.setTitle("javatari - Console Panel");
        this.setIconImages(Arrays.asList(this.masterWindow.icon64, this.masterWindow.icon32, this.masterWindow.favicon));
        this.addGlassPane();
        this.setSize(this.desiredSize());
        this.setResizable(false);
        this.add((Component)this.consolePanel, "Center");
        Toolkit tk = Toolkit.getDefaultToolkit();
        int x = (tk.getScreenSize().width - this.getWidth()) / 2;
        int y = (tk.getScreenSize().height - this.getHeight()) / 2;
        this.setLocation(x, y);
        this.addMasterWindowListeners();
    }

    private void addGlassPane() {
        TopControls gp = new TopControls();
        this.setGlassPane(gp);
        gp.setOpaque(false);
        gp.setVisible(true);
    }

    private void addMasterWindowListeners() {
        this.masterWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent e) {
                if (DesktopConsolePanel.this.isVisible()) {
                    DesktopConsolePanel.this.setVisible(false);
                }
            }

            @Override
            public void windowActivated(WindowEvent e) {
                if (!DesktopConsolePanel.this.userClosed) {
                    DesktopConsolePanel.this.setVisible(true);
                }
            }
        });
        this.masterWindow.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                DesktopConsolePanel.this.trackMasterWindow();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                DesktopConsolePanel.this.trackMasterWindow();
            }
        });
    }

    private void loadImages() {
        try {
            this.retractButtonImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/PanelRetractButton.png");
            this.expandButtonImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/PanelExpandButton.png");
            this.closeButtonImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/PanelCloseButton.png");
        }
        catch (IOException ex) {
            System.out.println("Console Panel: unable to load images\n" + ex);
        }
    }

    private void addHotspots(MousePressAndMotionListener forwardListener) {
        this.hotspots = new HotspotManager(this, forwardListener);
        this.hotspots.addHotspot(new Rectangle(218, -13, 30, 15), new Runnable(){

            @Override
            public void run() {
                DesktopConsolePanel.this.toggleRetract();
            }
        });
        this.hotspots.addHotspot(new Rectangle(446, -129, 14, 13), new Runnable(){

            @Override
            public void run() {
                if (!DesktopConsolePanel.this.docked) {
                    DesktopConsolePanel.this.setVisible(false);
                    DesktopConsolePanel.this.userClosed = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DesktopConsolePanel.this.toggleRetract();
                        }
                    });
                }
            }
        });
    }

    @Override
    protected void movingTo(int x, int y) {
        if (this.retracted) {
            return;
        }
        this.docked = false;
        if (this.locationDockable(new Point(x, y))) {
            this.goToDockedLocation();
        } else {
            this.setLocation(x, y);
        }
    }

    @Override
    protected void finishedMoving() {
        if (this.locationDockable(this.getLocation())) {
            this.dock();
        } else {
            this.undock();
        }
    }

    private void toggleRetract() {
        if (this.sizeAdjustThread != null && this.sizeAdjustThread.isAlive()) {
            return;
        }
        this.retracted = !this.retracted;
        this.adjustSize();
        if (this.retracted) {
            this.dock();
        }
    }

    private boolean locationDockable(Point p) {
        if (this.dockedLocation == null) {
            return false;
        }
        if (Math.abs(p.y - this.dockedLocation.y) > 16) {
            return false;
        }
        return Math.abs(p.x - this.dockedLocation.x) < Math.max(Math.abs(this.masterWindow.getWidth() - this.getWidth()) / 2, 40);
    }

    private void trackMasterWindow() {
        this.dockedLocation = new Point(this.masterWindow.getLocation().x + (this.masterWindow.getWidth() - this.getWidth()) / 2, this.masterWindow.getLocation().y + this.masterWindow.getHeight());
        if (this.docked) {
            this.goToDockedLocation();
        } else if (this.locationDockable(this.getLocation())) {
            this.dock();
        }
        this.adjustSize();
    }

    private void dock() {
        this.goToDockedLocation();
        this.docked = true;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    private void undock() {
        this.docked = false;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    private void goToDockedLocation() {
        this.setLocation(this.dockedLocation);
    }

    private void adjustSize() {
        final Dimension targetSize = this.desiredSize();
        if (this.getSize().equals(targetSize)) {
            return;
        }
        final int dir = targetSize.height > this.getHeight() ? -1 : 1;
        final int[] delta = new int[]{Math.abs(targetSize.height - this.getHeight())};
        this.sizeAdjustThread = new Thread(){

            @Override
            public void run() {
                while (delta[0] >= 0) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                DesktopConsolePanel.this.setSize(targetSize.width, targetSize.height + delta[0] * dir);
                            }
                        });
                        Thread.sleep(8L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    delta[0] = delta[0] - 8;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DesktopConsolePanel.this.setSize(targetSize);
                    }
                });
            }
        };
        this.sizeAdjustThread.start();
    }

    private Dimension desiredSize() {
        Insets ins = this.getInsets();
        int h = this.retracted ? (this.masterWindow.getWidth() < 465 ? 0 : 10) : 137;
        return new Dimension(465 + ins.left + ins.right, h + ins.top + ins.bottom);
    }

    class TopControls
    extends JPanel {
        private static final long serialVersionUID = 1L;

        TopControls() {
        }

        @Override
        public void paintComponent(Graphics g) {
            Insets ins = this.getInsets();
            int initialHeight = this.getHeight() - ins.bottom;
            boolean retr = DesktopConsolePanel.this.retracted;
            boolean dock = DesktopConsolePanel.this.docked;
            if (retr) {
                g.drawImage(DesktopConsolePanel.this.expandButtonImage, 225, initialHeight - 10, null);
            } else {
                g.drawImage(DesktopConsolePanel.this.retractButtonImage, 225, initialHeight - 10, null);
            }
            if (!dock) {
                g.drawImage(DesktopConsolePanel.this.closeButtonImage, 448, initialHeight - 132, null);
            }
        }
    }
}

