/*
 * Decompiled with CFR 0.152.
 */
package atari.board;

import atari.cartridge.Cartridge;
import atari.pia.PIA;
import atari.pia.RAM;
import atari.tia.TIA;
import general.board.BUS16Bits;
import general.board.ClockDriven;
import general.m6502.M6502;
import parameters.Parameters;
import utils.Randomizer;

public final class BUS
implements BUS16Bits,
ClockDriven {
    public Cartridge cartridge;
    public final M6502 cpu;
    public final RAM ram;
    public final TIA tia;
    public final PIA pia;
    private byte data = 0;
    private boolean cartridgeNeedsClock = false;
    private boolean cartridgeNeedsBusMonitoring = false;
    private static final int CART_MASK = 4096;
    private static final int CART_SEL = 4096;
    private static final int RAM_MASK = 4736;
    private static final int RAM_SEL = 128;
    private static final int TIA_MASK = 4224;
    private static final int TIA_SEL = 0;
    private static final int PIA_MASK = 4736;
    private static final int PIA_SEL = 640;
    private static final boolean DATA_RETENTION = Parameters.BUS_DATA_RETENTION;

    public BUS(M6502 cpu, TIA tia, PIA pia, RAM ram) {
        this.cpu = cpu;
        this.ram = ram;
        this.tia = tia;
        this.pia = pia;
        cpu.connectBus(this);
        tia.connectBus(this);
        pia.connectBus(this);
    }

    public void powerOn() {
        this.data = this.cartridge == null ? (byte)Randomizer.instance.nextInt(256) : (byte)0;
    }

    public void powerOff() {
    }

    @Override
    public void clockPulse() {
        this.pia.clockPulse();
        this.cpu.clockPulse();
        if (this.cartridgeNeedsClock) {
            this.cartridge.clockPulse();
        }
    }

    @Override
    public byte readByte(int address) {
        if ((address & 0x1000) == 4096) {
            if (this.cartridge != null) {
                this.data = this.cartridge.readByte(address);
            }
        } else {
            this.data = (address & 0x1280) == 128 ? this.ram.readByte(address) : ((address & 0x1280) == 640 ? this.pia.readByte(address) : (DATA_RETENTION ? (byte)(this.data & 0x3F | this.tia.readByte(address)) : this.tia.readByte(address)));
        }
        if (this.cartridgeNeedsBusMonitoring) {
            this.cartridge.monitorByteRead(address, this.data);
        }
        return this.data;
    }

    @Override
    public void writeByte(int address, byte b) {
        this.data = b;
        if ((address & 0x1280) == 128) {
            this.ram.writeByte(address, b);
        } else if ((address & 0x1080) == 0) {
            this.tia.writeByte(address, b);
        } else if ((address & 0x1280) == 640) {
            this.pia.writeByte(address, b);
        } else if (this.cartridge != null) {
            this.cartridge.writeByte(address, b);
        }
        if (this.cartridgeNeedsBusMonitoring) {
            this.cartridge.monitorByteWritten(address, b);
        }
    }

    public void cartridge(Cartridge cartridge) {
        this.cartridge = cartridge;
        if (cartridge != null) {
            cartridge.connectBus(this);
        }
        this.cartridgeNeedsClock = cartridge == null ? false : cartridge.needsClock();
        this.cartridgeNeedsBusMonitoring = cartridge == null ? false : cartridge.needsBusMonitoring();
    }
}

