/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge.formats;

import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeFormat;
import atari.cartridge.CartridgeFormatOption;
import atari.cartridge.formats.CartridgeFormatOptionHinted;

public final class Cartridge2K_CV
extends Cartridge {
    private byte[] extraRAM = new byte[1024];
    private static final int SIZE = 2048;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("CV", "2K Commavid +RAM"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge create(byte[] content, String contentName) {
            return new Cartridge2K_CV(content, contentName, null);
        }

        @Override
        public CartridgeFormatOption getOption(byte[] content, String contentName) {
            if (content.length != 2048 && content.length != 4096) {
                return null;
            }
            return new CartridgeFormatOptionHinted(102, this, contentName);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge2K_CV(byte[] content, String contentName) {
        super(new byte[4096], contentName, FORMAT);
        int len = content.length;
        int pos = 0;
        while (pos < 4096) {
            System.arraycopy(content, 0, this.bytes, pos, len);
            pos += len;
        }
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        if (this.maskedAddress < 1024) {
            return this.extraRAM[this.maskedAddress];
        }
        return this.bytes[this.maskedAddress];
    }

    @Override
    public void writeByte(int address, byte b) {
        this.maskAddress(address);
        if (this.maskedAddress >= 1024 && this.maskedAddress <= 2047) {
            this.extraRAM[this.maskedAddress - 1024] = b;
        }
    }

    @Override
    public Cartridge2K_CV clone() {
        Cartridge2K_CV clone = (Cartridge2K_CV)super.clone();
        clone.extraRAM = (byte[])this.extraRAM.clone();
        return clone;
    }

    /* synthetic */ Cartridge2K_CV(byte[] byArray, String string, Cartridge2K_CV cartridge2K_CV) {
        this(byArray, string);
    }
}

