/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge.formats;

import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeFormat;
import atari.cartridge.CartridgeFormatOption;
import atari.cartridge.formats.CartridgeBanked;
import atari.cartridge.formats.CartridgeFormatOptionHinted;

public final class Cartridge64K_F0
extends CartridgeBanked {
    private static final int SIZE = 65536;
    private static final int BANK_SIZE = 4096;
    private static final int BANKSW_ADDRESS = 4080;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("F0", "64K Dynacom Megaboy"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge create(byte[] content, String contentName) {
            return new Cartridge64K_F0(content, contentName, null);
        }

        @Override
        public CartridgeFormatOption getOption(byte[] content, String contentName) {
            if (content.length != 65536) {
                return null;
            }
            return new CartridgeFormatOptionHinted(101, this, contentName);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge64K_F0(byte[] content, String contentName) {
        super(content, contentName, FORMAT);
    }

    @Override
    protected void performBankSwitchOnMaskedAddress() {
        if (this.maskedAddress == 4080) {
            this.bankAddressOffset += 4096;
            if (this.bankAddressOffset >= 65536) {
                this.bankAddressOffset = 0;
            }
        }
    }

    /* synthetic */ Cartridge64K_F0(byte[] byArray, String string, Cartridge64K_F0 cartridge64K_F0) {
        this(byArray, string);
    }
}

