/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge.formats;

import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeFormat;
import atari.cartridge.CartridgeFormatOption;
import atari.cartridge.formats.CartridgeBankedByBusMonitoring;
import atari.cartridge.formats.CartridgeFormatOptionHinted;

public class Cartridge64K_X07
extends CartridgeBankedByBusMonitoring {
    protected static final int BANK_SIZE = 4096;
    protected static final int BANK_14_ADDRESS = 57344;
    protected static final int SIZE = 65536;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("X07", "64K AtariAge"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge create(byte[] content, String contentName) {
            return new Cartridge64K_X07(content, contentName);
        }

        @Override
        public CartridgeFormatOption getOption(byte[] content, String contentName) {
            if (content.length != 65536) {
                return null;
            }
            return new CartridgeFormatOptionHinted(102, this, contentName);
        }
    };
    public static final long serialVersionUID = 1L;

    protected Cartridge64K_X07(byte[] content, String contentName) {
        super(content, contentName, FORMAT);
    }

    @Override
    protected void performBankSwitchOnMonitoredAccess(int address) {
        if ((address & 0x180F) == 2061) {
            this.bankAddressOffset = ((address & 0xF0) >> 4) * 4096;
        } else if (this.bankAddressOffset >= 57344 && (address & 0x1880) == 0) {
            this.bankAddressOffset = ((address & 0x40) == 0 ? 14 : 15) * 4096;
        }
    }
}

