/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge.formats;

import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeFormat;
import atari.cartridge.CartridgeFormatOption;
import atari.cartridge.formats.CartridgeBankedByBusMonitoring;
import atari.cartridge.formats.CartridgeFormatOptionHinted;

public class Cartridge8K_512K_SB
extends CartridgeBankedByBusMonitoring {
    private final int maxBank;
    protected static final int BANK_SIZE = 4096;
    protected static final int MIN_SIZE = 8192;
    protected static final int MAX_SIZE = 262144;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("SB", "8K-512K Superbanking"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge create(byte[] content, String contentName) {
            return new Cartridge8K_512K_SB(content, contentName);
        }

        @Override
        public CartridgeFormatOption getOption(byte[] content, String contentName) {
            if (content.length % 4096 != 0 || content.length < 8192 || content.length > 262144) {
                return null;
            }
            return new CartridgeFormatOptionHinted(113, this, contentName);
        }
    };
    public static final long serialVersionUID = 1L;

    protected Cartridge8K_512K_SB(byte[] content, String contentName) {
        super(content, contentName, FORMAT);
        this.maxBank = content.length / 4096 - 1;
    }

    @Override
    protected void performBankSwitchOnMonitoredAccess(int address) {
        if ((address & 0x1800) != 2048) {
            return;
        }
        int bank = address & 0x7F;
        if (bank > this.maxBank) {
            return;
        }
        this.bankAddressOffset = bank * 4096;
    }
}

