/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge.formats;

import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeFormat;
import atari.cartridge.CartridgeFormatOption;
import atari.cartridge.formats.CartridgeBankedByMaskedRange;
import atari.cartridge.formats.CartridgeFormatOptionHinted;

public final class Cartridge8K_64K_EF
extends CartridgeBankedByMaskedRange {
    private static final int MIN_SIZE = 8192;
    private static final int MAX_SIZE = 65536;
    private static final int BANK_SIZE = 4096;
    private static final int BASE_BANKSW_ADDRESS = 4064;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("EF", "8K-64K H. Runner (+RAM)"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge create(byte[] content, String contentName) {
            return new Cartridge8K_64K_EF(content, contentName, null);
        }

        @Override
        public CartridgeFormatOption getOption(byte[] content, String contentName) {
            if (content.length % 4096 != 0 || content.length < 8192 || content.length > 65536) {
                return null;
            }
            return new CartridgeFormatOptionHinted(114, this, contentName);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge8K_64K_EF(byte[] content, String contentName) {
        super(content, contentName, FORMAT, 4064, null, 128);
    }

    /* synthetic */ Cartridge8K_64K_EF(byte[] byArray, String string, Cartridge8K_64K_EF cartridge8K_64K_EF) {
        this(byArray, string);
    }
}

