/*
 * Decompiled with CFR 0.152.
 */
package atari.console;

import atari.board.BUS;
import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeFormatOption;
import atari.cartridge.CartridgeSocket;
import atari.cartridge.formats.CartridgeDatabase;
import atari.console.savestate.ConsoleState;
import atari.console.savestate.SaveStateMedia;
import atari.console.savestate.SaveStateSocket;
import atari.controls.ConsoleControls;
import atari.controls.ConsoleControlsInput;
import atari.controls.ConsoleControlsSocket;
import atari.pia.PIA;
import atari.pia.RAM;
import atari.tia.TIA;
import general.av.audio.AudioSignal;
import general.av.video.VideoSignal;
import general.av.video.VideoStandard;
import general.board.Clock;
import general.m6502.M6502;
import java.util.ArrayList;
import java.util.Map;
import parameters.Parameters;

public class Console {
    public boolean powerOn = false;
    protected BUS bus;
    protected M6502 cpu;
    protected TIA tia;
    protected PIA pia;
    protected RAM ram;
    protected VideoStandard videoStandard;
    protected boolean videoStandardAuto = true;
    private boolean videoStandardAutoDetectionInProgress = false;
    protected ConsoleControlsSocket controlsSocket;
    protected CartridgeSocketAdapter cartridgeSocket;
    protected SaveStateSocketAdapter saveStateSocket;
    protected Clock mainClock;
    public static final int FAST_SPEED_FACTOR = Parameters.CONSOLE_FAST_SPEED_FACTOR;

    public Console() {
        this.mainComponentsCreate();
        this.socketsCreate();
        this.mainClockCreate();
        this.videoStandardAuto();
    }

    public VideoSignal videoOutput() {
        return this.tia.videoOutput();
    }

    public AudioSignal audioOutput() {
        return this.tia.audioOutput();
    }

    public ConsoleControlsSocket controlsSocket() {
        return this.controlsSocket;
    }

    public CartridgeSocket cartridgeSocket() {
        return this.cartridgeSocket;
    }

    public SaveStateSocket saveStateSocket() {
        return this.saveStateSocket;
    }

    public void powerOn() {
        if (this.powerOn) {
            this.powerOff();
        }
        this.bus.powerOn();
        this.ram.powerOn();
        this.cpu.powerOn();
        this.pia.powerOn();
        this.tia.powerOn();
        this.powerOn = true;
        this.controlsSocket.controlsStatesRedefined();
        this.mainClockGo();
        this.videoStandardAutoDetectionStart();
        if (this.cartridge() == null) {
            this.showOSD("NO CARTRIDGE INSERTED!", true);
        }
    }

    public void powerOff() {
        this.mainClockPause();
        this.tia.powerOff();
        this.pia.powerOff();
        this.cpu.powerOff();
        this.ram.powerOff();
        this.bus.powerOff();
        this.powerOn = false;
        this.controlsSocket.controlsStatesRedefined();
    }

    public void destroy() {
        this.mainClockDestroy();
    }

    public void showOSD(String message, boolean overlap) {
        this.tia.videoOutput().showOSD(message, overlap);
    }

    public VideoStandard videoStandard() {
        return this.videoStandard;
    }

    public void videoStandard(VideoStandard videoStandard) {
        if (videoStandard != this.videoStandard) {
            this.videoStandard = videoStandard;
            this.tia.videoStandard(this.videoStandard);
            this.mainClockAdjustToNormal();
        }
        this.showOSD(String.valueOf(this.videoStandardAuto ? "AUTO: " : "") + videoStandard.toString(), false);
    }

    public Clock mainClock() {
        return this.mainClock;
    }

    protected Cartridge cartridge() {
        return this.bus.cartridge;
    }

    protected void cartridge(Cartridge cartridge) {
        this.controlsSocket.removeForwardedInput(this.cartridge());
        this.bus.cartridge(cartridge);
        if (cartridge != null) {
            this.controlsSocket.addForwardedInput(cartridge);
        }
    }

    protected void videoStandardAuto() {
        this.videoStandardAuto = true;
        if (this.powerOn) {
            this.videoStandardAutoDetectionStart();
        } else {
            this.videoStandard(VideoStandard.NTSC);
        }
    }

    protected void videoStandardAutoDetectionStart() {
        VideoStandard suggestedStandard;
        if (!this.videoStandardAuto || this.videoStandardAutoDetectionInProgress) {
            return;
        }
        VideoStandard videoStandard = suggestedStandard = this.bus.cartridge != null ? this.bus.cartridge.suggestedVideoStandard() : VideoStandard.NTSC;
        if (suggestedStandard != null) {
            this.videoStandard(suggestedStandard);
            return;
        }
        if (this.tia.videoOutput().monitor() == null) {
            return;
        }
        this.videoStandardAutoDetectionInProgress = true;
        this.tia.videoOutput().monitor().videoStandardDetectionStart();
        new Thread(){

            @Override
            public void run() {
                VideoStandard std;
                int tries = 0;
                do {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((std = Console.this.tia.videoOutput().monitor().videoStandardDetected()) == null && ++tries < 75);
                if (std != null) {
                    Console.this.videoStandard(std);
                } else {
                    Console.this.showOSD("AUTO: FAILED", false);
                }
                Console.this.videoStandardAutoDetectionInProgress = false;
            }
        }.start();
    }

    protected void videoStandardForced(VideoStandard forcedVideoStandard) {
        this.videoStandardAuto = false;
        this.videoStandard(forcedVideoStandard);
    }

    protected void mainComponentsCreate() {
        this.cpu = new M6502();
        this.tia = new TIA();
        this.pia = new PIA();
        this.ram = new RAM();
        this.bus = new BUS(this.cpu, this.tia, this.pia, this.ram);
    }

    protected void mainClockCreate() {
        this.mainClock = new Clock("Console(TIA)", this.tia, 0.0);
    }

    protected void mainClockAdjustToNormal() {
        this.mainClock.speed(this.tia.desiredClockForVideoStandard());
    }

    protected void mainClockAdjustToFast() {
        this.mainClock.speed(this.tia.desiredClockForVideoStandard() * (double)FAST_SPEED_FACTOR);
    }

    protected void mainClockGo() {
        this.mainClock.go();
    }

    protected void mainClockPause() {
        this.mainClock.pause();
    }

    protected void mainClockDestroy() {
        this.mainClock.terminate();
    }

    protected void socketsCreate() {
        this.controlsSocket = new ConsoleControlsSocket();
        this.controlsSocket.addForwardedInput(new ConsoleControlsInputAdapter());
        this.controlsSocket.addForwardedInput(this.tia);
        this.controlsSocket.addForwardedInput(this.pia);
        this.cartridgeSocket = new CartridgeSocketAdapter();
        this.saveStateSocket = new SaveStateSocketAdapter();
    }

    protected void loadState(ConsoleState state) {
        this.tia.loadState(state.tiaState);
        this.pia.loadState(state.piaState);
        this.ram.loadState(state.ramState);
        this.cpu.loadState(state.cpuState);
        this.cartridge(state.cartridge);
        this.videoStandard(state.videoStandard);
        this.controlsSocket.controlsStatesRedefined();
    }

    protected ConsoleState saveState() {
        return new ConsoleState(this.tia.saveState(), this.pia.saveState(), this.ram.saveState(), this.cpu.saveState(), this.cartridge(), this.videoStandard());
    }

    protected void powerFry() {
        this.ram.powerFry();
    }

    private ConsoleState pauseAndSaveState() {
        this.mainClockPause();
        ConsoleState state = this.saveState();
        this.mainClockGo();
        return state;
    }

    private void pauseAndLoadState(ConsoleState state) {
        this.mainClockPause();
        this.loadState(state);
        this.mainClockGo();
    }

    protected class CartridgeSocketAdapter
    implements CartridgeSocket {
        protected CartridgeSocketAdapter() {
        }

        @Override
        public void insert(Cartridge cartridge, boolean autoPower) {
            if (autoPower && Console.this.powerOn) {
                Console.this.powerOff();
            }
            Console.this.cartridge(cartridge);
            if (autoPower && !Console.this.powerOn) {
                Console.this.controlsSocket.controlStateChanged(ConsoleControls.Control.POWER, true);
            }
        }

        @Override
        public Cartridge inserted() {
            return Console.this.cartridge();
        }
    }

    protected class ConsoleControlsInputAdapter
    implements ConsoleControlsInput {
        @Override
        public void controlStateChanged(ConsoleControls.Control control, boolean state) {
            if (control == ConsoleControls.Control.FAST_SPEED) {
                if (state) {
                    Console.this.showOSD("FAST FORWARD", true);
                    Console.this.mainClockAdjustToFast();
                } else {
                    Console.this.showOSD("NORMAL SPEED", true);
                    Console.this.mainClockAdjustToNormal();
                }
                return;
            }
            if (!state) {
                return;
            }
            switch (control) {
                case POWER: {
                    if (Console.this.powerOn) {
                        Console.this.powerOff();
                        break;
                    }
                    Console.this.powerOn();
                    break;
                }
                case POWER_FRY: {
                    Console.this.powerFry();
                    break;
                }
                case SAVE_STATE_0: 
                case SAVE_STATE_1: 
                case SAVE_STATE_2: 
                case SAVE_STATE_3: 
                case SAVE_STATE_4: 
                case SAVE_STATE_5: 
                case SAVE_STATE_6: 
                case SAVE_STATE_7: 
                case SAVE_STATE_8: 
                case SAVE_STATE_9: 
                case SAVE_STATE_10: 
                case SAVE_STATE_11: 
                case SAVE_STATE_12: {
                    Console.this.saveStateSocket.saveState(control.slot);
                    break;
                }
                case LOAD_STATE_0: 
                case LOAD_STATE_1: 
                case LOAD_STATE_2: 
                case LOAD_STATE_3: 
                case LOAD_STATE_4: 
                case LOAD_STATE_5: 
                case LOAD_STATE_6: 
                case LOAD_STATE_7: 
                case LOAD_STATE_8: 
                case LOAD_STATE_9: 
                case LOAD_STATE_10: 
                case LOAD_STATE_11: 
                case LOAD_STATE_12: {
                    Console.this.saveStateSocket.loadState(control.slot);
                    break;
                }
                case VIDEO_STANDARD: {
                    Console.this.showOSD(null, true);
                    if (Console.this.videoStandardAuto) {
                        Console.this.videoStandardForced(VideoStandard.NTSC);
                        break;
                    }
                    if (Console.this.videoStandard() == VideoStandard.NTSC) {
                        Console.this.videoStandardForced(VideoStandard.PAL);
                        break;
                    }
                    Console.this.videoStandardAuto();
                    break;
                }
                case CARTRIDGE_FORMAT: {
                    if (Console.this.cartridge() == null) {
                        if (Console.this.cartridge() != null) break;
                        Console.this.showOSD("NO CARTRIDGE INSERTED!", true);
                        break;
                    }
                    ArrayList<CartridgeFormatOption> options = CartridgeDatabase.getFormatOptionsUnhinted(Console.this.cartridge());
                    if (options.isEmpty()) break;
                    CartridgeFormatOption currOption = null;
                    for (CartridgeFormatOption option : options) {
                        if (!option.format.equals(Console.this.cartridge().format())) continue;
                        currOption = option;
                    }
                    int pos = options.indexOf(currOption) + 1;
                    if (pos >= options.size()) {
                        pos = 0;
                    }
                    CartridgeFormatOption newOption = options.get(pos);
                    Cartridge newCart = newOption.format.create(Console.this.cartridge());
                    Console.this.cartridgeSocket().insert(newCart, true);
                    Console.this.showOSD(newOption.format.toString(), true);
                }
            }
        }

        @Override
        public void controlStateChanged(ConsoleControls.Control control, int position) {
        }

        @Override
        public void controlsStateReport(Map<ConsoleControls.Control, Boolean> report) {
            report.put(ConsoleControls.Control.POWER, Console.this.powerOn);
        }
    }

    protected class SaveStateSocketAdapter
    implements SaveStateSocket {
        private SaveStateMedia media;

        protected SaveStateSocketAdapter() {
        }

        @Override
        public void connectMedia(SaveStateMedia media) {
            this.media = media;
        }

        public void saveState(int slot) {
            if (!Console.this.powerOn || this.media == null) {
                return;
            }
            ConsoleState state = Console.this.pauseAndSaveState();
            if (this.media.save(slot, state)) {
                Console.this.showOSD("State " + slot + " saved", true);
            } else {
                Console.this.showOSD("State " + slot + " save failed", true);
            }
        }

        public void loadState(int slot) {
            if (!Console.this.powerOn || this.media == null) {
                return;
            }
            ConsoleState state = this.media.load(slot);
            if (state == null) {
                Console.this.showOSD("State " + slot + " load failed", true);
                return;
            }
            Console.this.pauseAndLoadState(state);
            Console.this.showOSD("State " + slot + " loaded", true);
        }
    }
}

