/*
 * Decompiled with CFR 0.152.
 */
package atari.network;

import atari.cartridge.Cartridge;
import atari.console.Console;
import atari.console.savestate.ConsoleState;
import atari.console.savestate.SaveStateMedia;
import atari.controls.ConsoleControls;
import atari.controls.ConsoleControlsSocket;
import atari.network.ControlChange;
import atari.network.ControlChangeForPaddle;
import atari.network.RemoteReceiver;
import atari.network.ServerUpdate;
import general.board.ClockDriven;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ClientConsole
extends Console
implements ClockDriven {
    private RemoteReceiver remoteReceiver;
    private static List<ConsoleControls.Control> DISABLED_CONTROLS = Arrays.asList(ConsoleControls.Control.CARTRIDGE_FORMAT);

    public ClientConsole(RemoteReceiver receiver) {
        this.setupReceiver(receiver);
    }

    public RemoteReceiver remoteReceiver() {
        return this.remoteReceiver;
    }

    @Override
    protected void mainClockCreate() {
    }

    @Override
    protected void mainClockAdjustToNormal() {
    }

    @Override
    protected void mainClockAdjustToFast() {
    }

    @Override
    protected void mainClockGo() {
    }

    @Override
    protected void mainClockPause() {
    }

    @Override
    protected void mainClockDestroy() {
    }

    @Override
    protected void socketsCreate() {
        this.controlsSocket = new ClientConsoleControlsSocketAdapter();
        this.controlsSocket.addForwardedInput(new Console.ConsoleControlsInputAdapter());
        this.controlsSocket.addForwardedInput(this.tia);
        this.controlsSocket.addForwardedInput(this.pia);
        this.cartridgeSocket = new ClientConsoleCartridgeSocketAdapter();
        this.saveStateSocket = new ClientConsoleSaveStateSourceAdapter();
    }

    @Override
    public void clockPulse() {
        this.tia.clockPulse();
    }

    void connected() {
        this.showOSD("Connected to Player 1 Server", true);
    }

    void disconnected() {
        this.showOSD("Disconnected from Player 1 Server", true);
    }

    void receiveServerUpdate(ServerUpdate update) {
        if (update.powerOn != null) {
            this.receiveServerPower(update.powerOn);
        }
        if (update.consoleState != null) {
            this.receiveServerState(update.consoleState);
        }
        if (update.controlChanges != null) {
            ((ClientConsoleControlsSocketAdapter)this.controlsSocket).serverControlChanges(update.controlChanges);
        }
        if (update.isClockPulse) {
            this.clockPulse();
        }
    }

    List<ControlChange> controlChangesToSend() {
        return ((ClientConsoleControlsSocketAdapter)this.controlsSocket).getChangesToSend();
    }

    private void receiveServerPower(boolean serverPowerOn) {
        if (serverPowerOn && !this.powerOn) {
            this.powerOn();
        } else if (!serverPowerOn && this.powerOn) {
            this.powerOff();
        }
    }

    private void receiveServerState(ConsoleState state) {
        this.loadState(state);
    }

    private void setupReceiver(RemoteReceiver receiver) {
        this.remoteReceiver = receiver;
        this.remoteReceiver.clientConsole(this);
    }

    private class ClientConsoleCartridgeSocketAdapter
    extends Console.CartridgeSocketAdapter {
        private ClientConsoleCartridgeSocketAdapter() {
        }

        @Override
        public void insert(Cartridge cartridge, boolean autoPower) {
            ClientConsole.this.showOSD("Only the Server can change Cartridges", true);
        }
    }

    private class ClientConsoleControlsSocketAdapter
    extends ConsoleControlsSocket {
        private List<ControlChange> queuedChanges = new ArrayList<ControlChange>();

        private ClientConsoleControlsSocketAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void controlStateChanged(ConsoleControls.Control control, boolean state) {
            if (DISABLED_CONTROLS.contains((Object)control)) {
                ClientConsole.this.showOSD("Option disabled in Player 2 Client", true);
                return;
            }
            List<ControlChange> list = this.queuedChanges;
            synchronized (list) {
                this.queuedChanges.add(new ControlChange(control, state));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void controlStateChanged(ConsoleControls.Control control, int position) {
            List<ControlChange> list = this.queuedChanges;
            synchronized (list) {
                this.queuedChanges.add(new ControlChangeForPaddle(control, position));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ControlChange> getChangesToSend() {
            List<ControlChange> list = this.queuedChanges;
            synchronized (list) {
                block4: {
                    if (!this.queuedChanges.isEmpty()) break block4;
                    return null;
                }
                ArrayList<ControlChange> changesToSend = new ArrayList<ControlChange>(this.queuedChanges);
                this.queuedChanges.clear();
                return changesToSend;
            }
        }

        public void serverControlChanges(List<ControlChange> changes) {
            for (ControlChange change : changes) {
                if (change instanceof ControlChangeForPaddle) {
                    super.controlStateChanged(change.control, ((ControlChangeForPaddle)change).position);
                    continue;
                }
                super.controlStateChanged(change.control, change.state);
            }
        }
    }

    private class ClientConsoleSaveStateSourceAdapter
    extends Console.SaveStateSocketAdapter {
        private ClientConsoleSaveStateSourceAdapter() {
        }

        @Override
        public void connectMedia(SaveStateMedia media) {
        }
    }
}

