/*
 * Decompiled with CFR 0.152.
 */
package atari.tia;

import atari.board.BUS;
import atari.controls.ConsoleControls;
import atari.controls.ConsoleControlsInput;
import atari.tia.audio.AudioGenerator;
import atari.tia.audio.AudioMonoGenerator;
import atari.tia.video.NTSCPalette;
import atari.tia.video.PALPalette;
import atari.tia.video.VideoGenerator;
import general.av.video.VideoStandard;
import general.board.BUS16Bits;
import general.board.ClockDriven;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import parameters.Parameters;
import utils.Array2DCopy;

public final class TIA
implements BUS16Bits,
ClockDriven,
ConsoleControlsInput {
    private final VideoGenerator videoOutput;
    private final AudioMonoGenerator audioOutput;
    private int clock = 0;
    private BUS bus;
    private boolean powerOn = false;
    private final int[] debugPixels = new int[228];
    private int[] palette;
    private int vSyncColor = -2236963;
    private int vBlankColor = 0;
    private int hBlankColor = 0;
    private boolean debugPause = false;
    private int debugPauseMoreFrames = 0;
    private boolean debug = false;
    private int debugLevel = 0;
    private boolean debugNoCollisions = false;
    private int[] linePixels = new int[228];
    private int lastObservableChangeClock = -1;
    private boolean observableChangeExtended = false;
    private boolean repeatLastLine;
    private boolean vSyncOn = false;
    private boolean vBlankOn = false;
    private boolean vBlankDecodeActive = false;
    private boolean vBlankNewState;
    private boolean hMoveHitBlank = false;
    private int hMoveHitClock = -1;
    private boolean hMoveLateHit = false;
    private boolean hMoveLateHitBlank = false;
    private boolean[] playfieldPattern = new boolean[40];
    private boolean playfieldPatternInvalid = true;
    private boolean playfieldCurrentPixel = false;
    private int playfieldColor = -16777216;
    private int playfieldBackground = -16777216;
    private boolean playfieldReflected = false;
    private boolean playfieldScoreMode = false;
    private boolean playfieldPriority = false;
    private int playfieldDelayedChangeClock = -1;
    private int playfieldDelayedChangePart = -1;
    private int playfieldDelayedChangePattern = -1;
    private int player0ActiveSprite = 0;
    private int player0DelayedSprite = 0;
    private int player0Color = -16777216;
    private boolean player0RecentReset = false;
    private int player0Counter = 0;
    private int player0ScanCounter = -1;
    private int player0ScanSpeed = 4;
    private boolean player0VerticalDelay = false;
    private boolean player0CloseCopy = false;
    private boolean player0MediumCopy = false;
    private boolean player0WideCopy = false;
    private boolean player0Reflected = false;
    private int player1ActiveSprite = 0;
    private int player1DelayedSprite = 0;
    private int player1Color = -16777216;
    private boolean player1RecentReset = false;
    private int player1Counter = 0;
    private int player1ScanCounter = -1;
    private int player1ScanSpeed = 4;
    private boolean player1VerticalDelay = false;
    private boolean player1CloseCopy = false;
    private boolean player1MediumCopy = false;
    private boolean player1WideCopy = false;
    private boolean player1Reflected = false;
    private boolean missile0Enabled = false;
    private int missile0Color = -16777216;
    private boolean missile0RecentReset = false;
    private int missile0Counter = 0;
    private int missile0ScanCounter = -1;
    private int missile0ScanSpeed = 8;
    private boolean missile0ResetToPlayer = false;
    private boolean missile1Enabled = false;
    private int missile1Color = -16777216;
    private boolean missile1RecentReset = false;
    private int missile1Counter = 0;
    private int missile1ScanCounter = -1;
    private int missile1ScanSpeed = 8;
    private boolean missile1ResetToPlayer = false;
    private boolean ballEnabled = false;
    private boolean ballDelayedEnablement = false;
    private int ballColor = -16777216;
    private int ballCounter = 0;
    private int ballScanCounter = -1;
    private int ballScanSpeed = 8;
    private boolean ballVerticalDelay = false;
    private int[][] playersDelayedSpriteChanges = new int[50][3];
    private int playersDelayedSpriteChangesCount = 0;
    private boolean controlsButtonsLatched = false;
    private boolean controlsJOY0ButtonPressed = false;
    private boolean controlsJOY1ButtonPressed = false;
    private boolean paddleCapacitorsGrounded = false;
    private int paddle0Position = -1;
    private int paddle0CapacitorCharge = 0;
    private int paddle1Position = -1;
    private int paddle1CapacitorCharge = 0;
    private int CXM0P;
    private int CXM1P;
    private int CXP0FB;
    private int CXP1FB;
    private int CXM0FB;
    private int CXM1FB;
    private int CXBLPF;
    private int CXPPMM;
    private int INPT0;
    private int INPT1;
    private int INPT2;
    private int INPT3;
    private int INPT4;
    private int INPT5;
    private int PF0;
    private int PF1;
    private int PF2;
    private int AUDC0;
    private int AUDC1;
    private int AUDF0;
    private int AUDF1;
    private int AUDV0;
    private int AUDV1;
    private int HMP0;
    private int HMP1;
    private int HMM0;
    private int HMM1;
    private int HMBL;
    private static final int VBLANK_COLOR = 0;
    private static final int HBLANK_COLOR = -16777216;
    private static final int VSYNC_COLOR = -2236963;
    private static final int HBLANK_DURATION = 68;
    private static final int LINE_WIDTH = 228;
    private static final int DEBUG_MARKS_COLOR = -14671840;
    private static final int DEBUG_HBLANK_COLOR = -12303292;
    private static final int DEBUG_VBLANK_COLOR = -14013910;
    private static final int DEBUG_WSYNC_COLOR = -7864184;
    private static final int DEBUG_HMOVE_COLOR = -1;
    private static final int DEBUG_P0_COLOR = -16776961;
    private static final int DEBUG_P0_RES_COLOR = -14540101;
    private static final int DEBUG_P0_GR_COLOR = -15658633;
    private static final int DEBUG_P1_COLOR = -65536;
    private static final int DEBUG_P1_RES_COLOR = -4513246;
    private static final int DEBUG_P1_GR_COLOR = -8974063;
    private static final int DEBUG_M0_COLOR = -10066177;
    private static final int DEBUG_M1_COLOR = -39322;
    private static final int DEBUG_PF_COLOR = -12285884;
    private static final int DEBUG_PF_GR_COLOR = -13378253;
    private static final int DEBUG_BK_COLOR = -13417421;
    private static final int DEBUG_BL_COLOR = -256;
    private static final int DEBUG_SP_COLOR = -16711681;
    private static final int DEBUG_SP_COLOR2 = -65281;
    private static final int READ_ADDRESS_MASK = 15;
    private static final int WRITE_ADDRESS_MASK = 63;
    private static final int PLAYERS_DELAYED_SPRITE_GHANGES_MAX_COUNT = 50;
    private static final boolean SYNC_WITH_AUDIO_MONITOR = Parameters.TIA_SYNC_WITH_AUDIO_MONITOR;
    private static final boolean SYNC_WITH_VIDEO_MONITOR = Parameters.TIA_SYNC_WITH_VIDEO_MONITOR;
    private static final double FORCED_CLOCK = Parameters.TIA_FORCED_CLOCK;

    public TIA() {
        this.videoOutput = new VideoGenerator();
        this.audioOutput = new AudioMonoGenerator();
    }

    public void connectBus(BUS bus) {
        this.bus = bus;
    }

    public VideoGenerator videoOutput() {
        return this.videoOutput;
    }

    public AudioGenerator audioOutput() {
        return this.audioOutput;
    }

    public void videoStandard(VideoStandard standard) {
        this.videoOutput.standard(standard);
        this.audioOutput.videoStandard(standard);
        this.palette = standard.equals((Object)VideoStandard.NTSC) ? NTSCPalette.getPalette() : PALPalette.getPalette();
    }

    public double desiredClockForVideoStandard() {
        if (FORCED_CLOCK != 0.0) {
            return FORCED_CLOCK;
        }
        return this.videoOutput.standard().fps;
    }

    public void powerOn() {
        Arrays.fill(this.linePixels, -16777216);
        Arrays.fill(this.debugPixels, 0);
        this.initLatchesAtPowerOn();
        this.observableChangeExtended();
        this.powerOn = true;
    }

    public void powerOff() {
        this.powerOn = false;
        this.videoOutput.nextLine(null, false);
        this.audioOutput.channel0().setVolume(0);
        this.audioOutput.channel1().setVolume(0);
    }

    @Override
    public void clockPulse() {
        if (!this.powerOn || this.debugPause && this.debugPausedNoMoreFrames()) {
            return;
        }
        boolean videoOutputVSynched = false;
        do {
            this.clock = 0;
            this.bus.clockPulse();
            if (!this.bus.cpu.RDY) {
                this.bus.cpu.RDY = true;
            }
            this.clock = 3;
            while (this.clock < 68) {
                if (!this.repeatLastLine) {
                    this.checkRepeatMode();
                }
                this.bus.clockPulse();
                this.clock += 3;
            }
            this.audioOutput.clockPulse();
            int subClock3 = 2;
            this.clock = 68;
            while (this.clock < 228) {
                if (!this.repeatLastLine) {
                    this.checkRepeatMode();
                }
                if (this.vBlankDecodeActive) {
                    this.vBlankClockDecode();
                }
                if (--subClock3 == 0) {
                    this.bus.clockPulse();
                    subClock3 = 3;
                }
                this.objectsClockCounters();
                if (!(this.repeatLastLine || this.clock < 76 && this.hMoveHitBlank)) {
                    this.setPixelValue();
                }
                ++this.clock;
            }
            this.audioOutput.clockPulse();
            if (this.paddle0Position >= 0 && !this.paddleCapacitorsGrounded) {
                this.chargePaddleCapacitors();
            }
            this.finishLine();
        } while (!(videoOutputVSynched = this.videoOutput.nextLine(this.linePixels, this.vSyncOn)) && this.powerOn);
        if (this.powerOn) {
            this.audioOutput.sendSamplesFrameToMonitor();
            if (SYNC_WITH_AUDIO_MONITOR) {
                this.audioOutput.monitor().synchOutput();
            }
            if (SYNC_WITH_VIDEO_MONITOR) {
                this.videoOutput.monitor().synchOutput();
            }
        }
    }

    private void checkRepeatMode() {
        if (this.clock == this.lastObservableChangeClock) {
            this.repeatLastLine = true;
            this.lastObservableChangeClock = -1;
        }
    }

    private void setPixelValue() {
        int sprite;
        if (this.vSyncOn) {
            this.linePixels[this.clock] = this.vSyncColor;
            return;
        }
        if (this.vBlankOn) {
            this.linePixels[this.clock] = this.vBlankColor;
            return;
        }
        if ((this.clock & 3) == 0 || this.clock == this.lastObservableChangeClock) {
            this.playfieldUpdateCurrentPixel();
        }
        int color = 1;
        boolean P0 = false;
        boolean P1 = false;
        boolean M0 = false;
        boolean M1 = false;
        boolean FL = false;
        boolean BL = false;
        if (this.playfieldPriority) {
            if (this.ballScanCounter >= 0 && this.ballScanCounter <= 7) {
                this.playersPerformDelayedSpriteChanges();
                if (this.ballEnabled) {
                    BL = true;
                    color = this.ballColor;
                }
            }
            if (this.playfieldCurrentPixel) {
                FL = true;
                if (color > 0) {
                    color = this.playfieldColor;
                }
            }
        }
        if (this.player0ScanCounter >= 0 && this.player0ScanCounter <= 31) {
            this.playersPerformDelayedSpriteChanges();
            int n = sprite = this.player0VerticalDelay ? this.player0ActiveSprite : this.player0DelayedSprite;
            if (sprite != 0 && (sprite >> (this.player0Reflected ? 7 - (this.player0ScanCounter >>> 2) : this.player0ScanCounter >>> 2) & 1) != 0) {
                P0 = true;
                if (color > 0) {
                    color = this.player0Color;
                }
            }
        }
        if (this.missile0ScanCounter >= 0 && this.missile0Enabled && this.missile0ScanCounter <= 7 && !this.missile0ResetToPlayer) {
            M0 = true;
            if (color > 0) {
                color = this.missile0Color;
            }
        }
        if (this.player1ScanCounter >= 0 && this.player1ScanCounter <= 31) {
            this.playersPerformDelayedSpriteChanges();
            int n = sprite = this.player1VerticalDelay ? this.player1ActiveSprite : this.player1DelayedSprite;
            if (sprite != 0 && (sprite >> (this.player1Reflected ? 7 - (this.player1ScanCounter >>> 2) : this.player1ScanCounter >>> 2) & 1) != 0) {
                P1 = true;
                if (color > 0) {
                    color = this.player1Color;
                }
            }
        }
        if (this.missile1ScanCounter >= 0 && this.missile1Enabled && this.missile1ScanCounter <= 7 && !this.missile1ResetToPlayer) {
            M1 = true;
            if (color > 0) {
                color = this.missile1Color;
            }
        }
        if (!this.playfieldPriority) {
            if (this.ballScanCounter >= 0 && this.ballScanCounter <= 7) {
                this.playersPerformDelayedSpriteChanges();
                if (this.ballEnabled) {
                    BL = true;
                    if (color > 0) {
                        color = this.ballColor;
                    }
                }
            }
            if (this.playfieldCurrentPixel) {
                FL = true;
                if (color > 0) {
                    int n = !this.playfieldScoreMode ? this.playfieldColor : (color = this.clock < 148 ? this.player0Color : this.player1Color);
                }
            }
        }
        if (color > 0) {
            color = this.playfieldBackground;
        }
        this.linePixels[this.clock] = color;
        if (this.debugNoCollisions) {
            return;
        }
        if (P0 && FL) {
            this.CXP0FB |= 0x80;
        }
        if (P1) {
            if (FL) {
                this.CXP1FB |= 0x80;
            }
            if (P0) {
                this.CXPPMM |= 0x80;
            }
        }
        if (BL) {
            if (FL) {
                this.CXBLPF |= 0x80;
            }
            if (P0) {
                this.CXP0FB |= 0x40;
            }
            if (P1) {
                this.CXP1FB |= 0x40;
            }
        }
        if (M0) {
            if (P1) {
                this.CXM0P |= 0x80;
            }
            if (P0) {
                this.CXM0P |= 0x40;
            }
            if (FL) {
                this.CXM0FB |= 0x80;
            }
            if (BL) {
                this.CXM0FB |= 0x40;
            }
        }
        if (M1) {
            if (P0) {
                this.CXM1P |= 0x80;
            }
            if (P1) {
                this.CXM1P |= 0x40;
            }
            if (FL) {
                this.CXM1FB |= 0x80;
            }
            if (BL) {
                this.CXM1FB |= 0x40;
            }
            if (M0) {
                this.CXPPMM |= 0x40;
            }
        }
    }

    private void objectsClockCounters() {
        this.player0ClockCounter();
        this.player1ClockCounter();
        this.missile0ClockCounter();
        this.missile1ClockCounter();
        this.ballClockCounter();
    }

    private void player0ClockCounter() {
        if (++this.player0Counter == 160) {
            this.player0Counter = 0;
        }
        if (this.player0ScanCounter >= 0) {
            if (this.missile0ResetToPlayer && this.player0Counter < 12 && this.player0ScanCounter >= 28 && this.player0ScanCounter <= 31) {
                this.missile0Counter = 156;
            }
            this.player0ScanCounter -= this.player0ScanSpeed;
        }
        if (this.player0Counter == 156) {
            if (this.player0RecentReset) {
                this.player0RecentReset = false;
            } else {
                this.player0ScanCounter = 31 + this.player0ScanSpeed * (this.player0ScanSpeed == 4 ? 5 : 6);
            }
        } else if (this.player0Counter == 12) {
            if (this.player0CloseCopy) {
                this.player0ScanCounter = 31 + this.player0ScanSpeed * 5;
            }
        } else if (this.player0Counter == 28) {
            if (this.player0MediumCopy) {
                this.player0ScanCounter = 31 + this.player0ScanSpeed * 5;
            }
        } else if (this.player0Counter == 60 && this.player0WideCopy) {
            this.player0ScanCounter = 31 + this.player0ScanSpeed * 5;
        }
    }

    private void player1ClockCounter() {
        if (++this.player1Counter == 160) {
            this.player1Counter = 0;
        }
        if (this.player1ScanCounter >= 0) {
            if (this.missile1ResetToPlayer && this.player1Counter < 12 && this.player1ScanCounter >= 28 && this.player1ScanCounter <= 31) {
                this.missile1Counter = 156;
            }
            this.player1ScanCounter -= this.player1ScanSpeed;
        }
        if (this.player1Counter == 156) {
            if (this.player1RecentReset) {
                this.player1RecentReset = false;
            } else {
                this.player1ScanCounter = 31 + this.player1ScanSpeed * (this.player1ScanSpeed == 4 ? 5 : 6);
            }
        } else if (this.player1Counter == 12) {
            if (this.player1CloseCopy) {
                this.player1ScanCounter = 31 + this.player1ScanSpeed * 5;
            }
        } else if (this.player1Counter == 28) {
            if (this.player1MediumCopy) {
                this.player1ScanCounter = 31 + this.player1ScanSpeed * 5;
            }
        } else if (this.player1Counter == 60 && this.player1WideCopy) {
            this.player1ScanCounter = 31 + this.player1ScanSpeed * 5;
        }
    }

    private void missile0ClockCounter() {
        if (++this.missile0Counter == 160) {
            this.missile0Counter = 0;
        }
        if (this.missile0ScanCounter >= 0) {
            this.missile0ScanCounter -= this.missile0ScanSpeed;
        }
        if (this.missile0Counter == 156) {
            if (this.missile0RecentReset) {
                this.missile0RecentReset = false;
            } else {
                this.missile0ScanCounter = 7 + this.missile0ScanSpeed * 4;
            }
        } else if (this.missile0Counter == 12) {
            if (this.player0CloseCopy) {
                this.missile0ScanCounter = 7 + this.missile0ScanSpeed * 4;
            }
        } else if (this.missile0Counter == 28) {
            if (this.player0MediumCopy) {
                this.missile0ScanCounter = 7 + this.missile0ScanSpeed * 4;
            }
        } else if (this.missile0Counter == 60 && this.player0WideCopy) {
            this.missile0ScanCounter = 7 + this.missile0ScanSpeed * 4;
        }
    }

    private void missile1ClockCounter() {
        if (++this.missile1Counter == 160) {
            this.missile1Counter = 0;
        }
        if (this.missile1ScanCounter >= 0) {
            this.missile1ScanCounter -= this.missile1ScanSpeed;
        }
        if (this.missile1Counter == 156) {
            if (this.missile1RecentReset) {
                this.missile1RecentReset = false;
            } else {
                this.missile1ScanCounter = 7 + this.missile1ScanSpeed * 4;
            }
        } else if (this.missile1Counter == 12) {
            if (this.player1CloseCopy) {
                this.missile1ScanCounter = 7 + this.missile1ScanSpeed * 4;
            }
        } else if (this.missile1Counter == 28) {
            if (this.player1MediumCopy) {
                this.missile1ScanCounter = 7 + this.missile1ScanSpeed * 4;
            }
        } else if (this.missile1Counter == 60 && this.player1WideCopy) {
            this.missile1ScanCounter = 7 + this.missile1ScanSpeed * 4;
        }
    }

    private void ballClockCounter() {
        if (++this.ballCounter == 160) {
            this.ballCounter = 0;
        }
        if (this.ballScanCounter >= 0) {
            this.ballScanCounter -= this.ballScanSpeed;
        }
        if (this.ballCounter == 156) {
            this.ballScanCounter = 7 + this.ballScanSpeed * 4;
        }
    }

    private void playfieldDelaySpriteChange(int part, int sprite) {
        this.observableChange();
        if (this.debug) {
            this.debugPixel(-13378253);
        }
        this.playfieldPerformDelayedSpriteChange(true);
        this.playfieldDelayedChangeClock = this.clock;
        this.playfieldDelayedChangePart = part;
        this.playfieldDelayedChangePattern = sprite;
    }

    private void playfieldPerformDelayedSpriteChange(boolean force) {
        int dif;
        if (this.playfieldDelayedChangePart == -1) {
            return;
        }
        if (!(force || (dif = this.clock - this.playfieldDelayedChangeClock) != 0 && dif != 1)) {
            return;
        }
        this.observableChange();
        if (this.playfieldDelayedChangePart == 0) {
            this.PF0 = this.playfieldDelayedChangePattern;
        } else if (this.playfieldDelayedChangePart == 1) {
            this.PF1 = this.playfieldDelayedChangePattern;
        } else if (this.playfieldDelayedChangePart == 2) {
            this.PF2 = this.playfieldDelayedChangePattern;
        }
        this.playfieldPatternInvalid = true;
        this.playfieldDelayedChangePart = -1;
    }

    private void playfieldUpdateCurrentPixel() {
        this.playfieldPerformDelayedSpriteChange(false);
        if (this.playfieldPatternInvalid) {
            int i;
            int s;
            this.playfieldPatternInvalid = false;
            if (this.PF0 == 0 && this.PF1 == 0 && this.PF2 == 0) {
                Arrays.fill(this.playfieldPattern, false);
                this.playfieldCurrentPixel = false;
                return;
            }
            if (this.playfieldReflected) {
                s = 40;
                i = -1;
            } else {
                s = 19;
                i = 1;
            }
            boolean bl = (this.PF0 & 0x10) != 0;
            this.playfieldPattern[s += i] = bl;
            this.playfieldPattern[0] = bl;
            boolean bl2 = (this.PF0 & 0x20) != 0;
            this.playfieldPattern[s += i] = bl2;
            this.playfieldPattern[1] = bl2;
            boolean bl3 = (this.PF0 & 0x40) != 0;
            this.playfieldPattern[s += i] = bl3;
            this.playfieldPattern[2] = bl3;
            boolean bl4 = (this.PF0 & 0x80) != 0;
            this.playfieldPattern[s += i] = bl4;
            this.playfieldPattern[3] = bl4;
            boolean bl5 = (this.PF1 & 0x80) != 0;
            this.playfieldPattern[s += i] = bl5;
            this.playfieldPattern[4] = bl5;
            boolean bl6 = (this.PF1 & 0x40) != 0;
            this.playfieldPattern[s += i] = bl6;
            this.playfieldPattern[5] = bl6;
            boolean bl7 = (this.PF1 & 0x20) != 0;
            this.playfieldPattern[s += i] = bl7;
            this.playfieldPattern[6] = bl7;
            boolean bl8 = (this.PF1 & 0x10) != 0;
            this.playfieldPattern[s += i] = bl8;
            this.playfieldPattern[7] = bl8;
            boolean bl9 = (this.PF1 & 8) != 0;
            this.playfieldPattern[s += i] = bl9;
            this.playfieldPattern[8] = bl9;
            boolean bl10 = (this.PF1 & 4) != 0;
            this.playfieldPattern[s += i] = bl10;
            this.playfieldPattern[9] = bl10;
            boolean bl11 = (this.PF1 & 2) != 0;
            this.playfieldPattern[s += i] = bl11;
            this.playfieldPattern[10] = bl11;
            boolean bl12 = (this.PF1 & 1) != 0;
            this.playfieldPattern[s += i] = bl12;
            this.playfieldPattern[11] = bl12;
            boolean bl13 = (this.PF2 & 1) != 0;
            this.playfieldPattern[s += i] = bl13;
            this.playfieldPattern[12] = bl13;
            boolean bl14 = (this.PF2 & 2) != 0;
            this.playfieldPattern[s += i] = bl14;
            this.playfieldPattern[13] = bl14;
            boolean bl15 = (this.PF2 & 4) != 0;
            this.playfieldPattern[s += i] = bl15;
            this.playfieldPattern[14] = bl15;
            boolean bl16 = (this.PF2 & 8) != 0;
            this.playfieldPattern[s += i] = bl16;
            this.playfieldPattern[15] = bl16;
            boolean bl17 = (this.PF2 & 0x10) != 0;
            this.playfieldPattern[s += i] = bl17;
            this.playfieldPattern[16] = bl17;
            boolean bl18 = (this.PF2 & 0x20) != 0;
            this.playfieldPattern[s += i] = bl18;
            this.playfieldPattern[17] = bl18;
            boolean bl19 = (this.PF2 & 0x40) != 0;
            this.playfieldPattern[s += i] = bl19;
            this.playfieldPattern[18] = bl19;
            boolean bl20 = (this.PF2 & 0x80) != 0;
            this.playfieldPattern[s += i] = bl20;
            this.playfieldPattern[19] = bl20;
        }
        this.playfieldCurrentPixel = this.playfieldPattern[this.clock - 68 >>> 2];
    }

    private void playerDelaySpriteChange(int player, int sprite) {
        this.observableChange();
        if (this.debug) {
            this.debugPixel(player == 0 ? -15658633 : -8974063);
        }
        if (this.playersDelayedSpriteChangesCount >= 50) {
            this.debugInfo(">>> Max player delayed changes reached: 50");
            return;
        }
        this.playersDelayedSpriteChanges[this.playersDelayedSpriteChangesCount][0] = this.clock;
        this.playersDelayedSpriteChanges[this.playersDelayedSpriteChangesCount][1] = player;
        this.playersDelayedSpriteChanges[this.playersDelayedSpriteChangesCount][2] = sprite;
        ++this.playersDelayedSpriteChangesCount;
    }

    private void playersPerformDelayedSpriteChanges() {
        if (this.playersDelayedSpriteChangesCount == 0 || this.playersDelayedSpriteChanges[0][0] == this.clock) {
            return;
        }
        int i = 0;
        while (i < this.playersDelayedSpriteChangesCount) {
            int[] change = this.playersDelayedSpriteChanges[i];
            if (change[1] == 0) {
                this.player0DelayedSprite = change[2];
                this.player1ActiveSprite = this.player1DelayedSprite;
            } else {
                this.player1DelayedSprite = change[2];
                this.player0ActiveSprite = this.player0DelayedSprite;
                this.ballEnabled = this.ballDelayedEnablement;
            }
            ++i;
        }
        this.playersDelayedSpriteChangesCount = 0;
    }

    private void ballSetGraphic(int value) {
        this.observableChange();
        boolean bl = this.ballDelayedEnablement = (value & 2) != 0;
        if (!this.ballVerticalDelay) {
            this.ballEnabled = this.ballDelayedEnablement;
        }
    }

    private void player0SetShape(int shape) {
        this.observableChange();
        int speed = shape & 0x30;
        if (speed == 0) {
            speed = 8;
        } else if (speed == 16) {
            speed = 4;
        } else if (speed == 32) {
            speed = 2;
        } else if (speed == 48) {
            speed = 1;
        }
        if (this.missile0ScanSpeed != speed) {
            if (this.missile0ScanCounter > 7) {
                this.missile0ScanCounter = 7 + (this.missile0ScanCounter - 7) / this.missile0ScanSpeed * speed;
            } else if (this.missile0ScanCounter >= 0) {
                this.missile0ScanCounter = -1;
            }
            this.missile0ScanSpeed = speed;
        }
        if ((shape & 7) == 5) {
            speed = 2;
            this.player0WideCopy = false;
            this.player0MediumCopy = false;
            this.player0CloseCopy = false;
        } else if ((shape & 7) == 7) {
            speed = 1;
            this.player0WideCopy = false;
            this.player0MediumCopy = false;
            this.player0CloseCopy = false;
        } else {
            speed = 4;
            this.player0CloseCopy = (shape & 1) != 0;
            this.player0MediumCopy = (shape & 2) != 0;
            boolean bl = this.player0WideCopy = (shape & 4) != 0;
        }
        if (this.player0ScanSpeed != speed) {
            if (this.player0ScanCounter > 31) {
                this.player0ScanCounter = 31 + (this.player0ScanCounter - 31) / this.player0ScanSpeed * speed;
            } else if (this.player0ScanCounter >= 0) {
                this.player0ScanCounter = -1;
            }
            this.player0ScanSpeed = speed;
        }
    }

    private void player1SetShape(int shape) {
        this.observableChange();
        int speed = shape & 0x30;
        if (speed == 0) {
            speed = 8;
        } else if (speed == 16) {
            speed = 4;
        } else if (speed == 32) {
            speed = 2;
        } else if (speed == 48) {
            speed = 1;
        }
        if (this.missile1ScanSpeed != speed) {
            if (this.missile1ScanCounter > 7) {
                this.missile1ScanCounter = 7 + (this.missile1ScanCounter - 7) / this.missile1ScanSpeed * speed;
            } else if (this.missile1ScanCounter >= 0) {
                this.missile1ScanCounter = -1;
            }
            this.missile1ScanSpeed = speed;
        }
        if ((shape & 7) == 5) {
            speed = 2;
            this.player1WideCopy = false;
            this.player1MediumCopy = false;
            this.player1CloseCopy = false;
        } else if ((shape & 7) == 7) {
            speed = 1;
            this.player1WideCopy = false;
            this.player1MediumCopy = false;
            this.player1CloseCopy = false;
        } else {
            speed = 4;
            this.player1CloseCopy = (shape & 1) != 0;
            this.player1MediumCopy = (shape & 2) != 0;
            boolean bl = this.player1WideCopy = (shape & 4) != 0;
        }
        if (this.player1ScanSpeed != speed) {
            if (this.player1ScanCounter > 31) {
                this.player1ScanCounter = 31 + (this.player1ScanCounter - 31) / this.player1ScanSpeed * speed;
            } else if (this.player1ScanCounter >= 0) {
                this.player1ScanCounter = -1;
            }
            this.player1ScanSpeed = speed;
        }
    }

    private void playfieldAndBallSetShape(int shape) {
        boolean reflect;
        this.observableChange();
        boolean bl = reflect = (shape & 1) != 0;
        if (this.playfieldReflected != reflect) {
            this.playfieldReflected = reflect;
            this.playfieldPatternInvalid = true;
        }
        this.playfieldScoreMode = (shape & 2) != 0;
        this.playfieldPriority = (shape & 4) != 0;
        int speed = shape & 0x30;
        if (speed == 0) {
            speed = 8;
        } else if (speed == 16) {
            speed = 4;
        } else if (speed == 32) {
            speed = 2;
        } else if (speed == 48) {
            speed = 1;
        }
        if (this.ballScanSpeed != speed) {
            if (this.ballScanCounter > 7) {
                this.ballScanCounter = 7 + (this.ballScanCounter - 7) / this.ballScanSpeed * speed;
            } else if (this.ballScanCounter >= 0) {
                this.ballScanCounter = -1;
            }
            this.ballScanSpeed = speed;
        }
    }

    private void hitRESP0() {
        this.observableChangeExtended();
        if (this.debug) {
            this.debugPixel(-14540101);
        }
        if (this.clock >= 68 + (this.hMoveHitBlank ? 7 : 0)) {
            if (this.player0Counter != 155) {
                this.player0RecentReset = true;
            }
            this.player0Counter = 155;
            return;
        }
        int d = 0;
        if (this.hMoveHitBlank) {
            if (this.clock >= 68) {
                d = 68 - this.clock + 8;
            } else {
                d = this.clock - this.hMoveHitClock - 4 >> 2;
                if (d > 8) {
                    d = 8;
                }
            }
        }
        this.player0Counter = 157 - d;
        this.player0RecentReset = this.player0Counter <= 155;
    }

    private void hitRESP1() {
        this.observableChangeExtended();
        if (this.debug) {
            this.debugPixel(-4513246);
        }
        if (this.clock >= 68 + (this.hMoveHitBlank ? 7 : 0)) {
            if (this.player1Counter != 155) {
                this.player1RecentReset = true;
            }
            this.player1Counter = 155;
            return;
        }
        int d = 0;
        if (this.hMoveHitBlank) {
            if (this.clock >= 68) {
                d = 68 - this.clock + 8;
            } else {
                d = this.clock - this.hMoveHitClock - 4 >> 2;
                if (d > 8) {
                    d = 8;
                }
            }
        }
        this.player1Counter = 157 - d;
        this.player1RecentReset = this.player1Counter <= 155;
    }

    private void hitRESM0() {
        this.observableChangeExtended();
        if (this.debug) {
            this.debugPixel(-10066177);
        }
        if (this.clock >= 68 + (this.hMoveHitBlank ? 7 : 0)) {
            if (this.missile0Counter != 155) {
                this.missile0RecentReset = true;
            }
            this.missile0Counter = 155;
            return;
        }
        int d = 0;
        if (this.hMoveHitBlank) {
            if (this.clock >= 68) {
                d = 68 - this.clock + 8;
            } else {
                d = this.clock - this.hMoveHitClock - 4 >> 2;
                if (d > 8) {
                    d = 8;
                }
            }
        }
        this.missile0Counter = 157 - d;
        this.missile0RecentReset = this.missile0Counter <= 155;
    }

    private void hitRESM1() {
        this.observableChangeExtended();
        if (this.debug) {
            this.debugPixel(-39322);
        }
        if (this.clock >= 68 + (this.hMoveHitBlank ? 7 : 0)) {
            if (this.missile1Counter != 155) {
                this.missile1RecentReset = true;
            }
            this.missile1Counter = 155;
            return;
        }
        int d = 0;
        if (this.hMoveHitBlank) {
            if (this.clock >= 68) {
                d = 68 - this.clock + 8;
            } else {
                d = this.clock - this.hMoveHitClock - 4 >> 2;
                if (d > 8) {
                    d = 8;
                }
            }
        }
        this.missile1Counter = 157 - d;
        this.missile1RecentReset = this.missile1Counter <= 155;
    }

    private void hitRESBL() {
        this.observableChange();
        if (this.debug) {
            this.debugPixel(-256);
        }
        if (this.clock >= 68 + (this.hMoveHitBlank ? 7 : 0)) {
            this.ballCounter = 155;
            return;
        }
        int d = 0;
        if (this.hMoveHitBlank) {
            if (this.clock >= 68) {
                d = 68 - this.clock + 8;
            } else {
                d = this.clock - this.hMoveHitClock - 4 >> 2;
                if (d > 8) {
                    d = 8;
                }
            }
        }
        this.ballCounter = 157 - d;
    }

    private void hitHMOVE() {
        if (this.debug) {
            this.debugPixel(-1);
        }
        if (this.clock < 68) {
            this.hMoveHitClock = this.clock;
            this.hMoveHitBlank = true;
            this.performHMOVE();
            return;
        }
        if (this.clock < 219) {
            this.debugInfo("Unsupported HMOVE hit");
            return;
        }
        this.hMoveHitClock = 160 - this.clock;
        this.hMoveLateHit = true;
        this.hMoveLateHitBlank = this.clock >= 225;
    }

    private void performHMOVE() {
        int i;
        int add;
        boolean vis = false;
        int n = add = this.hMoveHitBlank ? this.HMP0 : this.HMP0 + 8;
        if (add != 0) {
            vis = true;
            if (add > 0) {
                i = add;
                while (i > 0) {
                    this.player0ClockCounter();
                    --i;
                }
            } else {
                this.player0Counter += add;
                if (this.player0Counter < 0) {
                    this.player0Counter += 160;
                }
                if (this.player0ScanCounter >= 0) {
                    this.player0ScanCounter -= this.player0ScanSpeed * add;
                }
            }
        }
        int n2 = add = this.hMoveHitBlank ? this.HMP1 : this.HMP1 + 8;
        if (add != 0) {
            vis = true;
            if (add > 0) {
                i = add;
                while (i > 0) {
                    this.player1ClockCounter();
                    --i;
                }
            } else {
                this.player1Counter += add;
                if (this.player1Counter < 0) {
                    this.player1Counter += 160;
                }
                if (this.player1ScanCounter >= 0) {
                    this.player1ScanCounter -= this.player1ScanSpeed * add;
                }
            }
        }
        int n3 = add = this.hMoveHitBlank ? this.HMM0 : this.HMM0 + 8;
        if (add != 0) {
            vis = true;
            if (add > 0) {
                i = add;
                while (i > 0) {
                    this.missile0ClockCounter();
                    --i;
                }
            } else {
                this.missile0Counter += add;
                if (this.missile0Counter < 0) {
                    this.missile0Counter += 160;
                }
                if (this.missile0ScanCounter >= 0) {
                    this.missile0ScanCounter -= this.missile0ScanSpeed * add;
                }
            }
        }
        int n4 = add = this.hMoveHitBlank ? this.HMM1 : this.HMM1 + 8;
        if (add != 0) {
            vis = true;
            if (add > 0) {
                i = add;
                while (i > 0) {
                    this.missile1ClockCounter();
                    --i;
                }
            } else {
                this.missile1Counter += add;
                if (this.missile1Counter < 0) {
                    this.missile1Counter += 160;
                }
                if (this.missile1ScanCounter >= 0) {
                    this.missile1ScanCounter -= this.missile1ScanSpeed * add;
                }
            }
        }
        int n5 = add = this.hMoveHitBlank ? this.HMBL : this.HMBL + 8;
        if (add != 0) {
            vis = true;
            if (add > 0) {
                i = add;
                while (i > 0) {
                    this.ballClockCounter();
                    --i;
                }
            } else {
                this.ballCounter += add;
                if (this.ballCounter < 0) {
                    this.ballCounter += 160;
                }
                if (this.ballScanCounter >= 0) {
                    this.ballScanCounter -= this.ballScanSpeed * add;
                }
            }
        }
        if (vis) {
            this.observableChange();
        }
    }

    private void missile0SetResetToPlayer(int res) {
        this.observableChange();
        this.missile0ResetToPlayer = (res & 2) != 0;
        if (this.missile0ResetToPlayer) {
            this.missile0Enabled = false;
        }
    }

    private void missile1SetResetToPlayer(int res) {
        this.observableChange();
        this.missile1ResetToPlayer = (res & 2) != 0;
        if (this.missile1ResetToPlayer) {
            this.missile1Enabled = false;
        }
    }

    private void vBlankSet(int blank) {
        if ((blank & 2) != 0 != this.vBlankOn) {
            this.vBlankDecodeActive = true;
            boolean bl = this.vBlankNewState = !this.vBlankOn;
        }
        if ((blank & 0x40) != 0) {
            this.controlsButtonsLatched = true;
        } else {
            this.controlsButtonsLatched = false;
            this.INPT4 = this.controlsJOY0ButtonPressed ? (this.INPT4 &= 0x7F) : (this.INPT4 |= 0x80);
            this.INPT5 = this.controlsJOY1ButtonPressed ? (this.INPT5 &= 0x7F) : (this.INPT5 |= 0x80);
        }
        if ((blank & 0x80) != 0) {
            this.paddleCapacitorsGrounded = true;
            this.paddle1CapacitorCharge = 0;
            this.paddle0CapacitorCharge = 0;
            this.INPT0 &= 0x7F;
            this.INPT1 &= 0x7F;
            this.INPT2 &= 0x7F;
            this.INPT3 &= 0x7F;
        } else {
            this.paddleCapacitorsGrounded = false;
        }
    }

    private void vBlankClockDecode() {
        this.vBlankDecodeActive = false;
        this.vBlankOn = this.vBlankNewState;
        this.observableChange();
    }

    private void finishLine() {
        if (this.hMoveHitBlank) {
            this.linePixels[74] = this.linePixels[75] = this.hBlankColor;
            this.linePixels[73] = this.linePixels[75];
            this.linePixels[72] = this.linePixels[75];
            this.linePixels[71] = this.linePixels[75];
            this.linePixels[70] = this.linePixels[75];
            this.linePixels[69] = this.linePixels[75];
            this.linePixels[68] = this.linePixels[75];
            this.hMoveHitBlank = false;
        }
        if (this.hMoveLateHit) {
            this.hMoveLateHit = false;
            this.hMoveHitBlank = this.hMoveLateHitBlank;
            this.performHMOVE();
        }
        if (this.observableChangeExtended) {
            this.lastObservableChangeClock = 227;
            this.observableChangeExtended = false;
        }
        if (this.debugLevel >= 2) {
            this.processDebugPixelsInLine();
        }
    }

    private void observableChange() {
        this.lastObservableChangeClock = this.clock;
        if (this.repeatLastLine) {
            this.repeatLastLine = false;
        }
    }

    private void observableChangeExtended() {
        this.observableChange();
        this.observableChangeExtended = true;
    }

    private void debug(int level) {
        this.debugLevel = level > 4 ? 0 : level;
        this.debug = this.debugLevel != 0;
        this.videoOutput.showOSD(this.debug ? "Debug Level " + this.debugLevel : "Debug OFF", true);
        this.bus.cpu.debug = this.debug;
        this.bus.pia.debug = this.debug;
        if (this.debug) {
            this.debugSetColors();
        } else {
            this.debugRestoreColors();
        }
    }

    private void debugSetColors() {
        this.player0Color = -16776961;
        this.player1Color = -65536;
        this.missile0Color = -10066177;
        this.missile1Color = -39322;
        this.ballColor = -256;
        this.playfieldColor = -12285884;
        this.playfieldBackground = -13417421;
        this.hBlankColor = this.debugLevel >= 1 ? -12303292 : -16777216;
        this.vBlankColor = this.debugLevel >= 2 ? -14013910 : 0;
    }

    private void debugRestoreColors() {
        this.hBlankColor = -16777216;
        this.vBlankColor = 0;
        this.playfieldBackground = this.palette[0];
        Arrays.fill(this.linePixels, this.hBlankColor);
        this.observableChange();
    }

    private void debugInfo(String str) {
        if (this.debug) {
            System.out.printf("Line: %3d, Pixel: %3d, " + str + "\n", this.videoOutput.monitor().currentLine(), this.clock);
        }
    }

    private void debugPixel(int color) {
        this.debugPixels[this.clock] = color;
    }

    private boolean debugPausedNoMoreFrames() {
        if (this.debugPauseMoreFrames <= 0) {
            return true;
        }
        --this.debugPauseMoreFrames;
        return false;
    }

    private void processDebugPixelsInLine() {
        int i;
        Arrays.fill(this.linePixels, 0, 68, this.hBlankColor);
        if (this.debugLevel >= 4 && this.videoOutput.monitor().currentLine() % 10 == 0) {
            i = 0;
            while (i < 228) {
                if (this.debugPixels[i] == 0) {
                    if (i < 68) {
                        if (i % 6 == 0 || i == 66 || i == 63) {
                            this.debugPixels[i] = -14671840;
                        }
                    } else if ((i - 68 - 1) % 6 == 0) {
                        this.debugPixels[i] = -14671840;
                    }
                }
                ++i;
            }
        }
        if (this.debugLevel >= 3) {
            i = 0;
            while (i < 228) {
                if (this.debugPixels[i] != 0) {
                    this.linePixels[i] = this.debugPixels[i];
                    this.debugPixels[i] = 0;
                }
                ++i;
            }
        }
        this.observableChange();
    }

    private void chargePaddleCapacitors() {
        if (this.INPT0 < 128 && ++this.paddle0CapacitorCharge >= this.paddle0Position) {
            this.INPT0 |= 0x80;
        }
        if (this.INPT1 < 128 && ++this.paddle1CapacitorCharge >= this.paddle1Position) {
            this.INPT1 |= 0x80;
        }
    }

    private void initLatchesAtPowerOn() {
        this.CXPPMM = 0;
        this.CXBLPF = 0;
        this.CXM1FB = 0;
        this.CXM0FB = 0;
        this.CXP1FB = 0;
        this.CXP0FB = 0;
        this.CXM1P = 0;
        this.CXM0P = 0;
        this.INPT3 = 0;
        this.INPT2 = 0;
        this.INPT1 = 0;
        this.INPT0 = 0;
        this.INPT5 = 128;
        this.INPT4 = 128;
    }

    @Override
    public byte readByte(int address) {
        int reg = address & 0xF;
        if (reg == 0) {
            return (byte)this.CXM0P;
        }
        if (reg == 1) {
            return (byte)this.CXM1P;
        }
        if (reg == 2) {
            return (byte)this.CXP0FB;
        }
        if (reg == 3) {
            return (byte)this.CXP1FB;
        }
        if (reg == 4) {
            return (byte)this.CXM0FB;
        }
        if (reg == 5) {
            return (byte)this.CXM1FB;
        }
        if (reg == 6) {
            return (byte)this.CXBLPF;
        }
        if (reg == 7) {
            return (byte)this.CXPPMM;
        }
        if (reg == 8) {
            return (byte)this.INPT0;
        }
        if (reg == 9) {
            return (byte)this.INPT1;
        }
        if (reg == 10) {
            return (byte)this.INPT2;
        }
        if (reg == 11) {
            return (byte)this.INPT3;
        }
        if (reg == 12) {
            return (byte)this.INPT4;
        }
        if (reg == 13) {
            return (byte)this.INPT5;
        }
        return 0;
    }

    @Override
    public void writeByte(int address, byte b) {
        int i = b & 0xFF;
        int reg = address & 0x3F;
        if (reg == 27) {
            this.playerDelaySpriteChange(0, i);
            return;
        }
        if (reg == 28) {
            this.playerDelaySpriteChange(1, i);
            return;
        }
        if (reg == 2) {
            this.bus.cpu.RDY = false;
            if (this.debug) {
                this.debugPixel(-7864184);
            }
            return;
        }
        if (reg == 42) {
            this.hitHMOVE();
            return;
        }
        if (reg == 13) {
            if (this.PF0 != i || this.playfieldDelayedChangePart == 0) {
                this.playfieldDelaySpriteChange(0, i);
            }
            return;
        }
        if (reg == 14) {
            if (this.PF1 != i || this.playfieldDelayedChangePart == 1) {
                this.playfieldDelaySpriteChange(1, i);
            }
            return;
        }
        if (reg == 15) {
            if (this.PF2 != i || this.playfieldDelayedChangePart == 2) {
                this.playfieldDelaySpriteChange(2, i);
            }
            return;
        }
        if (reg == 6) {
            this.observableChange();
            if (!this.debug) {
                this.player0Color = this.missile0Color = this.palette[i];
            }
            return;
        }
        if (reg == 7) {
            this.observableChange();
            if (!this.debug) {
                this.player1Color = this.missile1Color = this.palette[i];
            }
            return;
        }
        if (reg == 8) {
            this.observableChange();
            if (!this.debug) {
                this.playfieldColor = this.ballColor = this.palette[i];
            }
            return;
        }
        if (reg == 9) {
            this.observableChange();
            if (!this.debug) {
                this.playfieldBackground = this.palette[i];
            }
            return;
        }
        if (reg == 29) {
            this.observableChange();
            this.missile0Enabled = (i & 2) != 0;
            return;
        }
        if (reg == 30) {
            this.observableChange();
            this.missile1Enabled = (i & 2) != 0;
            return;
        }
        if (reg == 20) {
            this.hitRESBL();
            return;
        }
        if (reg == 16) {
            this.hitRESP0();
            return;
        }
        if (reg == 17) {
            this.hitRESP1();
            return;
        }
        if (reg == 18) {
            this.hitRESM0();
            return;
        }
        if (reg == 19) {
            this.hitRESM1();
            return;
        }
        if (reg == 32) {
            this.HMP0 = b >> 4;
            return;
        }
        if (reg == 33) {
            this.HMP1 = b >> 4;
            return;
        }
        if (reg == 34) {
            this.HMM0 = b >> 4;
            return;
        }
        if (reg == 35) {
            this.HMM1 = b >> 4;
            return;
        }
        if (reg == 36) {
            this.HMBL = b >> 4;
            return;
        }
        if (reg == 43) {
            this.HMBL = 0;
            this.HMM1 = 0;
            this.HMM0 = 0;
            this.HMP1 = 0;
            this.HMP0 = 0;
            return;
        }
        if (reg == 31) {
            this.ballSetGraphic(i);
            return;
        }
        if (reg == 4) {
            this.player0SetShape(i);
            return;
        }
        if (reg == 5) {
            this.player1SetShape(i);
            return;
        }
        if (reg == 10) {
            this.playfieldAndBallSetShape(i);
            return;
        }
        if (reg == 11) {
            this.observableChange();
            this.player0Reflected = (i & 8) != 0;
            return;
        }
        if (reg == 12) {
            this.observableChange();
            this.player1Reflected = (i & 8) != 0;
            return;
        }
        if (reg == 37) {
            this.observableChange();
            this.player0VerticalDelay = (i & 1) != 0;
            return;
        }
        if (reg == 38) {
            this.observableChange();
            this.player1VerticalDelay = (i & 1) != 0;
            return;
        }
        if (reg == 39) {
            this.observableChange();
            this.ballVerticalDelay = (i & 1) != 0;
            return;
        }
        if (reg == 21) {
            this.AUDC0 = i;
            this.audioOutput.channel0().setControl(i & 0xF);
            return;
        }
        if (reg == 22) {
            this.AUDC1 = i;
            this.audioOutput.channel1().setControl(i & 0xF);
            return;
        }
        if (reg == 23) {
            this.AUDF0 = i;
            this.audioOutput.channel0().setDivider((i & 0x1F) + 1);
            return;
        }
        if (reg == 24) {
            this.AUDF1 = i;
            this.audioOutput.channel1().setDivider((i & 0x1F) + 1);
            return;
        }
        if (reg == 25) {
            this.AUDV0 = i;
            this.audioOutput.channel0().setVolume(i & 0xF);
            return;
        }
        if (reg == 26) {
            this.AUDV1 = i;
            this.audioOutput.channel1().setVolume(i & 0xF);
            return;
        }
        if (reg == 40) {
            this.missile0SetResetToPlayer(i);
            return;
        }
        if (reg == 41) {
            this.missile1SetResetToPlayer(i);
            return;
        }
        if (reg == 1) {
            this.vBlankSet(i);
            return;
        }
        if (reg == 0) {
            this.observableChange();
            this.vSyncOn = (i & 2) != 0;
            return;
        }
        if (reg == 44) {
            this.observableChange();
            this.CXPPMM = 0;
            this.CXBLPF = 0;
            this.CXM1FB = 0;
            this.CXM0FB = 0;
            this.CXP1FB = 0;
            this.CXP0FB = 0;
            this.CXM1P = 0;
            this.CXM0P = 0;
            return;
        }
        if (reg == 3) {
            return;
        }
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, boolean state) {
        switch (control) {
            case JOY0_BUTTON: {
                if (state) {
                    this.controlsJOY0ButtonPressed = true;
                    this.INPT4 &= 0x7F;
                } else {
                    this.controlsJOY0ButtonPressed = false;
                    if (!this.controlsButtonsLatched) {
                        this.INPT4 |= 0x80;
                    }
                }
                return;
            }
            case JOY1_BUTTON: {
                if (state) {
                    this.controlsJOY1ButtonPressed = true;
                    this.INPT5 &= 0x7F;
                } else {
                    this.controlsJOY1ButtonPressed = false;
                    if (!this.controlsButtonsLatched) {
                        this.INPT5 |= 0x80;
                    }
                }
                return;
            }
        }
        if (!state) {
            return;
        }
        switch (control) {
            case DEBUG: {
                this.debug(this.debugLevel + 1);
                return;
            }
            case NO_COLLISIONS: {
                this.debugNoCollisions = !this.debugNoCollisions;
                this.videoOutput.showOSD(this.debugNoCollisions ? "Collisions OFF" : "Collisions ON", true);
                return;
            }
            case PAUSE: {
                this.debugPause = !this.debugPause;
                this.debugPauseMoreFrames = 0;
                this.videoOutput.showOSD(this.debugPause ? "PAUSE" : "RESUME", true);
                return;
            }
            case FRAME: {
                ++this.debugPauseMoreFrames;
                return;
            }
            case TRACE: {
                this.bus.cpu.trace = !this.bus.cpu.trace;
                return;
            }
        }
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, int position) {
        switch (control) {
            case PADDLE0_POSITION: {
                this.paddle0Position = position;
                return;
            }
            case PADDLE1_POSITION: {
                this.paddle1Position = position;
                return;
            }
        }
    }

    @Override
    public void controlsStateReport(Map<ConsoleControls.Control, Boolean> report) {
    }

    public TIAState saveState() {
        TIAState state = new TIAState();
        state.linePixels = (int[])this.linePixels.clone();
        state.lastObservableChangeClock = this.lastObservableChangeClock;
        state.observableChangeExtended = this.observableChangeExtended;
        state.repeatLastLine = this.repeatLastLine;
        state.vSyncOn = this.vSyncOn;
        state.vBlankOn = this.vBlankOn;
        state.vBlankDecodeActive = this.vBlankDecodeActive;
        state.vBlankNewState = this.vBlankNewState;
        state.playfieldPattern = (boolean[])this.playfieldPattern.clone();
        state.playfieldPatternInvalid = this.playfieldPatternInvalid;
        state.playfieldCurrentPixel = this.playfieldCurrentPixel;
        state.playfieldColor = this.playfieldColor;
        state.playfieldBackground = this.playfieldBackground;
        state.playfieldReflected = this.playfieldReflected;
        state.playfieldScoreMode = this.playfieldScoreMode;
        state.playfieldPriority = this.playfieldPriority;
        state.player0ActiveSprite = this.player0ActiveSprite;
        state.player0DelayedSprite = this.player0DelayedSprite;
        state.player0Color = this.player0Color;
        state.player0RecentReset = this.player0RecentReset;
        state.player0Counter = this.player0Counter;
        state.player0ScanCounter = this.player0ScanCounter;
        state.player0ScanSpeed = this.player0ScanSpeed;
        state.player0VerticalDelay = this.player0VerticalDelay;
        state.player0CloseCopy = this.player0CloseCopy;
        state.player0MediumCopy = this.player0MediumCopy;
        state.player0WideCopy = this.player0WideCopy;
        state.player0Reflected = this.player0Reflected;
        state.player1ActiveSprite = this.player1ActiveSprite;
        state.player1DelayedSprite = this.player1DelayedSprite;
        state.player1Color = this.player1Color;
        state.player1RecentReset = this.player1RecentReset;
        state.player1Counter = this.player1Counter;
        state.player1ScanCounter = this.player1ScanCounter;
        state.player1ScanSpeed = this.player1ScanSpeed;
        state.player1VerticalDelay = this.player1VerticalDelay;
        state.player1CloseCopy = this.player1CloseCopy;
        state.player1MediumCopy = this.player1MediumCopy;
        state.player1WideCopy = this.player1WideCopy;
        state.player1Reflected = this.player1Reflected;
        state.missile0Enabled = this.missile0Enabled;
        state.missile0Color = this.missile0Color;
        state.missile0RecentReset = this.missile0RecentReset;
        state.missile0Counter = this.missile0Counter;
        state.missile0ScanCounter = this.missile0ScanCounter;
        state.missile0ScanSpeed = this.missile0ScanSpeed;
        state.missile0ResetToPlayer = this.missile0ResetToPlayer;
        state.missile1Enabled = this.missile1Enabled;
        state.missile1Color = this.missile1Color;
        state.missile1RecentReset = this.missile1RecentReset;
        state.missile1Counter = this.missile1Counter;
        state.missile1ScanCounter = this.missile1ScanCounter;
        state.missile1ScanSpeed = this.missile1ScanSpeed;
        state.missile1ResetToPlayer = this.missile1ResetToPlayer;
        state.ballEnabled = this.ballEnabled;
        state.ballDelayedEnablement = this.ballDelayedEnablement;
        state.ballColor = this.ballColor;
        state.ballCounter = this.ballCounter;
        state.ballScanCounter = this.ballScanCounter;
        state.ballScanSpeed = this.ballScanSpeed;
        state.ballVerticalDelay = this.ballVerticalDelay;
        state.playfieldDelayedChangeClock = this.playfieldDelayedChangeClock;
        state.playfieldDelayedChangePart = this.playfieldDelayedChangePart;
        state.playfieldDelayedChangePattern = this.playfieldDelayedChangePattern;
        state.playersDelayedSpriteChanges = Array2DCopy.copy(this.playersDelayedSpriteChanges);
        state.playersDelayedSpriteChangesCount = this.playersDelayedSpriteChangesCount;
        state.hMoveHitBlank = this.hMoveHitBlank;
        state.hMoveHitClock = this.hMoveHitClock;
        state.PF0 = this.PF0;
        state.PF1 = this.PF1;
        state.PF2 = this.PF2;
        state.AUDC0 = this.AUDC0;
        state.AUDC1 = this.AUDC1;
        state.AUDF0 = this.AUDF0;
        state.AUDF1 = this.AUDF1;
        state.AUDV0 = this.AUDV0;
        state.AUDV1 = this.AUDV1;
        state.HMP0 = this.HMP0;
        state.HMP1 = this.HMP1;
        state.HMM0 = this.HMM0;
        state.HMM1 = this.HMM1;
        state.HMBL = this.HMBL;
        state.CXM0P = this.CXM0P;
        state.CXM1P = this.CXM1P;
        state.CXP0FB = this.CXP0FB;
        state.CXP1FB = this.CXP1FB;
        state.CXM0FB = this.CXM0FB;
        state.CXM1FB = this.CXM1FB;
        state.CXBLPF = this.CXBLPF;
        state.CXPPMM = this.CXPPMM;
        return state;
    }

    public void loadState(TIAState state) {
        this.linePixels = state.linePixels;
        this.lastObservableChangeClock = state.lastObservableChangeClock;
        this.observableChangeExtended = state.observableChangeExtended;
        this.repeatLastLine = state.repeatLastLine;
        this.vSyncOn = state.vSyncOn;
        this.vBlankOn = state.vBlankOn;
        this.vBlankDecodeActive = state.vBlankDecodeActive;
        this.vBlankNewState = state.vBlankNewState;
        this.playfieldPattern = state.playfieldPattern;
        this.playfieldPatternInvalid = state.playfieldPatternInvalid;
        this.playfieldCurrentPixel = state.playfieldCurrentPixel;
        this.playfieldColor = state.playfieldColor;
        this.playfieldBackground = state.playfieldBackground;
        this.playfieldReflected = state.playfieldReflected;
        this.playfieldScoreMode = state.playfieldScoreMode;
        this.playfieldPriority = state.playfieldPriority;
        this.player0ActiveSprite = state.player0ActiveSprite;
        this.player0DelayedSprite = state.player0DelayedSprite;
        this.player0Color = state.player0Color;
        this.player0RecentReset = state.player0RecentReset;
        this.player0Counter = state.player0Counter;
        this.player0ScanCounter = state.player0ScanCounter;
        this.player0ScanSpeed = state.player0ScanSpeed;
        this.player0VerticalDelay = state.player0VerticalDelay;
        this.player0CloseCopy = state.player0CloseCopy;
        this.player0MediumCopy = state.player0MediumCopy;
        this.player0WideCopy = state.player0WideCopy;
        this.player0Reflected = state.player0Reflected;
        this.player1ActiveSprite = state.player1ActiveSprite;
        this.player1DelayedSprite = state.player1DelayedSprite;
        this.player1Color = state.player1Color;
        this.player1RecentReset = state.player1RecentReset;
        this.player1Counter = state.player1Counter;
        this.player1ScanCounter = state.player1ScanCounter;
        this.player1ScanSpeed = state.player1ScanSpeed;
        this.player1VerticalDelay = state.player1VerticalDelay;
        this.player1CloseCopy = state.player1CloseCopy;
        this.player1MediumCopy = state.player1MediumCopy;
        this.player1WideCopy = state.player1WideCopy;
        this.player1Reflected = state.player1Reflected;
        this.missile0Enabled = state.missile0Enabled;
        this.missile0Color = state.missile0Color;
        this.missile0RecentReset = state.missile0RecentReset;
        this.missile0Counter = state.missile0Counter;
        this.missile0ScanCounter = state.missile0ScanCounter;
        this.missile0ScanSpeed = state.missile0ScanSpeed;
        this.missile0ResetToPlayer = state.missile0ResetToPlayer;
        this.missile1Enabled = state.missile1Enabled;
        this.missile1Color = state.missile1Color;
        this.missile1RecentReset = state.missile1RecentReset;
        this.missile1Counter = state.missile1Counter;
        this.missile1ScanCounter = state.missile1ScanCounter;
        this.missile1ScanSpeed = state.missile1ScanSpeed;
        this.missile1ResetToPlayer = state.missile1ResetToPlayer;
        this.ballEnabled = state.ballEnabled;
        this.ballDelayedEnablement = state.ballDelayedEnablement;
        this.ballColor = state.ballColor;
        this.ballCounter = state.ballCounter;
        this.ballScanCounter = state.ballScanCounter;
        this.ballScanSpeed = state.ballScanSpeed;
        this.ballVerticalDelay = state.ballVerticalDelay;
        this.playfieldDelayedChangeClock = state.playfieldDelayedChangeClock;
        this.playfieldDelayedChangePart = state.playfieldDelayedChangePart;
        this.playfieldDelayedChangePattern = state.playfieldDelayedChangePattern;
        this.playersDelayedSpriteChanges = state.playersDelayedSpriteChanges;
        this.playersDelayedSpriteChangesCount = state.playersDelayedSpriteChangesCount;
        this.hMoveHitBlank = state.hMoveHitBlank;
        this.hMoveHitClock = state.hMoveHitClock;
        this.PF0 = state.PF0;
        this.PF1 = state.PF1;
        this.PF2 = state.PF2;
        this.AUDC0 = state.AUDC0;
        this.audioOutput.channel0().setControl(this.AUDC0 & 0xF);
        this.AUDC1 = state.AUDC1;
        this.audioOutput.channel1().setControl(this.AUDC1 & 0xF);
        this.AUDF0 = state.AUDF0;
        this.audioOutput.channel0().setDivider((this.AUDF0 & 0x1F) + 1);
        this.AUDF1 = state.AUDF1;
        this.audioOutput.channel1().setDivider((this.AUDF1 & 0x1F) + 1);
        this.AUDV0 = state.AUDV0;
        this.audioOutput.channel0().setVolume(this.AUDV0 & 0xF);
        this.AUDV1 = state.AUDV1;
        this.audioOutput.channel1().setVolume(this.AUDV1 & 0xF);
        this.HMP0 = state.HMP0;
        this.HMP1 = state.HMP1;
        this.HMM0 = state.HMM0;
        this.HMM1 = state.HMM1;
        this.HMBL = state.HMBL;
        this.CXM0P = state.CXM0P;
        this.CXM1P = state.CXM1P;
        this.CXP0FB = state.CXP0FB;
        this.CXP1FB = state.CXP1FB;
        this.CXM0FB = state.CXM0FB;
        this.CXM1FB = state.CXM1FB;
        this.CXBLPF = state.CXBLPF;
        this.CXPPMM = state.CXPPMM;
        if (this.debug) {
            this.debugSetColors();
        }
    }

    public static class TIAState
    implements Serializable {
        int[] linePixels;
        int lastObservableChangeClock;
        boolean observableChangeExtended;
        boolean repeatLastLine;
        boolean vSyncOn;
        boolean vBlankOn;
        boolean vBlankDecodeActive;
        boolean vBlankNewState;
        boolean[] playfieldPattern;
        boolean playfieldPatternInvalid;
        boolean playfieldCurrentPixel;
        int playfieldColor;
        int playfieldBackground;
        boolean playfieldReflected;
        boolean playfieldScoreMode;
        boolean playfieldPriority;
        int player0ActiveSprite;
        int player0DelayedSprite;
        int player0Color;
        boolean player0RecentReset;
        int player0Counter;
        int player0ScanCounter;
        int player0ScanSpeed;
        boolean player0VerticalDelay;
        boolean player0CloseCopy;
        boolean player0MediumCopy;
        boolean player0WideCopy;
        boolean player0Reflected;
        int player1ActiveSprite;
        int player1DelayedSprite;
        int player1Color;
        boolean player1RecentReset;
        int player1Counter;
        int player1ScanCounter;
        int player1ScanSpeed;
        boolean player1VerticalDelay;
        boolean player1CloseCopy;
        boolean player1MediumCopy;
        boolean player1WideCopy;
        boolean player1Reflected;
        boolean missile0Enabled;
        int missile0Color;
        boolean missile0RecentReset;
        int missile0Counter;
        int missile0ScanCounter;
        int missile0ScanSpeed;
        boolean missile0ResetToPlayer;
        boolean missile1Enabled;
        int missile1Color;
        boolean missile1RecentReset;
        int missile1Counter;
        int missile1ScanCounter;
        int missile1ScanSpeed;
        boolean missile1ResetToPlayer;
        boolean ballEnabled;
        boolean ballDelayedEnablement;
        int ballColor;
        int ballCounter;
        int ballScanCounter;
        int ballScanSpeed;
        boolean ballVerticalDelay;
        int playfieldDelayedChangeClock;
        int playfieldDelayedChangePart;
        int playfieldDelayedChangePattern;
        int[][] playersDelayedSpriteChanges;
        int playersDelayedSpriteChangesCount;
        boolean hMoveHitBlank;
        int hMoveHitClock;
        int PF0;
        int PF1;
        int PF2;
        int AUDC0;
        int AUDC1;
        int AUDF0;
        int AUDF1;
        int AUDV0;
        int AUDV1;
        int HMP0;
        int HMP1;
        int HMM0;
        int HMM1;
        int HMBL;
        int CXM0P;
        int CXM1P;
        int CXP0FB;
        int CXP1FB;
        int CXM0FB;
        int CXM1FB;
        int CXBLPF;
        int CXPPMM;
        public static final long serialVersionUID = 3L;
    }
}

