/*
 * Decompiled with CFR 0.152.
 */
package atari.tia.audio;

import atari.tia.audio.ChannelStream;
import general.av.audio.AudioMonitor;
import general.av.audio.AudioSignal;
import general.av.video.VideoStandard;
import general.board.ClockDriven;
import parameters.Parameters;

public abstract class AudioGenerator
implements AudioSignal,
ClockDriven {
    protected final ChannelStream channel0 = new ChannelStream();
    protected final ChannelStream channel1 = new ChannelStream();
    protected final byte[] samples = new byte[1024];
    protected int generatedSamples = 0;
    private int samplesPerFrame = 0;
    private AudioMonitor monitor;
    private static final int SAMPLE_RATE = Parameters.TIA_AUDIO_SAMPLE_RATE;

    @Override
    public void connectMonitor(AudioMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void clockPulse() {
        if (this.generatedSamples < this.samplesPerFrame) {
            this.generateNextSamples(1);
        }
    }

    public ChannelStream channel0() {
        return this.channel0;
    }

    public ChannelStream channel1() {
        return this.channel1;
    }

    public void sendSamplesFrameToMonitor() {
        int missingSamples = this.samplesPerFrame - this.generatedSamples;
        if (missingSamples > 0) {
            this.generateNextSamples(missingSamples);
        }
        if (this.monitor != null) {
            this.monitor.nextSamples(this.samples, this.generatedSamples);
        }
        this.generatedSamples = 0;
    }

    public AudioMonitor monitor() {
        return this.monitor;
    }

    public void videoStandard(VideoStandard standard) {
        this.samplesPerFrame = (int)Math.round((double)SAMPLE_RATE / standard.fps);
    }

    protected abstract void generateNextSamples(int var1);
}

