/*
 * Decompiled with CFR 0.152.
 */
package atari.tia.audio;

public final class ChannelStream {
    private float volume = 0.0f;
    private int control = 0;
    private int divider = 1;
    private int dividerCountdown = 1;
    private int currentSample = 0;
    private int poly4 = 15;
    private int poly5 = 31;
    private int poly9 = 511;
    private int tone2 = 1;
    private int tone6 = 1;
    private int tone6Countdown = 3;
    private int tone31Count = 30;
    private static final int[] TONE31_STREAM;
    private static final int MAX_VOLUME = 15;

    static {
        int[] nArray = new int[31];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[14] = 1;
        nArray[15] = 1;
        nArray[16] = 1;
        nArray[17] = 1;
        TONE31_STREAM = nArray;
    }

    public float nextSample() {
        if (--this.dividerCountdown <= 0) {
            this.dividerCountdown = this.divider;
            this.currentSample = this.nextSampleForControl();
        }
        return this.currentSample == 1 ? this.volume : 0.0f;
    }

    public void setVolume(int newVolume) {
        this.volume = (float)newVolume / 15.0f;
    }

    public void setDivider(int newDivider) {
        if (this.divider == newDivider) {
            return;
        }
        this.dividerCountdown = (int)((float)this.dividerCountdown / (float)this.divider * (float)newDivider);
        this.divider = newDivider;
    }

    public void setControl(int control) {
        if (this.control == control) {
            return;
        }
        this.control = control;
    }

    private int nextSampleForControl() {
        if (this.control == 0 || this.control == 11) {
            return 1;
        }
        if (this.control == 1) {
            return this.nextPoly4();
        }
        if (this.control == 2) {
            return this.currentTone31() != this.nextTone31() ? this.nextPoly4() : this.currentPoly4();
        }
        if (this.control == 3) {
            return this.nextPoly5() == 1 ? this.nextPoly4() : this.currentPoly4();
        }
        if (this.control == 4 || this.control == 5) {
            return this.nextTone2();
        }
        if (this.control == 6 || this.control == 10) {
            return this.nextTone31();
        }
        if (this.control == 7 || this.control == 9) {
            return this.nextPoly5();
        }
        if (this.control == 8) {
            return this.nextPoly9();
        }
        if (this.control == 12 || this.control == 13) {
            return this.nextTone6();
        }
        if (this.control == 14) {
            return this.currentTone31() != this.nextTone31() ? this.nextTone6() : this.currentTone6();
        }
        if (this.control == 15) {
            return this.nextPoly5() == 1 ? this.nextTone6() : this.currentTone6();
        }
        throw new IllegalStateException("Invalid TIA Audio Channel Control: " + this.control);
    }

    private int currentPoly4() {
        return this.poly4 & 1;
    }

    private int nextPoly4() {
        int carry = this.poly4 & 1;
        int push = (this.poly4 >> 1 ^ carry) & 1;
        this.poly4 >>>= 1;
        this.poly4 = push == 0 ? (this.poly4 &= 7) : (this.poly4 |= 8);
        return carry;
    }

    private int nextPoly5() {
        int carry = this.poly5 & 1;
        int push = (this.poly5 >> 2 ^ carry) & 1;
        this.poly5 >>>= 1;
        this.poly5 = push == 0 ? (this.poly5 &= 0xF) : (this.poly5 |= 0x10);
        return carry;
    }

    private int nextPoly9() {
        int carry = this.poly9 & 1;
        int push = (this.poly9 >> 4 ^ carry) & 1;
        this.poly9 >>>= 1;
        this.poly9 = push == 0 ? (this.poly9 &= 0xFF) : (this.poly9 |= 0x100);
        return carry;
    }

    private int nextTone2() {
        this.tone2 = this.tone2 == 0 ? 1 : 0;
        return this.tone2;
    }

    private int currentTone6() {
        return this.tone6;
    }

    private int nextTone6() {
        if (--this.tone6Countdown == 0) {
            this.tone6Countdown = 3;
            this.tone6 = this.tone6 == 0 ? 1 : 0;
        }
        return this.tone6;
    }

    private int currentTone31() {
        return TONE31_STREAM[this.tone31Count];
    }

    private int nextTone31() {
        if (++this.tone31Count == 31) {
            this.tone31Count = 0;
        }
        return TONE31_STREAM[this.tone31Count];
    }
}

