/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;

public final class CPx
extends Instruction {
    private final int reg;
    private final int type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public CPx(M6502 cpu, int reg, int type) {
        super(cpu);
        this.reg = reg;
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 1) {
            this.ea = this.cpu.fetchImmediateAddress();
            return 2;
        }
        if (this.type == 20) {
            this.ea = this.cpu.fetchZeroPageAddress();
            return 3;
        }
        if (this.type == 21) {
            this.ea = this.cpu.fetchZeroPageXAddress();
            return 4;
        }
        if (this.type == 10) {
            this.ea = this.cpu.fetchAbsoluteAddress();
            return 4;
        }
        if (this.type == 11) {
            this.ea = this.cpu.fetchAbsoluteXAddress();
            return 4 + (this.cpu.pageCrossed ? 1 : 0);
        }
        if (this.type == 12) {
            this.ea = this.cpu.fetchAbsoluteYAddress();
            return 4 + (this.cpu.pageCrossed ? 1 : 0);
        }
        if (this.type == 31) {
            this.ea = this.cpu.fetchIndirectXAddress();
            return 6;
        }
        if (this.type == 32) {
            this.ea = this.cpu.fetchIndirectYAddress();
            return 5 + (this.cpu.pageCrossed ? 1 : 0);
        }
        throw new IllegalStateException("CPx Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        int uR;
        int uVal = M6502.toUnsignedByte(this.cpu.bus.readByte(this.ea));
        if (this.reg == 0) {
            uR = M6502.toUnsignedByte(this.cpu.A);
        } else if (this.reg == 5) {
            uR = M6502.toUnsignedByte(this.cpu.X);
        } else if (this.reg == 6) {
            uR = M6502.toUnsignedByte(this.cpu.Y);
        } else {
            throw new IllegalStateException("CPx Invalid Register: " + this.reg);
        }
        this.cpu.CARRY = uR >= uVal;
        this.cpu.ZERO = uR == uVal;
        this.cpu.NEGATIVE = (byte)(uR - uVal) < 0;
    }
}

