/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;

public final class Txx
extends Instruction {
    private final int source;
    private final int dest;
    public static final long serialVersionUID = 1L;

    public Txx(M6502 cpu, int src, int dest) {
        super(cpu);
        this.source = src;
        this.dest = dest;
    }

    @Override
    public int fetch() {
        return 2;
    }

    @Override
    public void execute() {
        byte val;
        if (this.source == 0) {
            val = this.cpu.A;
        } else if (this.source == 5) {
            val = this.cpu.X;
        } else if (this.source == 6) {
            val = this.cpu.Y;
        } else if (this.source == 20) {
            val = this.cpu.SP;
        } else {
            throw new IllegalStateException("Txx Invalid Source Register: " + this.source);
        }
        if (this.dest == 0) {
            this.cpu.A = val;
        } else if (this.dest == 5) {
            this.cpu.X = val;
        } else if (this.dest == 6) {
            this.cpu.Y = val;
        } else if (this.dest == 20) {
            this.cpu.SP = val;
        } else {
            throw new IllegalStateException("Txx Invalid Destination Register: " + this.dest);
        }
        if (this.dest != 20) {
            this.cpu.ZERO = val == 0;
            this.cpu.NEGATIVE = val < 0;
        }
    }
}

