/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;

public final class uARR
extends Instruction {
    private int ea;
    public static final long serialVersionUID = 1L;

    public uARR(M6502 cpu) {
        super(cpu);
    }

    @Override
    public int fetch() {
        this.ea = this.cpu.fetchImmediateAddress();
        return 2;
    }

    @Override
    public void execute() {
        byte val = (byte)(this.cpu.A & this.cpu.bus.readByte(this.ea));
        int oldCarry = this.cpu.CARRY ? 128 : 0;
        this.cpu.A = val = (byte)((val & 0xFF) >>> 1 | oldCarry);
        this.cpu.ZERO = val == 0;
        this.cpu.NEGATIVE = val < 0;
        int comp = this.cpu.A & 0x60;
        if (comp == 96) {
            this.cpu.CARRY = true;
            this.cpu.OVERFLOW = false;
        } else if (comp == 0) {
            this.cpu.CARRY = false;
            this.cpu.OVERFLOW = false;
        } else if (comp == 32) {
            this.cpu.CARRY = false;
            this.cpu.OVERFLOW = true;
        } else if (comp == 64) {
            this.cpu.CARRY = true;
            this.cpu.OVERFLOW = true;
        }
    }
}

