/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;

public final class uISB
extends Instruction {
    private final int type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uISB(M6502 cpu, int type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 20) {
            this.ea = this.cpu.fetchZeroPageAddress();
            return 5;
        }
        if (this.type == 21) {
            this.ea = this.cpu.fetchZeroPageXAddress();
            return 6;
        }
        if (this.type == 10) {
            this.ea = this.cpu.fetchAbsoluteAddress();
            return 6;
        }
        if (this.type == 11) {
            this.ea = this.cpu.fetchAbsoluteXAddress();
            return 7;
        }
        if (this.type == 12) {
            this.ea = this.cpu.fetchAbsoluteYAddress();
            return 7;
        }
        if (this.type == 31) {
            this.ea = this.cpu.fetchIndirectXAddress();
            return 8;
        }
        if (this.type == 32) {
            this.ea = this.cpu.fetchIndirectYAddress();
            return 8;
        }
        throw new IllegalStateException("uISB Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        byte val = (byte)(this.cpu.bus.readByte(this.ea) + 1);
        this.cpu.bus.writeByte(this.ea, val);
        byte b = val;
        int uB = M6502.toUnsignedByte(val);
        byte oldA = this.cpu.A;
        int uOldA = M6502.toUnsignedByte((int)oldA);
        int oldCarryNot = this.cpu.CARRY ? 0 : 1;
        int aux = oldA - b - oldCarryNot;
        int uAux = uOldA - uB - oldCarryNot;
        byte newA = (byte)M6502.toUnsignedByte(uAux);
        this.cpu.ZERO = newA == 0;
        this.cpu.NEGATIVE = newA < 0;
        this.cpu.OVERFLOW = aux > 127 || aux < -128;
        boolean bl = this.cpu.CARRY = uAux >= 0;
        if (!this.cpu.DECIMAL_MODE) {
            this.cpu.A = newA;
            return;
        }
        uAux = (uOldA & 0xF) - (uB & 0xF) - oldCarryNot;
        if (uAux < 0) {
            uAux = (uAux - 6 & 0xF) - 16;
        }
        if ((uAux = (uOldA & 0xF0) - (uB & 0xF0) + uAux) < 0) {
            uAux -= 96;
        }
        this.cpu.A = (byte)M6502.toUnsignedByte(uAux);
    }
}

