/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;

public final class uSRE
extends Instruction {
    private final int type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uSRE(M6502 cpu, int type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 20) {
            this.ea = this.cpu.fetchZeroPageAddress();
            return 5;
        }
        if (this.type == 21) {
            this.ea = this.cpu.fetchZeroPageXAddress();
            return 6;
        }
        if (this.type == 10) {
            this.ea = this.cpu.fetchAbsoluteAddress();
            return 6;
        }
        if (this.type == 11) {
            this.ea = this.cpu.fetchAbsoluteXAddress();
            return 7;
        }
        if (this.type == 12) {
            this.ea = this.cpu.fetchAbsoluteYAddress();
            return 7;
        }
        if (this.type == 31) {
            this.ea = this.cpu.fetchIndirectXAddress();
            return 8;
        }
        if (this.type == 32) {
            this.ea = this.cpu.fetchIndirectYAddress();
            return 8;
        }
        throw new IllegalStateException("uSRE Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        byte val = this.cpu.bus.readByte(this.ea);
        this.cpu.CARRY = (val & 1) != 0;
        val = (byte)((val & 0xFF) >>> 1);
        this.cpu.bus.writeByte(this.ea, val);
        this.cpu.A = val = (byte)(this.cpu.A ^ val);
        this.cpu.ZERO = val == 0;
        this.cpu.NEGATIVE = val < 0;
    }
}

