/*
 * Decompiled with CFR 0.152.
 */
package main;

import atari.network.RemoteReceiver;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import parameters.Parameters;
import pc.room.Room;
import pc.screen.PanelScreen;
import utils.Terminator;

public final class AppletMultiplayerClient
extends JApplet {
    private Room room;
    private static final long serialVersionUID = 1L;

    @Override
    public void init() {
        ArrayList<String> args = new ArrayList<String>();
        int i = -1;
        while (i < 50) {
            String paramName = "ARG" + (i >= 0 ? Integer.valueOf(i) : "");
            String paramValue = this.getParameter(paramName);
            if (paramValue != null) {
                args.add(paramValue);
            }
            ++i;
        }
        Parameters.init(args.toArray(new String[0]));
        String backgroundParam = this.getParameter("BACKGROUND");
        System.out.println("Background color: " + backgroundParam);
        Integer backColor = backgroundParam != null ? Integer.valueOf(Integer.parseInt(backgroundParam)) : null;
        this.room = Room.buildAppletClientRoom();
        this.setContentPane((PanelScreen)this.room.screen());
        if (backColor != null) {
            this.setBackground(new Color(backColor));
        }
    }

    @Override
    public void start() {
        this.room.powerOn();
        ((PanelScreen)this.room.screen()).requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean success = AppletMultiplayerClient.askUserForConnection(AppletMultiplayerClient.this.room.clientCurrentConsole().remoteReceiver(), Parameters.mainArg);
                if (!success) {
                    Terminator.terminate();
                }
            }
        });
    }

    @Override
    public void stop() {
        this.room.powerOff();
        try {
            this.room.clientCurrentConsole().remoteReceiver().disconnect();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error disconnecting from Server:\n" + ex, "javatari P2 Client", 0);
        }
    }

    @Override
    public void destroy() {
        this.room.destroy();
    }

    private static boolean askUserForConnection(RemoteReceiver remoteReceiver, String defaultServer) {
        String server = defaultServer;
        while (true) {
            if (server != null && !server.isEmpty()) {
                try {
                    remoteReceiver.connect(server);
                    return true;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Unnable to connect to: " + server + "\n" + ex, "Atari Player 2 Client", 0);
                }
            }
            do {
                if ((server = (String)JOptionPane.showInputDialog(null, "Atari Player 1 Server address[:port]:", "Atari Player 2 Client", -1, null, null, server)) != null) continue;
                return false;
            } while ((server = server.trim()).isEmpty());
        }
    }
}

