/*
 * Decompiled with CFR 0.152.
 */
package pc.cartridge;

import atari.cartridge.Cartridge;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jnlp.FileContents;
import javax.swing.JOptionPane;
import pc.cartridge.CartridgeCreator;
import pc.cartridge.UnsupportedROMFormatException;

public final class ROMLoader {
    private static final int MAX_ROM_SIZE = 524288;
    private static final int MAX_STREAM_SIZE = 525312;
    public static final String VALID_FILES_DESC = "ROM files (.bin .rom .a26 .zip)";
    public static final String[] VALID_FILE_EXTENSIONS = new String[]{"bin", "rom", "a26", "zip"};

    public static Cartridge load(String url) {
        try {
            return ROMLoader.load(new URL(url));
        }
        catch (MalformedURLException ex) {
            ROMLoader.errorMessage(ex, url);
            return null;
        }
    }

    public static Cartridge load(File file) {
        try {
            return ROMLoader.load(file.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            ROMLoader.errorMessage(ex, file.getPath());
        }
        catch (AccessControlException ex) {
            ROMLoader.errorMessage(ex, file.getPath());
        }
        return null;
    }

    public static Cartridge load(URL url) {
        InputStream stream = null;
        try {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            stream = conn.getInputStream();
            return ROMLoader.load(stream, url.toString(), ROMLoader.getCartridgeName(url.toString()));
        }
        catch (AccessControlException ex) {
            ROMLoader.errorMessage(ex, url.toString());
        }
        catch (IOException ex) {
            ROMLoader.errorMessage(ex, url.toString());
        }
        return null;
    }

    public static Cartridge load(FileContents fileCont) {
        String fileName = "<unknown>";
        try {
            fileName = fileCont.getName();
            InputStream stream = fileCont.getInputStream();
            return ROMLoader.load(stream, fileName, ROMLoader.getCartridgeName(fileName));
        }
        catch (IOException ex) {
            ROMLoader.errorMessage(ex, fileName);
            return null;
        }
    }

    public static Cartridge load(InputStream stream, String location, String name) {
        System.out.println("Loading Cartridge from: " + location);
        BufferedInputStream buffer = ROMLoader.bufferedStream(stream);
        try {
            Cartridge cartridge = ROMLoader.tryCreation(buffer, name);
            return cartridge;
        }
        catch (UnsupportedROMFormatException ex) {
            buffer.reset();
            InputStream romFromZIP = ROMLoader.getFirstROMFromZIP(buffer);
            if (romFromZIP == null) {
                throw ex;
            }
            Cartridge cartridge = ROMLoader.tryCreation(romFromZIP, name);
            return cartridge;
        }
        catch (IOException ex) {
            ROMLoader.errorMessage(ex, location);
        }
        finally {
            try {
                stream.close();
                buffer.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static Cartridge tryCreation(InputStream stream, String name) throws IOException, UnsupportedROMFormatException {
        int read;
        byte[] buffer = new byte[525312];
        int totalRead = 0;
        while ((read = stream.read(buffer, totalRead, 525312 - totalRead)) != -1 && (totalRead += read) < 525312) {
        }
        byte[] content = totalRead > 0 ? Arrays.copyOf(buffer, totalRead) : new byte[]{};
        return CartridgeCreator.create(content, name);
    }

    private static InputStream getFirstROMFromZIP(InputStream stream) throws IOException, UnsupportedROMFormatException {
        ZipInputStream zipStream = new ZipInputStream(stream);
        ZipEntry entry;
        block0: while ((entry = zipStream.getNextEntry()) != null) {
            String entryName = entry.getName().toUpperCase();
            int i = 0;
            while (true) {
                if (i >= VALID_FILE_EXTENSIONS.length) continue block0;
                if (entryName.endsWith(VALID_FILE_EXTENSIONS[i].toUpperCase())) {
                    return zipStream;
                }
                ++i;
            }
            break;
        }
        return null;
    }

    private static String getCartridgeName(String url) {
        String name = url;
        try {
            int bslash;
            int slash;
            int i;
            String enc = System.getProperty("file.encoding");
            if (enc != null) {
                name = URLDecoder.decode(url, enc);
            }
            if ((i = Math.max(slash = name.lastIndexOf("/"), bslash = name.lastIndexOf("\\"))) >= 0 && i < name.length() - 1) {
                name = name.substring(i + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    private static BufferedInputStream bufferedStream(InputStream stream) {
        BufferedInputStream buf = new BufferedInputStream(stream, 525312);
        buf.mark(525312);
        return buf;
    }

    private static void errorMessage(Exception ex, String location) {
        String tLoc;
        System.out.println("Could not load Cartridge from: " + location);
        System.out.println(ex);
        String string = tLoc = location == null ? "" : location.trim();
        if (tLoc.length() > 80) {
            tLoc = String.valueOf(tLoc.substring(0, 79)) + "...";
        }
        JOptionPane.showMessageDialog(null, "Could not load Cartridge from:\n" + tLoc + "\n\n" + ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Error loading Cartridge", 0);
    }
}

