/*
 * Decompiled with CFR 0.152.
 */
package pc.savestate;

import atari.console.savestate.ConsoleState;
import atari.console.savestate.SaveStateMedia;
import atari.console.savestate.SaveStateSocket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class FileSaveStateMedia
implements SaveStateMedia {
    private String savesDirectory;
    private static final String BASE_DIR = "javatarisaves";

    public void connect(SaveStateSocket socket) {
        socket.connectMedia(this);
    }

    @Override
    public boolean save(int slot, ConsoleState state) {
        try {
            block6: {
                File dir = new File(this.savesDirectory());
                if (!dir.isDirectory()) {
                    dir.mkdir();
                }
                FileOutputStream file = null;
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    ObjectOutputStream stream = new ObjectOutputStream(data);
                    stream.writeObject(state);
                    file = new FileOutputStream(String.valueOf(this.savesDirectory()) + File.separator + "save" + slot + ".sav");
                    file.write(data.toByteArray());
                }
                finally {
                    if (file == null) break block6;
                    file.close();
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public ConsoleState load(int slot) {
        ConsoleState consoleState;
        block6: {
            FileInputStream file = null;
            try {
                file = new FileInputStream(String.valueOf(this.savesDirectory()) + File.separator + "save" + slot + ".sav");
                byte[] data = new byte[file.available()];
                file.read(data);
                ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(data));
                consoleState = (ConsoleState)stream.readObject();
                if (file == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        file.close();
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            file.close();
        }
        return consoleState;
    }

    private String savesDirectory() {
        if (this.savesDirectory != null) {
            return this.savesDirectory;
        }
        try {
            String userHome = System.getProperty("user.home");
            if (userHome != null && !userHome.isEmpty()) {
                this.savesDirectory = String.valueOf(userHome) + File.separator + BASE_DIR;
                return this.savesDirectory;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.savesDirectory = BASE_DIR;
        return BASE_DIR;
    }
}

