/*
 * Decompiled with CFR 0.152.
 */
package pc.speaker;

import general.av.audio.AudioMonitor;
import general.av.audio.AudioSignal;
import general.board.Clock;
import general.board.ClockDriven;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import parameters.Parameters;

public final class Speaker
implements ClockDriven,
AudioMonitor {
    public final Clock clock;
    private final double fps;
    private AudioSignal signal;
    private SourceDataLine dataLine;
    private ByteBuffer inputBuffer;
    private byte[] tempBuffer;
    private final AudioFormat AUDIO_FORMAT = new AudioFormat(Parameters.TIA_AUDIO_SAMPLE_RATE, 8, 1, true, false);
    public static final double DEFAULT_FPS = Parameters.SPEAKER_DEFAULT_FPS;
    public static final int INPUT_BUFFER_SIZE = Parameters.SPEAKER_INPUT_BUFFER_SIZE;
    public static final int OUTPUT_BUFFER_SIZE = Parameters.SPEAKER_OUTPUT_BUFFER_SIZE;
    public static final int OUTPUT_BUFFER_FULL_SLEEP_TIME = Parameters.SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME;
    public static final int NO_DATA_SLEEP_TIME = Parameters.SPEAKER_NO_DATA_SLEEP_TIME;
    public static final int ADDED_THREAD_PRIORITY = Parameters.SPEAKER_ADDED_THREAD_PRIORITY;

    public Speaker() {
        this.fps = DEFAULT_FPS;
        this.clock = new Clock("Speaker", this, this.fps);
    }

    public void connect(AudioSignal signal) {
        this.signal = signal;
        signal.connectMonitor(this);
    }

    public void powerOn() {
        if (this.dataLine == null) {
            this.getLine();
        }
        if (this.dataLine == null) {
            return;
        }
        this.dataLine.start();
        this.clock.go();
    }

    public void powerOff() {
        if (this.dataLine == null) {
            return;
        }
        this.dataLine.drain();
        this.dataLine.stop();
        this.clock.pause();
    }

    public void destroy() {
        this.dataLine.close();
        this.dataLine = null;
        this.clock.terminate();
    }

    @Override
    public synchronized void nextSamples(byte[] buffer, int quant) {
        int ava = this.inputBuffer.remaining();
        if (ava > quant) {
            ava = quant;
        }
        this.inputBuffer.put(buffer, 0, ava);
    }

    @Override
    public void synchOutput() {
        this.refresh();
    }

    @Override
    public void clockPulse() {
        this.synchOutput();
    }

    private void getLine() {
        if (this.signal == null) {
            return;
        }
        AudioFormat audioFormat = this.AUDIO_FORMAT;
        try {
            this.dataLine = AudioSystem.getSourceDataLine(audioFormat);
            this.dataLine.open(audioFormat, OUTPUT_BUFFER_SIZE);
            this.inputBuffer = ByteBuffer.allocateDirect(INPUT_BUFFER_SIZE);
            this.tempBuffer = new byte[this.inputBuffer.capacity()];
            if (ADDED_THREAD_PRIORITY != 0) {
                this.clock.setPriority(5 + ADDED_THREAD_PRIORITY);
            }
            System.out.println("Sound Mixer Line: " + this.dataLine);
            System.out.println("Sound Output buffer: " + this.dataLine.getBufferSize());
        }
        catch (Exception ex) {
            System.out.println("Unable to acquire audio line:\n" + ex);
            this.dataLine = null;
        }
    }

    private synchronized int getFromInputBuffer(byte[] buffer, int quant) {
        this.inputBuffer.flip();
        int ava = this.inputBuffer.remaining();
        if (ava > quant) {
            ava = quant;
        }
        this.inputBuffer.get(buffer, 0, ava);
        this.inputBuffer.compact();
        return ava;
    }

    private void refresh() {
        int ava = this.dataLine.available();
        if (ava == 0) {
            if (OUTPUT_BUFFER_FULL_SLEEP_TIME > 0 && this.fps < 0.0) {
                try {
                    Thread.sleep(OUTPUT_BUFFER_FULL_SLEEP_TIME, 0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
        int data = this.getFromInputBuffer(this.tempBuffer, ava);
        if (data == 0) {
            if (NO_DATA_SLEEP_TIME > 0 && this.fps < 0.0) {
                try {
                    Thread.sleep(NO_DATA_SLEEP_TIME, 0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
        this.dataLine.write(this.tempBuffer, 0, data);
    }
}

