/*
 * Decompiled with CFR 0.152.
 */
package utils.slickframe;

import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import utils.slickframe.MousePressAndMotionAdapter;
import utils.slickframe.MousePressAndMotionListener;

public class SlickFrame
extends JFrame {
    private MousePressAndMotionListener mouseListener;
    private final boolean resizable;
    private Point clickPosition = null;
    private Point startingLocation = null;
    private Dimension startingSize = null;
    private Dimension minimumSize = new Dimension(80, 40);
    private static final int RESIZE_CORNER_SIZE = 18;
    public static final long serialVersionUID = 1L;

    public SlickFrame() throws HeadlessException {
        this(true);
    }

    public SlickFrame(boolean resizable) throws HeadlessException {
        this.init();
        this.resizable = resizable;
    }

    public void minimunResize(Dimension minSize) {
        this.minimumSize = minSize;
    }

    public MousePressAndMotionListener detachMouseListener() {
        this.removeMouseListener(this.mouseListener);
        this.removeMouseMotionListener(this.mouseListener);
        return this.mouseListener;
    }

    protected void init() {
        this.setUndecorated(true);
        this.setResizable(false);
        this.mouseListener = this.buildMouseListener();
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
    }

    protected void movingTo(int x, int y) {
        this.setLocation(x, y);
    }

    protected void resizingTo(int width, int height) {
        this.setSize(width, height);
    }

    protected void finishedMoving() {
    }

    protected void finishedResizing() {
    }

    private MousePressAndMotionListener buildMouseListener() {
        return new MousePressAndMotionAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                SlickFrame.this.clickPosition = e.getLocationOnScreen();
                if (!SlickFrame.this.resizable) {
                    SlickFrame.this.startingLocation = SlickFrame.this.getLocation();
                    return;
                }
                Rectangle resizeArea = new Rectangle(SlickFrame.this.getWidth() - 18, SlickFrame.this.getHeight() - 18, SlickFrame.this.getWidth(), SlickFrame.this.getHeight());
                if (resizeArea.contains(e.getPoint())) {
                    SlickFrame.this.startingSize = SlickFrame.this.getSize();
                } else {
                    SlickFrame.this.startingLocation = SlickFrame.this.getLocation();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                SlickFrame.this.clickPosition = null;
                if (SlickFrame.this.startingLocation != null) {
                    SlickFrame.this.finishedMoving();
                } else if (SlickFrame.this.startingSize != null) {
                    SlickFrame.this.finishedResizing();
                }
                SlickFrame.this.startingLocation = null;
                SlickFrame.this.startingSize = null;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SlickFrame.this.clickPosition == null) {
                    return;
                }
                Point p = e.getLocationOnScreen();
                if (SlickFrame.this.startingLocation != null) {
                    SlickFrame.this.movingTo(((SlickFrame)SlickFrame.this).startingLocation.x + p.x - ((SlickFrame)SlickFrame.this).clickPosition.x, ((SlickFrame)SlickFrame.this).startingLocation.y + p.y - ((SlickFrame)SlickFrame.this).clickPosition.y);
                } else {
                    SlickFrame.this.resizingTo(Math.max(((SlickFrame)SlickFrame.this).startingSize.width + p.x - ((SlickFrame)SlickFrame.this).clickPosition.x, ((SlickFrame)SlickFrame.this).minimumSize.width), Math.max(((SlickFrame)SlickFrame.this).startingSize.height + p.y - ((SlickFrame)SlickFrame.this).clickPosition.y, ((SlickFrame)SlickFrame.this).minimumSize.height));
                }
            }
        };
    }
}

