
/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Johann Ruegg
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *  AENDERUNGEN AN DIESER DATEI: Die Fehlermeldungen des Compilers werden
 *      in eine Datei geschrieben, die den Namen des C-Quelltextes mit der
 *      Endung "ERR" erhaelt. Dadurch ist es in jeder Version des
 *      Betriebs-Systems moeglich, die Fehlermeldungen in eine Datei zu
 *      bekommen. Die Aenderungen betreffen die Funktionen
 *      main(), error...(), warn...(), fatal...() und optnl()
 *      -- Holger --
 *
 *	main.c
 *
 *	Main routine, options, error handling.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <tos.h>
#include <ext.h>
#include <setjmp.h>
#include "common/hierarch.h"
#include "lmem.h"

#include "param.h"
#include "shell/xref.h"
#include "ahcc.h"
#include "pre.h"
#include "body.h"
#include "gsub.h"
#include "out.h"
#include "opt.h"

global long	lineno, n_lineno;

global COMMON G;
global STATS stats = {0};
global CC_PHASE phase;

#define debug_z (G.yflags['z'-'a'])

#if ! BIP_CC
static const
char 	corq   [] = "C or Q ? ",
		wacht  [] = "Press any key.\n";
#endif

static CP input;
static short succ, breakin;

extern string srchlist[];

global AHCOUT *bugf = stdout;

#define MAXPREDEF	128

global DEFS defines[MAXPREDEF];		/* NN..BB.. There are also in init_cc() for BIP_CC */

#define BRKVAL 20

global char *ahcc_version = "V4.6";
static const

#ifdef PRGNAME
char Version[] = PRGNAME ": version %s (c) 1988 by Sozobon,\n"
                 "                 1990-2011 by H.Robbers Amsterdam\n";
#else
char Version[] = "AHCC: version %s (c) 1988 by Sozobon,\n"
                 "                 1990-2011 by H.Robbers Amsterdam\n";
#endif

static bool toomanyerr(void)
{
static bool given = false;
	if (G.nmerrors > G.e_max_errors)
	{
		if (!given)
			console("more than %d error%s\n", G.e_max_errors, pluralis(G.e_max_errors)),
			given = true;
		return true;
	}
	return false;
}

static bool toomanywarn(void)
{
static bool given = false;
	if (G.nmwarns > G.f_max_warnings)
	{
		if (!given)
			console("more than %d warning%s\n", G.f_max_warnings, pluralis(G.f_max_warnings)),
			given = true;
		return true;
	}
	return false;
}

void send_incname(short inclvl, string incname)
{
	if (G.v_Cverbosity > 1)
	{
		char *s = incname+strlen(incname);	/* display short name */
		while (s > incname)
			if (*s eq bslash or *s eq fslash)
			{
				s++;
				break;
			}
			else
				s--;
#if BIP_CC
	#if C_DEBUG
		send_msg("%d>[%d]%s\n", inclvl, G.inctab->p.fileno, s);
	#else
		send_msg("%d>%s\n", inclvl, incname);
	#endif
#else
		console(inclvl ? "\t" : "\n");
	#if C_DEBUG
		console("[%d]%s ", G.inctab->p.fileno, s);
	#else
		console("%s ", s);
	#endif
#endif
	}
}

global void adddef(string s)		/* adddef subdef & dodefs 3'91 v1.2 */
{
	string as;


	if (G.npred >= MAXPREDEF)
	{
		warn("too many -D 's");
		return;
	}

	if ((as = strchr(s,'=')) ne nil)
	{
		*as++ = 0;
	othw
		as = nil;
	}

	defines[G.npred].dname = s;
	defines[G.npred].dval  = as;
	G.npred++;
	defines[G.npred].dname = nil;
	defines[G.npred].dval  = nil;
}

static void dodefs(void)
{
	short i;
	struct def *pt;

	/*
	 * Define the "built-in" macros
	 */
	pt = defines;
	for (i = 0; i < G.npred; i++, pt++)
	{
		char *s = pt->dname, *as = pt->dval;
		if (!as)
			as = "1";
#if 1
		if (G.v_Cverbosity > 3)
			send_msg("def: '%s','%s'\n", s, as);
#endif
		optdef(s, as);
	}
}

static void optnl(void)
{
	D_B (if (bugf eq stdout and G.anydebug) (send_msg("\n"), breakin++);)
}

static
jmp_buf cc_jump;
static
char *abort_msg = "**** compiler aborted, insufficient memory. ****\n";
static
short xjmp;

XA_run_out CC_ranout
{
	if (phase > COMPILING)
	{
		console("Internal error: CC_ranout wrong phase %d, key %d", phase, key);
		bios(2,2);
		exit(9999);
	}

	if (base->flags & XA_LOCAL)
		XA_free_all(base, -1, -1);

	G.nmerrors++;		/* prevents output */
	longjmp(cc_jump, 1);
	return 1;			/* dummy: not reached ever */
}

global char trtime[10],
	        trdate[24];		/* for use in pre.c */

#if 0
#define mem(a) pmem(a)
void pmem(char *s)
{
	extern size_t XA_total;
	static long memory = 0;
	console("%-8s: was %8ld, XA %8ld %8ld\n", s, memory, XA_total, XA_total - memory);
	memory = XA_total;
}
#else
	#define mem(a)
#endif

static
short do_file(void)
{
	long clo=clock();
	XA_report cpunit;
	VpV asmc_end, opc_end, setup_end;

	union
	{
		long lt;
		struct
		{
			ubits y : 7;
			ubits m : 4;
			ubits d : 5;
			ubits h : 5;
			ubits mn : 6;
			ubits s : 5;
		} b;
	} tij;

	extern XP *deflist,
			  curtok;		/* from  PRE  */
	short i;

	tij.lt = Gettime();
	i = tij.b.y + 1980;

	sprintf(trtime, "%02u:%02u:%02u", tij.b.h, tij.b.mn, tij.b.s);
	sprintf(trdate, "%04u-%02u-%02u", i,       tij.b.m,  tij.b.d);

	breakin = 0;

	tok_init();

	init_dictionary();
	deflist = init_symtab(AH_NEW_DEFLIST);
	symtab = init_symtab(AH_NEW_SYMTAB);
	curtok = allocXn(1);
	dodefs();							/* 3'91 v1.2 */

	lineno = n_lineno = 1;
	cur_LEX = input->text;
	xjmp = setjmp(cc_jump);

	if (xjmp eq 1)
	{
		console("----> cc_abort\n");
		goto cc_abort;
	}

#if BIP_ASM
	if (G.in_S)
		do_S();				/* assemble a S file */
	else
#endif
	if (!create_areas())
		error("[1]Not enough memory for output");
	else
		do_C();				/* compile a C file */

	write_literals();

mem("file");

cc_abort:
	if (deflist)
	{
		for (i = 0; i < numhash; i++)
		{
			freeXn(deflist[i]);
			deflist[i] = nil;
		}
		CC_xfree(deflist, 200);
		deflist = nil;
	}

	freeXn(G.holdtok);
	G.holdtok = nil;
	freeXn(G.expanding);
	G.expanding = nil;

	if (symtab)
	{
		for (i = 0; i < numhash; i++)
		{
			freeTn(symtab[i]);
			symtab[i] = nil;
		}
		CC_xfree(symtab, 201);
		symtab = nil;
	}

	freeTn(G.optab);
	G.optab = nil;

	freeTn(G.casttab);
	G.casttab = nil;

	freeTn(G.tagtab);
	G.tagtab = nil;

	freeincs();

	free_cache_unit(input, 1);
	free_dictionary();
mem("dictionary");

	freenodespace(XNr);
	freenodespace(TLr);
	freenodespace(EXr);
	freenodespace(VNr);

	if (G.v_Cverbosity > 1)
		console("\n");

	clo = clock()-clo;	/* wide measurement */
	G.clockopt = clock();

#if BIP_ASM
	if (G.in_S)
		end_S();
	else
#endif
		end_C();		/* calls optimizer */

#if BIP_ASM
	asmc_end();			/* 12'09 HR: Also frees C embedded asm setup */
#endif
	freenodespace(INr);
	freenodespace(BKr);
mem("nodespace");

	destroy_areas();	/* 12'09 HR: moved to here (asm was leaking) */
mem("areas");

	G.clockopt = clock()-G.clockopt;;

	if (G.nmwarns and G.nmwarns <= G.f_max_warnings)
		console("%d warning%s\n", G.nmwarns, pluralis(G.nmwarns));
	if (G.nmerrors and G.nmerrors <= G.e_max_errors)
		console("%d error%s\n", G.nmerrors, pluralis(G.nmerrors));

	{
		short fclo;

#if C_DEBUG
		if (G.an_IXC)
		{
			fclo = clo/2;
			console("clocked: %d.%02d\n", fclo/100, fclo%100);
			if (G.nmerrors)
				console("processed %ld bytes.\n", G.C_bytes);
			elif (fclo)
				console("compiled %ld bytes; thats %ld Bps.\n", G.C_bytes, (G.C_bytes*100)/fclo);
			else
				console("compiled %ld bytes.\n", G.C_bytes);
		}
		else
#endif
		{
			short pclo;
			fclo = clo/2;
			if (G.nmerrors)
			{
				if (fclo)
					console("clocked %d.%02d\n",fclo/100,fclo%100);
				console("processed %ld bytes.\n",G.C_bytes);
			othw
				G.clockopt  -= G.asm_clock;
				G.asm_clock /= 2;
				pclo = G.clockopt/2;

#if 0
				console("compiled %ld bytes in (%d.%02d + %d.%02d + %d.%02d) seconds",
					G.C_bytes, fclo/100,fclo%100,
					           pclo/100,pclo%100,
					           G.asm_clock/100,G.asm_clock%100);
#else
				pclo += G.asm_clock;
				if (pclo)
					console("compiled %ld bytes in (%d.%02d + %d.%02d) seconds",
						G.C_bytes, fclo/100,fclo%100,
						           pclo/100,pclo%100);
				elif (fclo)
					console("compiled %ld bytes in %d.%02d seconds",
						G.C_bytes, fclo/100,fclo%100);
				else
					console("compiled %ld bytes in no time", G.C_bytes);
#endif
				fclo += pclo;
				if (fclo)
					console("; %ld Bps", (G.C_bytes*100)/fclo);
				console(".\n");
			}
		}
	}

#if NODESTATS
	if (G.al_list_stats)
		nodecnts();
#endif

	if (xjmp)
	{
		send_msg(abort_msg);
		setup_end();
#if BIP_ASM
		asmc_end();
#endif
		opc_end();
		free_cache(9);
		CC_xfree_all(-1);
		CC_ffree_all(-1);
		NS_xfree_all(-1);
	}

	if (G.nmerrors)
		return G.nmerrors;
	if (G.nmwarns)
		return -G.nmwarns;			/* '-' tbv SHELL */
	return 0;
}

XA_report cpunit
{
	if (!unit)
		printf("Leak: nil\n");
	else
	{
		XA_key key = unit->key;
		if (G.ac_cache_headers)
			if (key eq AH_OPEN_C or key eq AH_OPEN_X)
				return;
		/* see common/mallocs.h */
		if (key < CC_LEAK_BEGIN or key > CC_LEAK_END)
			return;

		console("Leak[%d]: %3d size %5ld %lx block %5ld %lx %s\n",
			which, key, unit->size, unit->area, blk->size, blk, base->name);
	}
}

static void subdef(string s)
{
	short i;

	for (i = 0; i < G.npred; i++)
		if (strcmp(s, defines[i].dname) ne 0)
			break;

	while (i < G.npred)
	{
		defines[i] = defines[i+1];
		i++;
	}
	G.npred--;
}

static char *ON(bool opt)
{
	return opt ? "ON" : "OFF";
}

static bool on_off(char *s, bool *b)
{
	if (*s eq '-') { s++; *b = false; return true; }
	if (*s eq '+') { s++; *b = true ; return true; }		/* goto next - */
	*b = true;
	return false;		/* next letter */
}

#define ON_OFF(x) if (on_off(s, &(x))) return; else continue

void help_options(char c)
{
	if (c)
		send_msg("\nwarning: unknown option: %c\tthey are:\n\t(followed by current state)\n", c);
	send_msg("AHCC specific options:\n");
	send_msg("-*g    warn goto's                         (%s)\n", ON(G.ag_nogoto));
	send_msg("-*b    no branch reversals                 (%s)\n", ON(G.ab_no_branch_reversals));
	send_msg("-*i    default int is 32 bits              (%s)\n", ON(G.ai_int32));
	send_msg("-*w    default Xn is long                  (%s)\n", ON(G.aw_Xnl));
	send_msg("-*u    Assembly starts in .super mode      (%s)\n", ON(G.au_supervisor));
	send_msg("\nPure C compatible options:\n");
	send_msg("-a     strict ANSI                         (%s)\n", ON(G.a_strict_ANSI));
	send_msg("-b     DRI object output                   (%s)\n", ON(G.b_output_DRI));
	send_msg("-c     allow nested comments               (%s)\n", ON(G.c_nested_comments));
	send_msg("-dX..X define macro; optional =value\n");
	send_msg("-eN    maximum no of erors                 (%d)\n",    G.e_max_errors);
	send_msg("-fN    maximum no of warnings              (%d)\n",    G.f_max_warnings);
	send_msg("-g     size optimization                   (%s)\n", ON(G.g_optimum_size));
	send_msg("-h     cdecl calling                       (%s)\n", ON(G.h_cdecl_calling));
	send_msg("-iX..X include directory\n");
	send_msg("-j     no jump optimization                (%s)\n", ON(G.j_no_jump_optimization));
	send_msg("-k     default char is unsigned            (%s)\n", ON(G.k_char_is_unsigned));
	send_msg("-l     maximum identifier length           (%d)\n",    G.l_identifier_max_length);
	send_msg("-m     merge identical strings             (%s)\n", ON(G.m_string_merging));
	send_msg("-n     'nm' list of symbols                (%s)\n", ON(G.n_nmlist));
	send_msg("-p     use absolute calls                  (%s)\n", ON(G.p_absolute_calls));
	send_msg("-s     force frame pointers                (%s)\n", ON(G.s_frame_pointer));
	send_msg("-t     stack checking                      (%s)\n", ON(G.t_stack_checking));
	send_msg("-uX..X undefine macro\n");
	send_msg("-v     verbosity                           (%d)\n",    G.v_Cverbosity);
	send_msg("-x     prepend underline to identiers      (%s)\n", ON(G.x_add_underline));
#if FLOAT
	send_msg("-2     generate for MC68020+               (%s)\n", ON(G.i2_68020));
	send_msg("-3     generate for MC68020+               (%s)\n", ON(G.i2_68020));
	send_msg("-4     generate for MC68020+               (%s)\n", ON(G.i2_68020));
	send_msg("-6     generate for MC68020+               (%s)\n", ON(G.i2_68020));
	send_msg("-8     generate directly for MC68881/2     (%s)\n", ON(G.use_FPU));
#endif
#if COLDFIRE
	send_msg("-7     Coldfire                            (%s)\n", ON(G.Coldfire));
	send_msg("-27    Coldfire, also runnable on 68020 (%s,%s)\n", ON(G.Coldfire),ON(G.i2_68020));
#endif
#if C_DEBUG
#if ! BIP_CC
	send_msg(wacht);
	bios(2,2);
#endif
	send_msg("debug options:\n");
	send_msg("-*t    make listing of internal token names and values\n");
	send_msg("-*e    suppress extracodes (ahcc_rt.h)\n");
	send_msg("-*a    obey ALL but zZ debug code\n");
	send_msg("-*z    obey ALL debug code except printnode\n");
	send_msg("-*y... obey yflagged code (a..z)\n");
	send_msg("-*x... obey xflagged code (A..Z)\n");
	send_msg("-*f    debug output to:                    (ahcc.jnl)\n");
	send_msg("-*l    all kinds of lists in journal       (%s)\n", ON(G.al_list_stats));
	send_msg("-*p    suppress peephole optimizations     (%s)\n", ON(G.ap_no_peep));
	send_msg("-*d    do newest optimization              (%s)\n", ON(G.ad_new_peep));
	send_msg("-*n    suppress optimizer & assembler      (%s)\n", ON(G.an_IXC));
	send_msg("-*r    suppress registerization            (%s)\n", ON(G.ar_no_registerization));
#endif
#if ! BIP_CC
	send_msg(wacht);
	bios(2,2);
#endif
}

void node_sizes(void)
{
	console("common        %ld\n", offsetof(struct vnode, nd));
	console("sizeof(XNODE) %ld\n", sizeof(XNODE));
	console("sizeof(TNODE) %ld\n", sizeof(TNODE));
	console("sizeof( NODE) %ld\n", sizeof( NODE));
	console("sizeof(INODE) %ld\n", sizeof(INODE));
	console("sizeof(OPND ) %ld\n", sizeof(OPND ));
	console("sizeof(BNODE) %ld\n", sizeof(BNODE));
	console("sizeof(SNODE) %ld\n", sizeof(SNODE));
	console("sizeof(FNODE) %ld\n", sizeof(FNODE));
	console("\n");
	console("sizeof(VNODE) %ld\n", sizeof(VNODE));
	console("sizeof(mnode) %ld\n", sizeof(struct mnode));
	console("sizeof(cnode) %ld\n", sizeof(struct cnode));
	console("sizeof(pnode) %ld\n", sizeof(struct pnode));
	console("sizeof(flown) %ld\n", sizeof(struct flown));
}

static void newopt(string s)
{
	register char c;

	while ((c = *s++) ne 0 )
	{
		c = tolower(c);
		switch (c)
		{
#if C_DEBUG
		case 'y':
		case 'x':
		{
			short tp = c;
			while ((c = *s++) ne 0 )
			{
				c = tolower(c);
				if (c >= 'a' and c <='z')
				{
					if (tp eq 'y')
						G.yflags[c-'a'] ^= 1;		/* EOR usefull alfter option -a */
					else
						G.xflags[c-'a'] ^= 1;
					G.anydebug++;
				}
			}
			return;
		}
		case 'a':
		{
			short i;
			G.anydebug++;
			for (i = 0; i<25; i++)			/* all except Z */
			{
				G.yflags[i] = 1;
				G.xflags[i] = 1;
			}
			continue;
		}
		case 'z':
		{
			short i;
			G.anydebug++;
			for (i = 0; i<25; i++)			/* all except Z */
			{
				G.yflags[i] = 1;
				G.xflags[i] = 1;
			}
			G.xflags['n'-'a'] = 0;	/* not printnode; do separate with -yno or do -a */
			G.xflags['o'-'a'] = 0;
			G.xflags['t'-'a'] = 0;
			continue;
		}
		case 'e':
			ON_OFF(G.ae_no_extracodes);		/* suppress extracodes (ahcc_rt.h) */
		case 'f':				/* debugging to disk */
			bugf = fopen("ahcc.jnl", WOPEN);
			continue;
		case 't':
			printtoks();
			waitexit(0);
		case 'n':						/* IXC output */
			ON_OFF(G.an_IXC);
		case 'd':						/* suppress newest peep */
			ON_OFF(G.ad_new_peep);
		case 'p':						/* suppress peep */
			ON_OFF(G.ap_no_peep);
#endif
		case 'r':			/* suppress register variables */
			ON_OFF(G.ar_no_registerization);
		case 'b':
			ON_OFF(G.ab_no_branch_reversals);
		case 'c':
			ON_OFF(G.ac_cache_headers);
		case 'g':			/* no goto's */
			ON_OFF(G.ag_nogoto);
		case 'h':			/* project help */
			ON_OFF(G.ah_project_help);
		case 'j':
			ON_OFF(G.aj_auto_depend);
		case 'i':			/* default int is 32 bits */
			ON_OFF(G.ai_int32);
		case 'l':
#if NODESTATS
			G.al_list_stats = true;
			node_sizes();
#endif
			continue;
		case 'u':
			ON_OFF(G.au_supervisor);	/* default assembly .super */
		}
	}
}

/*		PURE_C compatible options		*/
static void doopt(string s)
{
	register char c;
	short
		me = 0,
	    mw = 0,
	    mi = 0;

	while ((c = *s++) ne 0 )
	{
		c = tolower(c);
		switch (c)
		{
		case 'a':
			ON_OFF(G.a_strict_ANSI);
		case 'b':
			ON_OFF(G.b_output_DRI);
		case 'c':				/* nested comments */
			ON_OFF(G.c_nested_comments);
		case 'd':
			if (*s eq '=')			/* 10'10 HR */
				s++;
			adddef(s);
			return;
		case 'e':				/* no of errors */
			while(*s >='0' and *s <= '9')
				me = (me*10) + (*s++-'0');
			if (me)
				G.e_max_errors = me;
			return;
		case 'f':				/* no of warnings */
			while(*s >='0' and *s <= '9')
				mw = (mw*10) + (*s++-'0');
			if (mw)
				G.f_max_warnings = mw;
			return;
		case 'g':			/* size optimization */
			ON_OFF(G.g_optimum_size);
		case 'h':			/* use cdecl calling */
			ON_OFF(G.h_cdecl_calling);
		case 'i':
			if (*s eq '=')			/* 10'10 HR */
				s++;
			doincl(s);
			return;
		case 'j':			/* Dont optimize jumps */
			ON_OFF(G.j_no_jump_optimization);
		case 'k':			/* default char is unsigned */
			ON_OFF(G.k_char_is_unsigned);
		case 'l':
			while(*s >='0' and *s <= '9')
				mi = (mi*10) + (*s++-'0');
			if (mi)
				G.l_identifier_max_length = mi;
			return;
		case 'm':
			ON_OFF(G.m_string_merging);
		case 'n':
			ON_OFF(G.n_nmlist);
		case 'p':
			ON_OFF(G.p_absolute_calls);
		case 'q':
			ON_OFF(G.q_pascal_calling);
		case 's':
			ON_OFF(G.s_frame_pointer);
		case 't':
			ON_OFF(G.t_stack_checking);
		case 'u':
			subdef(s);		/* 3'91 v1.2 */
			return;
		case 'v':
#if ! BIP_CC
			if (G.v_Cverbosity eq 0)
				console(Version, ahcc_version);
#endif
			G.v_Cverbosity += 1;			/* number of v's = level of verbosity */
			continue;
		case 'w':
			return;
		case 'x':
			ON_OFF(G.x_add_underline);
		case 'y':
			ON_OFF(G.y_debugging);
		case 'z':
			ON_OFF(G.z_register_reload);
#if COLDFIRE
		case '7':			/* Coldfire (double is 64 bits)  */
			ON_OFF(G.Coldfire);
#endif
#if COLDFIRE || FLOAT
		case '2':			/* generate for >= 68020 or CF compatible */
			ON_OFF(G.i2_68020);
		case '3':
			ON_OFF(G.i2_68030);
		case '4':
			ON_OFF(G.i2_68040);
		case '6':
			ON_OFF(G.i2_68060);
#endif
#if FLOAT
		case '8':			/* generate for fpu MC68882 (reals) */
			ON_OFF(G.use_FPU);
#endif
#if ! BIP_CC
		default:
			help_options(c);
#endif
		}
	}
}

#include "cache.h"

global
short filecount, high_prj;

#define debug_l (G.yflags['l'-'a'])

#define prefix 128;

char in_name[256];

global
void cur_name(void)
{
	HI_NAME *hn = hn_make(G.inctab->name, ":\\.", 3);

	strcpy(in_name, hn->fn->n);
	hn_free(hn);
}

global
void do_autodepend(CP fd, char *name, short *count, short fileno)
{
	DEP *dp, *root;

	dp = xref_find_file(auto_dependencies, name, false);

	if (!dp)
		dp = xref_new_file(&auto_dependencies, name, fileno);

	if (dp)
	{
		if (count)
			*count = dp->data->file_number;
		fd->fileno = dp->data->file_number;

		if (G.inctab)
		{
			root = xref_find_file(auto_dependencies, G.inctab->name, false);

			if (root)
			{
				DEP *ddp = xref_find_file(root->depend, name, false);
				if (!ddp)
					xref_new_file(&root->depend, name, dp->data->file_number);
			}
		}
	}
}

global
void add_stats(CP xp)
{
	stats.cbytes += xp->bytes;
	stats.clines += xp->lines;
}

global
VP load_bin(char *name)
{
	void *bitmap;
	short fl;
	long pl;
	VP fd = allocVn(1);

	if (fd)
	{
		bitmap = CC_load(name, &fl, &pl, "while loading", AH_CLOAD);
		if (bitmap)
		{
			fd->name  = CC_xmalloc(strlen(name) + 1, AH_OPEN_X, CC_ranout);
			strcpy(fd->name, name);
			fd->nflags.f.nheap = NHEAP;
			fd->codep = bitmap;
			fd->vval  = pl;
			return fd;
		}
		freeVn(fd);
		fd = nil;
	}

	return fd;
}

global
CP load_source_file(char *name, short *count)
{
	CP fd;
	short fl;
	long pl;
	char *bitmap;
	HI_NAME *hn;

	fd = new_cache(1);

	if (fd)
	{
		hn = hn_make(name, ":\\.", 3);
		strcpy(in_name, hn->fn->n);
		hn_free(hn);

		bitmap = Cload(name, &fl, &pl, "while loading");

		if (bitmap)
		{
			LEX_RECORD *lex;
			long cl, il = pl*res_LEX + prefix;		/* prefix allows for very small compact files */

			lex = CC_fmalloc(il, AH_OPEN_C, nil);
			if (lex)
			{
				long lines;
				stats.bytes += pl;
				cl = C_lexical(bitmap, lex, &lines, G.c_nested_comments, G.in_S);
				stats.lines += lines;

				D_D(_l, (console("lex in %6ld, out %6ld out/in %3ld  %s\n", pl, cl, (cl*100)/pl, name));)

				lex = CC_frealloc(lex, cl, AH_OPEN_C, nil);
#if BIP_CC
				{
					DEP *dp; short fileno = -1;

					/* We must use the fileno if present of the prj db  */
					dp = xref_find_file(prj_dependencies, name, false);		/* files from project */

					if (dp)
						fileno = dp->data->file_number;
					else
					{
						dp = xref_find_file(auto_dependencies, name, false);
						if (!dp)
							fileno = ++filecount;
						else
							fileno = dp->data->file_number;
					}

					if (!(G.aj_auto_depend or G.ah_project_help))
					{
						if (count)
							*count = fileno;
						fd->fileno = fileno;
					}
					else
						do_autodepend(fd, name, count, fileno);
				}
#else
				filecount++;
				if (count)
					*count = filecount;
				fd->fileno = filecount;
#endif
				fd->fl   = fl;

				G.C_bytes += pl;
				fd->name  = CC_xmalloc(strlen(name) + 1, AH_OPEN_X, CC_ranout);
				strcpy(fd->name, name);
				fd->heap  = NHEAP;
				fd->text  = lex;
				fd->bytes = pl;
				fd->lines = lines;
				fd->size  = cl;
				CC_ffree(bitmap, 202);
				return fd;
			othw
				CC_ffree(bitmap, 203);
				cache = free_cache_unit(fd, 2);		/* always last */
			}
		}
		else
			cache = free_cache_unit(fd, 3);
	}

	return nil;
}

void pr_blocks(void);

static VNODE start_inc;

global short AHCC(short argc, string *argv)
{
#ifdef ENVINC
	string pt;
#endif
	short shownames;

#if CC_LEAK && C_DEBUG
	static long memory = 0, this = 0;
	if (memory eq 0)
		(void *)memory = Malloc(-1L);
	(void *)this = Malloc(-1L);		/* memory left !!! */
	if (this < memory)
	{
		XA_report punit;
		console("memory increased by %ld from %ld to %ld\n", memory - this, memory, this);
		XA_leaked(&XA_NS_base,  -1, -1, cpunit, 21);
		XA_leaked(&XA_CC_base,  -1, -1, cpunit, 22);
		XA_leaked(&XA_CC_fbase, -1, -1, cpunit, 23);
		memory = this;
	}
/*	elif (this > memory)
	{
		console("memory decreased by %ld from %ld\n", this - memory, memory);
		memory = this;
	}
*/
#endif

/*	node_sizes();			/* once w/o debug */
*/
mem("========== AHCC ===========");
	phase = COMPILING;
	init_cc();
	init_po();		/* 11'09 HR: fix serious regression */

#if BIP_CC
	{	static bool SV = false;
		if (!SV)
		{	send_msg(Version, ahcc_version);		/* if integrated, only once */
			SV = true;
	}	}
#endif

#ifdef ENVINC
	/*
	 * Parse the INCLUDE environment variable, if present.
	 */
	if ((pt = getenv("INCLUDE")) ne nil)
		doincl(pt);
#endif
	shownames = 0;

	while (argc-- > 1)
	{
		argv++;			/* NB eerste arg = nil (gereserveerd voor program name */

		if (argv[0][0] eq '-')
		{
			if (argv[0][1] eq '*')
				newopt(&argv[0][2]);
			else
				doopt (&argv[0][1]);
		othw
#if ! BIP_CC
			if (!G.anydebug)
			{
				P_path av;
				S_path ern;

				av.s = argv[0];
	            ern = change_suffix(av.t, ".err");		/* errors file */
	            bugf = fopen(ern.s, WOPEN);
	        }
#endif
			G.in_S = findsuf(argv[0], ".s") eq 's';
			input = load_source_file(argv[0], nil);

			{
				char *pd;
				DIRcpy(&G.input_dir, argv[0]);
				pd = strrslash(G.input_dir.s);
				if (pd)
					*(pd + 1) = 0;
				DIRcpy(&G.includer, G.input_dir.s);
			}

			if (input  eq nil)
			{
				console("Can't open input %s\n", argv[0]);
				succ = 1;
				continue;
			}

			add_stats(input);
			cache = cache->next;		/* only headers remain in cache */
			G.inctab = &start_inc;		/* for file_number */
			memset(G.inctab, 0, sizeof(VNODE));
			G.inctab          = allocVn(IFNODE);		/* level 0 for include chain */
			G.inctab->name    = argv[0];

#if BIP_CC
			G.inctab->p.fileno = input->fileno;
#endif

			if ( argc-- > 1 )
			{
				if (     argv[1][0] eq '-'
					and (   argv[1][1] eq 'o'
						 or argv[1][1] eq 'O'
						)
				   )
				{
					argv++;
					argc--;
					DIRcpy(&G.output_name, &argv[0][2]);
					if (!G.in_S)
					{
						G.output       = open_S(G.output_name.s);
						if (G.output eq nil)
						{
							console("Can't open output %s\n", G.output_name);
							succ = 1;
							continue;
						}
					}
				}
			}

			if (argc > 0 or shownames) /* meer dan 1 input file */
			{
				shownames++;
				console              ("IN:  %s\t", G.inctab->name);
				if (G.output) console("OUT: %s", G.output_name.s);
				console("\n");
			}

			if (!out_setup(G.inctab->name))		/* fills output_name */
			{
				succ = 1;
				continue;
			}

#if COLDFIRE
			if (G.Coldfire)
			{
				if (G.v_Cverbosity)
					console("target Coldfire\n");
				adddef("__DOUBLE_64__=1");
				adddef("__COLDFIRE__=1");
/*				G.i2_68020 = 0;
*/				G.use_FPU  = 1;
			}
#endif
#if FLOAT
			if (G.i2_68020)
			{
				if (G.v_Cverbosity)
					console("target 68020\n");
				adddef("__68020__=1");
			}
			if (G.use_FPU)
			{
				if (G.v_Cverbosity)
					console("target FPU\n");
				adddef("__68881__=1");
				adddef("__68882__=1");
				adddef("__FPU__=1");
			}
#else
			adddef("__NO_FLOAT__=1");
			adddef("__68000__=1");
			if (G.v_Cverbosity)
				console("target 68000\n");
#endif
			if (G.k_char_is_unsigned)
				adddef("__CHAR_UNSIGNED__=1");

			if (G.ai_int32)
				adddef("__INT4__=1");
			else
				adddef("__MSHORT__=1");
#if C_DEBUG
			if (G.anydebug)
			{
				char pbug[56];
				string pu = pbug;
				short i;
				for(i = 0; i<26; i++) if (G.xflags[i]) *pu++ = 'A'+i;
				for(i = 0; i<26; i++) if (G.yflags[i]) *pu++ = 'a'+i;
				*pu = 0;
				if (pbug[0])
					console("debug: %s\n", pbug);
			}
#endif
			if (argc > 0)
				succ |= do_file();	/*        not specific on no of  warnings */
			else
				succ  = do_file();	/* definitely     "       "         "	  */

			if (!G.ac_cache_headers)		/* 12'09 HR: forgot to do this */
			{
				free_cache(3);
				mem("free cache");
			}

#if CC_LEAK
			XA_leaked(&XA_NS_base,  -1, -1, cpunit, 21);
			XA_leaked(&XA_CC_base,  -1, -1, cpunit, 22);
			XA_leaked(&XA_CC_fbase, -1, -1, cpunit, 23);
#endif
		}
	}

#if ! BIP_CC
	free_cache(0);
#endif
	free_srchlist();		/* -i directories */

	if (G.anydebug)
		console("\n");

	if (bugf ne stdout)
		fclose(bugf);	/* if BIP_CC bugf is ghost stdout */

mem("=========== CCHA ================");
	waitexit(succ);
	return succ;
}

static bool askq(void)
{
#if ! BIP_CC
	char c;
	if (G.anydebug)
	{
		breakin++;
		if (breakin > BRKVAL)
		{
			breakin = 0;
			send_msg(corq);
			c = bios(2, 2);
			if (c eq 'q')
				return true;
		}
	}
#endif
	return false;
}

static NP find_name(NP tp)
{
	if (tp)
		if (tp->nt ne DFNODE)
			if ( tp->tt ne E_LEAF)
				return find_name(tp->left);
	return tp;
}

static char errbuf[256];

string Error   = "Error",
       Warning = "Warning",
       Message = "Message",
       Fatal   = "Fatal";

global void errorn (void *vp, string s, ...)
{
	NP tp = vp;
	long line = tp ? tp->lineno : lineno;
	va_list argpoint;

	if (toomanyerr())
		return;					/* last message allready given */
	optnl();
	va_start(argpoint, s);
	vsprintf(errbuf, s, argpoint);
	va_end(argpoint);
	if (G.inctab)
		send_msg("%s   in %s L%ld %s", Error, G.inctab->name, line, errbuf);
	else
		send_msg("%s   %s", Error, errbuf);
	if (tp)
	{
		send_msg(" : '");
		if (tp->nt eq FLNODE)
			send_msg("%s", tp->name);
		else
			send_name(tp->nt eq GENODE
							? childname(tp)
							: find_name(tp));
		send_msg("'");
	}
	send_msg("\n");
	G.nmerrors++;
#if ! BIP_CC
	if (bugf eq stdout) if ( askq() ) exit(1);
#endif
}

global void error(string s, ...)
{
	va_list argpoint;
	if (toomanyerr())
		return;					/* last message allready given */
	optnl();
	va_start(argpoint, s);
	vsprintf(errbuf, s, argpoint);
	va_end(argpoint);
	if (G.inctab)
		send_msg("%s   in %s L%ld %s\n", Error, G.inctab->name, lineno, errbuf);
	else
		send_msg("%s   %s\n", Error, errbuf);
	G.nmerrors++;
#if ! BIP_CC
	if (bugf eq stdout) if ( askq() ) exit(1);
#endif
}

global void warnn(void *vp,string s, ...)
{
	NP tp = vp;
	long line = tp ? tp->lineno : lineno;
	va_list argpoint;
	if (toomanywarn())
		return;					/* last message allready given */
	optnl();
	va_start(argpoint, s);
	vsprintf(errbuf, s, argpoint);
	va_end(argpoint);
	if (G.inctab)
		send_msg("%s in %s L%ld %s", Warning, G.inctab->name, line, errbuf);
	else
		send_msg("%s %s", Warning, errbuf);
	if (tp)
	{
		send_msg(" : '");
		if (tp->nt eq FLNODE)
			send_msg("%s", tp->name);
		else
			send_name(tp->nt eq GENODE
							? childname(tp)
							: find_name(tp));
		send_msg("'");
	}
	send_msg("\n");
	G.nmwarns++;
#if ! BIP_CC
	if (bugf eq stdout) if ( askq() ) exit(1);
#endif
}

global void warn(string s, ...)
{
	va_list argpoint;
	if (toomanywarn())
		return;					/* last message allready given */
	optnl();
	va_start(argpoint, s);
	vsprintf(errbuf, s, argpoint);
	va_end(argpoint);
	if (G.inctab)
		send_msg("%s in %s L%ld %s\n", Warning, G.inctab->name, lineno, errbuf);
	else
		send_msg("%s %s\n", Warning, errbuf);
	G.nmwarns++;
#if ! BIP_CC
	if (bugf eq stdout) if ( askq() ) exit(1);
#endif
}

global void messagen(void *vp, string s, ...)
{
	NP tp = vp;
	long line = tp ? tp->lineno : lineno;
	va_list argpoint;
	optnl();
	va_start(argpoint, s);
	vsprintf(errbuf,s, argpoint);
	va_end(argpoint);
	if (G.inctab)
		send_msg("%s in %s L%ld %s", Message, G.inctab->name, line, errbuf);
	else
		send_msg("%s %s", Message, errbuf);
	if (tp)
	{
		send_msg(" : '");
		send_name(tp->nt eq GENODE
						? childname(tp)
						: find_name(tp));
		send_msg("'");
	}
	send_msg("\n");
#if ! BIP_CC
	if (bugf eq stdout) if ( askq() ) exit(1);
#endif
}

global void message(string s, ...)
{
	va_list argpoint;
	optnl();
	va_start(argpoint, s);
	vsprintf(errbuf, s, argpoint);
	va_end(argpoint);
	if (G.inctab)
		send_msg("%s in %s L%ld %s\n", Message, G.inctab->name, lineno, errbuf);
	else
		send_msg("%s %s\n", Message, errbuf);
#if ! BIP_CC
	if (bugf eq stdout) if ( askq() ) exit(1);
#endif
}

global void waitexit(short ret)		/* also used in nodes.c */
{
#if ! BIP_CC
	if (   G.nmerrors
		or G.nmwarns)
	{
		console(wacht);
		bios(2, 2);
	}
	exit(ret);
#endif
}

#if ! BIP_CC
char * pluralis(short n)
{
	return n ne 1 ? "s" : "";
}
#endif
