/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Johann Ruegg
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *	code.h
 */

typedef struct mtbl
{
	ulong
		restr;
	ushort
		needregs,
		needd,
		needa;
	string template;
} MTBL;

#if FLOAT
/* These are for the FPU (main difference is the association of the
	S (with < or >) so that we dont need ANY casting AT ALL.
	a fp reg is allways .x the source determines S */
#if COLDFIRE
static MTBL tblf2[] =
{
	{LISTMP|CANRL|		  CANTM,RETLEFT, 0,0,	"\tNx>S\t<A\t>A" C(tblf2 1) "\n"					},
	{LISTMP|CANRL,				RETLEFT, 0,1,	"\tlmx \tR1\t>A\n\tNx>S\t<A\tR1." C(tblf2 1f) "\n"	},
	{RISTMP|CANLR|NDASSOC|CANTM,RETRIGHT,0,0,	"\tNx<S\t>A\t<A" C(tblf2 2) "\n"					},
	{RISTMP|CANLR|NDASSOC,		RETRIGHT,0,1,	"\tlmx \tR1\t<A\n\tNx<S\tR1.\t<A" C(tblf2 2f) "\n"	},
	{CANRD|				  CANTM,RETDREG, 0,0,	"\tldx<S\tA\t<A\n\tNx>S\tA\t>A" C(tblf2 3) "\n"		},
	{CANRD,						RETDREG, 0,1,	"\tldx<S\tA\t<A\n"
	                                            "\tlmx \tR1\t>A\n\tNx>S\tA\tR1." C(tblf2 3f) "\n"	},
	{CANLD|NDASSOC|		  CANTM,RETDREG, 0,0,	"\tldx>S\tA\t>A\n\tNx>S\tA\t<A" C(tblf2 4) "\n"		},
	{CANLD|NDASSOC,				RETDREG, 0,1,	"\tlmx \tR1\t>A\n\tldx>S\tA\tR1.\n"
	                                            "\tlmx \tR1\t<A\n\tNx>S\tA\tR1." C(tblf2 4f) "\n"	},
	{0}
};
#else
static MTBL tblf2[] =
{
	{LISTMP|CANRL,			RETLEFT, 0,0,	"\tNx>S\t<A\t>A" C(tblf2 1) "\n"				},
	{RISTMP|CANLR|NDASSOC,	RETRIGHT,0,0,	"\tNx<S\t>A\t<A" C(tblf2 2) "\n"				},
	{CANRD,					RETDREG, 0,0,	"\tldx<S\tA\t<A\n\tNx>S\tA\t>A" C(tblf2 3) "\n"	},
	{CANLD|NDASSOC,			RETDREG, 0,0,	"\tldx>S\tA\t>A\n\tNx>S\tA\t<A" C(tblf2 4) "\n"	},
	{0}
};
#endif
#endif

#if COLDFIRE
static MTBL tbllmul[] =
{
	{CANRL|LISTMP|CANTM,	RETLEFT, 0,0,	"\tUmpxS\t<A\t>A" C(tbllmul 1) "\n"},
	{CANRL|LISTMP,			RETLEFT, 0,1,	"\tlmx \tR1\t>A\n\tUmpxS\t<A\tR1." C(tbllmul 1f) "\n"},
	{CANLR|RISTMP|CANTM,	RETRIGHT,0,0,	"\tUmpxS\t>A\t<A" C(tbllmul 2) "\n"},
	{CANLR|RISTMP,			RETRIGHT,0,1,	"\tlmx \tR1\t<A\n\tUmpxS\t>A\tR1." C(tbllmul 2f) "\n"},
	{CANRD       |CANTM,	RETDREG, 0,0,	"\tldx>S\tA\t>A\n\tUmpxS\tA\t<A" C(tbllmul 3) "\n"},
	{CANRD,					RETDREG, 0,1,	"\tldx<S\tA\t<A\n"
	                                        "\tlmx \tR1\t>A\n\tUmpxS\tA\tR1." C(tbllmul 3f) "\n"},
	{0}
};

static MTBL tbllscale[] =
{
	{CANRL|LISTMP|CANTM,	RETLEFT, 0,0,	"\tUmpxS\t<A\t>A" C(tbllscale 1) "\n"},
	{CANRL|LISTMP,			RETLEFT, 0,1,	"\tlmx \tR1\t>A\n\tUmpxS\t<A\tR1." C(tbllscale 1f) "\n"},
	{CANLR|RISTMP|CANTM,	RETRIGHT,0,0,	"\tUmpxS\t>A\t<A" C(tbllscale 2) "\n"},
	{CANLR|RISTMP,			RETRIGHT,0,1,	"\tlmx \tR1\t<A\n\tUmpxS\t>A\tR1." C(tbllscale 2f) "\n"},
	{CANRD       |CANTM,	RETDREG, 0,0,	"\tldx<S\tA\t<A\n\tUmpxS\tA\t>A" C(tbllscale 3) "\n"},
	{CANRD,					RETDREG, 0,1,	"\tldx<S\tA\t<A\n"
											"\tlmx \tR1\t>A\n\tUmpxS\tA\tR1." C(tbllscale 3f) "\n"},
	{0}
};

static MTBL tblldiv[] =
{
	{CANRL|LISTMP|CANTM,	RETLEFT,0,0,	"\tUdvxS\t<A\t>A" C(tblldiv 1) "\n"},
	{CANRL|LISTMP,	        RETLEFT,0,1,	"\tlmx \tR1\t>A\n\tUdvxS\t<A\tR1." C(tblldiv 1f) "\n"},
	{CANRD       |CANTM,	RETDREG,0,0,	"\tldxS\tA\t<A\n\tUdvxS\tA\t>A" C(tblldiv 2) "\n"},
	{CANRD,			        RETDREG,0,1,	"\tldxS\tA\t<A\n"
											"\tlmx \tR1\t>A\n\tUdvxS\tA\tR1." C(tblldiv 2f) "\n"},
	{0}
};

static MTBL tbllmod[] =
{
	{CANRL|LISTMP|CANTM,	RETLEFT,1,0,	"\tUrmxS\tR1\t>A,<A\n\tldx.l\t<A\tR1" C(tbllmod 1f) "\n"},
	{CANRL|LISTMP,	        RETLEFT,1,1,	"\tlmx \tR2\t>A\n\tUrmxS\tR1\tR2.,<A\n\tldx.l\t<A\tR1" C(tbllmod 2f) "\n"},
	{CANRD       |CANTM,	RETDREG,1,0,	"\tldxS\tA\t<A\n\tUrmxS\tR1\t>A,A\n\tldx.l\tA\tR1" C(tbllmod 3f) "\n"},
	{CANRD,			        RETDREG,1,1,	"\tldxS\tA\t<A\n"
											"\tlmx \tR2\t>A\n\tUrmxS\tR1\tR2.,A\n\tldx.l\tA\tR1" C(tbllmod 4f) "\n"},
	{0}
};

static MTBL tblas[] =
{
	{CANIM|CANTM,			RETLEFT,0,0,	"\tNiS\t\t>A,<A" C(tblas 1) "\n"},
	{CANLD|CANTM|LISREGVAR,	RETLEFT,0,0,	"\tNxS\t<A\t>A" C(tblas 2) "\n"},
	{CANRL|CANTM,			RETLEFT,0,0,	"\tNsS\t>A\t<A" C(tblas 3) "\n"},
	{CANDL,					RETLEFT,1,0,	"\tldxS\tR1\t>A\n\tNsS\tR1\tA" C(tblas 4) "\n"},

	/* only MUL, DIV and shifts should get to here */
	{CANRD,			RETDREG,0,0,	"\tldxS\tA\t<A\n\tNxS\tA\t>A\n\tstoS\tA\t<A" C(tblas 5) "\n"},
	{CANLD|NDASSOC,	RETDREG,0,0,	"\tldxS\tA\t>A\n\tNxS\tA\t<A\n\tstoS\tA\t<A" C(tblas 6) "\n"},
	{CANDD,			RETDREG,1,0,	"\tldxS\tA\t<A\n\tldxS\tR1\t>A\n\tNxS\tA\tR1\n\tstoS\tA\t<A" C(tblas 7) "\n"},
	{0}
};

#else
static MTBL tbllmul[] =
{
	{CANRL|LISTMP,	RETLEFT, 0,0,	"\tUmpxS\t<A\t>A" C(tbllmul 1) "\n"},
	{CANLR|RISTMP,	RETRIGHT,0,0,	"\tUmpxS\t>A\t<A" C(tbllmul 2) "\n"},
	{CANRD,			RETDREG, 0,0,	"\tldx>S\tA\t>A\n\tUmpxS\tA\t<A" C(tbllmul 3) "\n"},
	{0}
};

static MTBL tbllscale[] =
{
	{CANRL|LISTMP,	RETLEFT, 0,0,	"\tUmpxS\t<A\t>A" C(tbllscale 1) "\n"},
	{CANLR|RISTMP,	RETRIGHT,0,0,	"\tUmpxS\t>A\t<A" C(tbllscale 2) "\n"},
	{CANRD,			RETDREG, 0,0,	"\tldx<S\tA\t<A\n\tUmpxS\tA\t>A" C(tbllscale 3) "\n"},
	{0}
};

static MTBL tblldiv[] =
{
	{CANRL|LISTMP,	RETLEFT,0,0,	"\tUdvxS\t<A\t>A" C(tblldiv 1) "\n"},
	{CANRD,			RETDREG,0,0,	"\tldxS\tA\t<A\n\tUdvxS\tA\t>A" C(tblldiv 2) "\n"},
	{0}
};

static MTBL tbllmod[] =
{
	{CANRL|LISTMP,	RETLEFT,1,0,	"\tUrmxS\tR1\t>A,<A\n\tldx.l\t<A\tR1" C(tbllmod 1) "\n"},
	{CANRD,			RETDREG,1,0,	"\tldxS\tA\t<A\n\tUrmxS\tR1\t>A,A\n\tldx.l\tA\tR1" C(tbllmod 3) "\n"},
	{0}
};

static MTBL tblas[] =
{
	{CANIM,				RETLEFT,0,0,	"\tNiS\t\t>A,<A" C(tblas 1) "\n"},
	{CANLD|LISREGVAR,	RETLEFT,0,0,	"\tNxS\t<A\t>A" C(tblas 2) "\n"},
	{CANRL,				RETLEFT,0,0,	"\tNsS\t>A\t<A" C(tblas 3) "\n"},
	{CANDL,				RETLEFT,1,0,	"\tldxS\tR1\t>A\n\tNsS\tR1\tA" C(tblas 4) "\n"},

	/* only MUL, DIV and shifts should get to here */
	{CANRD,			RETDREG,0,0,	"\tldxS\tA\t<A\n\tNxS\tA\t>A\n\tstoS\tA\t<A" C(tblas 5) "\n"},
	{CANLD|NDASSOC,	RETDREG,0,0,	"\tldxS\tA\t>A\n\tNxS\tA\t<A\n\tstoS\tA\t<A" C(tblas 6) "\n"},
	{CANDD,			RETDREG,1,0,	"\tldxS\tA\t<A\n\tldxS\tR1\t>A\n\tNxS\tA\tR1\n\tstoS\tA\t<A" C(tblas 7) "\n"},
	{0}
};

#endif

static MTBL tbl2[] =
{
	{LISTMP|CANRL,			RETLEFT, 0,0,	"\tNxS\t<A\t>A" C(tbl2 1) "\n"},
	{RISTMP|CANLR|NDASSOC,	RETRIGHT,0,0,	"\tNxS\t>A\t<A" C(tbl2 2) "\n"},
	{CANRD,					RETDREG, 0,0,	"\tldxS\tA\t<A\n\tNxS\tA\t>A" C(tbl2 3) "\n"},
	{CANLD|NDASSOC,			RETDREG, 0,0,	"\tldxS\tA\t>A\n\tNxS\tA\t<A" C(tbl2 4) "\n"},
	/* only EOR and shifts get to here */
	{CANDL|LISTMP,			RETLEFT, 1,0,	"\tldxS\tR1\t>A\n\tNsS\tR1\tA" C(tbl2 5) "\n"},
	{CANDR|RISTMP|NDASSOC,	RETRIGHT,1,0,	"\tldxS\tR1\t<A\n\tNsS\tR1\tA" C(tbl2 6) "\n"},
	{CANDD,					RETDREG, 1,0,	"\tldxS\tA\t<A\n\tldx>S\tR1\t>A\n\tNxS\tA\tR1" C(tbl2 7) "\n"},	/* only shifts ?? */
	{0}
};

/* indexing.
   This table makes combining to extended operand modes
   much more straightforward.
*/
static MTBL tblindex[] =
{
	{LISTMP|CANRL,	RETLEFT,0,0,	"\tNx>S\t<A\t>A" C(tbli 1) "\n"},
	{CANRD,			RETAREG,0,0,	"\tldxS\tA\t<A\n\tNx>S\tA\t>A" C(tbli 2) "\n"},
	{0}
};

static MTBL tblmul[] =
{
	{CANRL|LISTMP,	RETLEFT, 0,0,	"\tUmpxS \t<A\t>A" C(tblmul 1) "\n"},
	{CANLR|RISTMP,	RETRIGHT,0,0,	"\tUmpxS \t>A\t<A" C(tblmul 2) "\n"},
	{CANRD,			RETDREG, 0,0,	"\tldx>S\tA\t>A\n\tUmpxS \tA\t<A" C(tblmul 3) "\n"},
	{0}
};

static MTBL tblscale[] =
{
	{CANRL|LISTMP,	RETLEFT, 0,0,	"\tUscx \t<A\t>A" C(tblscale 1) "\n"},
	{CANLR|RISTMP,	RETRIGHT,0,0,	"\tUscx \t>A\t<A" C(tblscale 2) "\n"},
	{CANRD,			RETDREG, 0,0,	"\tldx<S\tA\t<A\n\tUscx \tA\t>A" C(tblscale 3) "\n"},
	{0}
};

static MTBL tbldiv[] =
{
	{CANRL|LISTMP,	RETLEFT,0,0,	"\tmvs.w\t<A\t<A\n\tdvx \t<A\t>A" C(tbldiv 1) "\n"},
	{CANRD,			RETDREG,0,0,	"\tmvs.w\tA\t<A\n\tdvx \tA\t>A" C(tbldiv 2) "\n"},
	{0}
};

static MTBL tblmod[] =
{
	{CANRL|LISTMP,	RETLEFT,0,0,	"\tmvs.w\t<A\t<A\n\tmdx \t<A\t>A\n\tswx \t<A\t" C(tblmod 1) "\n"},
	{CANRD,			RETDREG,0,0,	"\tmvs.w\tA\t<A\n\tmdx \tA\t>A\n\tswx \tA" C(tblmod 2) "\n"},
	{0}
};

static MTBL tbludiv[] =
{
	{CANRD,			RETDREG,0,0,	"\tmvz  \tA\t<A\n\tudvx \tA\t>A" C(tbludiv 2) "\n"},
	{0}
};

static MTBL tblumod[] =
{
	{CANRD,			RETDREG,0,0,	"\tmvz  \tA\t<A\n\tumdx \tA\t>A\n\tswx \tA" C(tblumod 2) "\n"},
	{0}
};

static MTBL tblc[] =
{
	{CANIM,	0,0,0,	"\tcpi>S\t\t>A,<A" C(tblc 1) "\n"},
	{CANRL,	0,0,0,	"\tcpx>S\t<A\t>A" C(tblc 2) "\n"},
	{CANRD,	0,1,0,	"\tldx<S\tR1\t<A\n\tcpx>S\tR1\t>A" C(tblc 3) "\n"},
	{0}
};

/* not yet
static MTBL tbleor[] =
{
	{CANIM,	RETLEFT,0,0,	"\teri>S\t\t>A,<A" C(tbleor 1) "\n"},
	{CANRL,	RETLEFT,0,0,	"\ters>S\t>A\t<A" C(tbleor 2) "\n"},
	{CANLD,	0,		1,0,	"\tldx<S\tR1\t<A\n\ters>S\tR1\t>A" C(tbleor 3) "\n"},
	{0}
};
*/

static MTBL tblamul[] =
{
	{CANRL,			RETLEFT, 0,0,	"\tUmpx \t<A\t>A" C(tblamul 1) "\n"},
	{CANLR|RISTMP,	RETRIGHT,0,0,	"\tUmpx \t>A\t<A\n\tsto \t>A\t<A" C(tblamul 2) "\n"},
	{CANRD,			RETDREG, 0,0,	"\tldx  \tA\t<A\n\tUmpx \tA\t>A\n\tsto \tA\t<A" C(tblamul 3) "\n"},
	{0}
};

#if 1
static MTBL tbladiv[] =
{
	{CANRL,	RETLEFT,0,0,	"\tmvs.w\t<A\t<A\n\tdvx \t<A\t>A" C(tbladiv 1) "\n"},
	{CANRD,	RETDREG,0,0,	"\tmvs.w\tA\t<A\n\tdvx \tA\t>A\n\tsto  \tA\t<A" C(tbladiv 2) "\n"},
	{0}
};
#else
static MTBL tbladiv[] =
{
	{CANRL,	RETLEFT,0,0,	"\texx.l\t<A\n\tdvx \t<A\t>A" C(tbladiv 1) "\n"},
	{CANRD,	RETDREG,0,0,	"\tldx \tA\t<A\n\texx.l\tA\n\tdvx \tA\t>A\n\tsto \tA\t<A" C(tbladiv 2) "\n"},
	{0}
};
#endif

static MTBL tbluadiv[] =
{
	{CANRD,	RETDREG,0,0,	"\tmvz \tA\t<A\n\tudvx \tA\t>A\n\tsto \tA\t<A" C(tbluadiv) "\n"},
	{0}
};

#if 1
static MTBL tblamod[] =
{
	{CANRL,	RETLEFT,0,0,	"\tmvs.w\t<A\t<A\n\tmdx \t<A\t>A\n\tswx \t<A\t" C(tblamod 1) "\n"},
	{CANRD,	RETDREG,0,0,	"\tmvs.w\tA\t<A\n\tmdx \tA\t>A\n\tswx \tA\n\tsto \tA\t<A" C(tblamod 2) "\n"},
	{0}
};
#else
static MTBL tblamod[] =
{
	{CANRL,	RETLEFT,0,0,	"\texx.l\t<A\n\tmdx \t<A\t>A\n\tswx \t<A\t" C(tblamod 1) "\n"},
	{CANRD,	RETDREG,0,0,	"\tldx \tA\t<A\n\texx.l\tA\n\tmdx \tA\t>A\n\tswx \tA\n\tsto  \tA\t<A" C(tblamod 2) "\n"},
	{0}
};
#endif

static MTBL tbluamod[] =
{
	{CANRD,	RETDREG,0,0,	"\tmvz \tA\t<A\n\tumdx \tA\t>A\n\tswx \tA\n\tsto \tA\t<A" C(tbluamod) "\n"},
	{0}
};


static BOPS
/*	voor interchange code (denkbeeldige (risc?) computer met instr format F X OP)
	niettemin blijft deze tabel gebaseerd op: LopR, waarbij L is source en R is destination,
	hoe de uiteindelijke lezing er ook uit mag zien	*/

	 bop_cmpcf=	{"cp", 	EopD|     IopD|EopA|AopA|AopD},
	 bop_cmp=	{"cp",	EopD|     IopE|EopA|AopA|AopD},
	 bop_eor=	{"er",	     DopE|IopE},
	 bop_fcp=	{"cp",	EopD},
	 bop_mul=	{"mp",	EopD|                         ASSOC},
	 bop_div=	{"dv",	EopD},
	 bop_mod=	{"md",	EopD},
	 bop_and=	{"an",	EopD|DopE|IopE|     		  ASSOC},
	 bop_or=	{"or",	EopD|DopE|IopE|     		  ASSOC},
	 bop_add=	{"ad",	EopD|DopE|IopE|EopA|AopA|AopD|ASSOC},
	 bop_sub=	{"sb",	EopD|DopE|IopE|EopA|AopA|AopD},
	 bop_asl=	{"Vsl",	DopD|QopD|ONEopM},
	 bop_asr=	{"Vsr",	DopD|QopD|ONEopM},
	 bop_fadd=	{"ad",	EopD|ASSOC},
	 bop_fsub=	{"sb",	EopD}
	 ;
