/* Copyright (c) 1990 - 2009 by H. Robbers.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* defines for the AHCC lex system */

#ifndef C_LEX_H
#define C_LEX_H

#include "prelude.h"

#define MOPS_HERE 1

extern uchar C_hex[], C_oct[];

enum
{
	eof,
	ide,
	oct,
	dig,
	hex,
	spl,
	nl,
	com,
	op,
	mop,
	op2,
	op3,
	X,
	tab,
	ws,
	quo,
	apo,
	cok,
	Last,
};

typedef struct lex_record
{
/*	short rl;			/* record length */
*/	uchar rl, cat;		/* token length, catagory */
	char text[0];		/* text of token at least a \0 */
} LEX_RECORD;

enum
{
	size_LEX = sizeof(LEX_RECORD),
	dummy,
	res_LEX
};

#define next_LEX(r) (LEX_RECORD *)((char *)r + r->rl)
#define LEX_next(r) ((char *)r += r->rl)

long C_lexical(char *s, LEX_RECORD *output, long *lines, bool nest_com, bool for_S);

#if 1
#define break_in (Kbshift(-1)==3)
#else
#define break_in (0)
#endif

#endif
