/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Johann Ruegg
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *	decl.c
 *
 *	Do all declarations
 *
 *	Currently,
 *		struct tags are local
 *		struct members are tied to the struct
 *		enum tags are ignored
 *		enum members are local
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "param.h"

#if BIP_CC
#include "shell/xref.h"
#endif

#include "body.h"
#include "expr.h"
#include "e2.h"
#include "decl.h"
#include "d2.h"
#include "md.h"
#include "out.h"

TP declarator(void);		/* this is THE recursive one */

short   su_par [] = {K_UNION, K_STRUCT};

#define debugD G.xflags['d'-'a']
#define debugQ G.xflags['q'-'a']

/* decl.c */

static TP yields_code (TP mp)
{
	while(mp)
	{
		if ( is_code(mp)) break;
		mp = mp->type;
	}
	return mp;
}

/* 2nd def of same name at same level */

static bool def2nd(TP old, TP new)	/* prototyping: herzien */
{
	short osc, nsc, sim;
	TP pt, tp = new->type, op = old->type;

	osc = old->sc;
	nsc = new->sc;

	D_2(D, "def_second", old, new);
	pt = yields_code(tp);

	sim = similar_type(0, 1, op, tp, pt ne 0);

	if (sim)
	{
		if (    osc eq ENUM
		    and nsc eq ENUM
		   )
			if (old->offset ne new->offset)		/* 05'10 HR check enums */
			{
				errorn(new, "bad redeclaration of");
				freeTn(new);
				return false;
			}
			else
				return true;

		if (	( osc eq nsc )
			and ( osc eq K_TYPE or osc eq PROT )
			)
		{
			freeTn(new);
			return false;
		}

/* Exception for variables of type row. 04'09 */
		if (op->tflgs.f.formal)
			return true;		/* use second def */

/* Exception for variables of type func. */
		if (    pt
		    and (   (    osc eq K_EXTERN
		             and nsc ne PROT
		            )
		         or (    osc ne PROT
		             and nsc eq K_EXTERN
		            )
		        )
		   )
		   	return false;
	}

/* 11'09 HR: empty lists: type p(); type p() { ... }
             check independent from old/new style.	*/
/* 09'11 HR: Ooofff, checked the wrong list. */
/* WRONG !!!!  and old->list eq nil and new->list eq nil */

	if (    sim				/* 06'11 HR */
		and tp and op
		and yields_code(op) ne nil
		and tp->list eq nil
	    and op->list eq nil
	   )
		return true;

	if (   ( pt and osc eq PROT and sim)
	    or (!pt and sim)
	   )
	{
		if ( osc eq PROT   )
		{
			old->sc = PROT_USED;	/* prototype node used:
									   to prevent 2nd def of body */
			if (tp->tflgs.f.old_args)
/* make inernal name so calls are matched against prototype.
 * We cannot free the node because it is a body definition.
 */ 			new_name(new, "__%d__", new_lbl());

			old->area_info = new->area_info;
			return true;
		}

		if ( osc eq K_EXTERN )
			return true;

		if ( nsc eq K_EXTERN )
		{
			freeTn(new);
			return false;
		}
	}

	errorn(new, "bad second decleration of");
	/* use 2nd def so other stuff works */
	return true;  /* put in front of list */
}

global bool loc_sym(TP xp)
{
	TP old;

	if (xp eq nil)
		return false;

	D_D(D, (send_name(xp), send_msg("\tlocal sym sc %s\n", psclass((NP)xp)));)
	if (is_op(xp->type))
		put_lifo(xp->type->token eq K_OP ? &G.scope->b_ops : &G.scope->b_casts, xp);
	else
	{
	/* put in table */
	/* later look for previous definition */
		old = tlook(G.scope->b_syms, xp);
		if (old eq nil or def2nd(old, xp ))
			put_lifo(&G.scope->b_syms, xp);
	}
	return true;
}

/* put in listpp */
global bool list_sym(TP *list, TP xp)
{
	if (xp eq nil)
		return false;
	/* put in table */
	put_lifo(list, xp);

	D_D(D, (send_name(xp), send_msg("\tadded to list\n"));)
	return true;
}

/* assemble decl and put in table */

short xref_scope(short scope)
{
	switch (scope)
	{
		case PROT:
		case PROT_USED:
		case K_EXTERN:
			return -1;
/*		case K_TYPE:
		case K_PROC:
		case K_GLOBAL:
			return 0;
*/	}
	return 0;
}

global void globl_sym(TP xp)
{
	if (xp)
	{
		TP old;

		if (xp->type and is_op(xp->type))
			put_lifo(xp->type->token eq K_OP ? &G.optab : &G.casttab, xp);
		else
		{
		/* put in table */
		/* later look for previous definition */
			short h = hash(xp->name);
			old = tlook(symtab[h], xp);
			if (old eq nil or def2nd(old, xp) )
			{
#if NODESTATS
				G.symbols++;
#endif
				D_D(D, (send_name(xp), send_msg("\tsym sc: %s\n", psclass((NP)xp)), printnode(xp));)
				put_hlist(&symtab[h], xp);
#if BIP_CC
				if (G.ah_project_help)
					xref_new_ide(3, &identifiers, xp->name, G.inctab->p.fileno, xp->lineno, xref_scope(xp->sc));
#endif
			}
		}
	}
}

static bool equiv = false;				/* prototyping: only look at tptrs */

global bool equivalent(TP a, TP b)
{
	bool same;
	equiv = true;
	same = similar_type(0,1,a, b, 1);
	equiv = false;
	return same;
}

#if  C_DEBUG
long simcount = 0, hwcount = 0, swcount = 0;

void psimcounts(void)
{
	send_msg("sim_type counts: %ld\n", simcount);
	send_msg("         hw      %ld\n", hwcount);
	send_msg("         sw      %ld\n", swcount);
	simcount = 0, hwcount = 0, swcount = 0;
}

void spr(short which, short lvl, TP a, TP b)
{
	if (which eq 6)
	message("[%d,%d]%lx,%lx\t%s,%s", which, lvl,
				a,
				b,
				a->name ? a->name : "",
				b->name ? b->name : "" /* ,
				xref_file_by_number(auto_dependencies, a->fileno),
				xref_file_by_number(auto_dependencies, b->fileno) */
		    ),
	bios(2,2);
}
#endif

global bool similar_type(short lvl, short q, TP a, TP b, short proty)	/* prototyping; geheel herziene 'same_type' */
{
	/* prototyping: maak universeel */
	/* allways starts with ->type's if any */

	TP l = a, r = b;

	if (l ne r)		/* same h/w address is easy
	                   this happens most often when the types
	                   come from the same symbol table 
	                   or are basic :-) */
	{
		while (l and r)
		{
			short aggreg, pty;

			if (l->token ne r->token) 											return false;

			if (l->token ne ROW)			/* index sizes may differ */
				if (	l->size and r->size
				    and l->size ne  r->size )									return false;

			/* equal token pair at this point */
			aggreg = is_aggreg(l) ne 0, pty = is_code(l) ne 0;

			if (    (pty or aggreg)
			    and l->nflags.f.n_brkpr eq 0
			   )
				if (!similar_type(lvl+1, q, l->list, r->list, pty))				return false;

			/* names in func decls may differ so we dont look at them */
			/* aggreg tag_names may have been generated so ignore them to   */
			/* and if only equivalency is the question, well */
			if (l->token eq ID)
				if ( !(proty or equiv) )
					if (strcmp(l->name, r->name) ne 0)							return false;
#if 1
			if (q)			/* 11'09 HR: consider qualifiers */
			{
				/* only dismiss if left is less restrictive */
				if (    l->cflgs.f.qconst eq 0
				    and r->cflgs.f.qconst ne 0)									return false;

				if (    l->cflgs.f.qvolat eq 0
				    and r->cflgs.f.qvolat ne 0)									return false;
			}
#endif
			if (!aggreg)	/* geen taglists bekijken */
				if (!similar_type(lvl+1, q, l->next, r->next, proty))
																				return false;
			if (l eq l->type or r eq r->type)
				break;

			l = l->type;
			r = r->type;
		}

		if (l or r) 	/* lost synchronization */								return false;
	}

	return true;
}

global TP do_declare(TP head, short qualifiers, short forcast)
{
	TP rv = nil, e1;
	TP tail = nil, scan;

	D_1(D, "do_declare", head);

	scan = e1 = declarator();

	D_1(D, "rev_decl", e1);

	while (scan)
	{
		short q;
		TP nxt = scan->next;

		switch (scan->token)
		{
		case REFTO:
			q = scan->cflgs.i & (CONST|VOLAT);
			scan->cflgs.i &= ~(CONST|VOLAT);
			scan->cflgs.i |= qualifiers;
			qualifiers = q;
			name_to_str(scan, "ptr to");
			break;
		case K_PROC:
			name_to_str(scan, "func rtn");
			break;
		case ARRAY:
			name_to_str(scan, "array of");
			break;
		case K_CAST:
			name_to_str(scan, "cast to");
			break;
		case ID:
		case K_OP:
			break;
		default:
			errorn(e1, "bad type expression at %s", graphic[scan->token]);
			freeTn(scan);
			return nil;
		}

	/* transform declarer tree into type list */
		scan->next = nil;
		scan->type = rv;

		if (rv eq nil)
			tail = scan;

		rv = scan;
		scan = nxt;
	}
	/* if normal decl and see something, must see id first */
	/* if for func then id optional and if absent generated */
	/* if for cast then id forbidden */
	/* if normal   then id required  */

	if (!ok_revx(rv, forcast))
	{
		D_1(D, "!ok_revx", rv);
		freeTn(rv);
		return nil;
	}

	D_2(D, "exit rev_decl", rv, tail);

	if (rv)
	{
		tail->type = head;
		to_nct(tail);

		D_D(Q,console("QUAL %d, tail? %d\n", qualifiers, tail->token eq REFTO);)
		if (tail->token ne REFTO)
			tail->cflgs.i |= qualifiers;
		else
			rv->cflgs.i |= qualifiers;		/* otherwise we loose a const */
	othw
		if (forcast) 			/* 0 normal 1 cast 2 func */
			rv = head; 			/* cast or func */
	}

	D_1(D, "exit do_declare", rv);

	return rv;
}

static short storage_class(void)					/* was d_scl */
{
	short sc = 0;

	if (is_sclass(cur))
	{
		sc = cur->token;
		fadvnode();
	}
	return sc;
}

/* look for qualifiers 'const' or 'volatile'	*/
static short qualifier(void)
{
	if  (cur->token eq K_CONST)
		return fadvnode(), CONST;

	if (cur->token eq K_VOLAT)
		return fadvnode(), VOLAT;

/*	if (cur->token eq K_RESTRICT)
		return fadvnode(), RESTRICT;
*/
	return 0;
}


/* look for modifiers 'long', 'short', 'unsigned'
 * extra: 'signed' 'double'
 *        ('single' 'extended'; FOR_A)
 */
static short modifier(void)
{
	short adj = 0;

	if (   is_tadj(cur)
		or is_xadj(cur)
	   )				/* alg&ANSI; is_xadj  */
	{
		switch (cur->token)
		{
		case K_SHORT:
			adj = SAW_SHORT;
			break;
		case K_LONG:
			adj = SAW_LONG;
			break;
		case K_UNS:
			adj = SAW_UNS;
			break;
#if FOR_A
		case K_SINGLE:
			adj = SAW_SINGLE;
			break;
#endif
#if FLOAT
		case K_DOUBLE:
			adj = SAW_DOUBLE;
			break;
#endif
		case K_SIGNED:						/* ANSI */
			adj = SAW_SIGNED;
			break;
		}
		fadvnode();
	}

	return adj;
}

/* Decls inside Struct/Union */
static void su_decls(TP *listpp, short isstruct, long *sizep, string alnp)
{
	TP head = nil, xp;
	long size = 0;
	char aln = 0;
	short fldw = 0, fldoff = 0;
	bool iscomma, isends, declty;
	short noclass = -1, qualifiers;

	do
	{
		iscomma = 0;
		isends  = 0;

		head = declarer(false, &qualifiers, &noclass, &declty);

		do
		{
			xp = do_declare(head, qualifiers, 0);	 	/* 0: forcast param */
			opt_field(xp, &fldw, isstruct);
			if (ok_sux(xp, head))			/* ook sclass */
			{
				if (fldw > 0)
				{									/* handle field */
					su_field(xp, &size, &aln, fldw, &fldoff);
					xp->offset = size;
				othw								/* handle non-field */
					afterfld(&size, &fldoff);
					xp->offset = isstruct ? size : 0;
					su_size(&size, &aln, xp, isstruct);
				}
				list_sym(listpp, xp);
				listpp = &xp->next;
			othw
				if (fldw eq 0)
					afterfld(&size, &fldoff);
			}
			iscomma = cur->token eq COMMA;
			if (iscomma) fadvnode();
		}
		while (iscomma);

		isends = cur->token eq ENDS;
		if (isends) fadvnode();
	}
	while (isends);

	afterfld(&size, &fldoff);
	while (aln & size)
		size++;
	*sizep = size;
	*alnp  = aln;
}

/* Decls inside Enum */
static void en_decls(void)
{
	TP head, xp;
	long curval = 0;

	head = default_type(-1, 0);

	do
	{
		xp = do_declare(head, 0, 0);
		if (ok_enx(xp, head))
		{
			opt_enval(&curval);
			xp->offset = curval++;
			xp->sc = ENUM;
			xp->token = ICON;
			xp->type = basic_type(icon_ty((NP)xp));     /* final type */

			if (G.prtab->level)
				loc_sym(xp);
			else
				globl_sym(xp);
		}

		if (cur->token eq COMMA)
		{
			fadvnode();
			continue;
		}

		return;
	}
	od
}


static TP decl_enum(void)
{
	short stok;
	fadvnode();				/* skip 'enum' */

	if (cur->token eq ID)
	{						/* ignore tag */
		fadvnode();
	}

#if FOR_A
		stok = cur->token eq BLOCK ? KCOLB
				: (cur->token eq PAREN ? NERAP : 0 );
	if (stok eq KCOLB or stok eq NERAP)
#else
	stok = KCOLB;
	if (cur->token eq BLOCK)
#endif
	{						/* new declaration */
		fadvnode();			/* skip PAREN */
		en_decls();			/* global scope */
		eat(stok);
	}
	return default_type(-1, 0);
}

static TP alltags(TP np)
{
	SCP bp;
	TP rv = nil;

	for (bp = G.scope; bp ne nil; bp = bp->outer)
		if ((rv = tlook(bp->b_tags, np)) ne nil)
			break;

	if (!rv)
		rv = tlook(G.tagtab, np);

	if (rv)
	{
		free_name(np);
		np->name = rv->name;
	}
	return rv;
}

global TP all_syms(TP np, short usage)
{
	SCP bp;
	TP rv = nil;

	for (bp = G.scope; bp ne nil; bp = bp->outer)
		if ((rv = tlook(bp->b_syms, np)) ne nil)
		{
#if USAGE
			if (usage)		/* 12'08 HR usage tracking */
				if (usage eq FORSEE)
				{
					rv->tflgs.f.used = 1;
					if (rv->tflgs.f.isarg eq 0)		/* dont warn arguments */
						if (rv->tflgs.f.inid eq 0)
							warnn(np, "no assignment to");
				}
#endif
			break;
		}

	if (!rv)
		rv = tlook(symtab[hash(np->name)], np);

	if (rv)
	{
		free_name(np);
		np->name = rv->name;
	}
	return rv;
}

#if FOR_A
/* tag name space abolished, tags to the symbol tables as typedefs.
	Makes the following possible (as in C++):
	struct TAG (.....);				definition of struct

	struct TAG (... TAG *myself; ... );   selfref in struct
	...
	TAG a, b[e], c;			declarations of instances of struct
*/
static TP decl_su(short isstruct)
{
	TP rv = nil, kp, tagp;
	TP *attab;
	short stok;

	D_(D, "decl_su");

	fadvnode();		/* skip 'struct' or 'union' */

	if (G.for_A)
		attab = G.prtab->level ? &G.scope->b_syms : symtab;
	else
		attab = G.prtab->level ? &G.scope->b_tags : &G.tagtab;

	tagp = nil;
	if (cur->token eq ID)
		tagp = tpcur(), advnode();	/* hold on to ID node */

	stok = cur->token eq BLOCK ? KCOLB
			: (cur->token eq PAREN ? NERAP : 0 );
	if (stok eq KCOLB or stok eq NERAP)
	{							/* new declaration */
		if (tagp eq nil)
		{
			tagp = allocTn(1);
			tagp->token = ID;
			new_name(tagp, "__%d", new_lbl());
		}
		fadvnode();

	/* Because the symtab uses next for chaining,
		we must make a extra node for the symbol table entry.
		 It happens to be of convenience to make this a K_TYPE node.
		  See 'derived_type()', which need not be changed.
	*/
		kp = copyTone(tagp);
		kp->token = ID;
		kp->sc = K_TYPE;
		kp->type = tagp;

		if (attab eq symtab)
		{
			if ((rv = tlook(symtab[hash(kp->name)], kp)) ne nil )
			{
				freeTn(kp);
				rv = rv->type;
				if (rv->list)
				{
					errorn(rv, "redefinition of %s", graphic[rv->token]);
					freeTn(rv->list);
					rv->list = nil;
				}
			othw					/* new defn */
				rv = tagp;
				to_type(rv, su_par[isstruct]);
				globl_sym(kp);
			}
		othw
			if ((rv = tlook(*attab, kp)) ne nil )
			{
				freeTn(kp);
				rv = rv->type;
				if (rv->list)
				{
					errorn(rv, "redefinition of %s", graphic[rv->token]);
					freeTn(rv->list);
					rv->list = nil;
				}
			othw					/* new defn */
				rv = tagp;
				to_type(rv, su_par[isstruct]);
				put_lifo(attab, kp);
			}
		}
		su_decls(&rv->list, isstruct,
				&rv->size, &rv->aln);
		eat(stok);
	othw						/* reference to allready defined */
		if ( tagp eq nil )
			error("nonsense %s", graphic[isstruct ? K_STRUCT : K_UNION]);
		else
		{
			kp = copyTone(tagp);
			kp->token = ID;
			kp->sc = K_TYPE;
			kp->type = tagp;

			if (attab eq symtab)
			{
				rv = tlook(symtab[hash(kp->name)], kp);
				if (rv eq nil)
				{						/* delayed tag */
					rv = tagp;
					to_type(rv, su_par[isstruct]);
					globl_sym(kp);
				othw
					rv = rv->type;
					freeTn(kp);
				}
			othw
				/* ANSI special decl
					struct <tag> ;
				   for hiding old tag within block */
				if (cur->token eq ENDS and G.prtab->level)
					rv = tlook(*attab, kp);
				else
					rv = alltags(kp);
				if (rv eq nil)
				{						/* delayed tag */
					rv = tagp;
					to_type(rv, su_par[isstruct]);
					put_lifo(attab, kp);
				othw
					rv = rv->type;
					freeTn(kp);
				}
			}
		}
	}
	return rv;	/* the type itself */
}
#else
static TP decl_su(short isstruct)
{
	TP rv = nil, tagp;
	TP *attab;

	D_(D, "decl_su");

	fadvnode();		/* skip 'struct' or 'union' */

	attab = G.prtab->level ? &G.scope->b_tags : &G.tagtab;
	tagp = nil;
	if (cur->token eq ID)
		tagp = tpcur(), advnode();	/* hold on to ID node */

	if (cur->token eq BLOCK)
	{							/* new declaration */
		if (tagp eq nil)
		{
			tagp = allocTn(1);
	/* Using line nr in dummy names is not a good idee,
	 * U can have any number of structs without tagname in 1 line.
	 */		tagp->token = ID;
			new_name(tagp, "__%d", new_lbl());
		}
		fadvnode();				/* skip left delimiter */
		if ((rv = tlook(*attab, tagp)) ne nil )
		{
			freeTn(tagp);
			if (rv->list)
			{
				errorn(rv, "redefinition of %s", graphic[rv->token]);
				freeTn(rv->list);
				rv->list = nil;
			}
		othw					/* new defn */
			rv = tagp;
			to_type(rv, su_par[isstruct]);
			put_lifo(attab, rv);
		}
		su_decls(&rv->list, isstruct,
				&rv->size, &rv->aln);
		eat(KCOLB);
	othw						/* reference to allready defined */
		if ( tagp eq nil )
			error("nonsense %s", graphic[isstruct ? K_STRUCT : K_UNION]);
		else
		{
			/* ANSI special decl
				struct <tag> ;
			   for hiding old tag within block */
			if (cur->token eq ENDS and G.prtab->level)
				rv = tlook(*attab, tagp);
			else
				rv = alltags(tagp);
			if (rv eq nil)
			{						/* delayed tag */
				rv = tagp;
				to_type(rv, su_par[isstruct]);
				put_lifo(attab, rv);
			} else
				freeTn(tagp);
		}
	}
	return rv;
}
#endif

static TP derived_type(bool *ty)
/* look for derived types */
{
	TP rv;
	short is_lbl(char *);

	*ty = false;

	if (cur->token eq ID)
	{
		rv = all_syms((TP)cur, 0);
		if (rv eq nil)
			return nil;
		if (rv->sc eq K_TYPE)
		{
			fadvnode();

			if (is_lbl(rv->type->name) > 0)		/* 11'09 HR: borrowed from OPT.C :-) */
				new_name(rv->type, "type %s", rv->name);	/* for display in messages */

			return rv->type;
		}
		else
			return nil;			/* !!! */
	}
	if (cur->token eq K_UNION)
	{
		*ty = true;
		return decl_su(0);
	}
	if (cur->token eq K_STRUCT)
	{
		*ty = true;
		return decl_su(1);
	}
	if (cur->token eq K_ENUM)
	{
		*ty = true;
		return decl_enum();
	}
	return nil;
}

#if FOR_A
/*
 * Looking for type makers [], ref, deref
 */

global TP type_maker(bool loc, short *qualifiers, short *sclass, bool *declty)
{
	TP rv;
	NP e1;

	switch (cur->token)
	{
		case ARRAY:
			rv = tpcur(); advnode();
			e1 = questx();
			eat(YARRA);
			name_to_str(rv, "row_of");
			rv->type = declarer(loc, qualifiers, sclass, declty);
			rv->list = (TP)e1;			/* will disappear after confold_value() */
			return rv;
		case K_REF:
			rv = tpcur(), advnode();
			to_type(rv, REFTO);
			rv->type = declarer(loc, qualifiers, sclass, declty);
			return rv;
		case K_DEREF:
			rv = tpcur(), advnode();
			to_type(rv, REFTO);
			rv->tflgs.f.derefto = 1;
			rv->type = declarer(loc, qualifiers, sclass, declty);
			return rv;
	}

	return nil;
}
#endif

static
short t_to_k[] =
{
	K_BOOL,
	K_CHAR,
	T_UCHAR,
	K_SHORT,
	T_USHORT,
	K_INT,
	K_UNS,
	K_LONG,
	T_ULONG,
#if LONGLONG
	T_LLONG,
#endif
	REFTO,
#if FLOAT
	K_FLOAT,
	K_REAL,
	K_COMPL,
#endif
	K_VARGL,
	K_VOID,
	T_NTY
};

/*
 * Looking for declaration specifiers & modifuers
 */
/* prototyping & ANSI;
   nogal gewijzigd:	nu geheel volgens K&R alle edities
   N.B. *sclass contains default storage class; negative means not allowed.
*/
global TP declarer(bool loc, short *qualifiers, short *sclass, bool *declty)
{
	short see, seen,
		b = 0,
		sc = 0,
		adj = 0,
		qual = 0;

#if LONGLONG
	short longs = 0;			/* count them; 2 are allowed */
#else
	short longs = 0;			/* count them; only 1 is allowed */
#endif

	TP rv = nil;

	*declty = false;		/* declty false: declarator required; true not */

#if FOR_A
	if (G.for_A)
	{
		rv = type_maker(loc, qualifiers, sclass, declty);
		if (rv)
			return rv;
	}
#endif

	do
	{
		seen = 0;

		if (*sclass >= 0)				/* sc allowed */
			if (!sc)					/* look for storage class only once */
				if ( (sc = storage_class()) ne 0)
					seen |= (see = *sclass = sc);

		qual |= (see = qualifier());	/* look for qualifiers */
		seen |= see;
		see = modifier();		/* look for modifiers  */

#if LONGLONG
		if (see eq SAW_LONG)
		{
			longs++;
			if (longs eq 2)
			{
				if (G.i2_68020)
					see = SAW_2LONG;
				else
					error("long long only available with option -2");
			}
		}
#else
		if (see eq SAW_LONG)
		{
			longs++;
			if (longs eq 2)
				error("long long not available yet");
		}
#endif

		adj |= see;
		seen |= see;

		if (!rv)						/* look for types only once */
		{
			if ( (see = is_plain(cur)) ne 0)
			{							/* look for 'char', 'int', 'float', 'real', 'void' '...' */
				b = cur->token;
				rv = basic_type(modify_type(b, 0));
				fadvnode();
			othw
				rv = derived_type(declty);	/* look for 'struct', 'union', 'enum' or typedef names */
				see = rv ne 0;				/* enum returns default_type(-1, 0) in rv */
				if (see and rv->nflags.f.bas)
					b = t_to_k[rv->token - FIRST_BAS];	/* now we kan allow long or short enum's (see also 'switch') */
														/* or modified 'typedef'd' basic types */
			}
			seen |= see;
		}
	}	while (seen);

	if (adj eq 0 and rv eq nil)				/* saw nothing  */
		rv = default_type(*sclass, qual);
	elif (!rv)								/* didnt see a type */
#if FLOAT
		if (adj & (SAW_SINGLE|SAW_DOUBLE) )
			b = K_FLOAT;
		else
#endif
			b = K_INT;

	if (b or adj)
		b = modify_type(b, adj);
#if FLOAT
	elif (adj eq 0 and !G.use_FPU and b eq T_REAL)	/* 'real' only, no 'double|extended' */
		b = T_FLOAT;
#endif

	if (b)
		rv = basic_type(b);

	/*  ANSI: The problem with qualification is:
		syntacticly it belongs to the type, so thats the easiest way to
		handle it. Especially in this implementation.
		But it is really a property of the object.
		Basically the 2 are unrelated.
		type specifies format, qualifier specifies usage of declared object;
		The way qualifiers are defined in C is a real nuisance, not only
		for the user of C, but also for the compiler writer.
		Generally this the case for C decalaration syntax.
		K&R tried to combine 2 worlds that are profoundly different.

		In Algol 68 e.g. the way an object is initialized determines whether
		the object is constant.  'int a := 1' vs 'int a = 1'
		In C you can have uninitialized constant objects.		Hmmm.
	*/

	if (qualifiers)
		*qualifiers = qual;

	D_1(D, "declarer", rv);
	return rv;
}

/* do local decls
	return true if see something
*/
global bool loc_decls(void)			/* called from body.c */
{
	TP head, xp;
	short sclass, qualifiers;
	bool rv = 0, iscomma, declty;

	D_(D, "loc_decls");

	while (is_ty_start())
	{
		sclass = 0;		/* prototyping; defaults ---> regvar_options() */
						/* zie ook C_args en Algol_args */
		rv |= true;

		/* ANSI: sclass --> declarer (K&R all editions) */
		head = declarer(true, &qualifiers, &sclass, &declty);
		ok_lsh(sclass, head);
		do
		{
			iscomma = 0;
			xp = do_declare(head, qualifiers, 0);
			if (ok_lx(xp, head))
			{
				TP tp = xp->type;
				xp->sc = sclass;

				if (is_code(tp))
				{
					/* hier de plaats om locale procs toe te laten */
					if (tp->tflgs.f.ans_args)
					{
#if FOR_A
						if (!(cur->token eq COMMA or cur->token eq ENDS))
							tp->cflgs.f.cdec = 1, loc_proc(xp, L_PROC);
						else
#endif
						{
							if (xp->sc ne K_TYPE)	/* local typedef proc's */
								xp->sc = PROT;
							loc_sym(xp);
						}
					othw
						if (tp->list)		/* old args with decls */
							warnn(xp, "current C does not support local procedures");
						loc_sym(xp);
					}
				othw
					NP ap = nil;
#if FOR_A
					long slocs = G.scope->b_locs,
						 ssize = G.scope->b_size;
					ALREG sregs = G.scope->b_regs;
#endif

					new_gp(nil, LINIT);

					regvar_options(xp, sclass);

					if (xp->token eq ID)
					{
						if (xp->sc eq K_STATIC)
						{
							if (static_init(xp))
							{
								next_gp(add_tseg());
								G.scope->b_locs +=
									loc_size(gp, xp, &G.scope->b_size,
												     &G.scope->b_regs );
							}
							loc_sym(xp);
						}
						elif (      (   xp->sc eq K_AUTO
							         or xp->sc eq K_REG
							    	)
							    and (   cur->token eq ASSIGNMT
#if FOR_A
							    	 or (    cur->token eq IS_DEF_AS
							    	 	 and G.for_A )
#endif
							    	 )
							 )
						{
/* A lot of rearrangement for local aggragate initialization
 ( Also to make the difference possible between ':=' vs '=' as in Algol 68) */
							short context = tp->token eq ROW	? FORLAINIT
																: FORLINIT;
#if FOR_A
							if (cur->token eq IS_DEF_AS)
								xp->cflgs.f.qconst = 1,
								cur->token = ASSIGNMT;
#endif

							ap = npcur(); advnode();

							if (    (   is_aggreg(xp->type)
							         or xp->type->token eq ROW
								    )
								and (   cur->token eq BLOCK
								     or is_scon(cur)
								    )
							   )
								auto_init(xp, ap, a_init(xp), context);		/* put initializer aside as static */
							else
							{
								auto_init(xp, ap, assignx(), context);		/* scalar */
#if FOR_A
								if (ap->cflgs.f.qconst)		/* only if NO code needed */
								{
									G.scope->b_locs = slocs;		/* correction */
						 			G.scope->b_size = ssize;
									G.scope->b_regs = sregs;
									xp->token = ap->token;			/* adopt con */
									xp->size  = ap->size;
									xp->offset  = ap->val.i;
									freenode(gpbase);
									gpbase = nil;
								}
								else
#endif
									if (G.prtab->level > 1)			/* not args */
										loc_advice(xp, gpbase);
							}
						othw
							warn_const(xp);
							if (G.prtab->level > 1)		/* not args */
							{
								G.scope->b_locs +=
									loc_size(gpbase, xp, &G.scope->b_size,
											    	     &G.scope->b_regs );
								loc_advice(xp, gpbase);
							}
							loc_sym(xp);
						}
					}
					out_gp();
				}
			}

			iscomma = cur->token eq COMMA;
			if (iscomma) fadvnode();
		} while (iscomma);
		eat(ENDS);
	}

	while (STACKALN & G.scope->b_size)	/* ATARI ST/TT until even */
		G.scope->b_size++;
	return rv;
}

global bool is_ty_start(void)		/* tbv loc_decls() and casts */
{
	TP rv;

	if (is_tykw(cur))
		return true;

#if FOR_A
	if (G.for_A and cur->token eq ARRAY)
		return true;
#endif

	if (cur->token eq ID)
	{
		rv = all_syms((TP)cur, 0);
		if (rv)
		{
			if (rv->sc eq K_TYPE)
				return true;
#if FOR_A
			if (    G.for_A
				and	(   rv->token eq K_STRUCT
					 or rv->token eq K_UNION )
				)
				return true;
#endif
		}
	}

	G.prtab->insc = 0;			/* no more inits */
	return false;
}

/*	prototyping: geheel herschreven ty_args
 *	C gebruikt Algol68 type declarations.
 *	Maar een C prototype(ANSI weer) heeft een andere syntax.
 *	(een list van casts gescheiden door comma's)
 *
 *	ANSI is altijd goed geweest in het verminderen van orthogonaliteit.
 */
static TP C_args(TP np)
{
	TP *listpp, head, xp;
	short parnr, sclass, qualifiers;
	bool iscomma, isvargl, declty;

	parnr = 1;

	np->tflgs.f.ans_args = 1;
	np->size = 0;
	np->aln  = 0;

	listpp = &np->list;

	do
	{
		iscomma = 0;
		isvargl = 0;

		sclass = 0;
		head = declarer(false, &qualifiers, &sclass, &declty);	/* sclass --> declarer (K&R all editions) */
		if ( ok_prh(sclass, head) eq 0)
			sclass = 0;

		xp = do_declare(head, qualifiers, 2);			/* 2: for func */
		xp = dummy_id(xp, head, parnr);

		if ( ok_prx(xp, head) )
		{
			xp->tflgs.f.isarg = 1;
			regvar_options(xp, sclass);
			arg_size(&np->size, xp);
			list_sym(listpp, xp);
			listpp = &xp->next;
			isvargl = xp->type->token eq T_VARGL;
			parnr++;
		}

		iscomma = cur->token eq COMMA;
		if (iscomma)
			fadvnode();
		if (isvargl)
			break;
	}
	while (iscomma);

	while (STACKALN & np->size)
		np->size++;

	return np->list;				/* for orthogonality in ty_follow */
}

#if FOR_A
/* zoals het door ANSI eigenlijk voorgeschreven had moeten worden */
/* This is a restricted form of struct declaration */
/* For Algol 68 fans: the stuff between the () of a call is a structure display */
static void Algol_args(TP *listpp,long *sizep)
{
	TP head, xp;
	short parnr, sclass, qualifiers;
	bool iscomma, isends, isvargl, declty;

	*sizep = 0;
	parnr = 1;

	do
	{
		iscomma = 0;
		isends  = 0;
		sclass = 0;

		head = declarer(false, &qualifiers, &sclass, &declty);		/* sclass --> declarer (K&R all editions) */
		if ( ok_prh (sclass, head) eq 0 )
			sclass = 0;
		do
		{
			xp = do_declare(head, qualifiers, 2);	 	/* 2 for proc param ID not required */
			xp = dummy_id(xp, head, parnr);
			if (ok_prx(xp, head))
			{
				xp->tflgs.f.isarg = 1;
				regvar_options(xp, sclass);
				arg_size(sizep, xp);
				list_sym(listpp, xp);
				listpp = &xp->next;
				isvargl = xp->type->token eq T_VARGL;
				parnr++;
			}

			iscomma = cur->token eq COMMA;
			if (iscomma) fadvnode();
			if (isvargl) break;
		}
		while (iscomma);

		isends = cur->token eq ENDS;
		if (isends) fadvnode();
		if (isvargl) break;
	}
	while (isends);

	while (STACKALN & *sizep)
		*sizep += 1;
	return;
}
#endif

static TP opt_id(void)
{
	TP rv;

	if (cur->token eq ID)
	{
		rv = tpcur(); advnode();
		return rv;
	}
	else
		return nil;
}

/* called for args of function declaration or nil */
static TP ty_args(void)
{
	TP rv, tail, new;

	rv = opt_id();
	if (rv eq nil)
		return nil;
	tail = rv;
	do
	{
		if (cur->token ne COMMA)
			return rv;
		fadvnode();
		new = opt_id();
		if (new eq nil)
		{
			errorn(cur, "expect ID; got");
			return rv;
		}
		tail->next = new;
		tail = new;
	}od
}

/* restricted version of opt_follow for 'declarator' */
/* allow null [] */
static TP ty_follow(TP np)
{
	TP tp;

#if FOR_A
	if (!G.for_A)		/* [], ref & deref are 'type_makers' */
#endif
	if (cur->token eq ARRAY)
	{
		NP e1; TP fol;
		tp = tpcur(); advnode();
		e1 = questx();
		eat(YARRA);
		tp->next = np;
		tp->list = (TP)e1;			/* will disappear after confold_value() */
		fol = ty_follow(tp);
		return fol;
	}

	if (cur->token eq PAREN)		/* arglist or ANSI prototype or func decleration */
	{
		TP e1;
		tp = tpcur(); advnode();
#if 0	/* Probably not a good idee, but I couldnt resist writing it down :-) */
		if (cur->token eq NERAP)	/* declaration of 'fun()' becomes 'fun(void)' */
		{
			TP head = basic_type(T_VOID);
			e1 = dummy_id(head, head, 1);
		}
		else
#endif
		if (is_ty_start())
			e1 = C_args(tp);		/* allow C_args of func to follow */
		else
		{
			e1 = ty_args();			/* old args */
			tp->tflgs.f.old_args = 1;
		}
		eat(NERAP);
		tp->next = np;
		tp->list = e1;
		to_type(tp, K_PROC);		/* PAREN --> K_PROC */
		return ty_follow(tp);
	}

	return np;
}

/* restricted version of primary for "declarator" */
static TP ty_primary(void)
{
	TP e1;
	D_1(D, "primary", cur);
	if (cur->token eq ID)
		e1 = tpcur(), advnode();
	elif(cur->token eq PAREN)
	{
		fadvnode();
		e1 = declarator();
		eat(NERAP);
	}
	else
		e1 = nil;

	return ty_follow(e1);
}

#if FOR_A
static TP decl_proc(void)
{
	TP rv;

	D_(D, "decl_proc");

	rv = tpcur(); advnode();	/* 'proc'. N.B. C args met function C_args */

	rv->tflgs.f.ans_args = 1;

	if (cur->token eq PAREN)
	{
		fadvnode();				/* skip PAREN */

		Algol_args(&rv->list, &rv->size);
		eat(NERAP);
	}
	return rv;
}
#endif

static TP decl_op(void)
{
	TP rv, cp;
	short n = 0, narg = 0;

	D_(D, "decl_op");

	rv = tpcur(); advnode();		/* 'op' */

	if (cur->cflgs.f.prec)
		n = 2;					/* is binary op */
	if (is_unop(cur->token))
		n += 1;					/* can be unary op */
	if (!n)
		errorn(cur, "expect unary or binary operator; got");

	rv->offset = cur->token;	/* for later use */
	fadvnode();

	if (cur->token eq PAREN)
	{
		fadvnode();				/* skip PAREN */

		rv->list = C_args(rv);
		eat(NERAP);
	}

	if (n)
	{
		cp = rv->list;
		if (cp)
			narg++;
		while(cp->next) narg++, cp = cp->next;

		if (n eq 3)				/* binary that can be unary */
		{
			if (narg eq 0)
			{
				error("'operator' must have at least 1 arg");
				freeTn(rv);
				rv = nil;
			othw
				if (narg > 2)
				{
					error("'operator' cannot have > 2 args");
					freeTn(rv->list->next->next);
					rv->list->next->next = nil;
				}
			}
		othw			/* have either 1 or 2 args */
			if (n ne narg)
			{
				error("wrong number of arguments");
				freeTn(rv);
				rv = nil;
			}
		}
	}
	if (rv)
		name_to_str(rv, graphic[rv->offset]);		/* for oplook */

	return rv;
}

static TP decl_cast(void)
{
	TP rv, cp;
	short n = 0;

	D_(D, "decl_cast");

	rv = tpcur(); advnode();		/* 'cast' */

	if (cur->token eq PAREN)
	{
		fadvnode();				/* skip PAREN */

		rv->list = C_args(rv);
		eat(NERAP);
	}
	cp = rv->list;
	if (cp)
		n++;
	while(cp->next) n++, cp = cp->next;

	if (rv->token eq K_CAST and n ne 1)
	{
		error("'unary cast' must have 1 arg");
		freeTn(rv);
	}

	return rv;
}

static void warn_func_modifier(TP e1, short k)
{
	char *s = *graphic[K_PROC] ? graphic[K_PROC] : "function";
	if (e1)
		warnn(e1, "%s on non-%s", graphic[k], s);
	else
		warn("%s on non-%s", graphic[k], s);
}

static NP check_syscall(NP np)
{
	NP e1 = np;
	if (np)
	{
		form_types(np, FORSIDE, 0);		/* constant & enum folding */
		if (np->token eq ICON)			/* (n) */
			if (np->val.i < 0 or np->val.i > 15)
				e1 = nil;
			else
				return e1;
		elif (np->token ne COMMA)			/* (n,m) */
			e1 = nil;
		elif (np->left->token ne ICON or np->right->token ne ICON)
			e1 = nil;
		elif (np->left->val.i < 0 or np->left->val.i > 15)
			e1 = nil;
	}

	if (e1 eq nil)
	{
		error("invalid %s", graphic[K_SYSC]);
		freenode(np);
	}
	return e1;
}

/* restricted version of unary for declarations or coercions */
/* allows nil primary part */
static TP declarator(void)
{
	TP tp, e1, kp;
	NP e2;

	D_1(D, "declarator", cur);

#if FOR_A
	if (! G.for_A)
#endif
	switch (cur->token)
	{
	case DECLREF:						/* token for pointer in declarations */
		tp = tpcur(); advnode();
		to_type(tp, REFTO);
		tp->cflgs.i = qualifier();
		tp->next = declarator();
		return tp;

	case DECLDEREF:
		tp = tpcur(); advnode();
		to_type(tp, REFTO);
		tp->cflgs.i = qualifier();
		tp->tflgs.f.derefto = 1;			/* used by see_id */
		tp->next = declarator();
		return tp;
	}

	switch (cur->token)
	{
#if FOR_A
	case K_PROC:				/* 'proc' */
		e1 = decl_proc();
		e1->next = declarator();
	/* haakjes om de *fun hoeven nu niet meer.
	 * VB: 'char *  proc (int) *name;'
	 * ipv 'char *(*name)(int);'
	 * Dat is oa het voordeel van zo'n 'proc'
	 * Ook hoef je een proc zonder parameters nu niet meer te
	 * declareren als 'name(void)' maar simpel als 'proc name';
	 * geen tussenhaakjesvoid dus.
	 */
	 	return e1;
#endif

	case K_OP:
		e1 = decl_op();
		e1->next = declarator();
		return e1;
	case K_CAST:
		e1 = decl_cast();
		e1->next = declarator();
		return e1;
	case PAREN:					/* The (*fun)() is a pain in the ass */
	{
		bool is_cdecl = false;
		tp = tpcur(); advnode();
		if (cur->token eq K_CDECL)
		{
			is_cdecl = true;
			fadvnode();
		}
		e1 = declarator();
		eat(NERAP);
		if (e1 eq nil)			/* *) special: 'fun of' (*fun)(args) */
			/* left and right already nil */
			e1 = ty_follow(tp);
		else
		{
			freeTunit(tp);
			e1 = ty_follow(e1);
		}
		if (is_cdecl)
		{
			kp = yields_ty(e1, K_PROC);
			if (kp)
				kp->cflgs.f.cdec = 1;
			else
				warn_func_modifier(e1, K_CDECL);
		}
		return e1;
	}
	case K_CDECL:
		fadvnode();
		e1 = declarator();
		kp = yields_ty(e1, K_PROC);
		if (kp)
			kp->cflgs.f.cdec = 1;
		else
			warn_func_modifier(e1, K_CDECL);
		return e1;
	case K_PAS:
		fadvnode();
		e1 = declarator();
		kp = yields_ty(e1, K_PROC);
		if (!kp)
			warn_func_modifier(e1, K_PAS);
		return e1;
#if BIP_ASM
	case K_ASM:
		fadvnode();
		e1 = declarator();
		kp = yields_ty(e1, K_PROC);
		if (kp)
			kp->cflgs.f.asmfunc = 1;
		else
			warn_func_modifier(e1, K_ASM);
		return e1;
#endif
	case K_SYSC:				/* __syscall__ (currentlly used for generating trap instruction) */
		fadvnode();
		e2 = get_expr();
		e2 = check_syscall(e2);
		e1 = declarator();
		if (e1 eq nil or (e1 and e1->token ne K_PROC))
			warn_func_modifier(e1, K_SYSC);
		elif (e2)
		{
			if (e2->token eq ICON)
				e1->fld.offset = e2->val.i,
				e1->lbl  = -1;
			else
				e1->fld.offset = e2->left ->val.i,
				e1->lbl  = e2->right->val.i;
		}

		if (e2)
			freenode(e2);

		return e1;
	default:
		return ty_primary();
	}
}
