/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Johann Ruegg
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *  Macros to forge together the various attributes of things.
 *		Ruled by defining context.
 *
 *		DEFS.H
 *
 */

#undef FLAG
#undef DTOK
#undef KW
#undef KWS
#undef OP
#undef OPS

#if DEF_ENUM					/* context */
	#define FLAG(e, p)			e=p,		/* for enums */
	#define DTOK(e)				e,
	#define OP(g,f,c,p,e,x)		e,
	#define OPS(g,e)
	#define KW(g,f,c,e,x)		e,
	#define KWS(g,e)
#elif DEF_LEX							/* for lex table */
	#define FLAG(e,p)					/* (the currently chosen actual graphic */
	#define DTOK(e)						/*	representation of tokens) */
	#define OP(g,f,c,p,e,x)		{g,e},
	#define OPS(g,e)			{g,e},
	#define KW(g,f,c,e,x)		{g,e},
	#define KWS(g,e)			{g,e},
#elif DEF_DIAG
	#define FLAG(e,p)			#e,			/* for diagnostic printing */
	#define DTOK(e)				#e,
	#define OP(g,f,c,p,e,x)		#e,
	#define OPS(g,e)
	#define KW(g,f,c,e,x)		#e,
	#define KWS(g,e)
#elif DEF_TAB								/* for tok info table */
	#define FLAG(e,p)
	#define DTOK(e)
	#define OP(g,f,c,p,e,x)		{0,f,(ulong)c,p,e,x},
	#define OPS(g,e)
	#define KW(g,f,c,e,x)		{0,f|KWD,(ulong)c,0,e,x},
	#define KWS(g,e)
#endif

/* You see ?  ... synonyms are only in the LEX table.
			The cross indexes are found in tok.c */



#if ALL_FLAGS || DEF_K_FLAGS
/*		keyword catagories */
	L_FLAGS(AGGREG,SCLASS,TYP_MOD,EXT_MOD,LEAF,PLAIN,BASIC,DECL,BRANCH_STMT,BLOCK_STMT,LABEL_STMT,CODE,OPAT,STMT_END,ASM,ASMREG,
	        LOOP_STMT,C17,C18,C19,C20,C21,C22,C23,C24,C25,C26,C27,C28,C29,C30,C31)
#endif

#if ALL_FLAGS or DEF_TOK_FLAGS
/* token flags	*/

	W_FLAGS(RLOP,UNOP,C_NA,C_A,COMPARE,ASOP,KWD,SPCL,
	        O8,O9,O10,O11,O12,O13,O14,O15)

/*		RLOP			unary floating point operator that can be a function if not hardware
		ASOP			is assign operator
		UNOP			is, or can be unary op
		SPCL			special token beginner
		C_NA			commutative but not associative
		C_A 			commutative and associative
*/
#endif

/* NB!!!! These values MUST corresponf to the position of the flags in CFLAGS */

#if ALL_FLAGS or DEF_X_FLAGS
/* eval flags derived from context */

	B_FLAGS(NOVAL_OK,CC_OK,IMMA_OK,C3,C4,C5,C6,C7)

/*		NOVAL_OK,	/* value is optional */
		CC_OK,		/* just setting cond. codes okay */
		IMMA_OK,	/* immediate OREG is okay */
*/
#endif


/*
 *	defines of allowed operands
 *	'E' means Dreg or OREG or ONAME or (if on left) IMMediate
 *	'Q' means ICON which is 1 to 8
 *	ONE means ICON which is 1
 */
#if ALL_FLAGS or DEF_D_FLAGS
	#if LONGFLAGS
		L_FLAGS(DopD,AopD,MopD,IopD,
				Df4,Df5,Df6,Df7,
		        DopA,AopA,MopA,IopA,
		        Df12,Df13,Df14,Df15,
		        DopM,AopM,MopM,IopM,
		        Df20,Df21,Df22,Df23,
		        QopD,ONEopM,Df26,Df27,
		        ASSOC,REAL,COLD,Df31
		       )
	#else
		W_FLAGS(DopD,AopD,MopD,IopD,
		        DopA,AopA,MopA,IopA,
		        DopM,AopM,MopM,IopM,
		        QopD,ONEopM,ASSOC,REAL)
	#endif
#endif

/*	operand classes */
#if ALL_FLAGS or DEF_A_FLAGS
	#if COLDFIRE
		W_FLAGS(CL_DREG,CL_AREG,CL_ADR,CL_IMM,CL_ABS,Af5,Af6,Af7,
		        RETAREG,RETDREG,RETLEFT,RETRIGHT,Af12,Af13,Af14,Af15)
	#else
		W_FLAGS(CL_DREG,CL_AREG,CL_ADR,CL_IMM,Af4,Af5,Af6,Af7,
		        RETAREG,RETDREG,RETLEFT,RETRIGHT,Af12,Af13,Af14,Af15)
	#endif
#endif

#if ALL_FLAGS or DEF_M_FLAGS
/* modifier seen flags */

	B_FLAGS(
		SAW_SHORT,
		SAW_LONG,
		SAW_2LONG,
		SAW_UNS,
		SAW_SINGLE,
		SAW_DOUBLE,
		SAW_SIGNED,
		SAW_CONST
/*		SAW_VOLAT */
	)
#endif

#if ALL_FLAGS or DEF_R_FLAGS
/* operation flags */
	W_FLAGS(LISTMP,RISTMP,NDASSOC,CANRL,CANLR,CANRD,CANDL,CANLD,CANDD,CANDR,CANIM,LISREGVAR,CANTM,Rf13,Rf14,Rf15)
#endif


#if DEF_TOKS
	#if DEF_ENUM
		RESETTOK = -1,
	#endif

	DTOK(BADTOK)		/* MUST be first!! */

/* branch types
	EQUALS,			here are the C tokens, so you can check the correct order of B_.. tokens below
	NOTEQ,
	LESS,
	GTEQ,
	LTEQ,
	GREATER,
   designed so that pairs (i,i+1) with odd i represent opposites */

	DTOK(B_EQ)			/* MUST follow BADTOK */
	DTOK(B_NE)
	DTOK(B_LT)
	DTOK(B_GE)
	DTOK(B_LE)
	DTOK(B_GT)
	DTOK(B_YES)
	DTOK(B_NO)
	DTOK(B_ULT)
	DTOK(B_UGE)
	DTOK(B_ULE)
	DTOK(B_UGT)

	DTOK(ERRNODE)

/*  used for storage class in nodes (not in DECL.C, no category);
	must produce positive char value */
	DTOK (PROT)
	DTOK (PROT_USED)
	DTOK (ENUM)

	/* reserved words and operaters */
	/* only grouped by 1st character and then sorted;
		(\0 is higher than everything else) */
	/*  for the sake of the #param usage put the , immediate before and after the param that is to be #'d;
		Pure C should remove trailing and leading white space, but it does not do so. */

	OP ("{",	0,				0,		0,BLOCK,	0)	/* MUST be first */
	OP ("}",	0,				0,		0,KCOLB,	0)
	OP ("[",	0,				0,		0,ARRAY,	0)
	OP ("]",	0,				0,		0,YARRA,	0)
	OP ("(",	0,				0,		0,PAREN,	0)
	OP (")",	0,				0,		0,NERAP,	0)
	OP ("####",	0,				0,		0,END_MAC,	0)
	OP ("##",	0,				0,		0,PARCAT,	0)
	OP ("#",	0,				0,		0,PREP,		0)
	OP ("\\",	0,				0,		0,BSLASH,	0)
	OP (";",	0,				0,		0,ENDS,		0)
	OP (",",	0,				0,		0,COMMA,	0)

#if FOR_A
	OP (":=",	0,				0,	  ASP,ASSIGNMT,	0)
#else
	OP (":=",	0,				0,	  ASP,BECOMES,	0)
#endif

	OP (":",	0,				0, 		0,X_ELSE,	0)

	KW ("...",	0, DECL|BASIC|PLAIN	 	,K_VARGL,	0)
	OP (".",	0,				0,		0,SELECT,	0)

#if BIP_ASM
	OP ("@",	0,				0,		0,ASM_SELECT,0)
#endif

	OP ("\"",	SPCL,			0,		0,QUOTE,	0)
	OP ("'",	SPCL,			0,		0,APOS,		0)

	OP ("==",	C_NA|COMPARE,	0,		7,EQUALS,	B_EQ)

#if FOR_A
	OP ("=",	0,				0,	  ASP,IS_DEF_AS,0)
#else
	OP ("=",	0,				0,	  ASP,ASSIGNMT,	0)
#endif

	OP ("++",	UNOP,			0,		0,INCR,		0)
	OP ("+=",	ASOP,			0,	   +1,ASPLUS,	0)
	OP ("+",	UNOP|C_A,		0,		4,PLUS,		UPLUS)

	OP ("-=",	ASOP,			0,	   +3,ASMINUS,	0)
	OP ("--",	UNOP,			0,		0,DECR,		0)
	OP ("->",	0,				0,		0,ARROW,	0)
	OP ("-",	UNOP,			0,		4,MINUS,	NEGATE)

	OP ("*=",	ASOP,			0,	   +1,ASTIMES,	0)
	OP ("*",	UNOP|C_A,		0,		2,TIMES,	DEREF)

	OP ("%=",	ASOP,			0,	   +1,ASMOD,	0)
	OP ("%",	0,				0,		2,MOD,		0)

	OP ("/=",	ASOP,			0,	   +1,ASDIV,	0)
	OP ("/",	0,				0,		2,DIV,		0)

	OP ("&&",	0,				0,	   11,AND,		0)
	OP ("&=",	ASOP,			0,	   +1,ASBINAND,	0)
	OP ("&",	UNOP|C_A,		0,		8,BINAND,	TAKEAD)

	OP ("|=",	ASOP,			0,	   +2,ASBINOR,	0)
	OP ("||",	0,				0,	   12,OR,		0)
	OP ("|",	C_A,			0,	   10,BINOR,	0)

	OP ("!=",	C_NA|COMPARE,	0,		7,NOTEQ,	B_NE)
	OP ("!",	UNOP,			0,		0,NOT,		0)

	OP ("~",	UNOP,			0,		0,BINNOT,	0)

	OP ("^=",	ASOP,			0,	   +1,ASBINEOR,	0)
	OP ("^",	C_A,			0,		9,BINEOR,	0)

	OP ("<<=",	ASOP,			0,	   +1,ASLSHIFT,	0)
	OP ("<<",	0,				0,		5,LSHIFT,	0)
	OP ("<=",	C_NA|COMPARE,	0,		6,LTEQ,		B_LE)
	OP ("<",	SPCL|C_NA|COMPARE,0,	6,LESS,		B_LT)

	OP (">>=",	ASOP,			0,	   +1,ASRSHIFT,	0)
	OP (">>",	0,				0,		5,RSHIFT,	0)

	OP (">=",	C_NA|COMPARE,	0,		6,GTEQ,		B_GE)
	OP (">",	C_NA|COMPARE,	0,		6,GREATER,	B_GT)

	OP ("?",	0,				0,	 	0,X_THEN,	0)

#if BIP_ASM
	KW ("a0",	0,	ASM|LEAF|ASMREG		,K_A0,		0)
	KW ("a1",	0,	ASM|LEAF|ASMREG		,K_A1,		0)
	KW ("a2",	0,	ASM|LEAF|ASMREG		,K_A2,		0)
	KW ("a3",	0,	ASM|LEAF|ASMREG		,K_A3,		0)
	KW ("a4",	0,	ASM|LEAF|ASMREG		,K_A4,		0)
	KW ("a5",	0,	ASM|LEAF|ASMREG		,K_A5,		0)
	KW ("a6",	0,	ASM|LEAF|ASMREG		,K_A6,		0)
	KW ("a7",	0,	ASM|LEAF|ASMREG		,K_A7,		0)
#endif

#if FOR_A
	OPS("and"							,AND)
#endif

	KW ("auto",		0,	DECL|SCLASS				,K_AUTO,	0)
	KW ("break",	0,	BRANCH_STMT				,K_BREAK,	0)

#if FOR_A
	KW ("by",		0, 	BLOCK_STMT|LOOP_STMT	,K_BY,		0)
#endif

	KW ("case",		0,	LABEL_STMT				,K_CASE,	0)
	KW ("cdecl",	0,	DECL					,K_CDECL,	0)
	KW ("char",		0,	DECL|BASIC|PLAIN		,K_CHAR,	0)
	KW ("compl",	0,	DECL|BASIC|AGGREG|PLAIN	,K_COMPL,	0)
	KWS("complex"								,K_COMPL)
	KW ("const",	0,	DECL					,K_CONST,	0)
	KW ("continue",	0,	BRANCH_STMT				,K_CONT,	0)

#if BIP_ASM
	KW ("d0",		0,	ASM|LEAF|ASMREG			,K_D0,		0)
	KW ("d1",		0,	ASM|LEAF|ASMREG			,K_D1,		0)
	KW ("d2",		0,	ASM|LEAF|ASMREG			,K_D2,		0)
	KW ("d3",		0,	ASM|LEAF|ASMREG			,K_D3,		0)
	KW ("d4",		0,	ASM|LEAF|ASMREG			,K_D4,		0)
	KW ("d5",		0,	ASM|LEAF|ASMREG			,K_D5,		0)
	KW ("d6",		0,	ASM|LEAF|ASMREG			,K_D6,		0)
	KW ("d7",		0,	ASM|LEAF|ASMREG			,K_D7,		0)
#endif

#if FOR_A
	KW ("declared", 0,	0						,DECLARED,	0)	/* 04'09 just for fun */
#endif

	KW ("default", 	0,	LABEL_STMT				,K_DEF,		0)
	KW ("defined",	0,	0						,DEFINED,	0)

#if FOR_A
	KW ("deref",	0,	DECL					,K_DEREF,	0)
#endif

	KW ("do",		0,	BLOCK_STMT|LOOP_STMT	,K_DO,		0)

#if FLOAT
	KW ("double",	0,	DECL|EXT_MOD			,K_DOUBLE,	0)
#endif

#if FOR_A
	KW ("elif",		0,	STMT_END				,K_ELIF,	0)
#endif

	KW ("else",		0,	STMT_END				,K_ELSE,	0)
#if BIP_ASM
	KW ("endm",		0,	STMT_END				,K_ENDMAC,	0)
	KWS("endmac"								,K_ENDMAC)
	KWS("endr"									,K_ENDMAC)
#endif
	KW ("enum",		0,	DECL					,K_ENUM,	0)

#if FOR_A
	OPS("eq"									,EQUALS)
	KW ("esac",		0,	STMT_END|BRANCH_STMT	,K_ESAC,	0)
#endif

	KW ("extern",	0,	DECL|SCLASS				,K_EXTERN,	0)
	KW ("false",	0,	LEAF					,K_FALSE,	0)

#if FOR_A
	KW ("fi",		0,	STMT_END				,K_FI,		0)
#endif

#if FLOAT
	KW ("float",	0,	DECL|BASIC|PLAIN		,K_FLOAT,	0)
#endif

	KW ("for",		0,	BLOCK_STMT|LOOP_STMT	,K_FOR,		0)

#if BIP_ASM and FLOAT
	KW ("fp0",		0,	ASM|LEAF				,K_F0,		0)
	KW ("fp1",		0,	ASM|LEAF				,K_F1,		0)
	KW ("fp2",		0,	ASM|LEAF				,K_F2,		0)
	KW ("fp3",		0,	ASM|LEAF				,K_F3,		0)
	KW ("fp4",		0,	ASM|LEAF				,K_F4,		0)
	KW ("fp5",		0,	ASM|LEAF				,K_F5,		0)
	KW ("fp6",		0,	ASM|LEAF				,K_F6,		0)
	KW ("fp7",		0,	ASM|LEAF				,K_F7,		0)
#endif

#if FOR_A
	KW ("from",		0,	BLOCK_STMT|LOOP_STMT	,K_FROM,	0)
	OPS("ge"									,GTEQ)
#endif

#if ! I_TOK
	KW ("global",	0,	DECL|SCLASS				,K_GLOBAL,	0)
#endif

	KW ("goto",		0,	BRANCH_STMT				,K_GOTO,	0)
	KW ("if",		0,	BLOCK_STMT				,K_IF,		0)
	KW ("int",		0,	DECL|BASIC|PLAIN		,K_INT,		0)

#if FOR_A
	OPS("is"									,IS_DEF_AS)
	OPS("le"									,LTEQ)
#endif

	KW ("long",		0,	DECL|BASIC|TYP_MOD		,K_LONG,	0)

#if FOR_A
	OPS("mod"									,MOD)
	OPS("ne"									,NOTEQ)
#endif

	KW ("nil",		0,	LEAF					,K_NIL,		0)

#if FOR_A
	OPS("not"									,NOT)
	KW ("od",		0,	STMT_END				,K_OD,		0)
	OPS("or"									,OR)
#endif

	KW ("pascal",	0,	DECL					,K_PAS,		0)

#if BIP_ASM
	KW ("pc",		0,	ASM|LEAF|ASMREG			,K_PC,		0)
#endif

#if ! I_TOK
	KW ("proc",		0,	DECL|CODE				,K_PROC,	0)
#endif

#if FOR_A
	KW ("ref",		0,	DECL					,K_REF,		0)
#endif

	KW ("register",	0,	DECL|SCLASS				,K_REG,		0)
	KW ("return",	0,	BRANCH_STMT				,K_RETURN,	0)

#if FOR_A
	KW ("rof",		0,	STMT_END				,K_ROF,		0)
	KW ("row",		0,	BLOCK_STMT				,K_ROW,		0)
#endif

	KW ("short",	0,	DECL|BASIC|TYP_MOD		,K_SHORT,	0)
	KW ("signed",	0,	DECL|EXT_MOD			,K_SIGNED,	0)

#if FOR_A and FLOAT
	KW ("single",	0,	DECL|EXT_MOD			,K_SINGLE,	0)
#endif

	KW ("sizeof",	0,	0						,K_SIZEOF,	0)

#if BIP_ASM
	KWS("sp"									,K_A7)
#endif

	KW ("static",	0,	DECL|SCLASS				,K_STATIC,	0)
	KW ("struct",	0,	DECL|AGGREG				,K_STRUCT,	0)
	KW ("switch",	0,	BLOCK_STMT				,K_SWITCH,	0)

#if ! I_TOK
	KW ("then",		0,	STMT_END				,K_THEN,	0)
#endif
#if FOR_A
	KW ("to",		0, 	BLOCK_STMT|LOOP_STMT	,K_TO,		0)
#endif

	KW ("true",		0,	LEAF					,K_TRUE,	0)
	KW ("typedef",	0,	DECL|SCLASS				,K_TYPE,	0)
	KW ("union",	0,	DECL|AGGREG				,K_UNION,	0)
	KW ("unsigned",	0,	DECL|BASIC|TYP_MOD		,K_UNS,		0)

#if FOR_A
	KW ("until",	0, 	BLOCK_STMT|LOOP_STMT	,K_UNTIL,	0)
#endif

	KW ("void",		0,	DECL|BASIC|PLAIN		,K_VOID,	0)
	KW ("volatile",	0,	DECL					,K_VOLAT,	0)

#if FOR_A
	KW ("when",		0,	STMT_END				,K_WHEN,	0)
#endif

	KW ("while",	0,	BLOCK_STMT|LOOP_STMT|STMT_END,K_WHILE,	0)
	KW ("wor",		0,	STMT_END				,K_WOR,		0)

#if BIP_ASM
	KWS("A0"	,K_A0)
	KWS("A1"	,K_A1)
	KWS("A2"	,K_A2)
	KWS("A3"	,K_A3)
	KWS("A4"	,K_A4)
	KWS("A5"	,K_A5)
	KWS("A6"	,K_A6)
	KWS("A7"	,K_A7)

	KWS("D0"	,K_D0)
	KWS("D1"	,K_D1)
	KWS("D2"	,K_D2)
	KWS("D3"	,K_D3)
	KWS("D4"	,K_D4)
	KWS("D5"	,K_D5)
	KWS("D6"	,K_D6)
	KWS("D7"	,K_D7)

#if FLOAT
	KWS("FP0"	,K_F0)
	KWS("FP1"	,K_F1)
	KWS("FP2"	,K_F2)
	KWS("FP3"	,K_F3)
	KWS("FP4"	,K_F4)
	KWS("FP5"	,K_F5)
	KWS("FP6"	,K_F6)
	KWS("FP7"	,K_F7)
#endif

	KWS("PC"	,K_PC)

	KWS("SP"	,K_A7)
#endif

	KW ("_Bool",	0,	DECL|BASIC|PLAIN		,K_BOOL,	0)

#if FLOAT
	KW ("_Real",	0,	DECL|BASIC|PLAIN		,K_REAL,	0)

	KW ("__FABS__",	RLOP,	0					,FABS,		0)
	KW ("__FACOS__",RLOP,	0					,ACOS,		0)
	KW ("__FASIN__",RLOP,	0					,ASIN,		0)
	KW ("__FATANH__",RLOP,	0					,ATANH,		0)
	KW ("__FATAN__",RLOP,	0					,ATAN,		0)
	KW ("__FCOSH__",RLOP,	0					,COSH,		0)
	KW ("__FCOS__",	RLOP,	0					,COS,		0)
	KW ("__FETOXM1__",RLOP,	0					,ETOXM1,	0)
	KW ("__FETOX__",RLOP,	0					,ETOX,		0)
	KW ("__FGETEXP__",RLOP,	0					,GETEXP,	0)
	KW ("__FGETMAN__",RLOP,	0					,GETMAN,	0)
	KW ("__FINTRZ__",RLOP,	0					,INTRZ,		0)
	KW ("__FINT__",	RLOP,	0					,INT,		0)
	KW ("__FLOG10__",RLOP,	0					,LOG10,		0)
	KW ("__FLOG2__",RLOP,	0					,LOG2,		0)
	KW ("__FLOGNP1__",RLOP,	0					,LOGNP1,	0)
	KW ("__FLOGN__",RLOP,	0					,LOGN,		0)
	KW ("__FNEG__",	RLOP,	0					,NEG,		0)
	KW ("__FSINH__",RLOP,	0					,SINH,		0)
	KW ("__FSIN__",	RLOP,	0					,SIN,		0)
	KW ("__FSQRT__",RLOP,	0					,SQRT,		0)
	KW ("__FTANH__",RLOP,	0					,TANH,		0)
	KW ("__FTAN__",	RLOP,	0					,TAN,		0)
	KW ("__FTENTOX__",RLOP,	0					,TENTOX,	0)
	KW ("__FTWOTOX__",RLOP,	0					,TWOTOX,	0)
#endif

	KW ("__OP__",	0,	 	DECL|CODE|OPAT		,K_OP,		0)
	KW ("__UC__",	0,	 	DECL|CODE|OPAT		,K_CAST,	0)

/* NB!! underline < lowercase !! */
	KW ("__asm__",	0,		DECL|CODE			,K_ASM,		0)
	OP ("__bswp__", UNOP,	0,		0			,BSWP,		0)	/* 03'09 */
	OP ("__getsetsr__",UNOP,0,		0			,GETSETSR,	0)	/* 03'09 */
	KW ("__ldsr__",	UNOP,	0					,GETSR,		0)	/* sr->ea 03'09 */
	KW ("__nop__",  0,		LEAF				,K_NOP,		0)	/* 03'09 */
	KW ("__offsetof__",0,	0					,K_OFFSET,	0)	/* 03'09 */
	KW ("__rest__", 0,		LEAF				,K_REST,	0)	/* 03'09 */
	KW ("__save__", 0,		LEAF				,K_SAVE,	0)	/* 03'09 */
	OP ("__stop__", UNOP,	0,		0			,HALT,		0)	/* 03'09 */
	OP ("__stsr__",	UNOP,	0,		0			,SETSR,		0)	/* ea->sr 03'09 */
	KW ("__syscall__",0,	DECL				,K_SYSC,	0)

/*					derived tokens */
	OPS("\362"									,QUOTE)
	OPS("\364"									,APOS)

/* same order as bas_def.h */
	KW ("",			0,	DECL|BASIC				,T_BOOL,	0)
	KW ("",			0,	DECL|BASIC				,T_CHAR,	0)
	KW ("",			0,	DECL|BASIC				,T_UCHAR,	0)
	KW ("",			0,	DECL|BASIC				,T_SHORT,	0)
	KW ("",			0,	DECL|BASIC				,T_USHORT,	0)
	KW ("",			0,	DECL|BASIC				,T_INT,		0)
	KW ("",			0,	DECL|BASIC				,T_UINT,	0)
	KW ("",			0,	DECL|BASIC				,T_LONG,	0)
	KW ("",			0,	DECL|BASIC				,T_ULONG,	0)

#if LONGLONG
	KW ("",			0,	DECL|BASIC|AGGREG		,T_LLONG,	0)
#endif

	KW ("",			0,	0						,REFTO,		0)

#if FLOAT
	KW ("",			0,	DECL|BASIC				,T_FLOAT,	0)
	KW ("",			0,	DECL|BASIC				,T_REAL,	0)
	KW ("",			0,	DECL|BASIC|AGGREG		,T_COMPL,	0)
#endif

	KW ("",			0,	DECL|BASIC				,T_VARGL,	0)
	KW ("",			0,	DECL|BASIC				,T_VOID,	0)
	KW ("",			0,	DECL|BASIC				,T_NTY,		0)

	KW ("",			0,	DECL|CODE				,L_PROC,	0)	/* #A local procs */

#if BIP_ASM
	KW ("",			0,	ASM						,REGINDIRECT,0)
	KW ("",			0,	ASM						,REGINDPLUS,0)
	KW ("",			0,	ASM						,MINUSREGIND,0)
	KW ("",			0,	ASM						,REGINDISP,	0)
	KW ("",			0,	ASM						,REGINDX,	0)
	KW ("",			0,	ASM						,REGINDIM,	0)
	KW ("",			0,	ASM						,ASMSCALE,	0)
	KW ("",			0,	ASM						,INSTR,		0)
	KW ("",			0,	ASM|DECL				,K_AHEAD,	0)	/* forward referencing operand */
#endif

#if I_TOK		/* #A tokens that are internally usefull */
	KW ("",			0,	DECL|CODE				,K_PROC,	0)
	KW ("",			0,	STMT_END				,K_THEN,	0)
	KW ("",			0,	DECL|SCLASS				,K_GLOBAL,	0)
#endif

 /* LAST_OP */
	KW ("",			0,	0						,K_LAST,	0)

	/* internal tokens */

	DTOK (FUSED)				/* ANSI: voor PARCAT catenated */
	DTOK (CATTED)				/* ANSI: voor PARCAT tokenized */
	DTOK (DELETE)				/* ANSI: voor TO_STR */
	DTOK (DPARAM)
	DTOK (EOFTOK)
	DTOK (FIELDAS)
	DTOK (ZERO)
	DTOK (ONAME)
	DTOK (OLNAME)
	DTOK (OREG)
	DTOK (PUSHER)
	DTOK (REGVAR)
	DTOK (O_ABS)
	DTOK (ICON)

#if FLOAT
	DTOK (FCON)				/* 32 bit float literals */
	DTOK (RCON)				/* 96 bit double loterals */
#endif

#if LONGLONG
	DTOK (LCON)				/* 01'09 HR long long constant */
#endif

#if COLDFIRE
	DTOK (COLDCON)			/* For coldfire: literals in a table (like RCONS and FCONS) */
#endif
							/* type conversions */
	DTOK (IMPCNV)			/* implicit */
	DTOK (EXPCNV)			/* explicit (casts) */
	DTOK (ARGCNV)			/* for pushing */

	DTOK (TSIZEOF)
	DTOK (TOFFSET)
	DTOK (MEMBER)
	DTOK (POSTINCR)
	DTOK (POSTDECR)
	DTOK (ARG)				/* COMMA in argument list */
	DTOK (PULL)				/* pull arguments in registers */
	DTOK (PULLARG)			/* pull 1 arg */
	DTOK (ARGP)				/* push struct return pointer. */

	/* unary use of otherwise binary operators	*/
	DTOK (DEREF)			/*   '*'   */
	DTOK (UPLUS)			/*   '+'   */
	DTOK (NEGATE)			/*   '-'   */
	DTOK (TAKEAD)			/*   '&'   */

	/* other tokens  (aplphabetic on mnemonic)
		handled outside matchop() */
#if FOR_A
	DTOK (I_ROW)			/* row inner */
/*	DTOK (O_ROW)			   row out */
	DTOK (STMT)				/* token of local proc that is generated
							   if a block or statement is used as primary */
#endif

	DTOK (ID)
	DTOK (ROW)				/* row size confolded */
	DTOK (INDEX)			/*   '[]' in expressions */
	DTOK (SCALE)			/* pointer scaling */
	DTOK (NL)

	/* keep xSCONn tokens together in this order */
	DTOK (ASCON)			/* ASCII constant pe: 'x' */
	DTOK (SCON)
	DTOK (SCON1)			/* ANSI: quoted string in include */
	DTOK (SCON2)			/*		  <..>    "         "    */

	DTOK (WS)
	DTOK (DLAST)			/* 03'09: for balancing macro expansions */
	DTOK (FLOW)				/* flow list node */

/* the following tokens are for the 'gp' nodes */
	DTOK (EXPR)
	DTOK (RETURN)
	DTOK (PROC)
	DTOK (IFX)
	DTOK (WHILE)
	DTOK (FOR)
	DTOK (SWIT)
	DTOK (EX1)
	DTOK (EX2)
	DTOK (EX3)
	DTOK (INIT)
	DTOK (LINIT)
	DTOK (SCALAR)
	DTOK (OUT)
	DTOK (LEXED)		/* pretokenized file */
	DTOK (HIGH_TOK)

#endif		/* deftoks */
