/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Johann Ruegg
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * diagpr.c
 *
 * diagnostic print routines
 *
 */

#define PROCESS_H
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <tos.h>
#include "param.h"		/* defines & undefines DEF_ENUM */

long bios( void, ... );

#define debugT (G.xflags['t'-'a'])	/* extended types */
#define debugO (G.xflags['o'-'a'])	/* NO nflags or code */
#define debugK (G.xflags['k'-'a'])	/* print keyword cataguories */
#define debugN (G.xflags['n'-'a'])	/* print at all */
#define debugY (G.xflags['y'-'a'])	/* print node addresses */
#define debugW  G.xflags['w'-'a']		/* wait */
#define debug_n G.yflags['n'-'a']		/* name type & size */
#define debug_o G.yflags['o'-'a']		/* const/volat */
#define debug_z (G.yflags['z'-'a'])

static string etypes[] =
{
	"E_LEAF",
	"E_UNARY",
	"E_BIN",
	"E_SPEC",
	"        "
};

static string storage[] =
{
	"t:0",
	"ET_CC",
	"ET_FC",
	"ET_XC",
	"ET_B",
	"ET_S",
	"ET_U",
	"ET_P",
	"ET_R",
	"ET_A",
	"            "
};

static string gtypes[] =
{
	"EV_NONE",
	"EV_LEFT",
	"EV_RIGHT",
	"EV_LR",
	"EV_RL",
	"EV_LRSEP",
	"EV_RLSEP",
	"            "
};

static short precur = 0;

#define DEF_DIAG 1

#define DEF_TOKS 1
static string ntypes[] =
{
#include "defs.h"
	"        "
};
#undef  DEF_TOKS


#define DEF_TOK_FLAGS 1
static string tokflags[] =
{
#include "defs.h"
};
#undef  DEF_TOK_FLAGS

#define DEF_PO_CODE 1
static string ascodes[] =
{
	"INVOP",
#include "po_defs.h"
};
#undef DEF_PO_CODE


global string pascode(short tok)
{
	static char rt[16];

	if ( tok <= 0 or tok > LDSR )
		sprintf(rt, "?[1]x%x?", tok);
	else
		sprintf(rt, "%s", ascodes[tok]);
	return rt;
}

void popond(OPND *op, short c)
{
	if (op)
	{
		if (op->amode)
		{
			if (c)
				send_msg("%c", c);
			switch(op->amode&~XLONG)
			{
				case REG:
					send_msg(preg(op->areg));	break;
				case REGI:
					send_msg("(%s)", preg(op->areg));	break;
				case REGI|INC:
					send_msg("(%s)+", preg(op->areg));	break;
				case REGI|DEC:
					send_msg("-(%s)", preg(op->areg));	break;
				case REGID:
					send_msg("%ld(%s)", op->disp, preg(op->areg));	break;
				case REGIDX:

send_msg("%ld(%s, %s.%c)", op->disp, preg(op->areg), preg(op->ireg), (op->amode&XLONG) ? 'l' : 'w'); break;
				default:
					send_msg("mode 7");
			}
		}
	}
}


static string pflags(unsigned short flags, string ty[])
{
	static char s[512];
	short i = 0;

	s[0] = 0;
	while (flags ne 0)
	{
		if (flags&1)
		{
			if (s[0])
				strcat(s, "|");
			strcat(s, ty[i]);
		}
		flags >>= 1;
		i++;
	}
	return s;
}

#define pflg(a) if (f.f.a) strcat(fs, #a "|")

static void n_flags(NP np)
{
	char fs[64], *s;

	NFLAGS f = np->nflags;
	if (f.i)
	{
		strcpy(fs,"N[");
		pflg(n_brkpr);
		pflg(nexp);
		pflg(spar);
		pflg(n_ct);
		pflg(free);
		pflg(rcat);
		pflg(lcat);
		pflg(bas);
		pflg(asmac);
		pflg(p1ws);
		pflg(follows);
		pflg(dot);
		pflg(nheap);
		s = fs + strlen(fs)-1;
		if (*s eq '|')
		{
			*s++ = ']';
			*s = 0;
			send_msg("%s\t", fs);
		}
	}
}

static void c_flags(NP tp)
{
	char fs[64], *s;

	CFLAGS f = tp->cflgs;
	if (f.i)
	{
		strcpy(fs,"C[");
		pflg(rlop);
		pflg(qconst);
		pflg(qvolat);
		pflg(cdec);
		pflg(asmfunc);
		pflg(see_reg);
		pflg(undef);
		pflg(lproc);
		s = fs + strlen(fs)-1;
		{
			*s++ = ']';
			*s = 0;
			send_msg("%s\t", fs);
		}
	}
}

static void t_flags(TP tp)
{
	char fs[64], *s;

	TFLAGS f = tp->tflgs;
	if (f.i)
	{
		strcpy(fs,"T[");
		pflg(ans_args);
		pflg(old_args);
		pflg(saw_array);
		pflg(derefto);
		pflg(inid);
		pflg(used);
		pflg(isarg);
		pflg(formal);
		s = fs + strlen(fs)-1;
		{
			*s++ = ']';
			*s = 0;
			send_msg("%s\t", fs);
		}
	}
}

static void e_flags(NP np)
{
	char fs[64], *s;

	EFLAGS f = np->eflgs;
	if (f.i)
	{
		strcpy(fs,"E[");
		pflg(see_u);
		pflg(see_l);
		pflg(see_f);
		pflg(see_ll);
		pflg(varg);
		pflg(typed);
		pflg(asm_l);
		pflg(asm_w);
		pflg(cc);
		pflg(imm);
		pflg(lname);
		pflg(rname);
		pflg(cfl);
		s = fs + strlen(fs)-1;
		{
			*s++ = ']';
			*s = 0;
			send_msg("%s\t", fs);
		}
	}
}

string pcoflags(short f)
{
	static char fs[64], *s;
	if (f eq 0)
		return "";
	fs[0] = 0;
	if (f&CC_OK)
		strcat(fs, "CC_OK|");
	if (f&IMMA_OK)
		strcat(fs, "IMMA_OK|");
	if (f&NOVAL_OK)
		strcat(fs, "NOVAL_OK");
	s = fs + strlen(fs) - 1;
	if (*s eq '|')
		*s = 0;
	return fs;
}

#define DEF_D_FLAGS 1
static string dflags[] =
{
#include "defs.h"
};
#undef DEF_D_FLAGS

global string pdoflags(short flags)
{
	return pflags(flags, dflags);
}

#define DEF_R_FLAGS 1
static string rflags[] =
{
#include "defs.h"
};
#undef DEF_R_FLAGS

global string preflags(short flags)
{
	return pflags(flags, rflags);
}

#define DEF_A_FLAGS 1
static string clsflags[] =
{
#include "defs.h"
};
#undef DEF_A_FLAGS

global string pclflags(short flags)
{
	return pflags(flags, clsflags);
}

#define DEF_K_FLAGS 1
static string catags[] =
{
#include "defs.h"
};
#undef DEF_K_FLAGS

static string pcategories(short flags)
{
	return pflags(flags, catags);
}

global string ptok(short tok)
{
	static char rt[16];

	if ( tok < 0 or tok > ASSIGN TOKMASK )
		sprintf(rt, "?[2]x%x?", tok);
	elif ( (tok&TOKMASK) >= LASTTOK)
		sprintf(rt, "%s?x%x?", (tok&(ASSIGN 0))?"AS":"", tok&TOKMASK);
	else
		sprintf(rt, "%s%s", (tok&(ASSIGN 0))?"AS":"", ntypes[tok&TOKMASK]);
	return rt;
}

global string pntype(short ty)
{
	static char rs[8] = "0";

	if (ty eq -1)
	{
		rs[0] = '?';
		rs[1] = 0;
	othw
		if (ty < FIRSTTY or ty >= LASTTY )
		{
			sprintf(rs, "?[3]x%x?", ty);
		othw
			rs[0] = "~>XEGTSFCPRDLIlib"[ty];
			rs[1] = 0;
		}
	}
	return rs;
}

global string psclass(NP np)
{
	static char ps[20];
	unsigned short sc = np->sc;

	*ps = 0;
	if ( sc )
		if (sc >= LASTTOK )
			sprintf(ps, "\tsc: ?x%x?", sc);
		elif (np->category&SCLASS)
	 		return ntypes[sc]+2;			/* w/o K_ */
	 	else
	 		return ntypes[sc];
	return ps;
}

global string petype(NP np)
{
	short ety = np->tt;

	if ( np->nt eq EXNODE and 0 <= ety and ety > E_SPEC )
	{
		ety = E_SPEC+1;
		sprintf(etypes[ety], "?[4]x%x?", np->tt);
	othw
		if ( 0 <= ety and ety > EV_RLSEP )
		{
			ety = EV_RLSEP + 1;
			sprintf(gtypes[ety], "?[5]x%x?", np->tt);
		}
	}
	return (np->nt eq EXNODE ? etypes[ety] : gtypes[ety]);
}

global string pty(short sty)
{
	if ( sty < 0 or sty > ET_A )
	{
		sprintf(storage[ET_A+1], "?[6]x%x?", sty);
		sty = ET_A+1;
	}
	return (storage[sty]);
}

static string contexts[] =
{
	"NONE",
	"FORSIDE",
	"FORPUSH",
	"FORCC",
	"FORIMA",
	"FORADR",
	"FORLVAL",			/* 12'08 HR usage tracking */
	"FORINIT",
	"IND0",
	"INF0",
	"INA0",
	"SWITCH",
	"RETSTRU",
	"FORLINIT",
	"FORLAINIT",
	"FORVALUE",
	"FORTRUTH",
	"FORASM",
	"FORSEE",
	"FOR x????????????????"
};

global string prcntxt(short context)
{
	if (context < 0 or context >= HIGHCONTEXT)
	{
		sprintf(&contexts[HIGHCONTEXT][5], "%x", context);
		return contexts[HIGHCONTEXT];
	}
	return contexts[context];
}

char *pclass(short class)
{
	static char pa[20];
	if (class >= 0 and class < high_class)
		return class_names[class];

	sprintf(pa, "A:%d(0x%x)", class, class);
	return pa;
}

static char ra[3][4] = {" D ", " F ", " A "}, fr[10];

global string preg(short r)
{
	if (r eq -1)
		return "";

	if (r < 0 or r >= 24)
	{
		sprintf(fr, "~r:0x%x", r);
		return fr;
	othw
		short tr = r>>3;
		ra[tr][2] = (r&7)+'0';
		return ra[tr];
	}
}

short tel = 0;

static void conwait(void)
{
	if (++tel eq 32 and bugf eq stdout)
	{
		bios(2, 2);
		tel = 0;
		send_msg("\n");
		if break_in
			exit(0);
	}
}

#include "pre.h"

global void printtoks(void)
{
	short i, tok = 0;

	tok_init();

	send_msg("Enum tokens:\n");
	while(tok <= LASTTOK)
	{
		send_msg("%3d\t0x%2x\t%-10s%-12s\n", tok, tok, ntypes[tok], graphic[tok]);
		tok++;
		conwait();
	}

	send_msg("\fC_lex:\n");
	for (i = 0; i<256; i++)
	{
		if (C_lex[i].text)
			send_msg("%3d\t%-12s t:%3d %s\n",
				i,
				C_lex[i].text,
				C_lex[i].value,
				ntypes[C_lex[i].value]);
		else
			break;
		conwait();
	}
	send_msg("\fC_tok\n");
	for (i = 0; i<256; i++)
	{
		if (C_tok[i])
		{
			TOKEN *pt = C_tok[i];
			send_msg("%3d %-12sp:%2d t:%3d %-16s",
							i, pt->text, pt->prec, pt->value,
							pflags(pt->flags, tokflags));
			send_msg("%-24s", pcategories(pt->category));
			if (pt->x)
				if (pt->category&BASIC)
					send_msg("%d", pt->x);
				else
					send_msg("%s", ntypes[pt->x]);
			send_msg("\n");
			conwait();
		}
	}
	send_msg("\f");
}

static void name_c_v(NP np)
{
	if (!debug_o)
		if (np->cflgs.f.qconst and np->cflgs.f.qvolat)
			send_msg("CV: ");
		else
		{
			if (np->cflgs.f.qconst)
				send_msg("C: ");
			if (np->cflgs.f.qvolat)
				send_msg("V: ");
		}
	send_name(np);
	if (debug_n)
		send_msg("[%c]", "NHS"[np->nflags.f.nheap]);
	send_msg("\t");
}

static void t_data(TP tp)
{
	if (!debugY)
		send_msg("%s%lx\t", pntype(tp->nt), tp);

	if debugK
		if ( tp->category )
			send_msg("%s\t",
					pcategories(tp->category) );

	if ( tp->sc )
		send_msg("%s\t",
		        psclass((NP)tp) );
	if ( tp->tflgs.i )
		t_flags(tp);
	if ( tp->cflgs.i)
		c_flags((NP)tp);
	if (tp->fld.width )
		send_msg("(%d,%d)\t", tp->fld.width, tp->fld.offset);
	if ( tp->size or tp->aln )
		send_msg("%s\ts:%ld\ta:%d\t",
				pty(tp->ty),
		        tp->size,
		        tp->aln);
	if ( tp->offset)
		send_msg("o:%ld\t",
		        tp->offset);
	if ( tp->area_info.class )
		send_msg("(%s)%d.%ld\t", pclass(tp->area_info.class), tp->area_info.id, tp->area_info.disp);
}

static void tprint(TP np, short indent)			/*	modelist nodes */
{
	short ni, ind;
	TP tp;

	if break_in return;		/* for loopholes in node structure (thats why you need debugging) */

	ni = indent+1;
	ind = indent;
	while (ind--) send_msg("    ");
	if (np eq nil )
	{
		send_msg("<nil>\n");
	othw
		tp = np;
		while (np ne nil)
		{
			name_c_v((NP)np);
			if (debugT)
			{
				t_data(np);
				n_flags((NP)np);
			}
			else
				send_msg(" ");
			np = np->type;
		}

		send_msg("\n");
		while(tp ne nil)
		{
			if (tp->nflags.f.n_brkpr eq 0)
				if (tp->next)
				{
					if (!debugY)
						send_msg("%lx", tp);
					send_msg("L\t");
					tprint(tp->next, ni);
				}

			if (tp->list)
			{
				if (!debugY)
					send_msg("%lx", tp);
				send_msg("R\t");
				tprint(tp->list, ni);
			}
			tp = tp->type;
		}
	}
}

static void cprint(NP np) /* np is the GENODE !! */
{
	VP tp;
	short i;

	send_msg("\n");
	if (np->betw)
	{
		tp = np->betw;
		for (i = 0; i < tp->tnr; i++)
			send_msg("betw: %s", tp->ts[i]);
	}

	if (is_nct(np))					/* code is a string */
		send_msg("\"%s\"", np->type);
	else
		for (tp = (VP)np->type; tp; tp = tp->codep)	/* code is a list */
			for (i = 0; i < tp->tnr; i++)
				send_msg("%s", tp->ts[i]);
}

static void prnode(NP np, short indent)
{
	short ni, ind;

	precur++;
	ni  = indent+1;
	ind = indent;

	if (!break_in)		/* for loopholes in node structure (thats why you need debugging) */
	{
		if (ind)
			while (--ind) send_msg("    ");	/* 1 less then actual indentation because of "L   " or "R   " */

		if (np eq nil)
			send_msg("<nil>\n");
		else
		{
			D_B(send_msg("%4ld:", np->lineno);)

			if (np->nt eq TLNODE)
			{
				name_c_v(np);
				send_msg("%s\t", ptok(np->token));
				t_data((TP)np);
			}
			elif (np->nt eq INNODE)
			{
				IP ip = (IP)np;
				send_msg("op:%s.%d  ",
							pascode(ip->opcode), ip->sz);
				if (ip->reg >= 0)
					send_msg("%s", preg(ip->reg) );
				send_msg("\t");
				popond(ip->arg,         0 );
				popond(ip->arg->next,  ',');
			othw								/* X, E, Gnode */
				send_name(np);
				if (debug_n)
					send_msg("[%c]", "DH~"[np->nflags.f.nheap]);
				if (!(np->nt eq DFNODE or np->nt eq STNODE))
					if ( np->lbl)
						send_msg("\tL%d",  np->lbl);
				send_msg("\t%s\t",  ptok(np->token));
				if (!debugY)
					send_msg("%s%lx\t",  pntype(np->nt),  np);
				if (np->nt ne DFNODE)
					send_msg("%s\t", petype(np));
				if debugK
					if ( np->category)
					send_msg("%s\t",
							pcategories(np->category) );
				if ( np->sc )
					send_msg("%s\t",
					        psclass(np) );
				if ( np->cflgs.i)
					c_flags(np);
				if ( np->eflgs.i)
					if (np->nt eq TLNODE)
						t_flags((TP)np);
					else
						e_flags(np);
				if ( np->cflgs.f.prec )
					send_msg("p:%d\t", np->cflgs.f.prec);

				if ( np->val.i )
#if FLOAT
					if ( np->token eq FCON )
						send_msg("F:%lx\t", np->val.i);
	/* TURBO C hack voor float: gebruik val.i omdat TC float naar double converteerd
		als de float op de stack moet */
					elif ( np->token eq RCON and np->val.dbl)
						send_msg("D:%08lx %08lx%08lx\t", getrcon(np));
					else
#endif
#if LONGLONG
					if ( np->token eq LCON and np->val.dbl)
						send_msg("L:%08lx%08lx\t", getlcon(np, 20));
					else
#endif
					if (np->token eq ICON)
						send_msg("I:%ld\t", np->val.i);
					else
						send_msg("o:%ld\t", np->val.i);

				if (np->nt > DFNODE and np->area_info.class)
					send_msg("(%s)%d.%ld\t", pclass(np->area_info.class), np->area_info.id, np->area_info.disp);

				if (np->nt > DFNODE)
				{
					if (np->size)
						send_msg("s:%ld\t", np->size);
					if (np->rno ne -1)
						send_msg("%s\t", preg(np->rno));
					if (np->fld.width)
						send_msg("(%d,%d)\t", np->fld.width, np->fld.offset);

					if ( np->ty)
						send_msg("%s\t",
							pty(np->ty));
		/*				if (np->aln ne 1)
						send_msg("a:%d\t", np->aln);		*/


					if (np->nt eq GENODE  )
					{
					/*	if (np->type)	*/
						{
							if ( *(short *)&np->needs )
								send_msg("n:#%03x\t", np->needs);
							if ( np->r1 ne -1 )
								send_msg("r1:%s\t", preg(np->r1));
							if ( np->r2 ne -1 )
								send_msg("r2:%s\t", preg(np->r2));
							if ( np->Tl)
								send_msg("Tl:%d\t", np->Tl);
							if ( np->Fl)
								send_msg("Fl:%d\t", np->Fl);
							if ( np->brt)
								send_msg("%s\t", ptok(np->brt + BR_TOK));
							if ( np->chunk_size )
								send_msg("chunk_size:%d\t", np->chunk_size);
							if ( np->misc1 )
								send_msg("misc1:%d\t", np->misc1);
							if ( np->misc )
								send_msg("misc:%ld\t", np->misc);
						}
					}
				}
			}

			if (!debugO)
				n_flags(np);

			if (np->nflags.f.free eq 0)
			{
				if (!np->type or debugO)
					send_msg("\n");
				elif (np->nt eq GENODE)
					cprint(np);
				elif (np->nt eq EXNODE)
					tprint(np->type, 0);
				elif (np->nt eq DFNODE)
				{
					send_msg("\n");
					prnode((NP)((XP)np)->tseq, ni);
				}

				if (np->nt ne INNODE)
				{
					if (np->left /* and !np->nflags.f.n_brkpr */)	 /* break recursie */
					{
						send_msg("L   ");
						if (debug_z)
							send_msg("%lx\t", np->left);
						elif (np->left ne np)
							prnode(np->left, ni);
					}

					if (np->right /* and !np->nflags.f.n_brkpr */)	/* break recursie */
					{
						send_msg("R   ");
						if (debug_z)
							send_msg("%lx\t", np->right);
						elif (np->right ne np)
							prnode(np->right, ni);
					}
				}
			}
		}
	}
	if (--precur eq 0 and bugf eq stdout and debugW) bios(2, 2);
}

static void prln(NP np, short indent)
{
	NP svl, nxtl;

	for (svl = np; svl ne nil; svl = nxtl)
	{
		nxtl = svl->left;
		svl->left = nil;
		prnode(svl, indent);
		svl->left = nxtl;
		/* special hack for tag list */
		if (svl->nflags.f.n_brkpr and svl->right)
			prln(svl->right, indent+2);
	}
}

global void printlist(TP np)
{
	send_msg("\n");
	prln((NP)np, 2);
}

global void frcprnode(NP np)		/* not used yet */
{
	if(debugW)
	{
		send_msg("\n");
		prnode(np, 0);
	othw
		ONY('w');
		send_msg("\n");
		prnode(np, 0);
		OFFY('w');
	}
}

global void printnode(void *vp)		/* test eof in comment ? remove -->*/
{
	TP tp = vp;
	if (debugN)
	{
		send_msg("\n");
		if (tp and tp->nt eq TLNODE)
			tprint(tp, 0);
		else
			prnode(vp, 0);
	}
}

static char pmb[512];
void pm_print(NP np)
{
	postmort(pmb, np, 28, ' ');
	send_msg("%lx:{[%s]}\n", np, pmb);
}
