/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Tony Andrews
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Optimizer integrated in the compiler.
 */

#define HDB 0

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "param.h"

#include "opt.h"

/* usefull for looking beyond blocks */
global RMASK anywhere_used, anywhere_set;


#if OPTBUG
void pusage(IP ip, short level)
{
	string pascode(short tok);
	send_msg("%d>%4ld %s \tR:%s", level, ip->inr, pascode(ip->opcode), mask_to_s(ip->rref, 1));
	send_msg("\tS:%s", mask_to_s(ip->rset, 1));
	send_msg("\tL:%s\n", mask_to_s(ip->live, 1));
}
#endif

static
void unmark(BP bp)
{
	while (bp)
		bp->bflg.mark = 0,
		bp = bp->next;
}

#if 0
	/* Tony's original v1.2 is extreeeemely non linear :-(
	   On the file icon.c (62Kb) of Teradesk rhealth
	   took 40 times longer.
	   Tony's took 20 seconds, mine only 0.5 sec.
	*/

#include "tony.h"

#elif NHEALTH

#include "nhealth.h"		/* new experimental version */

#else


/* Replaced all of the original Sozobon health.c
   (functions: bprep, fprep, scan_ref, is_live & bflow)
   by a single recursive function (scan_live).

   It does everything at the correct time at the correct
   place and all looks now even intelligeable ;-)

   This was made possible by updating the instructions reg usage
   when a inst is read and only when a inst is changed.
 */

static
void scan_live(BP bp, char *which, short level)
{
	RMASK live = 0;

	if (bp)
	{
		IP ip;
		bool marked = bp->bflg.mark;
/*		bool loop   = bp->bflg.loop;
 send_msg("%d>Block %s %s %s mark %d, loop %d\n",
       level, bp->name, which, mask_to_s(bp->live, 1), marked ne 0, loop ne 0);
*/
		bp->bflg.mark = 1;

		if (!bp->bflg.ret)
		{
			if (bp->cond)
			{
				if (!marked)
					scan_live(bp->cond, "cond", level+1);
				live |= bp->cond->live;
			}

			if (bp->fall)
			{
				if (!marked)
					scan_live(bp->fall, "fall", level+1);
				live |= bp->fall->live;
			}
		}

/* Work backward from the end of each block, checking the status of registers.
 * To start with, figure out the state of the register as of the end of the
 * block.
 */
/*		live is state at end of block */

		{
			RMASK bl_rref = 0, bl_rset = 0;
			string pascode(short tok);

			ip = bp->last;
			while (ip)
			{
				if ((idata[ip->opcode].iflag&USG) eq 0)
					anywhere_used |= ip->rref | ip->rset,
					anywhere_set  |= ip->rset;

				if (   ip->opcode eq DCS
					or ip->opcode eq JSL)
				{
					if (ip->arg)
					{
						BP rp = getsym(ip->arg->astr);
						if (rp)
						{
							scan_live(rp, rp->name, level+1);
							live |= rp->live;
						}
					}
				}

				ip->live = live;
/* send_msg("%d>%s\tL%3ld\t%s\n",
  level, pascode(ip->opcode), ip->inr, mask_to_s(live, 1));
*/
				live = (live & ~ip->rset) | ip->rref;

				bl_rref |= ip->rref;
				bl_rset |= ip->rset;

				ip = ip->prior;
			}

			bp->live = live;
			bp->rref = bl_rref;
			bp->rset = bl_rset;
		}
	}
}

void rhealth(BP bp, bool do_prep, short which)
{
	unmark(bp);
	anywhere_used = 0;
	anywhere_set  = 0;

	scan_live(bp,"first", 0);
	peep_loops++;
}

#endif
