/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Johann Ruegg
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *	nodes.h
 */

NP		allocnode	(short ntype);
VpN		freenode,
		freeunit;

XP		allocXn		(bool clr);
void	freeXn		(XP);
void	freeXunit	(XP);
XP 		copyXone	(XP np);

TP		allocTn		(bool clr);
VpT		freeTn,
		freeTunit;

VP		allocVn		(short ntype);
void	freeVunit	(VP vp);
void	freeVn		(VP vp);
VP		copyVone	(VP vp);

BP		allocBn		(void);
void	freeBunit	(BP bp);
void	freeBn		(BP bp);

IP		allocIn		(void);
void	freeIunit	(IP ip);
void	freeIn		(IP ip);

void free_name(void *ap);

NpT		t_copy_e,
		t_to_e,
		t_copyone_e;

TpN		e_copyone_t;

NpV		gx_node,
		npcur;
TpV		tpcur;


TpT		copyTnode,
		copyTone;

NpN		childname,
		copynode,
		copyone,				/* for warping new */
		for_old_copyone;		/*  "    "     old */

VpV		advnode,
		fadvnode,
		free_dictionary,
		init_dictionary;

void	send_name(void *vp);

VpI		freenodespace;
VpN		next_gp;

VpNI	new_gp,
		expr_gp;

VpNN	copyinto;
short 	hash(string);

NpNI	nthnode,
		rthnode;

global void * tlook(void *vt, void *nv);

void	putn_lifo	(NP *head, NP np),
		putv_lifo	(VP *head, VP np),
		put_lifo	(TP *head, TP np),
		put_fifo	(NP *first, NP *last, NP np),
		put_hlist	(TP *list, TP np),
		put_xlist	(XP *list, XP np),
	    name_to_str	(void *vp, string s),
		save_name	(void *vp, long l, string s),
		init_xlist	(XP np[]),
		init_hlist	(TP np[]);

void *	init_symtab	(short key);

string	to_dictionary(char *n),
		to_name_heap(short l, char *n);

short 	new_name	(void *vp, string text, ... );

#if FLOAT
void	new_rnode	(NP np, double x);
double	getrcon		(NP np);
#endif
#if LONGLONG
void	new_lnode	(NP np, __ll l);
__ll	getlcon		(NP np, short which);
#endif

#define line_number(x) (x)->lineno = lineno, (x)->fileno = G.inctab->p.fileno;

extern short numhash;
