/*  Copyright (c) 1990 - 2008 by Henk Robbers Amsterdam.
 *
 * This file is part of CALC.
 *
 * CALC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CALC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CALC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *		PARSE.C
 *
 *		Arithmatic expression recursive descent interpreter
 */

#include <prelude.h>
#include <math.h>
#include "parse.h"

#ifdef DIAG
extern bool diagnostics;
#endif

PARSE parsepar={0L, 0L,
				BADSTR,
				0L,0L,0L,0L};

T bad_tok(char *s)
{
	T r=BADTOK;
	r.nam=s;
	return r;
}

T binary(T l, bool haveleft);	 /* recursion */

static
T unary(void)
{
	T o=C,r;

	if (can_un(o.p))
	{
		primary();
		o.p=UNARY;
		r=unary();
		r=DO_UNOP(o,r);
	othw						/* is primary */
		if (o.t eq LPAR)
		{
			r=binary(primary(),need_LEFT);		/* whole expression as primary */
			if (C.t ne RPAR and !is_bad(r))
				r=bad_tok("missing ')'");
		}
		else
			r=o;
	}
	return r;
}

static
T binary(T l, bool has_left)
{
	T o,r;								/* operator, right part */

	if (!has_left)
		l=unary(), primary();			/* for left part */

	while (is_bin(C))
	{
		o=C, primary();					/* for operator */
		r=unary(), primary();			/* for right part */

		if (is_bin(C))
			if (C.p > o.p)				/* next is higher */
				r = binary(r,has_LEFT);
			else
			if (C.p < o.p)				/* next is lower:  */
				if (has_left)			/* if not at root level */
					return DO_BINOP(o,l,r);		/* leave recursion */

		l = DO_BINOP(o,l,r);	/* equal priority; evaluate left to right (iterative) */
	}
	return l;
}

global
T parse(void)
{
	return binary(primary(), need_LEFT);
}

global
void parsedef(PARSE_NEXT *token,
					void *ides,
					char *s,
					T (*tab)[],
					PARSE_BINOP *binop,
					PARSE_UNOP  * unop,
					PARSE_RANGE *range,
					PARSE_DEREF *deref)
{
	parsepar.tok=token;
	parsepar.ides = ides;
	parsepar.str=s;
	parsepar.c=BADTOK;
	parsepar.tab=tab;
	parsepar.binop=binop;
	parsepar.unop = unop;
	parsepar.range = range;
	parsepar.deref = deref;
}
