/*  Copyright (c) 1993 - 2008 by Henk Robbers Amsterdam.
 *
 * This file is part of CALC.
 *
 * CALC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CALC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CALC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* 	SHEET.C
 *	=======
 */
#define noTESTSHEET

#include <string.h>

#include "common/mallocs.h"
#include "common/aaaa_lib.h"
#include "common/hierarch.h"

#define SHEET_C

#include "aaaa.h"
#include "text/cursor.h"
#include "common/files.h"
#include "common/options.h"
#include "common/config.h"
#include "common/wdial.h"
#include "common/ahcm.h"

#include "sheet.h"

M_S cmen={false,false,0,0,0,0,0,0,0,nil,nil};
RECT sheetmargin={0,0,0,0};
int sh_col = 0,
    sh_row = 0;
SH_CELL buf = {0};

static
OBJECT *ed=nil;
static
TEDINFO *c_str,*ty_str,*ed_str;

#ifdef SH_LBLSTR
static
TEDINFO *lbl_str;
#endif

char sh_string[130], sh_tmpl[130];

static
void write_select(IT *w,CINF *css,CINF *cse, STMNR top, STMNR bot)
					  /*     start  -   end     van   -  tot  */
{
}

global
SELECT sheet_select	/*	IT *w */
{
	if ( w->ss.l and w->wselect)
		(*w->wselect)(w,&w->ss,&w->se,w->top,w->top+w->hw);
	else
		cur_on(w);
}

global
DESELECT sheet_deselect		/*  IT *w,CUR_TO rich	 rich is LOW or HIGH */
{
	if ( w->ss.l)
	{
		sheet_select(w);		/* ontschrijf */
		if (rich eq LOW)
			w->cu=w->ss;
		else
			w->cu=w->se;
		w->ss=nullcinf;
		w->se=nullcinf;
	othw
		cur_off(w);
	}
}


static
SHEET_ACT free_cell
{
	free(c);
	return false;
}

static
CELL tab_loop(IT *w,SHEET_ACT *act)
{
	CELL c;
	int i,j;
	loop(i,MAXCOLS)
		loop(j,MAXROWS)
		{
			c=get_cell(w,i,j);

			if (c)
				if ((*act)(w,c))
					return c;
		}
	return nil;
}

static
char *cell_str(int col,int row)
{
	static char s[DEFCOLW];

	sprintf(s,"%s%d",cbr(col,2,' ',LETTERS),row+1);
	return s;
}

global
char * is_label(char *s, int *ty)
{
	static char ide[128];
	char *st = ide;

	while (*s >= 'a' and *s <= 'z')
		*st++ = *s++;
	*st = 0;
	ide[31] = 0;

	if (ty)
	{
		if (*s eq '-' and *(s+1) eq '>')
			*ty = FUN;
		elif (*s eq ':' and *(s+1) eq ':')
			*ty = LAB;
		else
			*ty = 0;
	}

	return ide;
}

static
IDES * store_ide(IDES *ides, char *ide, int ty, int col, int row)
{
	IDES *id = ides;

	if (ty)
	{
		while (id)
		{
			if (strcmp(id->name, ide) eq 0)		/* replace old */
			{
				strcpy(id->name, ide);
				id->col = col;
				id->row = row;
				id->ty =ty;
				return ides;
			}
			id = id->next;
		}

		id = mmalloc(sizeof(IDES),
				"while allocating identifier","Abondoned", AH_IDE);
		if (id)
		{
			id->next = ides;
			strcpy(id->name, ide);
			id->col = col;
			id->row = row;
			id->ty = ty;
/*			sprintf(ide, "[1][ store: %s | %d,%d ][ Ok ]", id->name, id->col, id->row);
			form_alert(1, ide);
*/			ides = id;
		}
	}

	return ides;
}

static
void free_ides(IDES *ides)
{
	while(ides)
	{
		IDES *nx = ides->next;
		free(ides);
		ides = nx;
	}
}

static
void recalc(IT *w)
{
	int i, j;
	CELL c;

/*	free_ides(w->ides);
	w->ides = nil;
*/	loop(j, MAXROWS)
		loop(i, MAXCOLS)
			if ( (c = get_cell(w, i, j)) ne nil)
			{
				int ty;
				char *s = c->text;
				char *ide = is_label(s, &ty);

				sh_col = i, sh_row = j;

				c->ty = ty;

				if (ty)
					w->wks.ides = store_ide(w->wks.ides, ide, ty, i, j);

				if (!(c->attr eq VAL and *c->text eq 0))		/* mostly older sheets */
				{
					if (ty eq LAB)
						s += strlen(ide) + 2;
					c->val = shparse(w->wks.tab, w->wks.ides, s, &c->attr);
				}
			}
}

static
OB_PLACE sh_place
{
	w->dial.ob->x=w->ma.x-LEFTMARGIN;
	w->dial.ob->y=w->ma.y+w->ma.h+1;
	wdial_edob(w,w->dial.edob);
}

static
void disp_edit(IT *w)
{
	int col=w->cu.s-1,
		row=w->cu.l-1;
	CELL c=get_cell(w,col,row);

	strcpy(c_str->text,cell_str(col,row));

	if (w->wks.editing)
		strcpy(ed_str->text,w->wks.edstr);
	else
	if (c)
	{
		switch(c->attr)
		{
		case TXT:
			strcpy(ed_str->text,c->text);
			strcpy(ty_str->text,"text:");
		esac
		case VAL:
			if (c->text and *c->text)
				strcpy(ed_str->text,c->text);
			else
				sprintf(ed_str->text,"%g",c->val);
			strcpy(ty_str->text,"value:");
		esac
		case FORM:
			strcpy(ed_str->text,c->text);
			strcpy(ty_str->text,"formula:");
		esac
		case FUN:
			strcpy(ed_str->text,c->text);
			strcpy(ty_str->text,"function:");
		esac
		}
		strcpy(w->wks.edstr,ed_str->text);
	othw
		*ed_str->text=0;
		strcpy(ty_str->text,"empty!");
		*w->wks.edstr=0;
	}

	via (w->dial.place)(w);
}

static
void sh_dcell(IT *w,int i,int j,bool hide)		/* top and j starts at 1 */
{
	char s[MAXINPUT+1];
	int x=w->ma.x+(i- w->left  )*w->w,		/* w in pixels ! */
		y=w->ma.y+(j-(w->top-1))*w->h,
		cm=w->w/deskw.w;

	CELL c=get_cell(w,i,j);

	if (c)
	{
		switch(c->attr)
		{
		case TXT:
		case FUN:
			strcpy(s,c->text);
		esac
		case VAL:
			sprintf(s,"%g",c->val);
			*(s+cm)=0;
		esac
		case FORM:
			sprintf(s,"%g",c->val);
			*(s+cm)=0;
		esac
		}

		if (hide)
			hidem;
		f_txt(v_hl,x,y,s);
		if (hide)
			showm;
	}
}

DRAW sh_disp		/*	(IT *w,RECT t2)	*/
{
	int i,j;

	hidem;
	cur_off(w);
	if (w->wks.editing)
		wdial_off(w);

	gspbox(v_hl,w->wa);

	if (w->left+w->ww > w->wm)
		w->left=w->wm-w->ww;

	for(i=w->left; i<w->left+w->ww; i++)
	{
		f_txt(v_hl,w->ma.x+(i-w->left)*w->w,
				 w->wa.y,
				 cbr(i,DEFCOLW/2-1,' ',LETTERS)
			 );

		for(j=w->top-1; j<w->top +w->hw-1; j++)
		{
			if (i eq w->left)
				f_txt(v_hl,w->ma.x-LEFTMARGIN,
						 w->ma.y+(j-(w->top-1))*w->h,
						 cbdu(j+1,2,' ')
					 );
			sh_dcell(w,i,j,NO_HIDE);
		}
	}

	line(v_hl,w->wa.x,
			w->ma.y-1,
			w->wa.x+w->wa.w-1,
			w->ma.y-1);
	line(v_hl,w->ma.x-deskw.w/2-1,
			w->ma.y,
			w->ma.x-deskw.w/2-1,
			w->ma.y+w->ma.h-1);
	line(v_hl,w->wa.x,
			w->ma.y+w->ma.h,
			w->wa.x+w->wa.w-1,
			w->ma.y+w->ma.h);

	disp_edit(w);
	draw_ob(ed,0,t2);

	if (w->wks.editing)
		wdial_on(w);

	cur_on(w);
	showm;
}

ANTEVNT sh_evm		/* IT *w; bool w_on, short evmask */
{
	evmask|=MU_KEYBD|MU_M1;
	if (w_on)
		evmask|=MU_BUTTON;
	if (w->wks.editing)
		evmask=wdial_evm(w,w_on,evmask);
	return evmask;
}

static
SHEET_ACT unflag
{
	c->flags&=~ISMOD;
	return false;
}

static
FILE *uf = nil;
char *attrs[]={"TXT","VAL","FOR","FUN"};

static
SHEET_ACT unloadcell		/* struct it *w, CELL c */
{
	fprintf(uf,"cel=%d/%d,\t%s=",
		c->col,
		c->row,
		attrs[c->attr]);

	switch(c->attr)
	{
	case FUN:
	case TXT:
		fprintf(uf,"%ld:%s",strlen(c->text),c->text);
	esac
	case VAL:
	{
		char *t = c->text;
		if (t eq nil)
			t = "";
		fprintf(uf,"val=%g,txt=%ld:%s",
			c->val,strlen(t),t);
	}
	esac
	case FORM:
		fprintf(uf,"val=%g,for=%ld:%s",
			c->val,strlen(c->text),c->text);
	esac
	}
	fprintf(uf,"\n");
	return false;
}

static
void savesheet(IT *w,char *fn,bool force)
{
	struct sheet *k = &w->wks;
	if (w->ismod or force)
	{
		k->head.cols = MAXCOLS;
		k->head.rows = MAXROWS;
		k->head.colwsize = MAXCOLS;

		uf = fopen(fn, "w");
		if (!uf)
			alertm(frstr(FNOP), fn);
		else
		{
			w->fl = 6;
			fprintf(uf, "HR95sheet=%d/%d,cws=%d;\n",
				k->head.cols,
				k->head.rows,
				k->head.colwsize	);
			tab_loop(w, unloadcell);
			fprintf(uf, "end_HR95sheet\n");
			fclose(uf);

			tab_loop(w, unflag);
			w->ismod = false;
			w->tx=' ';
			w->tu=' ';
			set_wi_titel(w);
		}
	}
}

static
void savesheetas(IT *w)
{
	char *fn;
	if (w)
		if ( (fn = select_file(&idir,nil,&fsel," Save sheet as .WKS",&drive)) ne nil)
		{
			savesheet(w,fn,true);
			strcpy(w->title,fn);
			set_wi_titel(w);
		}
}

static
bool check_shsave(IT *w)
{
	if (w->ismod)
	{
		switch(alertm(frstr(ALCHA)))		/* 2 in testfase anders 1 (Save) */
		{
		case 1:
			savesheet(w,w->title,true);
		case 2:
			return true;			/* close without save */
		case 3:
			return false;			/* cancel */
		}
	}
	return true;		/* yes can close */
}

static
bool close_sheet(IT *w, bool force)
{
	if (!(force or check_shsave(w)))
		return false;

	cur_off(w);
	w->cu = c1st;
	w->left = 0;

	free_ides(w->wks.ides);
	tab_loop(w, free_cell);

	free(w->wks.tab);
	close_w(w);
	w->fl = 0;

	stmdelcur(&winbase);
/*	if (!w_handles(whs,no_dial))
		en_file(false);
*/	return true;
}

CLOSED sh_close
{
	if (close_sheet(w,false))		/* do not force */
		if (!w_handles(nil,no_dial))
			close_dials();
}

static
void do_shFile(IT *w, int mt)
{
	switch(mt)
	{
	case MNCSAVE:
		savesheet(w, w->title, false);	/* false = don't force */
	esac
	case MNCSAVES:
		savesheetas(w);
	esac
/*	case MNCPRI:
	esac
*/
	case MNCRECALC:
		recalc(w);
		do_redraw(w, w->wa);
	esac
	case MNCLRV:
	{
		CELL c;
		int i, j;
		loop(i, MAXCOLS)
			loop(j, MAXROWS)
			{
				c=get_cell(w, i, j);

				if (c)
					if (c->attr eq VAL)
					{
						if (c->ty)			/* keep the labels */
						{
							char *s = c->text;

							while (*s)
								if (*s eq ':' and *(s + 1) eq ':')
									break;
								else
									s++;

							if (*s eq ':')
							{
								*(s + 2) = '0';
								*(s + 3) = 0;
							}

							c->val = 0.0;
						othw
							free_cell(w, c);
							get_cell(w, i, j )= nil;
						}
						set_X(w);
					}
			}

		recalc(w);
		do_redraw(w, w->wa);
	}
	esac
	case MNCCLOSE:

		wmenu_tnormal(w,MTC1,true); /* before its gone */

		if (w)
			if (w->closed)
				(*w->closed)(w);
		return;
/*	case MNCABAN:
		abandonsheet(w);
	esac
*/	}

	wmenu_tnormal(w,MTC1,true);
}

static
CELL change_cell(IT *w, CELL n, int ty, int col, int row)
{
	CELL c;

	n->ty = ty;
	n->col = col;
	n->row = row;
	n->flags = ISMOD;
	w->ismod = true;

	c = (CELL)mmalloc(sizeof(SH_CELL),
					"while allocating cell.", "action cancelled", AH_CHCELL);
	if (c)
	{
		CELL o=get_cell(w, col, row);

		if (o)
			free_cell(w, o);

		get_cell(w, col, row) = c;
		memmove(c, n, sizeof(SH_CELL));
	}

	return c;
}

static
void do_shEdit(IT *w, int mt)
{
	CELL c;
	sh_col = w->cu.s - 1,
	sh_row = w->cu.l - 1;

	switch (mt)
	{
	case MNCCOPY:
		c = get_cell(w, sh_col, sh_row);
		if (c)
			buf = *c;
	esac;
	case MNCCUT:
	case MNCDEL:
		c = get_cell(w, sh_col, sh_row);
		if (c)
		{
			buf = *c;
			free_cell(w, c);
			get_cell(w, sh_col, sh_row) = nil;
			w->ismod = true;
			recalc(w);
			set_X(w);
			do_redraw(w,w->wa);
		}
	esac;
	case MNCPASTE:
		if (change_cell(w, &buf, 0, sh_col, sh_row))
		{
			recalc(w);
			set_X(w);
			do_redraw(w,w->wa);
		}
	esac;
	}
	wmenu_tnormal(w,MTCEDIT,true);
}

static
MENU_DO do_wshmenu
{
#if defined MTC1
		if ( mn eq MTC1		) do_shFile	(w, mt);
#endif

#if defined MTCEDIT
		if ( mn eq MTCEDIT	) do_shEdit	(w, mt);
#endif
	return true;
}

BUTTON txt_click;

static
BUTTON do_shbutton		/* (IT *w, short button, short kstate,
                                           short bclicks,
                                           short mx, short my);	*/
{
	if (!w->wks.editing)
	{
		w->wks.editing = objc_find(w->dial.ob,0,MAX_DEPTH,mx,my) eq SH_EDSTR ? w->dial.edob : 0;
		w->dial.edon = ON;
		wdial_xytoi(w,mx,my);	/* set appropriate variable in w */
		wdial_itotmpl(w);
		wdial_on(w);
	}
	else
		wdial_button(w,button,kstate,bclicks,mx,my);

	if (!w->wks.editing)
	{
		wdial_off(w);
		w->dial.edon = OFF;
		keusaf(ed[SH_CSTR]);
		txt_click(w,1,NO_DRAG,1,mx,my);  /* left button, no state or drag, 1 click */
		disp_edit(w);
		wdial_draw(w,0);
		w->wks.editing = bclicks eq 2 ? w->dial.edob : 0;

		if (bclicks eq 2 or button eq 2)		/* same as ESC */
		{
			w->wks.editing=w->dial.edob;
			w->dial.edon = ON;
			wdial_itotmpl(w);
			wdial_on(w);
		}
	}
}

bool do_cursor(IT *w,int kcode);

static
KEYBD do_shkeybd 			/*	w,kcode		*/
{
	if (w->wks.editing)
		wdial_keybd(w,kcode);
	else
	{
		keusaf(ed[SH_CSTR]);
		if (kcode < 0 and (kcode&0xff) eq NK_ESC)
		{
			w->wks.editing=w->dial.edob;
			w->dial.edon = ON;
			wdial_itotmpl(w);
			wdial_on(w);
		othw
			cur_off(w);
			do_cursor(w,kcode);
			disp_edit(w);
			wdial_draw(w,0);
			cur_on(w);
		}
	}
}

static
DEXIT sh_edend
{
	SH_CELL n;			/* new cell */
	double v;
	char *s = ed_str->text;

	w->wks.editing = 0;
	wdial_off(w);
	w->dial.edon = OFF;
	keusaf(ed[SH_CSTR]);

	if ( (obno&0xff) eq SH_CSTR)		/* exit with return or click on cell name */
	{
		int ty; char *ide;
		int col = w->cu.s-1,
			row = w->cu.l-1;

		strcpy(n.text, s);

		if (*s)
		{
			sh_col = col, sh_row = row;		/* for bip's */
			ide = is_label(s, &ty);
			if (ty)
			{
				w->wks.ides = store_ide(w->wks.ides, ide, ty, col, row);
				if (ty eq LAB)
					s += strlen(ide) + 2;
			}

			v = shparse(w->wks.tab, w->wks.ides, s, &n.attr);

			switch (n.attr)
			{
			case FUN:
			case TXT:
				n.val = 0;
			esac
			case VAL:
			case FORM:
				n.val = v;
			esac
			}

			strcpy(w->wks.edstr, s);

			if (change_cell(w, &n, ty, col, row))
				set_X(w);
		othw								/* clear cell */
			CELL c = get_cell(w, col, row);
			if (c)
			{
				free_cell(w, c);
				get_cell(w, col, row) = nil;
				set_X(w);
				w->ismod = true;
			}
		}

		recalc(w);
		do_redraw(w, w->wa);
	}
}

global
OpEntry wkstab[]=
{
	{"FILE= {}\n",0,file_cfg,0,0},	/* this one is not written; it only starts the recursion */
	{"\0"}
};

void load_sheetconfig(void)			/* files only */
{
	FILE *fp;
	setfn = dir_plus_name(&ipath, cfgname());

	fp = fopen(setfn.s,"r");
	if (fp ne nil)
	{
		loadconfig(fp,wkstab,0,false);
		fclose(fp);
	}
}

void save_sheetconfig(void)
{
	FILE *fp = fopen(setfn.s,"w");
	if (fp ne nil)
	{
		saveconfig(fp,wkstab,0,false);
		fclose(fp);
	}
}

static
WINIT sheet_winit
{
	w->in = overlap();
	snapwindow(w,&w->in);	/* !!! gebruikt slechts w->v !!! */
								/* mooi he? */
	w->frem=wwa;
	snapwindow(w,&w->frem);		/* snap fulled height */
}

MUIS m_pijl		/* IT *w */
{
	graf_mouse(0,nil);
}

IT *create_sheetw(
			bool cre,
			char *name,
			char *info,
			int fl,
			long mapl
		)
{
	sheetmargin.x = LEFTMARGIN+deskw.w/2;
	sheetmargin.y = TOPMARGIN+2;
	sheetmargin.h = ed->h + 2; /* deskw.h+2; */
	return
	create_IT	(	cre,
					name,
					fl,
					info,
					nil,
					WKIND | (diagnostics ? INFO : 0),
					CALC,
					ed,				/* object (edit regel) */
					sh_place,		/* place edit line after size or move or full */
					0,
					sheet_winit,
					sh_edend,
					nil,				/* antedraw */
					sh_disp,		/* draw */
					nil,				/* postdraw */
					sh_evm,			/* ante event */
					nil,
					nil,				/* disp line */
					nil,				/* ante, - */
					nil,				/* post  display	*/
					sh_close,
					close_sheet,
					nil,
					fullwindow,
					slidewindow,
					v_slider,
					arrowwindow,
					sizewindow,
					movewindow,
					do_shbutton,
					do_shkeybd,
					nil,				/* ed_key implicit (NO ROM sheets) */
					nil,				/* timer */
				#ifdef WMENU
					menu_draw,
					do_wshmenu,
					nil,
					&cmen,
				#else
					nil,
					do_wshmenu,
					nil,
					nil,
				#endif
					sheet_select,			/* NO selection (yet), only cursor */
					sheet_deselect,
					write_select,
					win_cursor,
					m_pijl,
					nil,
					mapl,
					deskw.w*DEFCOLW,
					deskw.h,
					deskw.points,
					nil,
					sheetmargin
				);
}

extern int colspace,rowspace;

FOPEN open_sheet
{
	int i,j;

	IT *w;
	FILE *fx = fopen(fn,"r");		/* existence allready checked */

	if (!ed)
		rsrc_gaddr(0,SH_EDOB,&ed);

	c_str   = get_tedinfo(ed,SH_CSTR);
	ty_str  = get_tedinfo(ed,SH_TYSTR);
	ed_str  = get_tedinfo(ed,SH_EDSTR);
#ifdef SH_LBLSTR
	lbl_str = get_tedinfo(ed,SH_LBLSTR);
#endif

	if ( (w=create_sheetw(
				true,
				fn,
				" ",
				0,
				0
				)
		 ) eq nil )
		alertwindow("sheet");
	else
	{
		SH_SHEET t;
		SH_CELL c;
		char cellty[8];

		c.col=-1;
		c.row=-1;

		if ( (t=(SH_SHEET)mmalloc(sizeof(SH_TAB),
				"while allocating table","Abondoned", AH_SHEET)) <= 0)
		{
			close_w(w);
		othw
			int scn;

			w->wks.ides = nil;

			w->wks.tab=t;

			loop(i,MAXCOLS)
				loop(j,MAXROWS)
					(*t)[i][j]=nil;

			scn = fscanf(fx,"HR95sheet=%d/%d,cws=%d;\n",
				&w->wks.head.cols,
				&w->wks.head.rows,
				&w->wks.head.colwsize	);

			do
			{
				void *new;
				char *ide; int ty;

				memset(&c,0,sizeof(c));
				scn = fscanf(fx,"cel=%d/%d,\t",&c.col,&c.row);
				if (scn ne 2)
					break;
				if (   c.col < 0 or c.col > MAXCOLS
					or c.row < 0 or c.row > MAXROWS)
					break;

				strcpy(cellty,"1234567");
				c.val = 0;
				c.size = 0;
				scn = fscanf(fx,"%[^=]=",cellty);

				if   (strcmp(cellty,attrs[0]) eq 0)
				{
					c.attr = TXT;
					scn = fscanf(fx,"%d:%[^\n]\n",&c.size,c.text);
				}
				elif (strcmp(cellty,attrs[1]) eq 0)
				{
					c.attr = VAL;
					scn = fscanf(fx,"val=%lg",&c.val);
					if (scn > 0)
						scn = fscanf(fx,",txt=%d:%[^\n]\n",&c.size,c.text);
					else
						scn = fscanf(fx,"%lg\n",&c.val);
				}
				elif (strcmp(cellty,attrs[2]) eq 0)
				{
					c.attr = FORM;
					scn = fscanf(fx,"val=%lg,for=%d:%[^\n]\n",&c.val,&c.size,c.text);
				othw
					c.attr = FUN;
					scn = fscanf(fx,"%d:%[^\n]\n",&c.size,c.text);
				}

				ide = is_label(c.text, &ty);
				if (ty)
					w->wks.ides = store_ide(w->wks.ides, ide, ty, c.col, c.row);

				c.ty = ty;
				c.flags=0;

				new = xmalloc(sizeof(SH_CELL), AH_CELL);
				if (new)
				{
					memmove(new,&c,sizeof(SH_CELL));
					(*t)[c.col][c.row] = new;
				othw
					alertm("| Not enough memory | for cell %d/%d", c.col, c.row);
					break;
				}
			}od

			fclose(fx);
			w->ismod = false;
			w->wm=MAXCOLS-1;
			w->n =MAXROWS;
/*			en_file(true);
*/			w->op=wind_open(w->wh, w->in.x, w->in.y, w->in.w, w->in.h);
			get_work(w);
			wind_set(w->wh,WF_TOP);
			w->wks.editing=0;
			rowspace=denotation_space(MAXROWS,10);
			colspace=denotation_space(MAXCOLS,LETTERS);
			cur_on(w);			/* because no timer for sheets */
		}
	}
}
