/* Copyright (c) 1990 - 2008 by H. Robbers Amsterdam.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *	GEMSHELL.C
 *  ==========
 */

#include <stdlib.h>				/* for free() */
#include <ctype.h>
#include <ext.h>

#include "common/mallocs.h"
#include "common/aaaa_lib.h"
#include "common/hierarch.h"

#include "aaaa.h"
#include "common/kit.h"
#include "text/text.h"
#include "text/text_cfg.h"
#include "shlcfg.h"
#include "xref.h"
#include "sheldefs.h"
#include "shell.h"
#include "common/journal.h"
#include "common/ipff.h"
#include "common/hierarch.h"
#include "ahcc/peepstat.h"

extern OBJECT *menu;

/* If the program is started with an argument
	we want start with that file,
	not with the initial journal message,
	so this bool is defined by FILES.C */
extern bool init_open_jrnl;
extern OpEntry shel_tab[];

void dial_b2(void);
void free_cache(short);

static
S_path mksel={""};

global
COPRMSG shell_msg=
/*            1         2         3         4         5         6         7
     123456789012345678901234567890123456789012345678901234567890123456789012		*/
{
	"           " PRGNAME " V4.6 = Sozobon ANSI C",
	"ANSI and GEM integration: (c) 2011 by H. Robbers A'dam.",
    "            Using Harald Siegmunds NKCC.",
	"-------------------------------------------------------",
	"",
	nil
};

void do_Scopyright(void)
{
	do_init_text(nil, nil, shell_msg);
/*	send_msg("\nPure C version: %x\nTurbo C version: %x\n", __PUREC__, __TURBOC__);
*/	send_msg("\n");
}

bool check_modified(char *fn);

global
void menu_prj(char *pn)
{
#ifdef MNDISPLAY
	char *p, *mnd = menu[MNDISPLAY].spec.free_string;
	MAX_dir fn;
	strcpy(fn, getfn(mkfn.s));
	p = getsuf(fn);
	if (p)
		*(p-1) = 0;
	fn[menu_prj_l - 3] = 0;
	strcpy(mnd + 2, fn);
#endif
}

global
void menu_ides(short ides)
{
#ifdef MNSIDE
	char *mni = menu[MNSIDE].spec.free_string;
	short l = sprintf(mni + 2, "%6d", ides);
	*(mni + 2 + l) = ' ';
#endif
}

#if JOURNAL
extern
char *Found ,
     *Scanning;

extern
char fkey[];
extern
short skl,fls,fds;
extern IT *jrnlwin;

void find_project(void)
{
	if (auto_dependencies)
	{
		short i;
		DEP *ft;
		jrnlwin = get_it(-1,JRNL);
	
		fls=0, fds=0;
		strcpy(fkey, get_fistr(0));
		skl = strlen(fkey);
		if (skl)
		{
			if (!cfg.csens)
				loop(i,skl)
					fkey[i]=tolower(fkey[i]);
	
			qpfind_prepare(skl, (ustring)fkey);
	
			send_msg("Looking for '%s' in project (%c %c)\n",
				get_fistr(0), cfg.wrd ? 'W' : ' ', cfg.csens ? 'C' : ' ');
	
			ft = auto_dependencies;
			while (ft)
			{
				if (scan_file(ft->data->name))
					break;
	
				ft = ft->next;
			}
	
			send_msg("%d in %d file%s\n",fds,fls,pluralis(fls));
		}
		else
			send_msg("find empty string\n");
	}
	else
		send_msg("Project help not active\n\tor no database (.ADB) file present\n");
}
#endif

static
DOSTIME tostime(void)	/* tbv touch.
						 * Dit alles allen maar om datum en tijd om te
						 * draaien! terwijl pv310c's Gettime het spul in de
						 * goede volgorde levert.
						 * NL de datum voorop.
						 * Eenmaal goed bedacht, worden de dingen wegens
						 * domheid van ijverige software makers weer
						 * verpest, zodat luie gebruikers onnodig toch hard
						 * moeten werken en het risico lopen alsnog voor lui
						 * gehouden te worden.
						 */
{
	union
	{	long l;
		struct
		{	unsigned short date,
						 time;
		} kbdt;
	} tost;

	DOSTIME t;

	tost.l=Gettime();
	(unsigned)t.date=tost.kbdt.date;
	(unsigned)t.time=tost.kbdt.time;
	return t;
}

#ifdef MTPRJ
global
bool do_shell(short mn, short mt)
{
	void open_text_file(char *fn);

	switch(mn)
	{
	#ifdef MTSHELL
		#include "mtshell.h"		/* discarded touch, delete, info & rename */
	#endif
		case MTPRJ:
		switch(mt)
		{
			case MNCOOPT:
				kit_dial(nil, 0, MNCOOPT);
			esac
#ifdef MNPROJ
			case MNPROJ:
				kit_dial(nil, 0, MNPROJ);
			esac
#endif
#ifdef MNDOWN
			case MNDOWN:
				clear_help_stack();
			esac
#endif
			case MNLMAKE:
			{
				char *f;
				S_path dir;
				DIRcpy(&dir, mkpad.s);
				DIRcat(&dir, "*.prj");
				f = select_file(&dir, &mkpad, &mksel, "find project:", &drive);
				if (f)
					loadmake(f, 0);
			}
			esac
			case MNEDPRJ:
				if (*mkfn.s)
					open_text_file(mkfn.s);
			esac
			case MNRELOAD:
				if (*mkfn.s)
					loadmake(mkfn.s, 0);
			esac
#ifdef MNLFOLD
			case MNLFOLD:
			{
				char *f;
				char * makefrfold(char *);
				f = select_file(&idir, nil, &fdum, "find folder:", &drive);
				if (f)
				{
					send_msg("idir '%s' fdum '%s'\n", idir.s, fdum.s);
					f = makefrfold(idir.s);
					if (f)
						send_msg("constructed %s\n", f);
				}
			}
			esac
#endif
#ifdef MNSDEP
			case MNSDEP:
			{
				if (auto_dependencies or prj_dependencies)
				{
					send_msg("\nPRJ dependencies:\n");
					xref_list_files(stdout, prj_dependencies, 0);
					send_msg("end of list\n\n");
					send_msg("\nAuto dependencies:\n");
					xref_list_files(stdout, auto_dependencies, 0);
					send_msg("end of list\n\n");
				}
				else
					send_msg("no dependency information\n");
			}
			esac
#endif
#ifdef MNSIDE
			case MNSIDE:		/* show identifiers from help database */
			{
				if (SHL_cfg.ah_project_help)
				{
					if (identifiers.first)
					{
						extern char msg_tab[];
						send_msg("%d identifiers\n", identifiers.last ? identifiers.last->n : 0);
			
			#if 1
						*msg_tab = ' ';
						xref_list_ordered(stdout, identifiers.cur, ' ', 0);
						*msg_tab = '\t';
			#else
						xref_list_ides(stdout, identifiers.first);
			#endif
					}
					else
						send_msg("no identifiers present; Try 'Make All'\n");
				}
				else
					send_msg("no project help active\n");
			}
			esac
#endif
			case MNASSEM:
			case MNCOMP:
			{
				IT *w=get_top_it();
				if (!w)
					break;
#if PCNT_SAMPLE
				clr_pcnts();
#endif
				do_compile(&root_project, w->title);
				free_cache(4);
			}
			esac

			case MNASSEMF:
			{
				char *f;

				idir = change_suffix(&idir, sufs.s);
				if (*fsel.s)
					fsel = change_suffix(&fsel, sufs.s);
				f = select_file(&idir, nil, &fsel, "assemble:", &drive);
#if PCNT_SAMPLE
				clr_pcnts();
#endif
				do_compile(&root_project, f);
				free_cache(5);
			}
			esac

			case MNCOMPF:
			{
				char *f;

				idir = change_suffix(&idir, sufs.c);
				if (*fsel.s)
					fsel = change_suffix(&fsel, sufs.c);
				f = select_file(&idir, nil, &fsel, "compile:", &drive);
#if PCNT_SAMPLE
				clr_pcnts();
#endif
				do_compile(&root_project, f);
				free_cache(7);
			}
			esac
			case MNMAKE:
#if 0 /* DEBUG */
				if (!warn_opt())
#endif
				{
#if PCNT_SAMPLE
					clr_pcnts();
#endif
					domake(&root_project);
					free_cache(1);
				}
			esac

			case MNMAKEAL:
#if PCNT_SAMPLE
				clr_pcnts();
#endif
				send_msg("\nMake all %s\n", mkfn.s);
				loadmake(mkfn.s, 1);		/* clean, dont load ADB */
				domakeall(&root_project);
				free_cache(2);
			esac
#if BIP_LD
			case MNLINK:
				dold(&root_project);
			esac
#endif
		}
		menu_tnormal(menu, MTPRJ, true);
		esac

#ifdef MTDEBUG
		case MTDEBUG:
		switch (mt)
		{
#if defined BUGGER && defined CODBG && DEBUG
			case CODBG:
				dial_b2();
			esac
			case DBGTXT:
				open_text_file("bugflags.txt");
			esac
#endif
			default:
				opt_to_cfg(shel_tab, mt, AMENU, nil, menu);
		}

		menu_tnormal(menu,MTDEBUG,true);
		esac
#endif
		default:					/* for menu title */
			return false;
	}

	return true;
}
#endif

global
void init_shell(void)
{
	gsclip(v_hl,1,scr_grect);

	kit_for_shell();
	xref_init();
	remove_project();
	menu_help(false);
}

#if JOURNAL
global
void show_its(void)
{
	IT *w;
	STMC *ws;

	send_msg("--== IT's ==--\n");
	ws=stmfifirst(&winbase);
	while (ws)
	{
		w=ws->wit;
		send_msg("%s\tfl:%d,wh:%d\n", w->title, w->fl, w->wh);
		stmakecur(&winbase,ws);		/* send_msg() changes currency in winbase */
		ws=stmfinext(&winbase);
	}
	send_msg("--== end ==--\n");
}
#endif
