/* Copyright (c) 1990 - 2008 by H. Robbers Amsterdam.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* 	AAAA.C
 *	=====
 */

#include <string.h>

#include "common/aaaa_lib.h"
#include "common/hierarch.h"

#include "aaaa.h"

#if GEMSHELL || TEXTFILE || BINARY
#include "common/kit.h"
#endif

#if TEXTFILE
#include "text/cursor.h"
#include "text/text.h"
#include "text/text_cfg.h"
#include "text/editor.h"
#endif

#include "shell/shell.h"
#include "common/files.h"
#include "common/options.h"
#include "common/journal.h"
#include "common/wdial.h"
#include "common/ahcm.h"

#if DIGGER
#include "digger/ttd_kit.h"
#include "digger/ttd_cfg.h"
#include "digger/dig.h"
#include "digger/digobj.h"
#endif

#if BINARY
#include "bined/ed.h"
#endif

#if WKS
extern M_S cmen;
FOPEN	open_sheet;
VpV load_sheetconfig, save_sheetconfig;
#endif

#if MFRAC
#include "mandel/mandelbr.h"
#endif

/*  GLOBALS  */

global
short
	aaaa_id=0,
	aes_flags=0,
	aes_font=1,
	aes_font_height=13;

char diam[MAXL+1];
char *global_message = nil;

STMDEF winbase;
STBASE *txtfreebase=0L;			/* STore Manager Cell's and area's */

short v_hl,				/* VDI handle's for normal font */
	  points,hpoints;	/* points for font & half font */

extern bool _nova,_t2w,MagX,MiNT;		/* ex SCR_INST */

short wchar,hchar;		/* tbv oude &| toplevel s/w */

#ifdef MNDISPLAY
short menu_prj_l;
#endif

MFORM lowpijl =
{
	3,3,1,0,1,
  { 0x0000, 0x0000, 0x3800, 0x3E00,
	0x3F80, 0x3FE0, 0x3FF8, 0x3FFC,
	0x3FF8, 0x3FE0, 0x39F0, 0x38F8,
	0x0078, 0x0000, 0x0000, 0x0000 },
  { 0x0000, 0x0000, 0x0000, 0x1800,
	0x1E00, 0x1F80, 0x1FE0, 0x1FF8,
	0x1F80, 0x1DC0, 0x10E0, 0x0070,
	0x0000, 0x0000, 0x0000, 0x0000 }
};

VpV marrow
{
	if (hchar > 8)
		graf_mouse(0,0L);
	else
		graf_mouse(USER_DEF,&lowpijl);
}

IT deskw;

OBJECT  *menu;

M_S	mainmenu={false,false,0,0,0,0,0,0,0,0L,0L};

bool showchange=false;

/*  COMMONS  */

static STBASE  *winfreebase=0L;
OBJECT  *tit=0L;

#ifndef WINTEXT
void f_txt(short hs,short x,short y,char *text)
{
	x&=0xfff8;
	v_gtext(abs(hs),x,y,text);
}
#endif

global
char *frstr(short ob)
{
	char *s;
	rsrc_gaddr(R_STRING,ob,&s);
	return s;
}
#ifdef STRINGS
global
char *obstr(short ob)
{
	static OBJECT *o=nil;
	if (o eq nil)
		rsrc_gaddr(0,STRINGS,&o);
	return o[ob].spec.free_string;
}
#endif

/*  This function is NOT for determining THE half font height,
 *	but only to divide the large font, if there is one.
 *	Consequently it can be used to ask if the latter is the fact.
 */

global
short half_h(void)
{
	return hchar > wchar ? hchar/2 : hchar;	 /* if font square, no small */
}


global
short (*alert_cur)(short,const char *) = form_alert;

global
short alert_msg(char *t, ... )
{
	char m[256], *mp=m;
	va_list a;
	va_start(a,t);
	if (*t ne '[')		/* This for security reasons only */
	{
		mp+=sprintf(mp,"[1][ ");
		mp+=vsprintf(mp,t,a);
		sprintf(mp," ][ Ok ]");
	}
	else
		vsprintf(mp,t,a);
	va_end(a);
	return (*alert_cur)(1,m);
}

global
short alert_text(char *t, ... )
{
	char m[256], *mp=m;
	va_list a;
	va_start(a,t);
	if (*t ne '[')		/* This for security reasons only */
	{
		mp+=sprintf(mp,"[1][ ");
		mp+=vsprintf(mp,t,a);
		sprintf(mp," ][ Ok ]");
	}
	else
		vsprintf(mp,t,a);
	va_end(a);
	return form_alert(1,m);
}

#ifndef JOURNAL
global
short alert(char *t, ... )
{
	char m[256];
	va_list a;
	va_start(a,t);
	vsprintf(m,t,a);
	va_end(a);
	return (*alert_cur)(1,m);	/* current alert s/w */
}
#endif

bool m_alerted=false;

global
void mem_alert(char *op1, char *op2)
{
	if (!m_alerted)
	{
#ifdef JOURNAL
		alert_jrnl("%s %s\n\t%s",frstr(RANOUT),op1 ? op1 : "",op2 ? op2 : "");
#else
		alert("%s %s\n\t%s",frstr(RANOUT),op1 ? op1 : "",op2 ? op2 : "");
		m_alerted = true;
#endif
	}
}

global
void *mmalloc(long l, char *op1, char *op2, short key)
{
	char *al;

	al=xmalloc(l,key);
	if (al <= 0L)
		mem_alert(op1,op2);
	else
		m_alerted=false,
		*al=0;				/* nicely deliver a null string */
	return al;
}

static
void do_dial(OBJECT *ob,short f)		/* alleen voor dialogues zonder form_save */
{
	form_dial(f,0,0,0,0,ob->x-3,ob->y-3,ob->w+6 pdial,ob->h+6 pdial);
}

#ifdef HELP
global
void start_help(char *word)		/* triggered by HELP key */
{							/* help context is future enhancement */
	char helpname[DIR_MAX*2+1];
	char *message;
	static union
	{
		short b[8];
		struct
		{
			short ty, sender, l;
			char *path;
			char *line;
			short dum;
		} s;
	} buf;

	short ac = appl_find(frstr(GUIDENAME));

	if (ac >= 0)
	{
		message = global_message ? global_message : helpname;

		strmaxcpy(message, frstr(HELPNAME), DIR_MAX);

		if (word and *word)
			if (strlen(word) < DIR_MAX)
			{
				strcat(message, " ");
				strcat(message, word);
			}

		buf.s.line = nil;
		buf.s.path = message;
		buf.s.dum  = 0;
		buf.s.ty   = 0x4711;
		buf.s.sender = aaaa_id;
		buf.s.l = 0;
		ac = appl_write(ac,sizeof(buf.s),buf.b);
		if (!ac)
			alertm(frstr(HELPFAIL));
	}
	else
		alertm("%s -=%s=-", frstr(NOGUIDE), frstr(GUIDENAME));
}
#endif

global
void wwa_align(OBJECT *ob,IT *w)
{	ob->y=w->wa.y+1;
	if (ob->y+ob->h > scr.h)
		ob->y=scr.h-ob->h-1;
}

static
void en_windows(short dis)
{
static short was = -1;
	if (dis ne was)
	{
#ifdef MNCYCL
		menu_ienable(menu,MNCYCL,dis);
#endif
#ifdef MNTILE
		menu_ienable(menu,MNTILE,dis);
#endif
#ifdef MNOVLAP
		menu_ienable(menu,MNOVLAP,dis);
#endif
		was = dis;
	}
}

XA_report punit
{
	printf("**** %s: ", txt);
	if (!unit)
	{
		printf("nil\n");
	othw
		XA_unit *prior = unit->prior, *next = unit->next;
		printf(" -= %d =- u%ld :: s%ld, p:%ld :: %ld, n:%ld :: %ld, block %ld :: s%ld\n",
			unit->key,
			unit, unit->size,
			prior, prior?prior->size:-1,
			next, next?next->size:-1,
			blk, blk->size);
		bios(2,2);
	}
}

global
short eruit(short r)
{
	mpijl;

	if (r ne 2)
	{
	#ifdef GEMSHELL
		end_shell();
		clear_help_stack();
	#endif

	#if TMENU
		if (cfg.a)
			save_txtconfig();
	#elif BMENU
		if (cfg.a)
			save_binconfig();
	#elif WKS
			save_sheetconfig();
	#elif DIGGER
		if (cfg.a)
			save_disconfig();
	#endif

		if (!delete_windows(r))
			return false;			/* if automatic save_files had been cancelled */

	#ifdef KIT
		end_kit();
	#elif TTD_KIT
		end_ttdkit();
	#endif

	#ifdef BOLDTAGS
		XA_free_all(nil, BOLDTAGS, -1);
	#endif

	#ifdef MFRAC
		end_mandel();
	#endif

	#if DIGGER
		end_disass();
	#endif

		menu_bar(menu,false);
		wind_update(END_UPDATE);

		nkc_exit();

		stmclear(&winbase);				/* for internal security */
		rsrc_free();
	#if TEXTFILE || BINARY
		xfree(deskw.loctab, 10);
	#endif
		stmfreeall();		/* free all allocated stmblocks.
				if everything is ok, only the freebases are remaining */

	}

	XA_free_all(&XA_global_base, -1, -1);
	v_clsvwk(v_hl);
	appl_exit();

#if AA_LEAK
	XA_leaked(nil, -1, -1, punit, 1);
	XA_leaked(&XA_file_base, -1, -1, punit, 2);
#endif
/*	XA_free_all(nil, -1, -1);  in _FreeAll */

	if (r)
		exit(r);
	return true;
}

static
void do_Title(void)
{
#ifdef GEMSHELL
	do_Scopyright();
#elif  DIGGER
	do_Ocopyright();
#else
	if (tit)
	{
		do_dial(tit,FMD_START);
		objc_draw(tit,0,2,wwa.x,wwa.y,wwa.w,wwa.h);
		aform_do(tit,0,0L,0,0);
		keusaf(tit[OKT]);
		do_dial(tit,FMD_FINISH);
	}
#endif
}

global
char prg_name[]=PRGNAME;

#if DROPWIN
char drop_name[14];
static
WINIT drop_winit
{
	sprintf(drop_name,"-%s-", prg_name);
	w->in.x = w->w+(w->wh*half_h()); /* next_upper_left? */
	w->in.y = w->h+(w->wh*half_h());
	w->in.w = strlen(drop_name)*w->w+w->v.w;
	w->in.h =                   w->h+w->v.h;
	snapwindow(w,&w->in);
}
static
DRAW  drop_draw
{
	short dum;
	vst_height(w->hl,w->points,&dum,&dum,&dum,&dum);
	hidem;
	if (get_cookie('NVDI',nil))		/* only then it looks good */
	{
		gspbox(w->hl,w->wa);
		vst_effects(w->hl,0x04);
		v_gtext(w->hl,w->wa.x-half_h(),w->wa.y,drop_name);
	}
	else
		v_gtext(w->hl,w->wa.x,w->wa.y,drop_name);
	showm;
	vst_height(w->hl,points,&dum,&dum,&dum,&dum);
	vst_effects(w->hl,0);
}
static
MOVED drop_move
{
	snapwindow(w,to);
	w->rem=*to;
	wind_set(w->wh,WF_CURRXYWH,w->rem);
	wind_get(w->wh,WF_WORKXYWH,&w->wa.x,&w->wa.y,&w->wa.w,&w->wa.h);
}
static
TOPPED drop_top
{
	wind_set(nw->wh,WF_TOP);
}
static
FCLOSE drop_delete
{
	wind_close(w->wh);
	wind_delete(w->wh);
	return true;
}
#endif

global
CFG_LOCAL def_loc =		/* for desk window */
{
	' ', ' ', 4, 4, 1, 4, 0, true, false, true, false,
	{false,0,1,2},		/* scroll info's */
	{true, 1,2,3}
};

static
void set_desk(IT *w)
{
	zero(deskw);
	menu_init(&mainmenu,AMENU,v_hl,scr_grect);
	menu=mainmenu.m;
	w->menu=&mainmenu;

	winfreebase=stminit(&winbase,0L,CYCLIC,sizeof(IT),16);
/*	16 = chunksize; if you open 65 windows 5 chunks will be allocated,
			so dont bother.
*/

	wind_get (0,WF_CURRXYWH,&win.x,&win.y,&win.w,&win.h);	/* cur */
	wind_calc(WC_WORK,NAME|MOVER, win.x, win.y, win.w, win.h,
	                       &wwa.x,&wwa.y,&wwa.w,&wwa.h);	/* wa */

	wwa.x = 0;				/* hack for x & w */
	wwa.w = scr_grect.w;

	wwv.x=win.x-wwa.x;
	wwv.y=win.y-wwa.y;
	wwv.w=win.w-wwa.w;
	wwv.h=win.h-wwa.h;
	w->wh=-1;
	w->type=-1;				/* w->w & w->h  in init_subsystems() */
	w->wm=MAXL;
	strcpy(w->title, " Desktop ");
	w->info[0]=0;
	w->full=true;
	w->fullw=74;
	w->points=points;		/* voorlopig absolute mode */
	w->w=wchar;				/* default unit sizes */
	w->h=hchar;
	w->hl=v_hl;
	w->hw=wwa.h/w->h;
	w->ww=wwa.w/w->w;

/*	Default settings; mostly for options that can be set
	when no window is open.
*/

#if TEXTFILE
	w->loc = txt_local();
#elif BINARY
	w->loc = bin_local();
#elif DIGGER
	dis_local(w);
	w->loc = def_loc;
#endif

#if DROPWIN and defined PRGNAME
	if (MagX or MiNT)
	{
		RECT nomargin = {0,0,0,0};
		IT *w;

		w = create_IT
		   (
			true, "drop", 0 , "", nil,
			NAME|MOVER, DROP, nil, nil, 0, drop_winit, nil, nil,
			drop_draw, nil, nil, nil, nil, nil, nil, nil,
			drop_delete,drop_top, nil, nil, nil, nil, nil,
			drop_move, nil, nil, nil, nil, nil, nil, nil,
			nil, nil, nil, nil, nil, nil, nil, 0L,
			deskw.w*2, deskw.h*2, deskw.points*2,
			nil,nomargin
		   );
		if (w)
		{
			w->op=wind_open(w->wh, w->rem.x, w->rem.y, w->rem.w, w->rem.h);
			if (w->op)
			{
				wind_set(w->wh,WF_NAME,w->title);
				wind_set(w->wh,WF_TOP);
				drop_move(w,&w->in);
				do_redraw(w,w->wa); /* Not yet in eventloop */
			}
		}
	}
#endif
}

static
void init_subsystems(short argc, char *argv[])
{
	short ax,ay;
	vsf_interior (v_hl,FIS_SOLID);
	vsf_style    (v_hl,0);
	vsf_color    (v_hl,0);
	vst_color    (v_hl,1);
	vsf_perimeter(v_hl,0);
	vst_alignment(v_hl,0, 5, &ax, &ay);	/* 5 = top line */

	nkc_init();

	if (MagX or MiNT)
		Pdomain(1);		/* allow long filenames */

	if ( rsrc_load(RSRC_RSC) eq 0)
	{
		form_alert(1, "[3][Geen resource!!][ Ach ]");
		eruit(2);
	}

#ifdef TITEL
	rsrc_gaddr(0,TITEL,&tit);
	tit->x=8;
	tit->y=24;
#endif
	/*	desktop */
	set_desk(&deskw);

#ifdef MTDEBUG
	#if ! DEBUG
		menu[MTDEBUG].state |= DISABLED;
		*menu[MTDEBUG].spec.free_string = 0;
	#endif
#endif

#ifdef MNASSEM
	#if !BIP_ASM
		menu[MNASSEM ].state |= DISABLED;
		menu[MNASSEMF].state |= DISABLED;
	#endif
#endif

#ifdef PRGNAME
	{
		static char mname[12];
		strcpy(mname, " ");
		strncpy(mname + 1, prg_name, 8);
		strcat(mname, " ");
		menu[MTDESK].spec.free_string = mname;
	}
#endif

	menu_bar(menu,true);

#ifdef MMENU
	menu_init(&mmen,MMENU,v_hl,scr_grect);
#endif
#ifdef TMENU
	menu_init(&tmen,TMENU,v_hl,scr_grect);
	#ifdef MTREPAIRNOT
		tmen.m[MTREPAIRNOT].state |= DISABLED;
		*tmen.m[MTREPAIRNOT].spec.free_string = 0;
	#endif
#endif
#ifdef JOURNAL
	menu_init(&jmen,JOURNAL,v_hl,scr_grect);
#endif
#ifdef OMENU
	menu_init(&dmen,OMENU,v_hl,scr_grect);
#endif
#ifdef BMENU
	menu_init(&bmen,BMENU,v_hl,scr_grect);
#endif
#ifdef CMENU
	menu_init(&cmen,CMENU,v_hl,scr_grect);
#endif

#if BIP_CC
	{ VpV tok_init;
		  tok_init();
	}
#endif

	init_dir(1);		/* 1 = GEM */

#ifdef MTSEARCHER		/* text viewer/editor */
	invoke_cursor(tmen.m);
	init_txtcfg(&pkit);
#elif MBSEARCHER		/* binary editor */
	invoke_kit();
	init_bincfg(&pkit);
#elif TTD_KIT			/* disassembler */
	invoke_ttdkit();
	init_ttdcfg(&pkit);
#endif

#ifdef MTM
	initoptions();
#endif

#ifdef MFRAC
	init_mandel(argc);			/* if args dont open intro mandelbrot */
#endif

#ifdef GEMSHELL
	init_shell();
#endif

#if TMENU
	load_txtconfig();
#elif BMENU
	load_binconfig();
#elif WKS
	load_sheetconfig();
#elif DIGGER
	load_disconfig();				/* before: init_files can open a object file */
#endif

#ifdef BOLDTAGS
	read_tags();
#endif

/*  if init_files opens a object, the journal
    is also opened (voor objects)
*/
	init_files(argc,argv);

#ifdef GEMSHELL
/* If a shell then also a journal and open it for copyright msg.
   BUT after init_files: if the latter opens any window,
   open_jrnl is suppressed if not allready opened by a object
*/
	{
		extern char *argmake;
		void init_make(char *);
	#ifdef MNDISPLAY
		menu_prj_l = strlen(menu[MNDISPLAY].spec.free_string);
	#endif
		if (!get_it(-1,JRNL))
			init_jrnl(&shell_msg, dial_find, 0);		/* (0; 1=full size) */
		init_make(argmake);
	}

#elif DIGGER
	if (!get_it(-1,JRNL))
	{
		init_jrnl(&ttd_msg, nil, 0);			/* 1 in testfase */
		send_msg("\n");
	}
#elif JOURNAL								/* absolutely default */
	if (!get_it(-1,JRNL))
		init_jrnl(nil, dial_find, 0);

#endif
}

#if 0 /* def __LINEA__ */
void font_info(FONT_HDR *sys,char *opm)
{
	short sf,fprop,a[5];

	send_msg("%s info:\n",opm);
	if (sys)
	{
		a[0]=sys->bot_dist;
		a[1]=sys->des_dist;
		a[2]=sys->hlf_dist;
		a[3]=sys->asc_dist;
		a[4]=sys->top_dist;

		fprop = sys->flags.mono_spaced ne 0;
		sf = sys->flags.system;
		send_msg("name='%s',ds[%d,%d,%d,%d,%d] sys:%d,prop:%d\n",
				sys->facename,a[0],a[1],a[2],a[3],a[4],fprop,sf);
	}
}
#endif

#if DRAGDROP
#include <signal.h>

#ifndef SIGPIPE
#define SIGPIPE 13
#endif


static char noexts[34],
            buf[DD_NAMEMAX+2];
static void *oldpipesig;
static char args    [] = "ARGS",
            pipename[] = DD_FNAME;

/*
 * close a drag & drop operation
 */

static
void ddclose(short fd)
{
	Psignal(SIGPIPE, oldpipesig);
	Fclose(fd);
}

#define DBGDROP 0

#if DBGDROP
#define	DPD(x) v_gtext(v_hl,640,1,x);
#else
#define	DPD(x)
#endif

static
void do_drop(short mp[])
{
	short i,fd;
	char nak = DD_NAK,
	     nok = DD_OK,
	     ext[6];
	long size; bool gotit = false;


DPD("stage 00  ")
	memset(noexts, 0, sizeof(noexts));
	pipename[17] = mp[7] & 0xff;
	pipename[18] = mp[7] >> 8;
	fd = Fopen(pipename, 2);
	if (fd > 0)
	{
DPD("stage 0   ")
		noexts[0] = DD_OK;
		strcpy(noexts+1, args);
		oldpipesig = Psignal(SIGPIPE, SIG_IGN);
		i = Fwrite(fd, DD_EXTSIZE+1, noexts);
		if (i eq DD_EXTSIZE+1)
		{
			short hdrlen; char naam[DD_NAMEMAX+2];
DPD("stage 1   ")
			i = Fread(fd, 2L, &hdrlen);
			if (i eq 2)
			{
DPD("stage    ")
				i = Fread(fd, 4, ext);	/* read ext */
				if (i eq 4)
				{
DPD("stage 2   ")
					ext[4]=0;
					if (strcmp(ext,args) eq 0)
					{
DPD("stage 3   ")
						i = Fread(fd, 4L, &size);
						if (i eq 4)
						{

DPD("stage 4   ")
							hdrlen-=8;
							if (hdrlen > DD_NAMEMAX)
								i = DD_NAMEMAX;
							else
								i = hdrlen;

							if (Fread(fd, i, naam) eq i)
							{
DPD("stage 5   ")
								hdrlen -= i;
								naam[i]=0;
							/* skip any extra header (future use) */
								while (hdrlen > DD_NAMEMAX)
								{
									Fread(fd, DD_NAMEMAX, buf);
									hdrlen -= DD_NAMEMAX;
								}
								if (hdrlen > 0)
									Fread(fd, hdrlen, buf);
								Fwrite(fd, 1, &nok);
								/* Now read the actual data */
								if (size > DD_NAMEMAX)
									size = DD_NAMEMAX;
								i = Fread(fd, size, buf);
								buf[i]=0;
								gotit = true;
							}
						}
					}
				}
			}
		}
		if (gotit)
		{
			char *s = buf, *t = buf;
			ddclose(fd);
#ifdef MNMULT
/* mp+3 window handle that's dropped on
   mp+4 mouse x position at time of drop
   mp+5 mouse Y position at time of drop
   mp+6 keyboard shift status at time of drop
        if dropped on kit's window it's a directory
	    that must be put in the text field on wich it is dropped
*/			{
				IT *w = get_it(-1,KIT);
				if (w)
				{
					if ( w->wh > 0 and w->op and w->wh eq mp[3])
					{
						if (*s eq '\'')
						{
							t++;
							s++;
							while (*s and *s ne '\'') s++;
						}
						else
							while (*s and *s ne ' ') s++;
						if (*s)
							*s = 0;
						kit_drop(w,0,t,mp[4],mp[5]);
						return;
					}
				}
			}
#endif
			while (*t)
			{
				if (*t eq '\'')
				{
					t++, s++;
					while (*s and *s ne '\'') s++;
					if (*s)
						*s++ =0;
					if (*s eq ' ')
						*s++ = 0;
				othw
					while (*s and *s ne ' ') s++;
					if (*s)
						*s++ = 0;
				}
#if DIGGER
				{
					long fl;
					if ( (fl=Fopen(t,0)) > 0)
						open_object(t, fl ,nil);
				}
#elif TEXTFILE
				open_text_file(t);		/* looks in cached file list before open */
#elif MFRAC
				{
					long fl;
					if ( (fl=Fopen(t,0)) > 0)
						open_mandel(t,fl);
				}
#elif BINARY
				{
					long fl;
					if ( (fl=Fopen(t,0)) > 0)
						open_binary(t,fl);
				}
#endif
				t = s;
			}
		othw
			Fwrite(fd, 1, &nak);
			ddclose(fd);
		}
	}
}
#endif

global
void w_top(short mn, IT *w, IT *wt)
{
	if (wt)
	{
		cur_off(wt);
	}
	cur_off(w);
	to_top();
	wind_set(mn,WF_TOP);
#ifdef WMENU
	get_work(w);		/* for menu_bar etc */
#endif
#if WINDIAL
	if (no_dial(w))
	{
		set_dialinfs(w);
	othw
		set_dialinfs(wt);
		wdial_on(w);
	}
#endif

#ifdef WMENU
	if (wt)
		if (wt->menu)
			wt->menu->valid = false;

	if (w->menu)
	{
		w->menu->valid = true;
		via (w->set_menu)(w);	/* vinkjes&enable (Digger only for now) */
	}
#endif
}

static
void do_mesag(IT *w,IT *wt,short mp[])
{
	short mn=mp[3],
		mt=mp[4];

/*	alertm("MESAG; mp(0)=%d,mn=%d",mp[0],mn);	*/

/* Care must be taken that all functions can be performed on
    non top windows */

	switch( mp[0] )
	{
		case WM_REDRAW:
			do_redraw(w,*(RECT *)&mp[4]);
		esac
		case WM_CLOSED:
			via (w->closed)(w);
		esac
		case WM_TOPPED:
			via (w->topped)(w,wt);
			else					/* default action */
				w_top(mn,w,wt);
		esac
		case WM_FULLED:
			via (w->fulled)(w);
		esac
		case WM_VSLID:
			via (w->slide)(w,w->hslp,mt,w eq wt);
		esac
		case WM_HSLID:
			via (w->slide)(w,mt,w->vslp,w eq wt);
		esac
		case WM_ARROWED:
			if (w->arrowd)
				if (aes_global.version >= 0x300 and aes_global.version < 0x400)
				{
					static short old=0;

/*	We dont do it if mp[2] changes to > 0.
Why this all is necessary is not found in any documentation, but it works.
If mp[2] never changes to >0 there is no problem and it works normal.

It seems that if you hold the button down on an arrow, mp[2] becomes >0,
but that in some TOSes the wait time is so short that you get 2 events
on what seems to be only 1 click; one event with 0 and one with x20 in mp[2].
*/
					if (!(mp[2] > 0 and old eq 0))
						(*w->arrowd)(w,mt,w eq wt);
					old = mp[2];
				}
				else
					(*w->arrowd)(w,mt,w eq wt);
		esac
		case WM_SIZED:
			via (w->sized)(w,(RECT *)&mp[4]); /* incl slidersize */
		esac
		case WM_MOVED:
			via (w->moved)(w,(RECT *)&mp[4]);
		esac
	}  /* end switch (mp) */
}

global
/* bool do_menu(IT *w,OBJECT *m,short mn,short mt,short kstate) */
MENU_DO do_menu			/* Now only for main menu */
{
	if (      mn eq MT1
		 and  mt eq MNQUIT
		 and  eruit(false) )			/* false: not force for check_save() */
			return false;				/* OK: quit */

	else if ( mn eq MTDESK
		 and  mt eq MNTITEL) 	do_Title();
#ifdef MTM
	else if ( mn eq MTM	   ) 	do_Mode (w,mt);
#endif

#ifdef MT1
	else if ( mn eq MT1	   )	do_Open  (   mt);
#endif

#ifdef GEMSHELL
	else if (!do_shell(mn, mt))
#elif defined WMENU
	else
#endif

	/* This calls the rest of the main menu if its there.
	   If what normally is held in window menu's is moved to the main
	   menu, that is called here too.
	*/
		if (w)
			via (w->do_menu)(w,m,mn,mt,kstate);
	menu_tnormal(m,mn,true);
	return true;
}

static
bool is_mkey(IT *w, short k)
{
	if (w)
		if (w->plain)
			return true;
	if (k&(NKF_CTRL|NKF_ALT))
		return true;
	k&=0xff;
	if (    k eq NK_UNDO or k eq NK_HELP or k eq NK_INS or k eq NK_DEL or k eq NK_ESC
	    or (k >= NK_F1 and k <= NK_F10)
	   )
		return true;
	return false;
}

void main(short argc, char *argv[])
{
	short evmask,event;
	short aes_keycode,aes_keystate;
	short kcode,mx,my,button,kstate,bclicks,mn,mt,mp[8];
	static bool w_on=false;

	XA_set_base(nil, 1L<<14, 13, 0, nil, nil);

	aaaa_id = appl_init();
	mbumble;
	move_mode=CLICK;

	{
		short dum,effects[3],d[5];
		v_hl = instt_scr();			/* also sets global aes_handle */
		vqt_fontinfo(v_hl,&dum,&dum,d,&dum,effects);
		points=d[4];	/* celltop to baseline */

	/* --------------------------- TEST, leuk!! ----------------- */
	/*	points=26;												  */
	/* ---------------------------------------------------------- */

		vst_height(v_hl,points,&dum,&points,&wchar,&hchar);
		hpoints=points/2;
		aes_flags = get_aes_info(aes_global.version,&aes_font,&aes_font_height,&dum,&dum);
	}

	/* If the system supports AP_TERM, tell the system that we do as well. */
	if (aes_flags&GAI_APTERM)
		shel_write(9,1,0,nil,nil);

	if (MagX or MiNT)
		global_message = XA_alloc(&XA_global_base, DIR_MAX*2+1, nil, -1, -1);

	init_subsystems(argc,argv);

	mpijl;

	do						/* THE and the ONLY one  event loop */
	{
static short lastwin = -1;

		RECT tw;
#ifdef WMENU
		RECT mw={0,0,0,0};
		short mwd=0;
#endif
		IT *wt; /* =get_top_it();	my top window */
		short lwh;

		en_windows(w_handles(0L,0L) ne 0);
		evmask=MU_MESAG|MU_KEYBD;	/* minimum (keybd for menu_keys) */

		wind_get(0,WF_TOP,&lwh);	/* what's REALLY the top window */

		/* find MY window info & secure position of window within chain;
	 		Remember that WM_NEWTOP does not occur,
			and WM_UNTOPPED does not exist in atari GEM	*/
		wt = get_it(lwh,-1);

		if (wt)
		{
			to_top();				/* synchronization. (convergent programming) */

			if (is_file(wt))
			{
				S_path dum;
				DIRcpy(&dum, wt->title);
				idir = dir_plus_name(&dum, "*.*");
			}

			if (wt->antevnt)
				evmask=(*wt->antevnt)(wt,w_on,evmask);
			tw=wt->wa;
#ifdef WMENU
			if (wt->do_menu)
			{
				menu_place(wt->menu,wt->men); /* --> get_work */
				evmask=menu_evm(wt->menu,evmask,MU_M2);
				mwd =wt->menu->evm_dir;
				mw = wt->menu->r;
				if (!wt->menu->valid and !wt->menu->pn)
					via (wt->set_menu)(wt);
			}

	#ifdef MTEDITOR
			dis_paste_etc(wt->menu->m,!is_buf(wt));
	#endif
#endif
		}
		else
			mpijl;

		lastwin = lwh;			/* Allways !!!! */

		event =
			evnt_multi(
				evmask,
				0x102,3,0,		/* see NKCC.DOC par 7 */
				w_on, tw.x,tw.y,tw.w,tw.h,
#ifdef WMENU
				mwd,mw.x,mw.y,mw.w,mw.h,
#else
				0,0,0,0,0,
#endif
				mp,
				500,0,		/* 1/2 sec */
				&mx,&my,
				&button,&aes_keystate,
				&aes_keycode,&bclicks
		 );

		kcode = aes_keycode;
		kstate = aes_keystate<<8;

		if (!event)
			continue;

		wind_update(BEG_UPDATE);

		if ( event & MU_M1 )
		{
			w_on = !w_on;			/* eruit <--> erin */
			if (w_on)
				wt->muisvorm(wt);				/* nu erin */
			else
			{
				mpijl;
				if (wt and no_dial(wt))
					cur_on(wt);			/* keep visible & steady */
			}
		}

#ifdef WMENU
		if (wt and (event&MU_BUTTON))
			if ((mn=menu_button(wt->menu,&mt)) > 0)
			{
				event&=~MU_BUTTON;
				if (!(*wt->do_menu)(wt,wt->menu->m,mn,mt,kstate))
					break;					/* while event:  QUIT */
			}
#endif

#ifdef CAN_CLICK
		if (   wt and (event&MU_BUTTON)
#if 1	/* spurious zero click button events on MILAN TOS */
			and bclicks
#endif
		   )
		{
			via (wt->button) (wt,button,kstate,bclicks,mx,my);
		}

#if 0
		if (event & MU_WHEEL)
		{
			alert_cur = form_alert;
			alert_msg("wheel: button %d | state %d | clicks %d", button, kstate, bclicks);
		}
#endif

		if (event & MU_KEYBD)
		{
			short k,c;
			M_KEY key;
/*
alert_text("ket 0x%04x", aes_keycode);
*/
	/* hack for some tosses &| emulators concerning page up/down key's.
												They're so tempting. :-) */
			if (aes_keycode eq 0x4900)		/* Milan PS2 keyboard */
				aes_keycode = 0x4838;
			elif (aes_keycode eq 0x5100)
				aes_keycode = 0x5032;
			if (   aes_keycode eq 0x4838	/* PC emulator (TOS2WIN) */
			    or aes_keycode eq 0x5032)
				aes_keystate|=K_RSHIFT|K_LSHIFT;

			kcode = normkey(aes_keystate,aes_keycode);

			k = kcode&0xff,
			c = kcode&NKF_CTRL,

			mn=0;
			mt=0;

			if (is_mkey(wt,kcode))
			{
				key=m_key(kcode);
	#ifdef LASTKEY		/* show the key's in menu_key format in a dummy menu entry */
				if (menu[SHOWKEY].state&CHECKED)
				{
					char *s = menu[LASTKEY].spec.free_string;
					while (*s) if (*s eq '=') break; else s++;
					if (*s)
					{
						/* strcpy(s+2,key.c);	*/	/* the free_string must be > 24 ch's!!! */
						sprintf(s+2,"%s S%x/N%x",key.c,aes_keycode,kcode);
						menu_bar(menu,true);
					}
				}
	#endif

	#ifdef MFRAC
				if (wt and wt->overscan)	/* cant use the menu's */
					mn = 0;
				else
	#endif
				{
	#ifdef WMENU
					if (wt and wt->do_menu and (mn=menu_keys(wt->menu,key,&mt)) ne 0)
						if (mt > 0 and !(*wt->do_menu)(wt,wt->menu->m,mn,mt,kstate))
							break;					/* while event:  QUIT */
	#endif
					if (!mn and (mn=menu_keys(&mainmenu,key,&mt)) ne 0 )
						if (mt > 0 and !do_menu(wt,menu,mn,mt,kstate))
							break;					/* while event:  QUIT */
				}
	#ifdef LASTKEY
			othw
				if (menu[SHOWKEY].state&CHECKED)
				{
					/* show the key's in hex in a dummy menu entry */
					char *s = menu[LASTKEY].spec.free_string;
					while (*s) if (*s eq '=') break; else s++;
					if (*s)
					{
						sprintf(s+2,"S%x/N%x",aes_keycode,kcode);
						menu_bar(menu,true);
					}
				}
	#endif
			}

			if (!mn and wt)		/* key_codes needing open window */
			{
				/* scancode before !! conversion by NKCC */
				wt->aeskcode=aes_keycode;
				wt->aeskstate=aes_keystate;

				/* standards */
				if   ( c and (k eq 'U' or k eq 'u') and wt->closed )
					wt->closed(wt);
				elif ( c and (k eq '=' or k eq '+' or k eq '-') and wt->fulled )
					wt->fulled(wt);
				elif ( c and (k eq 'W' or k eq 'w') )
					cyclewindows(wt);
	#if defined MFRAC && defined MMFULL
				elif (wt->overscan and k eq 'o')
					(*wt->do_menu)(wt,wt->menu->m,MMSHOW,MMFULL,0);
	#endif
				else
					via (wt->keybd)(wt,kcode);
			}
		}		/* endif MU_KEYBD */
#endif

		if ( event & MU_MESAG )
		{
			mt=mp[4];
			mn=mp[3];
			if (mp[0] eq AP_TERM)
			{
				if (eruit(false))
					break;
			}
			elif (mp[0] eq MN_SELECTED)	/* Can only be main menu!! */
			{
#if LASTKEY
				if (mn eq LASTKEY and mt eq SHOWKEY)
				{
					menu_icheck(menu,SHOWKEY,(menu[SHOWKEY].state&CHECKED) ? false : true);
					menu_tnormal(menu,LASTKEY,true);
				}
				else
#endif
				if (!do_menu(wt,menu,mn,mt,kstate))
					break;					/* while event:  QUIT */
			}
#if DRAGDROP
			elif (mp[0] eq AP_DRAGDROP)
				do_drop(mp);
#endif
			else
				do_mesag(get_it(mn,-1),wt,mp);
		}

#ifdef WMENU
		else
		/* not when also MU_MESAG;
		   for entries in top menu that overlay
		   the window menu bar */

		if ( (event & MU_M2) )
			if (menu_mouse(wt->menu,mx,my))
			{
				wind_update(END_UPDATE);
				continue;
			}
			else
			if (m_inside(mx,my,wt->ma))		/* Well where did we go to? */
				wt->muisvorm(wt);
			else
				mpijl;
#endif

		if ( event & MU_TIMER )
			if (wt)
				via (wt->timer)(wt);

		wind_update(END_UPDATE);
	}  while(true);
	exit(0);
}
