/* Copyright (c) 1990 - 2008 by H. Robbers Amsterdam.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* AA_INTRO.H
 * ==========
 */

#ifndef AA_INTRO_H
#define AA_INTRO_H

#ifdef RSRC_H
	#include RSRC_H			/* drives most of the conditional program production
							   taken from a [-D] in the project file (see also RSRC_RSC) */
#endif

#if defined MMENU	/* Mandelbrot */
	#define CAN_CLICK 1
	#define MFRAC 1
	#define IMGS 1
#endif

#if defined TMENU		/* full text editor */
	#define WINTEXT 1	/* window text functions */
	#define TEXTFILE 1

	#define SELECTION 1
	#define CAN_CLICK 1
	#if MTEDITOR
		#define DRAGSELECTION 1
		#define TEXTEDIT 1
	#endif
#endif

#if defined BMENU	/* binary file editor */
	#define BINARY 1
	#define CAN_CLICK 1
	#define BSELECTION 1
#endif

#if defined OMENU   /* disassembler */
	#define DIGGER 1
	#define CAN_CLICK 1
#endif

#if defined MNWKS	/* worksheets */
	#define WKS 1
	#define WIN_OB 1	/* dialogue's are part of a work window */
	#define CAN_CLICK 1
#endif

#if defined JOURNAL
	#define WINTEXT 1		/* journal needs some text functions */
	#ifdef MNJFIND
		#ifndef MNFIND
		#define MNFIND MNJFIND
		#endif
	#endif
#endif

typedef struct scrollinfo
{
	short m1,
	      arrow,
	      grtel,
	      grnoem;
} SINF;

typedef enum
{
	IS_OBJECT,
	IS_MENU,
	TCSL = 44
} TREETY;

typedef char TCS[TCSL];

typedef struct cfg_local
{
	short
		vistab,		/* Visible tab character							*/
		vistco,		/* if visible tab fill to target position			*/
		tabn,		/* apparent tabsize	for Fix tabulate				*/
		tabp,		/* physical tabsize for retabulation				*/
		tabl,		/* retab only leading white space					*/
		tabs,		/* tabsize											*/
		split;		/* Split line on last space before split chs.		*/
	bool
		ai,			/* autoindent cq autocalc							*/
		trail,		/* if true, remove trailing spaces when saving		*/
		boldtag,	/* reserved words are bold tags						*/
		font;		/* normal or small font								*/
	SINF
		sch,		/* scroll info  hor									*/
		scv;		/*    "     "   vert								*/
} CFG_LOCAL;

typedef struct charset
{
	char v[8][34];
} CHARSET;

typedef struct ttd_profile
{
	CHARSET cust;
	char invisible[2];

	bool
		mccf,
	    mc00,
	    mc20,
		mc30,
		mc40,
		mc60,
		mc51,
		mc81,

		dblf,
		wabx,
		dirw,

		labnl,
		opoct,
		dec,

		opc,
		asc,
		opasc,
		stand,
		lbl,
		sym,

		usysv,
		isysv,
		tosimg,		/* 151002 */
		v95,
		vger,
		vfra,
		vlat,
		vsca,
		vmat,
		vall,
		vnon,
		vcustom,
	    wordop,
		diags;

	TCS title,
	    sec_text,
	    sec_data,
	    sec_bss,
	    xdef,
	    xref,
	    comm,
	    moduul,
	    endmod,
		equ,
		sbr,
		wbr,
		lbr,
		wordabs,
		longabs,
		wordops,
		labelsep,
		kpref,
	    r16,
		illegal,
		src_ext,
		hex_ext,
		asx_ext;

	MAX_dir
	    rnamApath,		/* global namA */
		wnamApath,
		include,		/* template */
		sysvcom,		/* global equ's */
		sysvend,
		idxcom,			/* local equ's */
		idxend;
	CHARSET svvis;		/* remember of true characters */
	char tvis[260];			/* catenation of true characters */
	bool sym1;
	short rdx;
} TTD_PROF;

typedef unsigned short *PCU;
typedef short *PCW;
typedef long *PCL;		/* toch wel handig dat C */
typedef char *PCB;		/* PCL & PCB mostly for casting */

typedef union
{
	PCB b;
	PCW w;
	PCL l;
	uchar *k;
	uint *u;
	long i;
	ulong ui;
} PC;

typedef struct
{
	short ty;
	MAX_dir name, idx_name;
	bool idx;
	short  tabber;
	bool haveoff;

	long offset;
	PC   spg;
} TTD_CFG;

typedef struct d_cfg
{
	struct d_cfg *n;
	TTD_CFG cf;
	TTD_PROF cg;
} D_CFG;


typedef void VpV	(void);
typedef bool BpV	(void);
typedef void FOPEN	(char *fn,short fl);

typedef char *COPRMSG[];
typedef void COPRM(short *w, short *h, COPRMSG msg);

#ifndef PDW
#define PDW void
#endif

#endif
