/* Copyright (c) 2004 - 2009 by H. Robbers.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* cache.c  caching subsystem for header files */

#include <string.h>

#include "lmem.h"
#include "cache.h"
#include "peepstat.h"

void send_msg(char *text, ...);

global
CP cache = nil;

global
void pcache(short which)
{
	CP ip = cache;
	send_msg("**** [%d]cache ****\n", which);
	while (ip)
	{
		send_msg("%lx %6ld %s[%ld] %d\n", ip, ip->size, ip->name, ip->bytes, ip->busy);

		ip = ip->next;
	}
}

global
CP free_cache_unit(CP cp, short which)		/* only last */
{
	CP nx = nil;

	if (cp)
	{
		nx = cp->next;
		if (cp->text)
			CC_ffree(cp->text, 210);
		if (cp->name and cp->heap)
			CC_xfree(cp->name, 211);
		CC_xfree(cp, 212);
	}

	return nx;
}

global
void delete_from_cache(char *name, short caching)
{
	CP pr, nx;
	CP cp = cache_look(cache, &pr, name, false);
	if (cp)
	{
		if (caching)
			if (cp->busy > 0)
				cp->busy -= 1;
			else ;
		elif (cp->busy > 0)
			cp->busy -= 1;
		else
		{
			nx = free_cache_unit(cp, 4);
			if (pr eq nil)		/* deleted first */
				cache = nx;
			elif (nx)			/* deleted in the middle: pr and nx */
				pr->next = nx->next;
			else 				/* deleted last */
				pr->next = nil;
		}
	}
}

global
void free_cache(short which)
{
#if 0
		send_msg("[%d]free_cache\n", which);
		pcache(1);
#endif

	while (cache)
		cache = free_cache_unit(cache, which + 100);

#if PCNT_SAMPLE
	do_pcnts();
#endif
}

global
CP cache_look(CP pt, CP *ppr, char *name, bool new)
{
	CP pr = nil;
	while (pt)
	{
		if (stricmp(pt->name, name) eq 0)
		{
			if (new)
				pt->busy += 1;
			if (ppr)
				*ppr = pr;
			return pt;
		}
		pr = pt;
		pt = pt->next;
	}
	if (ppr)
		*ppr = nil;
	return nil;
}

global
CP new_cache(short which)
{
	CP new = CC_xcalloc(1, sizeof(*new), AH_NEW_CACHE, CC_ranout);
	if (new)
	{
		new->next = cache;
		cache = new;
	}

	return new;
}

/* if a cache entry is also in G.inctab, it is busy and cannot
   be freed. */

#if 0
static
bool not_busy(CP cp)
{
	VP np = G.inctab;

	while (np)
		if (strcmp(cp->name, G.inctab->name) eq 0)
			return false;
		else
			np = np->next;

	return true;
}
#else
	#define not_busy(a) ((a)->busy ne 0)
#endif

static
/* find smallest entry larger than size */
CP cache_fits(long size)
{
	long high = 0x7fffffff;
	CP cp = cache, have = nil;
	while (cp)
	{
		if (not_busy(cp))
			if (cp->size >= size)
				if (cp->size < high)
					high = cp->size, have = cp;

		cp = cp->next;
	}

	return have;
}

/* find largest entry smaller than size */
CP cache_high(long size)
{
	long high = 0;
	CP cp = cache, have = nil;
	while (cp)
	{
		if (not_busy(cp))
			if (cp->size < size)
				if (cp->size >= high)
					high = cp->size, have = cp;

		cp = cp->next;
	}

	return have;
}

/* try to obtain size bytes from the cache. Unfinished. */

global
bool clean(long size)
{
	/* first find the smallest unit larger than size */

	CP cp = cache_fits(size);
	if (cp)
		CC_ffree(cp, 213);
	else
	{
		/* then accumulate largest sizes until size is met */
	}

	return cp ne nil;		/* success */
}

