/* Copyright (c) 1990 - 2009 by H. Robbers.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* a multitude of common variables put in a single struct.
   reduces number of external names, reduces name space confusion.
 */

#include "common/hierarch.h"

typedef struct
{
	bool noregs, nopeep, new_peep;
} PRAGMATS;

typedef struct common
{
/* Pure C compatible options */
	bool
		i2_68020,
		i2_68030,
		i2_68040,
		i2_68060,
		use_FPU,
		Coldfire,
		a_strict_ANSI,
		b_output_DRI,
		c_nested_comments;
	short
		e_max_errors,
		f_max_warnings,
		l_identifier_max_length;

	bool
		g_optimum_size,
		h_cdecl_calling,
		j_no_jump_optimization,
		k_char_is_unsigned,
		m_string_merging,
		n_nmlist,
		p_absolute_calls,
		q_pascal_calling,
		s_frame_pointer,
		t_stack_checking;
	short
		v_Cverbosity;
	bool
		x_add_underline,
		y_debugging,
		z_register_reload;
/* end of Pure C compatible options */

/* AHCC specific options */
	bool
		ab_no_branch_reversals,
		ac_cache_headers,
		ae_no_extracodes,
		ag_nogoto,
		al_list_stats,
		ah_project_help,
		ai_int32,
		aj_auto_depend,
		au_supervisor,
		an_IXC,
		ap_no_peep,
		ad_new_peep,
		ar_no_registerization,
		aw_Xnl;
/* end of AHCC specific options */

/* internal switches */
	bool
		for_A,
		for_S,
		in_S,
		skip_S,
		incbin,			/* incbin (include binary file in asm) */
		in_if_x,
		in_def,
		skip_id,
		first_declare;

	short
		yflags[26],
		xflags[26],
		anydebug,
		nmerrors,
		nmwarns,
		npred,
		idir_n,
		idir_put,
		lblnum,
		tk_flags;

	PRAGMATS pragmats;

	enum cpus CPU;

	AHCOUT
		*output;

	S_path
		output_name,
		input_dir,
		lastdir,
		includer;

	VP	iftab,
		inctab,
		flow_chart,
		fltab;

	NP	strsave, strlast,
		consave, conlast;

	XP	holdtok,
		expanding;

	TP	optab,
		casttab,
		tagtab;

#if BIP_ASM
	TP	dot_labels, asmvars;
	bool
		dot_seen;		/* for bra   .label; the dot is eaten by isize() */
#endif

	FP	prtab;
	SCP scope;

	short
		asm_clo,
		asm_clock;

	LEX_RECORD
		* save_LEX;

	long
		clockopt,
		C_bytes;
#if NODESTATS
	long ncnt[LASTTY-FIRSTTY];
	long operators,ids,symbols,defs,
		 strcode,npcode,xcopied,
		 dictionary_names, heap_names;
#endif
} COMMON;

#if NODESTATS
void nodecnts(void);
#endif

extern COMMON G;
extern TP *symtab;
extern XP cur, curtok;
extern LEX_RECORD * cur_LEX;
extern string class_names[];
extern AHCOUT *bugf;
