/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Johann Ruegg
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *	d2.c
 *
 *	Declaration subroutines (mostly called from decl.c)
 *
 *	Mostly routines for initializations
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "param.h"

#include "body.h"
#include "decl.h"
#include "d2.h"
#include "expr.h"
#include "e2.h"
#include "gen.h"
#include "gsub.h"
#include "md.h"
#include "out.h"

#define debugD G.xflags['d'-'a']

long g_init(TP xp, short area);			/* for recursion */

global TP dummy_id(TP xp, TP head, short parnr)
{
	if (xp->token ne ID )
	{
		TP e1 = allocTn(1);
		e1->token = ID;
		if (xp->token eq T_VARGL)
			new_name(e1, "__ELLIPSIS__");
		else
			new_name(e1, "__P%d__", parnr);
		e1->type = xp;
		if (xp eq head )
			to_nct(e1);
		return e1;
	}
	return xp;
}

global void su_size(long *lp, string cp, TP xp, short isstruct)
{
	long sz;
	char al;

	sz = xp->type->size;
	al = xp->type->aln;

	if (isstruct eq 0)
		*lp = *lp > sz ? *lp : sz;
	else
	{
		while (al & *lp)
		{								/* align new field */
			*lp += 1;
			xp->offset += 1;
		}

		*lp += sz;
	}

	*cp = *cp > al ? *cp : al;
}

global long loc_size(NP fp, TP xp, long *lp, ALREG *rp)
{
	long sz;
	char al;

	fp->name = xp->name;
	fp->rno = FRAMEP;
	fp->token = OREG;
	fp->size = xp->type->size;
	if (xp->sc eq K_REG)
		if (lc_reg(rp, xp, nil))		/* check types; nil = alloc high to low */
		{
			fp->r1 = xp->rno;
			return fp->size;
		othw
			xp->sc = K_AUTO;
		}

	if (xp->sc ne K_AUTO)
		return 0;

	sz = xp->type->size;
	al = xp->type->aln;

	if (*lp + sz > 16384)
	{
		errorn(xp, "more than 16384 bytes local name space at");
		return sz;
	}

	xp->lbl = new_lbl();
	fp->lbl = xp->lbl;

	while (al & *lp)
	{							/* align new field */
		*lp += 1;
		xp->offset += 1;
	}
	*lp += sz;
	xp->offset = LOC_BASE - *lp;
	fp->val.i = xp->offset;
	return sz;
}

global void arg_size(long *lp, TP xp)
{
	long sz;
	char al;
								/* loc_size after all declarations */
	sz = xp->type->size ;
	if (sz < 0 ) sz = 0;		/* prototyping; voor vargl */
	al = xp->type->aln;
	while (al & *lp)			/* align new field */
		*lp += 1;
	sz = arg_align(sz, xp);		/* maakt xp->offset eerst 0 */
	xp->offset += *lp;			/* ARG_BASE after all declarations */
	*lp += sz;
}

global void afterfld(long *sizep, short *fop)
{
	if (*fop)
	{
		*sizep += default_type(-1, 0)->size;	/* 06'11 HR regression fixed: always default size int */
		*fop = 0;
	}
}

/* only called if xp ne 0 and fldw > 0 */
global void su_field(TP xp, long *sizep, char *alp, short fldw, short *fop)
{
	short w;

	if (*fop eq 0)					/* align properly */
		while (*alp & *sizep)
			(*sizep)++;

	if (*alp < ALN_I)
		*alp = ALN_I;

	w = 8*default_type(-1, 0)->size;	/* 06'11 HR regression fixed: always default size int */

	if (fldw + *fop > w)
		afterfld(sizep, fop);

	xp->fld.width  = fldw;
	xp->fld.offset = *fop;
	xp->fld.shift  = w - (fldw+*fop);		/* 02'11 HR optimization */

	*fop += fldw;
}

static bool ok_ty(TP np, TP endp)
{
	TP type;
	long csize = 0;

#if FOR_A
	if (!(G.for_A and np->token eq ARRAY))	/* The tree is slightly different from those for_C */
#endif
		if (np eq endp) return true;

	type = np->type;

	if (type)
	{
		if (ok_ty(type, endp) eq 0)
			return false;
		csize = type->size;
	}

	switch (np->token)
	{
	case REFTO:
		to_type(np, REFTO);
		break;
	case K_OP:
		if (	endp->token eq T_BOOL  /* is_CC(endp) */
			and !(is_compare(np->offset) or np->offset eq NOT)	)
			error("boolean result on no conditional operator");
		/* fall through */
	case K_CAST:
	case K_PROC:
			/*  size 0 okay; func ret void */
		if (type->token eq ARRAY)
		{
			errorn(np, "bad %s", graphic[np->token]);
			return false;
		}
		/* size 0 */
		break;
	case ARRAY:
/*		checking of csize moved to places where the sizes
		are actually needed.	(init and use)
*/
		np->token = ROW;		/* 04'09 confolded size */
		if (np->list)
		{
			long inds = confold_value((NP)np->list, FORSIDE);		/* frees its nodes */
			csize *= inds;
			np->list = nil;
			np->size = csize;
		}
		else
			np->tflgs.f.formal = 1;

		np->aln = type->aln;
		np->ty = ET_A;
		break;
	default:
		return true;
	}

	return true;
}

global bool ok_prh(short sc, TP np)
{
	if ( sc ne 0 and sc ne K_AUTO and sc ne K_REG)
	{
		error("'%s' in arguments", graphic[sc]);
		return false;
	}
	return ok_ty(np, nil);
}

static bool varglist(TP np)
{
	if ( np )
		if ( np->token eq T_VARGL )
		{
			error("'%s' outside function declaration", graphic[K_VARGL]);
			return true;
		}
	return false;
}

global bool ok_gsh(short sc, TP np)
{
	G.prtab->insc = sc;
	if ( sc eq K_AUTO or sc eq K_REG)
	{
		error("'%s' outside function", graphic[sc]);
		return false;
	}
	if (varglist(np)) return false;

	return ok_ty(np, nil);
}

global bool ok_gx(TP np, TP  endp)
{
	if (np)
		return ok_ty(np->type, endp);
	return false;
}

global bool ok_lsh(short sc, TP np)
{
	G.prtab->insc = sc;
	if (G.prtab->level eq 1)
		return ok_prh(sc, np);
	return ok_ty(np, nil);
}

global void array_to_ptr(TP np)
{
	
	TP tp = np->type;

	if (is_nct(np))
	{							/* cant change if no dupl. */
		tp = copyTone(tp);
		np->type = tp;
		not_nct(np);
		tp->nflags.f.bas = 0;
	}

	to_type(tp, REFTO);
/*	free_name(tp); */
	name_to_str(tp, "array_ptr to");
	tp->tflgs.f.saw_array = 1;		/* for &[] */
}

global void func_to_ptr(TP np)
{
	TP tp = allocTn(1);

	to_type(tp, REFTO);
	name_to_str(tp, "func_ptr to");
	tp->type = np->type;
	np->type = tp;
	to_nct(tp);
	not_nct(np);
}

global bool ok_prx(TP np, TP endp)
{
	/* for func decl formal parameters */
	if (np)
	{
		if (   np->type->token eq ARRAY
		    or np->type->token eq ROW		/* 04'09 */
		   )
		{
			ok_ty(np, endp);
			array_to_ptr(np);
		}
		if (np->type->token eq K_PROC)
		{
			ok_ty(np, endp);
			func_to_ptr(np);
		}
		if (np->type->token eq T_VOID)	/* ignore plain void */
		{
			freeTn(np);
			return false;
		}
		return ok_ty(np->type, endp);
	}
	return false;
}

global bool ok_lx(TP np, TP endp)
{
	if (G.prtab->level eq 1)
		return ok_prx(np, endp);

	if (np)
		return ok_ty(np->type, endp);
	return false;
}

global bool ok_sux(TP np, TP endp)
{
	if (np)
		return ok_ty(np->type, endp);
	return false;
}

global bool ok_enx(TP np, TP endp)
{
	if (np and np->type eq endp)	/* no modifiers */
		return true;
	return false;
}

global bool ok_cast(TP np, TP endp)
{
	if (np)
	{
		if (varglist(endp))
			return false;
		return ok_ty(np, endp);
	}
	return false;
}

global bool ok_revx(TP rv, short forcast)
{
	D_(D, "ok_revx");
	if (rv)
	{
		if ( forcast eq 0 and rv->token ne ID )
		{
			error("declaration %s needs ID", prdeclarer(rv->type));
			return false;
		}
		if ( forcast eq 1 and rv->token eq ID )
		{
			errorn(rv, "ID in cast");
			return false;
		}
	}
	return true;
}

global void regvar_options(TP xp, short sc)
{
	if (sc eq K_REG)
		xp->cflgs.f.see_reg = 1;
	if (sc eq 0)
		sc = K_AUTO;

	xp->sc = sc;
}

/* set array size or fill array with zeros */
/* squeeze can only be set for size 1 types */
static void a_fix(TP tp, short area, long nsee, short squeeze)
{
	long oldsize;

	D_D(D, send_msg("a_fix area: %d, nsee: %d, t.size: %ld\t", area, nsee, tp->size);)

	if (tp->size)
	{
		oldsize = tp->size / tp->type->size;

		if (oldsize > nsee)
		{
			if (squeeze)			/* ANSI */
			{
				addcode(gp, "Z");
				nsee++;
				std_areas->ar[area].size++;
			}
			if (oldsize > nsee)
				o_nz(tp->type->size * (oldsize-nsee), area, tp->type->aln);
		}
		else if (oldsize < nsee)
			error("too many init expressions");
	othw
		if (squeeze)			/* ANSI */
		{
			addcode(gp, "Z");
			nsee++;
			std_areas->ar[area].size++;
		}
		tp->size = nsee * tp->type->size;
	}
}

/* initialize 0 or 1 thing of any type (tp) */
static short scon_size(NP sc)
{
	if (is_scon(sc)) return        sc->size;
	else             return strlen(sc->name);
}

static long inita(TP tp, short area, long maxi)
{
	long nsee;

	nsee = g_init(tp, area);	/* initialize up to max items of type tp */
								/* if maxi is 0, any number is okay */
	if (nsee eq 0)
		return 0;

	while (cur->token eq COMMA)
	{
		if (nsee eq maxi)
			break;
		fadvnode();
		nsee += g_init(tp, area);
	}

	return nsee;
}

/* initialize (possible) structure */
static long inits(TP xp, short area)
{
	long see1;

	see1 = g_init(xp->type, area);

	if (see1 eq 0)
		return 0;

	while (xp->next)	/* for each member */
	{
		xp = xp->next;
		if (cur->token eq COMMA)
		{
			fadvnode();
			see1 = g_init(xp->type, area);
		}
		else
			see1 = 0;

		if (see1 eq 0)
		{					/* was: z_init */
			TP tp = xp->type;
			if (is_aggreg(tp) or tp->token eq ROW)
				o_nz(tp->size, area, tp->aln);
			else
			{				/* was: out_zi */
				NP fp = gx_node();		/* own node for size */
				fp->size = tp->size;
				std_areas->ar[area].size += tp->size;
				addcode(fp, "\t^YS\t\t0" C(initstr) "\n");
				next_gp(fp);
			}
		}
	}

	return 1;
}

static long g_init(TP tp, short area)
{
	NP np;
	long nsee;
	long sz, oldsize;
	short seebr = 0;

	D_(D, "g_init");

	if (    cur->token eq SCON
	    and tp->token eq ROW
	    and (   tp->type->token eq T_CHAR
	         or tp->type->token eq T_UCHAR
	        )
	   )
	{ 										/* hack for SCON ary */
		NP concat = npcur(); advnode();
		concatstr(concat);				/* ANSI: concatenate adjacent strings <	*/
		nsee = scon_size(concat);
		std_areas->ar[area].size += nsee;
#if NODESTATS
		G.ncnt[concat->nt]--;
		G.ncnt[GENODE]++;
#endif
		concat->nt = GENODE;
		addcode(concat, "X");
		next_gp(concat);
		a_fix(tp, area, nsee, 1);		/* delayed terminating zero if room for */
		return 1;
	}

	if (cur->token eq BLOCK)
	{
		fadvnode();
		seebr = 1;
	}

	switch (tp->token)
	{
	case ROW:					/* other than above */
		change_class(area);
		o_aln(tp->aln, area, 1);
		oldsize = tp->size ? tp->size / tp->type->size : 0;

		nsee = inita(tp->type, area, oldsize);
		if (nsee)
			a_fix(tp, area, nsee, 0);
		break;
	case K_STRUCT:
#if FLOAT
	case T_COMPL:
#endif
		change_class(area);
		o_aln(tp->aln, area, 2);
		nsee = inits(tp->list, area);
		break;
	case K_UNION:
		change_class(area);
		o_aln(tp->aln, area, 3);

		nsee = g_init(tp->list->type, area);	/* init only the first member */
		if (nsee)
		{
			sz = tp->size - tp->list->type->size;
			if (sz)
				o_nz(sz, area, 0);
		}
		break;
	default:		/* initialize one (or 0) scalar to an expr */
		np = assignx();
		if (!np)
			nsee = 0;
		else
		{
			G.prtab->tmps = 0;
			form_types(np, FORSIDE, 0);
			asn_check(tp, np, FORINIT);
			Cast(np, tp, IMPCNV, "Init cast");
			if (!G.nmerrors)
			{
				change_class(area);
				o_aln(tp->aln, area, 4);
				untype(np);
				branch_tree(np);
				nsee = geni(np);				/* reduced version of genx for init */
				if (nsee)
				{
					std_areas->ar[area].size += tp->size;
					gp->size  = tp->size;
				}
				gp->token = SCALAR;		/* for constanizing */
				gp->right = np;
			}
		}
		break;
	}

	if (seebr)
	{
		if (cur->token eq COMMA) fadvnode();
		eat(KCOLB);
	}

	return nsee ? 1 : 0;
}

char *pclass(short);

static
void std_area_start(TP xp, short class)
{
	xp->area_info.class = class;
	xp->area_info.id    = std_areas->ar[class].id;
	if (class > 0 and class < high_class)
		xp->area_info.disp = std_areas->ar[class].size;
}

static
void std_area_end(TP xp, short class)
{
	if (class > 0 and class < high_class)
	{
		if (class >= BSS_class)
			std_areas->ar[class].size += xp->type->size;
	}
}

static void permanent_var(TP np, short class, short which)
{					/* variable with permanent extent */
	long sz;

	TP tp;

	D_(D, "permanent_var");

	if (np->sc eq K_EXTERN)		/* ?? */
		return;

	tp = np->type;

	if (np->sc eq K_STATIC and G.prtab->level > 1)	/* lbl only if within func. */
		np->lbl = new_lbl();

	gp->sc  = np->sc;
	gp->lbl = np->lbl;
	gp->aln = tp->aln;
	gp->name = np->name;

	change_class(class);
	o_aln(gp->aln, class, 5);
	std_area_start(np, class);

	if (class eq BSS_class or class eq GBSS_class)
	{
		sz = tp->size;
		if (!sz)
			errorn(np, "size of object not known or zero");

/* Remove generation of 'comm'
   For Pure C linker and its stack allocation
   mechanism. All .comm was located at the end of the bss. Yes,
   after the stack. Pcstart puts the stackpointer at the end of the
   bss and thus at the end if the .comm variables so that these soon
   became overwritten. */

		if (tp->aln)
			gp->size = 2,		/* we dont how much of which basic size. */
			sz /= 2;			/* type->size is the whole */
		else
			gp->size = 1;

		gp->misc = sz;
		addcode(gp, "^N:\n\t^ZS\t\tM" C(perv 2) "\n");
	othw
		addcode(gp, "^N:" C(perv 4) "\n");
		out_gp();			/* must synchronize alignment */
		new_gp(nil, INIT);
	}
}

global
void warn_const(TP xp)
{
#if 0
	TP ap = xp->type;
	while (ap->token eq ROW)
		ap = ap->type;
	if (ap->cflgs.f.qconst)
	{
		D_1(D, "uninitialized", ap);
		warnn(xp, "uninitialized const object");
	}
#else
	if (xp->cflgs.f.qconst)
		warnn(xp, "uninitialized const object");
#endif
}

global
void auto_init(TP xp, NP ap, NP e1, short context)
{
	ap->left = t_copy_e(xp);		/* make expression node for left of assignment */
	ap->right = e1;
	ap->tt = E_BIN;
	if (G.prtab->level > 1)		/* not args */
		G.scope->b_locs += loc_size(gpbase, xp, &G.scope->b_size, &G.scope->b_regs);
	loc_sym(xp);
	next_gp(ap);
	do_expr(ap, context);	/* for local scalar init */
}

global
bool static_init(TP xp)
{
	short class;
#if FOR_A							/* 'is defined as' operator */
#include "for_a_in.h"
#else
	if (cur->token eq ASSIGNMT)
	{
		xp->type->tflgs.f.formal = 0;			/* 04'09 */
		class = xp->sc eq K_GLOBAL ? GDATA_class : DATA_class;
		permanent_var(xp, class, 1);
		fadvnode();
		std_area_end(xp, class);
		g_init(xp->type, class);
	othw
		class = xp->sc eq K_GLOBAL ? GBSS_class : BSS_class;
		if (xp->type->tflgs.f.formal)		/* 04'09 row unsized, unitinialized :: formal/forward decl */
			return false;
		warn_const(xp);
		permanent_var(xp, class, 2);
		std_area_end(xp, class);
	}

#endif
	return true;
}

global
NP add_tseg(void)
{
	NP fp = gx_node();
	fp->misc1 = TEXT_class;
	addcode(fp, "\n^D" C(add_tseg) "\n");	/* ^D dynamic change of area */
	return fp;
}

global
NP a_init(TP op)  /* local aggreg init only */
/* op is the declaration; it belongs to the symbol table!!
   Its not yet put in so we can copy, and we must,
   because we cant change it */
{
	TP xp;

	D_1(D, "init local aggreg", op);

	/* set aside initializer as static */
	xp = copyTnode(op);			/* symbol table entry for static initializer */
	xp->sc = K_STATIC;
	xp->rno = 0;
	permanent_var(xp, DATA_class, 3);	/* sets also new_lbl() in xp->lbl */
	new_name(xp, "__%d", xp->lbl);
	loc_sym(xp);
	std_area_end(xp, DATA_class);
	g_init(xp->type, DATA_class);
	next_gp(add_tseg());
	op->type->size = xp->type->size;
	return t_copy_e(xp);  /* R of assignment */
}

global void opt_enval(long *val)  /* enum id = value */
{
	NP np;

#if FOR_A
	if (G.for_A)
	{
		if (cur->token eq IS_DEF_AS)
		{
			fadvnode();
			np = questx();
			*val = confold_value(np, FORSIDE);
		}
	}
	else
#endif
	if (cur->token eq ASSIGNMT)
	{
		fadvnode();
		np = questx();
		*val = confold_value(np, FORSIDE);		/* removed (short) it spoiled the const checking. */
	}
}

static bool bad_fty(TP tp)
{
	short tok;

	tok = tp->token;

	if (tok eq T_INT or tok eq T_UINT)
		return false;

#if NO_INT
/* 01'11 HR: 06'11 HR: allow long/short with int32 */
	if (G.ai_int32 and (tok eq T_LONG or tok eq T_ULONG))
		return false;

	elif (!G.ai_int32 and (tok eq T_SHORT or tok eq T_USHORT))
		return false;
#endif
	return true;
}

global void opt_field(TP xp, short *wdp, short isstruct)
{
	*wdp = -1;
	if (isstruct eq 0) return; /* union */
	if (cur->token eq FIELD)
	{
		NP np;
		short i, w;

		fadvnode();
		np = questx();
		i = confold_value(np, FORSIDE);
		if (xp)
		{
			TP tp = xp->type;
			if (i < 0)
			{
				errorn(xp, "bad field width");
				return;
			}
			elif (bad_fty(tp))
			{
				errorn(xp, "bad field");
				return;
			}
			w = tp->size * 8;
			if (i > w)
			{
				errorn(xp, "field wider than %d bits", w);
				i = w;
			}
		}

		*wdp = i;
		return;
	}
}

#define NBAS (T_NTY-T_BOOL+1)

static
TNODE	basics[NBAS],
		str_ptr,
		nil_ptr,
		func_int,
		compl_s,
		repart,
		impart,
		long_s;

#define DEF_BTBL 1
global BASTAB btbl[] =
{
#include "bas_def.h"
};
#undef DEF_BTBL

global TP asm_type(void)
{
	return basic_type(T_LONG);		/* identifiers in operands without .w or .l (PASM compatible) */
}

global TP default_type(short sc, short q)
{
	if (sc eq K_EXTERN and !q)
		warn("no declarer for %s object", graphic[sc]);
	return basic_type(T_INT);
}

static
void make_compl(TP bas, TP t1, TP t2,
				short tok1, char *n1,
				short tok2, char *n2)
{
	bas->token = 0;
	bas->nflags.f.bas = 1;
	bas->list = t1;
	t1->next = t2;

	t1->token = ID;
	t1->name = to_dictionary(n1);
	t1->nflags.f.bas = 1;
	t1->nt = TLNODE;
	t1->type = basic_type(tok1);

	t2->token = ID;
	t2->name = to_dictionary(n2);
	t2->nflags.f.bas = 1;
	t2->nt = TLNODE;
	t2->offset = t1->type->size;
	t2->type = basic_type(tok2);
	bas->size = t1->size + t2->size;
}

/* Allways called with token out of keyword table (that is; if thoroughly debugged) */
global void to_type(TP np, short token)	/* ensure consistency of TLNODES */
{
	short n;

	if (!is_C(token))		/* not in table */
	{
		CE_X("weird type: %s\n", ptok(token));
		token = T_INT;
	}

	np->token = token;
	switch (token)
	{
		case K_PROC:
		case K_OP:
		case K_CAST:
		break;
		case K_STRUCT: 				/* derived types */
		case K_UNION:
			np->ty = ET_A;
			np->nflags.f.n_brkpr = 1;	/* break print loops */
		break;
#if FLOAT
		case T_COMPL:
			np->ty = ET_A;
			np->nflags.f.n_brkpr = 1;
		fall_thru
#endif
		default:					/* basic types */
			{
				n = token - FIRST_BAS;
				np->ty   = btbl[n].type;
				np->size = btbl[n].size;
				np->aln  = btbl[n].align;
			}
	}

	np->category = KW_C(token);
}

/*		Declare basic type(s) */
global TP basic_type(short btype)
{
	TP rv ;
	short bm;
	short i;

	if (!G.first_declare)
	{
		G.first_declare = true;

		for (i = 0; i<NBAS; i++)
			basics[i].token = 0;
/* dont want to change the original type names */
		if (G.ai_int32)
		{
			btbl[T_INT  - FIRST_BAS].size  = SIZE_L;
			btbl[T_INT  - FIRST_BAS].align = ALN_L;
			btbl[T_UINT - FIRST_BAS].size  = SIZE_L;
			btbl[T_UINT - FIRST_BAS].align = ALN_L;
		othw
			btbl[T_INT  - FIRST_BAS].size  = SIZE_I;
			btbl[T_INT  - FIRST_BAS].align = ALN_I;
			btbl[T_UINT - FIRST_BAS].size  = SIZE_I;
			btbl[T_UINT - FIRST_BAS].align = ALN_I;
		}
#if COLDFIRE && FLOAT
		if (G.Coldfire)
		{
			btbl[T_REAL  - FIRST_BAS].size  = SIZE_D;
			btbl[T_REAL  - FIRST_BAS].align = ALN_D;
		othw
			btbl[T_REAL  - FIRST_BAS].size  = SIZE_X;
			btbl[T_REAL  - FIRST_BAS].align = ALN_X;
		}
#endif
		name_to_str(&str_ptr, "str_ptr to");
		to_type(&str_ptr, REFTO);
		str_ptr.nflags.f.bas = 1;
		str_ptr.nt = TLNODE;
		to_nct(&str_ptr);
		str_ptr.type = basic_type(G.k_char_is_unsigned ? T_UCHAR : T_CHAR);

		name_to_str(&nil_ptr, "nil_ptr to");
		to_type(&nil_ptr, REFTO);
		nil_ptr.nflags.f.bas = 1;
		nil_ptr.nt = TLNODE;
		to_nct(&nil_ptr);
		nil_ptr.type = basic_type(T_VOID);

		name_to_str(&func_int, "func_rtng");
		to_type(&func_int, K_PROC);
		func_int.nflags.f.bas = 1;
		func_int.nt = TLNODE;
#if FOR_A
		if (G.for_A)
			func_int.type = basic_type(T_VOID);
		else
			func_int.type = default_type(-1, 0);
		/* default should allways have been 'void' */
#else
		func_int.type = default_type(-1, 0);
#endif
		to_nct(&func_int);

#if FLOAT
		make_compl(&compl_s, &repart, &impart, T_REAL,  "re", T_REAL,  "im");
#endif
	}

	if (btype eq REFTO)
	{
		rv = allocTn(1);
		to_type(rv, REFTO);
		name_to_str(rv, "ptr to");
		graphic[btype] = rv->name;		/* for displaying */
		return rv;
	}

	if (btype eq SCON)
		return &str_ptr;

	if (btype eq K_NIL)
		return &nil_ptr;

	if (btype eq K_PROC)
		return &func_int;

#if FLOAT
	if (btype eq T_COMPL)
		rv = &compl_s,
		bm = T_COMPL - FIRST_BAS;
	else
#endif
	{
#if C_DEBUG
		if (!(is_C(btype) and (KW_C(btype)&BASIC) ne 0))
		{
			CE_X("type not basic: %s\n", ptok(btype));
			btype = T_INT;
		}
#endif
		bm = btype - FIRST_BAS;
		rv = &basics[bm];
	}


	if (rv->token eq 0)			/* if not allready declared */
	{
	#if NODESTATS
		G.ncnt[rv->nt]--;
		G.ncnt[TLNODE]++;
	#endif
		rv->nt = TLNODE;
		to_type(rv, btype);
		rv->nflags.f.bas = 1;
		name_to_str(rv, btbl[bm].text);
		graphic[btype] = rv->name;		/* for displaying */

#if NO_INT					/* make int synonymous to either short or long */
		if (G.ai_int32)
		{
			if (rv->token eq T_INT)
				rv->token = T_LONG;
			elif(rv->token eq T_UINT)
				rv->token = T_ULONG;
		othw
			if (rv->token eq T_INT)
				rv->token = T_SHORT;
			elif(rv->token eq T_UINT)
				rv->token = T_USHORT;
		}
#endif
	}

	return rv;
}

global bool double_size(void *vp)
{
	NP np = vp;
#if COLDFIRE
	if (G.Coldfire)
		return np->size eq SIZE_D;
#endif
	return np->size eq SIZE_X;
}

global short CC_ty(NP lp, NP rp)
{
	short ty = ET_CC;
#if FLOAT
	if (lp->ty eq ET_R)
		if (double_size(lp))
			ty = ET_XC;
		else
			ty = ET_FC;

	if (ty eq ET_CC and rp)
		if (rp->ty eq ET_R)
			if (double_size(rp))
				ty = ET_XC;
			else
				ty = ET_FC;
#endif
	return ty;
}

global TP CC_type(NP lp, NP rp)
{
	short ty = ET_CC;
	TP tp = copyTone(basic_type(T_BOOL));		/* must copy because of ty */

	tp->nflags.f.bas = 0;
	ty = CC_ty((NP)lp->type, rp ? (NP)rp->type : nil);
	tp->ty = ty;
	return tp;
}

/* declare arg name as integral */
global void def_arg(TP *listpp, TP op)
{
	TP np;

	D_(D, "def_arg");

	np = copyTone(op);
	np->type = default_type(-1, 0);
	to_nct(np);
	np->sc = K_AUTO;
	list_sym(listpp, np);
}

global string prdeclarer(TP list)
{
	static MAX_str s;		/* N.B. niet dus meer dan 1 keer in EEN printf gebruiken */

	s[0] = 0;
	while (list)
	{
		if (list->name)
		{
#if C_DEBUG
			sprintf(s + strlen(s), "%s::%s ", ptok(list->token), list->name);
#else
			strcat(s, list->name);
			if (list->type)
				strcat(s, " ");
#endif
			if (list->cflgs.f.qconst)			/* qualifiers */
				strcat(s, "const ");
			if (list->cflgs.f.qvolat)
				strcat(s, "volatile ");
		othw
			strcat(s, "? ");
		}
		list = list->type;
	}
	return s;
}
