/* Copyright (c) 2004 - 2009 by H. Robbers.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * lmem.c
 *
 * local and/or quick memory allocation
 *
 */

#include <prelude.h>
#include <stdio.h>
#include "common/ahcm.h"
#include "lmem.h"

#define ANALYSE 0

void console(char *, ...);

XA_memory
	XA_NS_base  = {nil, nil, nil,  16384, 13, 0, 0, 0, nil, nil, "compiler node space"},
	XA_CC_base  = {nil, nil, nil,  16384, 13, 0, 0, 0, nil, nil, "compiler base"},
	XA_CC_fbase = {nil, nil, nil,  16384, 13, 0, 0, 0, nil, nil, "compiler file base"};

global
void * qalloc(MEMBASE *mb, long new, char *op1, char *op2)
{
	char *ret;

	if (new < 1)
	{
		printf("**** qalloc size < 1 %ld ****\n", new);
		return nil;
	}

#if ANALYSE
	ret = XA_alloc(&mb->base, new, nil, -1, -1);
#else
	new = (new + 3) & -4;

	if (mb->memorynow + new > mb->chunk)
	{
		mb->memory = XA_alloc(&mb->base, mb->chunk, nil, -1, -1);

		/* Only arrive here if runout = nil */
		if (mb->memory eq nil)
		{
			console("ran out of memory %s\n\t%s\n", op1 ? op1 : "",op2 ? op2 : "");
			return nil;
		}

		mb->memorynow = 0;
	}

	ret = mb->memory;
	mb->memory += new;
	mb->memorynow += new;
#endif
	return ret;
}

global
void * CC_qalloc(MEMBASE *mb, long new, XA_run_out *ranout, XA_key key)
{
	char *ret;

	if (new < 1)
	{
		printf("**** CC_qalloc size < 1 %ld ****\n", new);
		return nil;
	}

#if ANALYSE
	ret = XA_alloc(&mb->base, new, ranout, key, -1);
#else
	new = (new + 3) & -4;

	if (mb->memorynow + new > mb->chunk)
	{
		mb->memory = XA_alloc(&mb->base, mb->chunk, ranout, key, -1);
		mb->memorynow = 0;
	}

	ret = mb->memory;
	mb->memory += new;
	mb->memorynow += new;
#endif
	return ret;
}

global
void init_membase(MEMBASE *mb, long chunk, short flag, char *name, XA_run_out *runout)
{
	mb->chunk = chunk - blockprefix - 2*unitprefix;
	mb->memorynow = 2*mb->chunk;
	mb->memory = nil;
	mb->name = name;
	XA_set_base(&mb->base, chunk, 0, 0, runout, name);
	mb->base.flags = flag;
}

global
void free_membase(MEMBASE *mb)
{
	XA_free_all(&mb->base, -1, -1);
	mb->memorynow = 2*mb->chunk;
	mb->memory = nil;
}

global
void *NS_xmalloc(size_t size, XA_key key, XA_run_out *ranout)
{	return XA_alloc(&XA_NS_base, size, ranout, key, 0);	}
global
void *NS_xcalloc(size_t items, size_t chunk, XA_key key, XA_run_out *ranout)
{	return XA_calloc(&XA_NS_base, items, chunk, ranout, key, 0);}
global
void *NS_xrealloc(void *old, size_t size, XA_key key, XA_run_out *ranout)
{	return XA_realloc(&XA_NS_base, old, size, ranout, key, 0);	}
global
void NS_xfree(void *addr, short which)
{	XA_free(&XA_NS_base, addr, which); }
global
void NS_xfree_all(XA_key key)
{	XA_free_all(&XA_NS_base, key, -1); }


global
void *CC_xmalloc(size_t size, XA_key key, XA_run_out *ranout)
{	return XA_alloc(&XA_CC_base, size, ranout, key, 0);	}
global
void *CC_xcalloc(size_t items, size_t chunk, XA_key key, XA_run_out *ranout)
{	return XA_calloc(&XA_CC_base, items, chunk, ranout, key, 0);}
global
void *CC_xrealloc(void *old, size_t size, XA_key key, XA_run_out *ranout)
{	return XA_realloc(&XA_CC_base, old, size, ranout, key, 0);	}
global
void CC_xfree(void *addr, short which)
{	XA_free(&XA_CC_base, addr, which); }
global
void CC_xfree_all(XA_key key)
{	XA_free_all(&XA_CC_base, key, -1); }
global


void *CC_fmalloc(size_t size, XA_key key, XA_run_out *ranout)
{	return XA_alloc(&XA_CC_fbase, size, ranout, key, 0);	}
global
void *CC_fcalloc(size_t items, size_t chunk, XA_key key, XA_run_out *ranout)
{	return XA_calloc(&XA_CC_fbase, items, chunk, ranout, key, 0);}
global
void *CC_frealloc(void *old, size_t size, XA_key key, XA_run_out *ranout)
{	return XA_realloc(&XA_CC_fbase, old, size, ranout, key, 0);	}
global
void CC_ffree(void *addr, short which)
{	XA_free(&XA_CC_fbase, addr, which); }
global
void CC_ffree_all(XA_key key)
{	XA_free_all(&XA_CC_fbase, key, -1); }

