/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Johann Ruegg
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *	nodedefs.h
 */

#include "cache.h"

/* nodetypes */
enum
{
	STNODE = 1,		/* xnode unused */
	FIRSTTY=STNODE,
	DFNODE,			/* xnode */
	EXNODE,			/* enode */
	GENODE,			/* gnode */
	TLNODE,			/* tnode = symbol tables & type lists */
	BLNODE,			/* snode = scopes */
	FLNODE,			/* flown = flow node */
	CSNODE,			/* cnode = switches */
	TPNODE,			/* mnode = code templates */
	PRNODE,			/* fnode = proc,func nesting */
	RLNODE,			/* rnode = 96 bit real value */
	LLNODE,			/* lnode = 64 bit int value */
	IFNODE,			/* pnode #if #elif #endif tracking */
	LBNODE,			/* label node */
	INNODE,			/* inode */
	BKNODE,			/* bnode */
	LASTTY,
};

typedef union
{
	long	i;
#if FLOAT
	float	f;
	struct vnode	*dbl;
#endif
} Value;

typedef void node_zero(void *xp);

typedef struct nodespace
{
	size_t	nodesize;
	long	start;
	bool	exponential;
	long	tel, noem;
	node_zero *zer;
	char *	name;
	void	*space, *list;
#if NODESTATS
	short 	made, avail;
#endif
} NODESPACE;

extern NODESPACE xspace[];

typedef enum
{
	XNr, TLr, EXr, VNr, INr, BKr, XXr
} ROOTS;

/* generic node definition: describes commen part only.
   Nota Maxima Bene! Do never use sizeof() on this node
 */

typedef union
{
	struct
	{
	  ubits
		n_brkpr	: 1,		/* break printnode recursion		*/
		nexp	: 1,		/* dont expand						*/
		spar	: 1,		/* for DPARAM node's	(#param)	*/

		lcat	: 1,		/* left of ##						*/
		rcat	: 1,		/* right of ##						*/
		bas		: 1,		/* basic type (resident node)		*/
		free	: 1,		/* node is on free list				*/
		n_ct	: 1,		/* type is NOT a copy				*/

		asmac	: 1,		/* macro from asm */
		p1ws	: 1,		/* White space from character pos 1	*/
		follows : 1,		/* White space following identifier */
		dot     : 1,		/* Dot preceding identifier			*/
		b3_1    : 3,
		nheap	: 1;		/* Name is malloc'd, must be free'd */
							/* otherwise is absent or in dixtionary */
	} f;
	ushort i;
} NFLAGS;

/* NB!!! the E,G and T FLAGS must at any time be kept in the same order
         and on the same bit position.
*/
typedef union
{
	struct
	{
	  ubits
		cfl   : 1,			/* Long forced for Coldfire			*/
		rname : 1,			/* my name is my right child's name	*/
		lname : 1,			/* my name is my left child's name	*/
		imm   : 1,			/* Ptr to ID which is really Array of or Fun ret */
		cc    : 1,			/* cc set as side effect of op		*/
		asm_w : 1,			/* long size in asm expressions		*/
		asm_l : 1,			/* word size in asm expressions		*/
		typed : 1,			/* Argument to call is properly typed */
		varg  : 1,			/* Ellipsis seen stop allocating args to regs */
		see_ll: 1,			/* LL seen on integer constant		*/
		see_f : 1,			/*  F seen on constant				*/
		see_l : 1,			/*  L seen on integer constant		*/
		see_u : 1,			/*  U seen on integer constant		*/
		b14_15: 3;
	} f;
	ushort i;
} EFLAGS;

typedef union
{
	struct
	{
	  ubits
		formal    : 1,		/* Array declaration is formal (empty [])			*/
		isarg     : 1,		/* Is a argument (old style function declarations)	*/
		used      : 1,
		inid      : 1,
		derefto   : 1,		/* Implicit dereferncing of ptr to function 		*/
		saw_array : 1,		/* genuine []'d array seen but converted to pointer */
		old_args  : 1,		/* old style function declaration	*/
		ans_args  : 1,		/* ANSI prototype					*/
		b8_15     : 8;
	} f;
	ushort i;
} TFLAGS;

typedef union
{
	struct
	{
	  ubits
	    prec    : 4,
		lproc   : 1,		/* Local procedure */
		undef   : 1,		/* Name is undefined */
		see_reg : 1,		/* register declaration */
		asmfunc : 1,		/* declaration of embedded assembly */
		cdec    : 1,		/* cdecl function 	*/
		rlop    : 1,		/* floating point monadyc operator */
	  	b6_2	: 4,
		qvolat  : 1,		/* volatile declaration */
#define VOLAT 2
		qconst  : 1;		/* constant declaration */
#define CONST 1
	} f;
	ushort i;
} CFLAGS;

#if 1
typedef struct
{
	ubits
		offset	: 5,
		shift	: 5,
		width	: 6;
} BITS;
#else
typedef struct
{
	short
		offset,
		shift,
		width;
} BITS;
#endif

#define KEEP_QUAL(np, lp) (np)->cflgs.i |= (lp)->cflgs.i&(CONST|VOLAT)

#define NODECOMMON	\
	NFLAGS nflags;	\
	string name;	\
	uchar nt, sc;   \
	short token;	\
	short fileno;	\
	long lineno;


typedef struct allnodes
{
	struct	allnodes *left, *right;
	NODECOMMON
	Value	val;				/* almost every node type needs some value */

	union						/* used to be the 'type' vector */
	{
		struct allnodes *info;
		struct xnode    *tseq;
		struct tlnode   *type;
		struct bnode    *symbol;
		struct vnode    *codep;
		struct opnd     *arg;
		struct snode    *b_syms;
	} var;
} ANODE, *AP;

/*
 *	input & preprocessor node
 */

typedef struct xnode
{
/*
 *	stuff common to all nodes
 */
	struct	xnode *next, *right;
	NODECOMMON
	Value	val;
	struct	xnode *tseq;			/* token sequence */

/*  ---------------- */
	CFLAGS	cflgs;
	EFLAGS	zflgs;
	ulong	category;
	LEX_RECORD * catp;
} XNODE, *XP;

#if offsetof(XNODE, cflgs) != sizeof(ANODE)
#error incorrect common part of XNODE
#endif

/*
 *	symbol table & type list
 */

typedef struct tlnode
{
/*
 *	stuff common to all nodes
 */
	struct	tlnode *next, *list;
	NODECOMMON
	long	offset;		/* relative offset (stackframe or member) */
	struct	tlnode *type;

/*  ------------ */
	CFLAGS	cflgs;
	TFLAGS	tflgs;
	ulong	category;
	long	size;
	AREA_INFO area_info;
	char	tt,			/* type of tree branch (binary, unary or leaf) */
			rno;
	short	lbl;		/* for static names (static means: extent is permanent, scope is local) */
						/* name number if assembler name */
/*	char	fldw,
			fldo;	*/
	BITS	fld;
	char	aln,
			ty;
} TNODE, *TP;

#if offsetof(TNODE, cflgs) != sizeof(ANODE)
#error incorrect common part of TNODE
#endif

/*
 *	expression node and generation node data
 */

typedef struct exnode			/* enode & gnode amalgamated */
{
/*
 *	stuff common to all nodes
 */
	struct exnode *left, *right;
	NODECOMMON
	Value val;
	TP     type;

/*  ------------ */
	CFLAGS	cflgs;		/* must be same place as tnode	*/
	EFLAGS	eflgs;
	ulong	category;
	long	size;
	AREA_INFO area_info;
	char	tt,			/* type of tree branch (bin, un or leaf) */
			rno;
	short	lbl;
/*	char	fldw,
			fldo;	*/
	BITS	fld;
	char	aln,
			ty;			/* type DOUBLE, UNS, INT or AGGREG */

	struct vnode
			*betw;		/* code for between L and R					*/
	NREG	needs;
	short 	Tl,
			Fl,
			brt;		/* 				branch token				*/
	char	r1,
			r2,
			chunk_size,	/* aggreg chunk size (strasn)				*/
			misc1;
	long	misc;
	RMASK   reserve;
} NODE, *NP;

#if offsetof(NODE, cflgs) != sizeof(ANODE)
#error incorrect common part of NODE
#endif


/* preprocessor node became necessary
	because of the a-symmetric syntax of #elif */

struct pnode
{
	short kind;				/* of nests */
	short nest;
	bool truth;
	short lvl;				/* of include files */
	void *cur_LEX;			/* remember position */
	short fileno;
	CP cache;
};

#define p nd.pn

/*
 *	node data to hold case for switch generation
 */
struct cnode
{
	short lbl;		/* case label or label label */
	short def;		/* label defined */
};

#define cs nd.cn

/*
 * node data to hold flow information of function per statement
 *	right/inner    is  then ...
 *  out            is  else cq default
 */
struct flown
{
	short nr;
	struct vnode
		*out,			/* else ...; or default */
		*caselist;		/* sorted casevalues */
/*		*loc;			/* location of result of statement's last expression */
*/	short escape,		/* whether normal flow or discontinuous */
						/* cq  break; return; continue; fall thru; goto */
		deflbl,			/* default lable or -1 */
		size;			/* of switch expression */
	struct
	{
		short brk,		/* stmt's break    label (replaces prtab->curbrk) */
			cont;		/* stmt's continue label (replaces prtab->curcont) */
		struct vnode
			*base,		/* back to start of level */
			*root;		/* points to flow node of switch or loop statement */
	} fd;				/* flow data for inheriting */
};

#define F nd.fn
#define FF nd.fn.fd

#define TPLMAX (sizeof(struct flown)/sizeof(string))-1

/*
 *	code template node
 */
struct mnode		/* template node */
{
	short tno;
	string templates[TPLMAX];
};

#define tnr nd.mn.tno
#define ts  nd.mn.templates

#include "optimize.h"

typedef union
{
	struct ubits
	{
		b15_2  : 14,
		branch : 1,
		flt    : 1;
	} f;
	ushort i;
} IFLAGS;

typedef struct inode
{
 	struct inode *next, *prior;
	NFLAGS	nflags;
	OPND	*arg;			/* argument list */
	uchar	nt, sc;			/* 03'11 HR: nt needed for debugging */
	ASMOP	opcode;			/* instruction */
	short 	reg, sz;
	RMASK	rref,
			rset;
	IFLAGS	iflg;
	RMASK	live;			/* regs live after this inst. */

#if C_DEBUG
	long	lineno;
#endif

#if OPTBUG	 				/* debug optimizer */
	long inr;
	char *bugstr;			/* static debug info */
#endif
} INODE, *IP;

/*
 * Basic Block:
 *
 * References a linked list of instructions that make up the block.
 * Each block can be exited via one of two branches, which are
 * represented by pointers to two other blocks, or null.
 * There are 24 registers a0-a7, d0-d7 and f0-f7,
 */
typedef struct bnode
{
/*
 *	stuff common to all nodes
 */
	struct bnode *next, *chain;
	NFLAGS nflags;
	string name;
	uchar nt, sc;
	short token;
	short blocknr;
	RMASK rref,			/* registers referenced by block */
	      rset;		    /* registers modified   by block */
	struct bnode *symbol;

	BFLAGS bflg;		/* flags relating to this block */
	ASMOP opcode;		/* type of exiting branch */
	struct
	inode *first,		/* first instruction in block */
	      *last;		/* last instruction in block */

	/*
	 * Execution traversals
	 */
	struct
	bnode *cond,		/* conditional branch (or nil) */
		  *fall;		/* "fall through" branch */

	/*
	 * Information for data-flow analysis
	 */
	RMASK live;			/* registers live at the beginning ? */
} BNODE, *BP;

#if offsetof(BNODE, bflg) != sizeof(ANODE)
#error incorrect common part of BNODE
#endif

#if LONGLONG
#include "ll.h"			/* internal long long definitions */
/* AHCC internally doesnt use long long; It is emulated as long as
   I want to be able to compile by Pure C.
 */
#endif

typedef struct vnode
{
/*
 *	stuff common to all nodes
 */
	struct vnode *next, *inner;
	NODECOMMON
	ulong vval;

	struct vnode *codep;
/*
 *	various
 */
	union nd						/*	node data */
	{
		struct mnode mn;
		struct cnode cn;
		struct pnode pn;
		struct flown fn;
#if FLOAT
		double val;					/* for RLNODE */
#endif
#if LONGLONG
		__llasd lval;				/* for LLNODE */
#endif
	} nd;
} VNODE, *VP;

#define rval nd.val
#define llval nd.lval.m

#if offsetof(VNODE, nd) != sizeof(ANODE)
#error incorrect common part of VNODE
#endif


/*
 *	block info node
 */
typedef struct snode		/* scope information */
{
	struct snode *outer, *_right;
	NFLAGS nflags;
	string name;
	uchar nt, sc;
	short  token;			/* type: BLOCK, K_IF, K_SWITCH */
	short  b_tsize;		/* max tmps used for 1 expr		*/
	long   b_size;		/* size of locals cumulative	*/
	long   b_locs;		/* size of locals of 1 block	*/

	TP	b_syms;

	TP	b_tags,
		b_ops,		/* s/w dbl inline ops & casts		*/
		b_casts;
	ALREG	b_regs;	 	/* loc vars allocated			*/
} SNODE, *SCP;

#if offsetof(SNODE, b_tags) != sizeof(ANODE)
#error incorrect common part of SNODE
#endif

typedef struct fnode			/* proc decl nesting */
{
	struct fnode *outer, *_right;
	NFLAGS nflags;
	string name;
	uchar nt, sc;
	short token;			/* type: BLOCK, K_IF, K_SWITCH */
	short level;
	RMASK wregmsk,			/* for extra work regs */
	      resv;

	TP    type;
	VP    labels;
	short lkxl,				/* for lkx local name space amount */
		  mmxl,				/* for reglist */
	      fretl;
	ALREG maxregs;
	short maxlocs,
	      insc,				/* current init context */
	      tmps;				/* temporaries */
} FNODE, *FP;

typedef struct
{
	short l1, l2, l3, l4;
	NP xfor, xfrom, xby, xto, xwhile, xuntil;
	long e1_line, e2_line, e3_line, e4_line;
} LOOP_CONTROL;

#if offsetof(FNODE, labels) != sizeof(ANODE)
#error incorrect common part of FNODE
#endif


#if sizeof(XNODE)&3
#error size of xnode not multiple of 4
#endif

#if sizeof(NODE)&3
#error size of node not multiple of 4
#endif

#if sizeof(TNODE)&3
#error size of tnode not multiple of 4
#endif

#if sizeof(BNODE)&3
#error size of bnode not multiple of 4
#endif

#if sizeof(INODE)&3
#error size of inode not multiple of 4
#endif
