/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Tony Andrews
 * Copyright (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *	opt.h
 */

#define NHEALTH 0

typedef struct asmtable
{
	struct asmtable *link;
	char *name;
	ASMOP tok;
} ASM_TAB;

#define OPHASH 127

string	optimize(void);
short 	is_lbl		(char *l);
void	freesym		(char *);
BP		getsym		(char *),
		mksym		(char *);
void	add_debug	(IP ip, char *s);
bool 	ipeep0		(BP bp, IP ip);
/* bool	peep0		(BP bp); */
bool	is_dreg		(short m, short r);
bool	is_freg		(short m, short r);
bool	is_areg		(short m, short r);
short 	ophash		(string key);
ASMOP	find_op		(char *o);
char *	mask_to_s	(RMASK m, bool o68K);

#if OPTBUG
extern long inst_nr;
#endif

extern bool new_peep;
extern short cur_proc;
