/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Tony Andrews
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Basic defines and declarations for the optimizer.
 * Optimizer now integrated in the compiler.
 */

#if OPTBUG
	#define PDBG(x, y) {add_debug(x, #y);peepcnt.y++;}
	#define DBG(x, y)   add_debug(x, #y)
#else
	#define PDBG(x, y) ;
	#define DBG(x, y)
#endif

#include "peepstat.h"

/*
 * Instruction constants
 */

typedef enum
{
/*
 * Addressing modes in OPND.amode
 */
	NONE,			/* operand unused */
	REG,			/* register direct */
	REGI,			/* reg. indirect */
	REGID,			/* reg. indirect, w/ displacement */
	REGIDX,			/* reg. indirect, w/ displacement & index */
	REGIDXX,		/*      with 020+ extensions */
	PCD,			/* PC relative, w/ displacement */
	PCDX,			/* PC relative, w/ displacement & index */
	PCDXX,			/*      with 020+ extensions */
	IMM,			/* immediate */
	ABS,			/* absolute */
	INSTD,			/* instruction relative w/ displacement */
	RLST,			/* register list */
	CONDREG,		/* condition register (in opnd.disp) */
/*
 *  flags over OPND.amode
 */
	XLONG  = 0x0100,
	SYMB   = 0x0200,
	ABSW   = 0x0400,
	BDISP  = 0x0800,
	ODISP  = 0x1000,
	MIND   = 0x2000,
	INC    = 0x4000,
	POSTI  = INC,			/* or memory indirect post indexed */
	DEC    = 0x8000,
	PREI   = DEC,			/* or memory indirect pre  indexed */
} OPFLAG;

#if AMFIELDS
typedef union
{
	struct
	{
		ubits
			inc   : 1,		/* predecrement -(An) */
			dec   : 1,		/* postincrement (An)+ */
			mind  : 1,		/* memory indirection (optional with POSTI or PREI) */
			odisp : 1,		/* have outer displacement */
			bdisp : 1,		/* have base  displacement */
			absw  : 1,		/* ABS or BDISP is .w */
			symb  : 1,		/* symbol used, not constant */
			xlong : 1,		/* long index register used */
			m     : 8;		/* basic addressing mode */
	} f;
	ushort i;
} OPMODE;

#define amode adm.i
#endif

typedef struct
{
	ubits
		jsl     : 1,		/* block contains 1 or more calls to local proc */
		loop    : 1,		/* block is first of a loop (all label references are forward!
								except the 1 to the first instruction of a loop) */
		swt     : 1,		/* block terminates with a 'dc' (so contains a switch) */
		mark    : 1,		/* temporary 'touched' mark */
		ret     : 1,		/* block terminates with a 'return' */
		reached : 1,		/* block IS reached (for switches) */
		label   : 1,		/* the block needs a label */
		touched : 1,		/* used in traversals */
		is_global : 1;		/* is the block's symbol global? */
} BFLAGS;

/*
 * flags in IDATA.iflag
 */
typedef enum
{
	SIDE  = 0x01,		/* inst. has side-effects */
	CCU   = 0x02,		/* inst. uses condition codes Scc FScc */
	REVDD = 0x04,		/* ..s dx dy --> ..x dy dx (motorola dn,<ea> and <ea>,dn) */
	REVD  = 0x08,		/* ..s    dy --> ..x dy     single operand equivalent */
	SET   = 0x10,		/* operand is set */
	REF   = 0x20,		/* operand is referenced */
	RTN   = 0x40,		/* is return */
	USG   = 0x80,       /* insts whose usage we are to try to avoid */
	LEA   = 0x100		/* inst that takes address */
} IFLAG;

#if AMFIELDS
#define	MM(x)	((x) & 0x0f)		/* if you need more bits for flags */
#else
#define	MM(x)	((x) & 0xff)
#endif

#define MX(x)   ((x) & ~XLONG)

/*
 * Misc. define's, etc. for instruction parsing.
 */

/* flags for registerization */
#define	ALIASED		0x1	/* offset is aliased with another */
#define	ADDR_TAKEN	0x2	/* address of the variable was taken */
#define ARPTR	    0x4	/* pointer to standard area */

#define DEF_PO_ENUM 1
typedef enum
{
	INVOP,
#include "po_defs.h"
} ASMOP;

enum 		/* loc var type */
{
	DRG = 1,		/* normal data */
	FRG,			/* h/w floating */
	PTR,			/* pointer */
	ARD				/* area disp */
};

typedef struct opnd
{
	struct	opnd *next;	/* list of operands */
	struct	opnd *outd;	/* outer displacement (for astr, disp, aname & namedisp fields )*/
	long	disp,		/* also used for immediate data */
			namedisp;	/* displacement of name within area */
	char	*astr;	/* pointer to any symbol present */
	short	areg,	/* primary register or std area class number*/
			ireg;	/* index register, if applicable or real area number */
#if AMFIELDS
	OPMODE	adm;	/* addressing mode used */
#else
	OPFLAG	amode;
#endif
	ubits	aname : 1,	/* name has <area.disp> */
			gl    : 1,	/* name is global (for AS) */
			scale : 4,	/* scale factor for ireg (68020+) */
			type  : 4,	/* in case of loc var, type (PTR, DRG, FRG) */
			dum   : 6;
	char	fldo,	/* field offset */
			fldw;	/* field width */
	short	tlab;
} OPND;

/*
 * idata
 *
 * For each instruction, we have some global information, as well
 * as flags indicating what the instruction does with its operands.
 * We need to know if each operand is set and/or referenced. If the
 * instruction has side-effects not directly related to its operands,
 * we need to know that as well, so "special case" code can deal with
 * that as well.
 */

typedef
void o_A(struct inode *ip);

typedef struct
{
	char *text;
	o_A  *opr;
	short
		defsz,			/* 0 no size field, #0 default size */
	    cc,				/* cc predicate for branch instructions */
	    iflag,			/* flags regarding the entire instruction */
	    regf,			/* flags for the reg, first and second operands */
	    argf,
	    dstf;
} IDATA;

/*
 * DxxOK(x) - evaluates TRUE if 'x' is okay for a displacement value.
 *
 * 'x' must be of type "long"
 */
#define	D16OK(x)	(((x) >= -32768L) && ((x) <= 32767L))

/*
 * D8OK(x) - like D16OK but for 8-bit displacements
 * D3OK for 3-bit
 */

#define	D8OK(x)	((x) >= -128 && (x) <= 127)
#define D3OK(x) ((x)                <= 8)

/*
 * Optimization stats
 */
extern
short
	s_bdel,
	s_badd,
	s_brev,
	s_peep1,
	s_peep2,
	s_peep3,
	s_idel,
	s_reg,
	s_movem,
	s_lnk,
	peep_loops;

extern IDATA idata[];
extern RMASK loclist,		/* for mms mmx (movem) (uitsplitsing integral & float) */
             anywhere_used,
             anywhere_set;	/* for regdown */

#define OPFS(y)  (	    op2 eq y\
					and i1->iflg.i eq i2->iflg.i\
					and i1->sz     eq i2->sz)

#define is_return(x) (idata[(x)].iflag&RTN)
